/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.DatabaseIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbConsoleRootType
extends ConsoleRootType {
    private static final String FILE_PREFIX = "console";

    DbConsoleRootType() {
        super("db", "Database Consoles");
    }

    @NotNull
    public static DbConsoleRootType getInstance() {
        DbConsoleRootType dbConsoleRootType = (DbConsoleRootType)DbConsoleRootType.findByClass(DbConsoleRootType.class);
        if (dbConsoleRootType == null) {
            DbConsoleRootType.$$$reportNull$$$0(0);
        }
        return dbConsoleRootType;
    }

    @Nullable
    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        DbDataSource dataSource;
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(2);
        }
        return (dataSource = DbConsoleRootType.getDataSource(project, file)) != null ? DbSqlUtil.getSqlDialect((DbElement)dataSource) : null;
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file) {
        DbDataSource dataSource;
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(3);
        }
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(4);
        }
        if ((dataSource = DbConsoleRootType.getDataSource(project, file)) == null) {
            return DatabaseIcons.Sql;
        }
        return dataSource.getIcon();
    }

    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(6);
        }
        String name = file.isDirectory() ? file.getName() : file.getNameWithoutExtension();
        DbDataSource dataSource = DbConsoleRootType.getDataSource(project, file);
        if (dataSource == null) {
            return null;
        }
        String uniqueId = dataSource.getUniqueId();
        if (file.isDirectory()) {
            return name.equals(uniqueId) ? dataSource.getName() : name;
        }
        String rootPath = this.getContentRootPath(dataSource.getUniqueId());
        String relativePath = StringUtil.trimStart((String)file.getPath(), (String)rootPath);
        String s1 = StringUtil.trimStart((String)StringUtil.trimEnd((String)StringUtil.trimExtensions((String)relativePath).replace(uniqueId, dataSource.getName()).replace("/console_", "/").replace("/console", "/"), (String)"/"), (String)"/");
        return s1.isEmpty() ? dataSource.getName() : dataSource.getName() + " [" + s1 + "]";
    }

    public void fileOpened(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(7);
        }
        if (source == null) {
            DbConsoleRootType.$$$reportNull$$$0(8);
        }
        DatabaseEditorHelper.configureConsole(file, source);
    }

    public void fileClosed(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(9);
        }
        if (source == null) {
            DbConsoleRootType.$$$reportNull$$$0(10);
        }
        DatabaseEditorHelper.disposeConsoleIfSafe(file, source);
    }

    public boolean isIgnored(@NotNull Project project, @NotNull VirtualFile element) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(11);
        }
        if (element == null) {
            DbConsoleRootType.$$$reportNull$$$0(12);
        }
        return DbConsoleRootType.getDataSource(project, element) == null;
    }

    public void registerTreeUpdater(@NotNull Project project, @NotNull Disposable disposable, final @NotNull Runnable onUpdate) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(13);
        }
        if (disposable == null) {
            DbConsoleRootType.$$$reportNull$$$0(14);
        }
        if (onUpdate == null) {
            DbConsoleRootType.$$$reportNull$$$0(15);
        }
        DbPsiFacade.getInstance((Project)project).addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

            public void modificationCountChanged(DbPsiFacade source) {
                onUpdate.run();
            }
        }, disposable);
    }

    @NotNull
    public String getEntrySeparator() {
        if ("\n;-- -. . -..- - / . -. - .-. -.--\n" == null) {
            DbConsoleRootType.$$$reportNull$$$0(16);
        }
        return "\n;-- -. . -..- - / . -. - .-. -.--\n";
    }

    @NotNull
    public String getContentPathName(@NotNull String id) {
        if (id == null) {
            DbConsoleRootType.$$$reportNull$$$0(17);
        }
        String string = id + "/" + FILE_PREFIX;
        if (string == null) {
            DbConsoleRootType.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public String getContentRootPath(@NotNull String id) {
        if (id == null) {
            DbConsoleRootType.$$$reportNull$$$0(19);
        }
        String string = ScratchFileService.getInstance().getRootPath((RootType)this) + "/" + id;
        if (string == null) {
            DbConsoleRootType.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public String getHistoryPathName(@NotNull String id) {
        if (id == null) {
            DbConsoleRootType.$$$reportNull$$$0(21);
        }
        String string = id;
        if (string == null) {
            DbConsoleRootType.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getDefaultFileExtension() {
        if ("sql" == null) {
            DbConsoleRootType.$$$reportNull$$$0(23);
        }
        return "sql";
    }

    @Nullable
    public static DbDataSource getDataSource(@NotNull Project project, @NotNull VirtualFile original) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(24);
        }
        if (original == null) {
            DbConsoleRootType.$$$reportNull$$$0(25);
        }
        ScratchFileService service = ScratchFileService.getInstance();
        DbConsoleRootType rootType = DbConsoleRootType.getInstance();
        for (VirtualFile file = original; file != null && service.getRootType(file) == rootType; file = file.getParent()) {
            String name = file.getNameWithoutExtension();
            String uuid = name.substring(0, Math.min(36, name.length()));
            DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(uuid);
            if (dataSource == null) continue;
            return dataSource;
        }
        return null;
    }

    public static boolean isConsoleFile(@Nullable VirtualFile file) {
        return file != null && ScratchFileService.getInstance().getRootType(file) == DbConsoleRootType.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/DbConsoleRootType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUpdate";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/DbConsoleRootType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntrySeparator";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPathName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryPathName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "substituteLanguage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteIcon";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "substituteName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerTreeUpdater";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContentPathName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getHistoryPathName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

