/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import java.rmi.UnmarshalException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DatabaseConnectionEstablisher {
    private static final Logger LOG = Logger.getInstance(DatabaseConnectionManager.class);
    private static final String USER_KEY = "user";
    private static final String PASSWORD_KEY = "password";
    private final DatabaseConnectionPoint myConnectionPoint;
    private final Driver myDriver;
    private final Project myProject;
    private final boolean myAskPassword;
    private final AtomicReference<Boolean> myStopProcessRef;
    private final Properties myConnectionProperties;
    private final ConsoleRunConfiguration myConfiguration;
    private int myAttemptNo;
    private String myUrl;

    public static CompletionStage<DatabaseConnection> establishConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull Project project, boolean askPassword) {
        if (connectionPoint == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(2);
        }
        JdbcDriverManager jdbcDriverManager = JdbcDriverManager.getDriverManager(project);
        return DatabaseCredentials.getInstance().getCredentialsAsync(connectionPoint.getDataSource()).thenCompose(AsyncUtil.captureIndicator(credentials -> {
            if (connectionPoint == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(24);
            }
            if (runConfiguration == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(25);
            }
            if (project == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(26);
            }
            try {
                Driver driver = jdbcDriverManager.getDriver(connectionPoint.getDataSource(), runConfiguration);
                String url = DatabaseConnectionManager.getEffectiveUrl(connectionPoint, jdbcDriverManager);
                if (url == null) {
                    return CompletableFuture.completedFuture(null);
                }
                Runnable releaseDriver = () -> {
                    if (connectionPoint == null) {
                        DatabaseConnectionEstablisher.$$$reportNull$$$0(27);
                    }
                    if (runConfiguration == null) {
                        DatabaseConnectionEstablisher.$$$reportNull$$$0(28);
                    }
                    jdbcDriverManager.releaseDriver(connectionPoint.getDataSource(), runConfiguration);
                };
                DatabaseConnectionEstablisher establisher = new DatabaseConnectionEstablisher(project, runConfiguration, driver, connectionPoint, url, releaseDriver, askPassword);
                return establisher.tryConnect((Credentials)credentials);
            }
            catch (Exception e) {
                return AsyncUtil.exceptional(e);
            }
        }));
    }

    DatabaseConnectionEstablisher(@NotNull Project project, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull Driver driver, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull String url, final @NotNull Runnable releaseDriver, boolean askPassword) {
        if (project == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(3);
        }
        if (runConfiguration == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(4);
        }
        if (driver == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(5);
        }
        if (connectionPoint == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(6);
        }
        if (url == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(7);
        }
        if (releaseDriver == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(8);
        }
        this.myAttemptNo = 0;
        this.myConfiguration = runConfiguration;
        this.myStopProcessRef = new AtomicReference<Boolean>(true);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    if (((Boolean)DatabaseConnectionEstablisher.this.myStopProcessRef.get()).booleanValue()) {
                        releaseDriver.run();
                    }
                }
            });
        }
        this.myConnectionPoint = connectionPoint;
        this.myDriver = driver;
        this.myProject = project;
        this.myConnectionProperties = this.myConnectionPoint.getConnectionProperties();
        this.myUrl = url;
        this.myAskPassword = askPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public CompletionStage<DatabaseConnection> tryConnect(@Nullable Credentials credentials) {
        CompletionStage<DatabaseConnection> completionStage;
        block14: {
            CompletableFuture<DatabaseConnection> completableFuture;
            block13: {
                String password;
                String userName;
                String string = userName = credentials == null ? null : credentials.getUserName();
                if (StringUtil.isNotEmpty((String)userName)) {
                    LOG.info("Connecting as: " + userName);
                    this.myConnectionProperties.setProperty(USER_KEY, userName);
                } else {
                    LOG.info("No user name provided (may be in url)");
                }
                String string2 = password = credentials == null ? null : credentials.getPasswordAsString();
                if (StringUtil.isNotEmpty((String)password)) {
                    this.myConnectionProperties.setProperty(PASSWORD_KEY, password);
                }
                try {
                    DatabaseConnection connection = this.connect();
                    if (connection != null) {
                        CompletableFuture<DatabaseConnection> completableFuture2 = CompletableFuture.completedFuture(connection);
                        completableFuture = completableFuture2;
                        break block13;
                    }
                    CompletionStage<DatabaseConnection> completionStage2 = this.processNullConnection(credentials);
                    completionStage = completionStage2;
                    break block14;
                }
                catch (SQLException e) {
                    CompletionStage<DatabaseConnection> completionStage3 = this.processConnectionFailure(credentials, e);
                    CompletionStage<DatabaseConnection> completionStage4 = completionStage3;
                    if (completionStage4 == null) {
                        DatabaseConnectionEstablisher.$$$reportNull$$$0(11);
                    }
                    return completionStage4;
                }
            }
            if (completableFuture == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(9);
            }
            return completableFuture;
        }
        if (completionStage == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(10);
        }
        return completionStage;
        finally {
            this.myStopProcessRef.set(false);
            ProgressManager.checkCanceled();
        }
    }

    @NotNull
    private CompletionStage<DatabaseConnection> processConnectionFailure(@Nullable Credentials credentials, @NotNull SQLException e) {
        CompletionStage<DatabaseConnection> passwordResolution;
        if (e == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(12);
        }
        if (e.getCause() instanceof SQLException) {
            e = (SQLException)e.getCause();
        }
        String message = JdbcUtil.getLongMessage((Throwable)e);
        String title = "Connecting to: " + this.myUrl;
        String user = StringUtil.notNullize((String)(credentials == null ? null : credentials.getUserName()), (String)USER_KEY);
        if (this.myAttemptNo < 20 && DatabaseConnectionEstablisher.mayRequestPassword(message, user) && (passwordResolution = this.resolvePasswordIssues(title, message, credentials)) != null) {
            CompletionStage<DatabaseConnection> completionStage = passwordResolution;
            if (completionStage == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(13);
            }
            return completionStage;
        }
        LOG.warn(title);
        LOG.warn(message);
        CompletableFuture<DatabaseConnection> completableFuture = AsyncUtil.exceptional(e);
        if (completableFuture == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(14);
        }
        return completableFuture;
    }

    @Nullable
    private CompletionStage<DatabaseConnection> resolvePasswordIssues(@NotNull String title, @NotNull String message, @Nullable Credentials credentials) {
        if (title == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(15);
        }
        if (message == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(16);
        }
        DatabaseCredentials databaseCredentials = DatabaseCredentials.getInstance();
        if (this.myAttemptNo == 0 && !Comparing.equal((Object)credentials, (Object)databaseCredentials.getCredentials(this.myConnectionPoint.getDataSource()))) {
            return this.tryReconnectIfWithCredentials(databaseCredentials.getCredentials(this.myConnectionPoint.getDataSource()), message, title);
        }
        if (!this.myAskPassword) {
            return null;
        }
        String userName = credentials == null ? null : credentials.getUserName();
        return AsyncUtil.thenComposeAsync(DatabaseConnectionEstablisher.askPasswordAsync(this.myConnectionPoint.getDataSource(), this.myProject, databaseCredentials, credentials, userName, message), AsyncUtil.captureIndicator(c -> {
            if (message == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(22);
            }
            if (title == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(23);
            }
            return this.tryReconnectIfWithCredentials((Credentials)c, message, title);
        }), AsyncUtil.NON_EDT_EXECUTOR);
    }

    @NotNull
    private CompletionStage<DatabaseConnection> processNullConnection(@Nullable Credentials credentials) {
        if (this.myAttemptNo == 0 && DatabaseFamilyId.forConnection((RawConnectionConfig)this.myConnectionPoint).isPostgres()) {
            this.myUrl = this.myUrl + "/";
            CompletionStage<DatabaseConnection> completionStage = this.tryReconnect(credentials);
            if (completionStage == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(17);
            }
            return completionStage;
        }
        LOG.warn("Null connection returned for: " + this.myUrl);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(18);
        }
        return completableFuture;
    }

    @Nullable
    private DatabaseConnection connect() throws SQLException {
        LOG.info("Connecting to: " + this.myUrl);
        Connection jdbcConnection = null;
        try {
            jdbcConnection = this.myDriver.connect(this.myUrl, this.myConnectionProperties);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof UnmarshalException) {
                LOG.warn(e.getMessage());
            }
            throw e;
        }
        if (jdbcConnection != null) {
            try {
                this.prepareConnection(jdbcConnection);
            }
            catch (Throwable e) {
                JdbcUtil.closeConnectionSafe((Connection)jdbcConnection);
                throw e;
            }
        }
        return jdbcConnection == null ? null : new DatabaseConnection(this.myConnectionPoint, jdbcConnection, this.myConfiguration);
    }

    private void prepareConnection(@NotNull Connection jdbcConnection) throws SQLException {
        String name;
        if (jdbcConnection == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(19);
        }
        if (this.myConnectionPoint.isReadOnly()) {
            jdbcConnection.setReadOnly(true);
        }
        if (!DatabaseDriver.OPTION_SEND_APP_INFO.get(this.myConnectionPoint.getDatabaseDriver()).booleanValue()) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        String string = name = app == null || app.isUnitTestMode() ? null : ApplicationInfoEx.getInstanceEx().getFullApplicationName();
        if (name == null) {
            name = "DG Tests";
        }
        try {
            jdbcConnection.setClientInfo("ApplicationName", name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private CompletionStage<DatabaseConnection> tryReconnect(Credentials credentials) {
        ++this.myAttemptNo;
        this.myStopProcessRef.set(false);
        ProgressManager.checkCanceled();
        return this.tryConnect(credentials);
    }

    private CompletionStage<DatabaseConnection> tryReconnectIfWithCredentials(Credentials credentials, String message, String title) {
        if (credentials == null) {
            LOG.warn(title);
            LOG.warn(message);
            return AsyncUtil.cancelled();
        }
        return this.tryReconnect(credentials);
    }

    private static CompletionStage<Credentials> askPasswordAsync(@NotNull LocalDataSource dataSource, Project project, DatabaseCredentials databaseCredentials, Credentials credentials, String userName, String message) {
        if (dataSource == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(20);
        }
        String prompt = "The specified database user/password combination is rejected";
        prompt = prompt + (message.isEmpty() ? "." : ":<br>" + message);
        String userNameDef = StringUtil.notNullize((String)(credentials == null ? null : userName), (String)StringUtil.notNullize((String)dataSource.getUsername()));
        return databaseCredentials.askCredentialsWhenFailed(project, dataSource, "<html>" + prompt + "</html>", userNameDef);
    }

    private static boolean mayRequestPassword(@NotNull String message, @Nullable String user) {
        if (message == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(21);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return false;
        }
        if (message.contains("ORA-28001:")) {
            return true;
        }
        if (message.contains("ORA-12705:")) {
            return false;
        }
        String userPart = StringUtil.isNotEmpty((String)user) ? "|" + StringUtil.escapeToRegexp((String)user) : "";
        String regex = "(?i)\\b(access|denied|password|user" + userPart + ")\\b";
        return Pattern.compile(regex).matcher(message).find();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionPoint";
                break;
            }
            case 1: 
            case 4: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "releaseDriver";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseConnectionEstablisher";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcConnection";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseConnectionEstablisher";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "tryConnect";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processConnectionFailure";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "processNullConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "establishConnection";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processConnectionFailure";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolvePasswordIssues";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "prepareConnection";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "askPasswordAsync";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "mayRequestPassword";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolvePasswordIssues$2";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$establishConnection$1";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

