/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.AbstractScriptingService$WhenMappings;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.BaseEnableDisableGenerator;
import com.intellij.database.scripting.BaseRefreshMatViewGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u00020\u0007:\u0002pqB\u0017\b\u0014\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\nJ\u0010\u0010=\u001a\u00020>2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0012\u0010?\u001a\u00020>2\b\u0010@\u001a\u0004\u0018\u00010\u0006H\u0016J\u001d\u0010A\u001a\u0004\u0018\u00018\u00022\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CH\u0003\u00a2\u0006\u0002\u0010EJ\u0006\u0010F\u001a\u00020>J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0014J\u0010\u0010K\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0014J\u0010\u0010L\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0014J\u0010\u0010M\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0014J\u0010\u0010N\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0014J2\u0010O\u001a\u00180PR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0RH\u0014J\u0010\u0010S\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0014J\u0010\u0010T\u001a\u00020\"2\u0006\u0010U\u001a\u00020'H\u0016J\u0010\u0010V\u001a\u00020\"2\u0006\u0010U\u001a\u00020'H\u0016J\b\u00107\u001a\u000206H\u0016J\u0013\u0010W\u001a\b\u0012\u0004\u0012\u00020\"0XH\u0016\u00a2\u0006\u0002\u0010YJ\b\u0010Z\u001a\u00020\"H\u0016J\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020]0\\2\u0006\u0010^\u001a\u00020]H\u0014J\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020`0\\2\u0006\u0010^\u001a\u00020\u0006H\u0014J\u0010\u0010a\u001a\u00020\"2\u0006\u0010b\u001a\u000206H\u0002J\r\u0010c\u001a\u00020>H\u0010\u00a2\u0006\u0002\bdJ,\u0010e\u001a\u00020>2\u0018\u0010I\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0f0\\2\b\u0010@\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010g\u001a\u00020>2\u0006\u0010I\u001a\u00020J2\b\u0010@\u001a\u0004\u0018\u00010\u0006H\u0016J&\u0010g\u001a\u00020>2\u0006\u0010I\u001a\u00020J2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010h\u001a\u00020\fH\u0016J\u001e\u0010g\u001a\u00020>2\u0006\u0010I\u001a\u00020J2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00060jH\u0016J\u001e\u0010k\u001a\u00020>2\u0006\u0010I\u001a\u00020J2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020D0\\H\u0004J\u001c\u0010m\u001a\b\u0012\u0004\u0012\u00020'0C2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020'0\\H\u0004J\u001c\u0010n\u001a\b\u0012\u0004\u0012\u00020'0C2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020'0CH\u0002J\b\u0010o\u001a\u00020\"H\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R(\u0010\u0016\u001a\u0004\u0018\u00018\u00012\b\u0010\u0015\u001a\u0004\u0018\u00018\u00018W@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR(\u0010\u001c\u001a\u0004\u0018\u00018\u00022\b\u0010\u001b\u001a\u0004\u0018\u00018\u00028W@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u0004\u0018\u00010\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010,\u001a\u0004\b*\u0010+R$\u0010/\u001a\u00020.2\u0006\u0010-\u001a\u00020.8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\b\u0012\u0004\u0012\u000206058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u000eR\u0014\u0010;\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010$\u00a8\u0006r"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService;", "M", "Lcom/intellij/database/model/basic/BasicModel;", "D", "Lcom/intellij/database/model/basic/BasicDatabase;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/scripting/ScriptingService;", "model", "database", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicDatabase;)V", "considerOrderHeuristic", "", "getConsiderOrderHeuristic", "()Z", "setConsiderOrderHeuristic", "(Z)V", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "getContext", "()Lcom/intellij/database/scripting/ScriptingContext;", "db", "currentDatabase", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setCurrentDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "s", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "currentSchemaName", "", "getCurrentSchemaName", "()Ljava/lang/String;", "generated", "", "Lcom/intellij/database/model/basic/BasicElement;", "getGenerated", "()Ljava/util/Set;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/basic/BasicModel;", "newOptions", "Lcom/intellij/database/scripting/ScriptingOptions;", "options", "getOptions", "()Lcom/intellij/database/scripting/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/scripting/ScriptingOptions;)V", "script", "", "Lcom/intellij/database/scripting/CompositeText;", "getScript", "()Ljava/util/List;", "statementDelimiterOwnsLine", "getStatementDelimiterOwnsLine", "statementDelimiterStr", "getStatementDelimiterStr", "assumeCurrentDatabase", "", "assumeCurrentSchema", "schema", "checkForSingleSchema", "objects", "", "Lcom/intellij/database/model/basic/BasicScriptable;", "(Ljava/util/Collection;)Lcom/intellij/database/model/basic/BasicSchema;", "clearScript", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "createDropGenerator", "createEnableDisableGenerator", "createExecuteGenerator", "createGenerator", "createRefactoringGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$RefactoringGenerator;", "migrated", "", "createRefreshingGenerator", "getPreliminaryOrder", "element", "getPreliminaryOrderPart", "getScriptStatements", "", "()[Ljava/lang/String;", "getScriptText", "getScriptableChildren", "", "Lcom/intellij/database/model/basic/BasicSchemaObject;", "o", "getScriptableMajorObjects", "Lcom/intellij/database/model/basic/BasicMajorObject;", "getStatementDelimiter", "stmt", "init", "init$database_scripting", "makeRefactoringScript", "Lkotlin/Pair;", "makeScript", "recursive", "schemata", "", "sortAndGenerate", "unsortedObjects", "sortPreliminary", "sortTopologically", "toString", "RefactoringGenerator", "StupidGenerator", "database-scripting"})
public abstract class AbstractScriptingService<M extends BasicModel, D extends BasicDatabase, S extends BasicSchema>
implements ScriptingService {
    @NotNull
    private final M model;
    private boolean considerOrderHeuristic;
    @NotNull
    private final ScriptingContext context;

    @NotNull
    public final M getModel() {
        return this.model;
    }

    @Nullable
    public D getCurrentDatabase() {
        return (D)this.context.getCurrentDatabase();
    }

    public void setCurrentDatabase(@Nullable D db) {
        this.context.setCurrentDatabase((BasicDatabase)db);
    }

    @Nullable
    public S getCurrentSchema() {
        return (S)this.context.getCurrentSchema();
    }

    public void setCurrentSchema(@Nullable S s) {
        this.context.setCurrentSchema((BasicSchema)s);
    }

    private final String getCurrentSchemaName() {
        BasicSchema basicSchema = this.context.getCurrentSchema();
        return basicSchema != null ? basicSchema.getRealName() : null;
    }

    @Override
    public boolean getConsiderOrderHeuristic() {
        return this.considerOrderHeuristic;
    }

    @Override
    public void setConsiderOrderHeuristic(boolean bl) {
        this.considerOrderHeuristic = bl;
    }

    @NotNull
    protected final ScriptingContext getContext() {
        return this.context;
    }

    @NotNull
    protected final List<CompositeText> getScript() {
        return this.context.getScript();
    }

    @NotNull
    protected final Set<BasicElement> getGenerated() {
        return this.context.getGenerated();
    }

    @Override
    @NotNull
    public ScriptingOptions getOptions() {
        return this.context.getOptions();
    }

    @Override
    public void setOptions(@NotNull ScriptingOptions newOptions) {
        Intrinsics.checkParameterIsNotNull((Object)newOptions, (String)"newOptions");
        this.context.setOptions(newOptions);
    }

    public void init$database_scripting() {
    }

    @Override
    public void assumeCurrentDatabase(@NotNull BasicDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        this.context.setCurrentDatabase(database);
    }

    @Override
    public void assumeCurrentSchema(@Nullable BasicSchema schema) {
        this.context.setCurrentSchema(schema);
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @Nullable BasicSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        BasicSchema basicSchema = schema;
        if (basicSchema == null) {
            basicSchema = this.getCurrentSchema();
        }
        if (basicSchema == null) {
            return;
        }
        BasicSchema s = basicSchema;
        ArrayList<BasicMajorObject> elements = new ArrayList<BasicMajorObject>();
        if (schema != null) {
            this.setCurrentSchema(schema);
        }
        Iterable<BasicMajorObject> $receiver$iv = this.getScriptableMajorObjects(s);
        Iterator<BasicMajorObject> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            BasicMajorObject element$iv;
            BasicMajorObject it = element$iv = iterator.next();
            elements.add(it);
        }
        this.sortAndGenerate(task, (Iterable<BasicScriptable>)elements);
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @NotNull List<? extends BasicSchema> schemata) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(schemata, (String)"schemata");
        ArrayList<BasicMajorObject> elements = new ArrayList<BasicMajorObject>();
        if (schemata.size() == 1) {
            this.makeScript(task, (BasicSchema)CollectionsKt.first(schemata));
        } else {
            for (BasicSchema basicSchema : schemata) {
                Iterable<BasicMajorObject> $receiver$iv = this.getScriptableMajorObjects(basicSchema);
                Iterator<BasicMajorObject> iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    BasicMajorObject element$iv;
                    BasicMajorObject it = element$iv = iterator.next();
                    elements.add(it);
                }
            }
            this.sortAndGenerate(task, (Iterable<BasicScriptable>)elements);
        }
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @NotNull Collection<? extends BasicScriptable> objects, boolean recursive) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        ArrayList<? extends BasicScriptable> elements = new ArrayList<BasicScriptable>(objects);
        S singleSchema = this.checkForSingleSchema(objects);
        if (singleSchema != null) {
            this.setCurrentSchema(singleSchema);
        }
        this.sortAndGenerate(task, (Iterable<BasicScriptable>)elements);
    }

    private final S checkForSingleSchema(Collection<? extends BasicScriptable> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        BasicSchema schema = null;
        for (BasicScriptable basicScriptable : objects) {
            BasicSchema s;
            if (basicScriptable.getSchema() == null) {
                return null;
            }
            if (schema == null && s == null) {
                throw new TypeCastException("null cannot be cast to non-null type S");
            }
            if (schema == s) continue;
            return null;
        }
        return (S)schema;
    }

    @NotNull
    protected Iterable<BasicMajorObject> getScriptableMajorObjects(@NotNull BasicSchema o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        JBIterable jBIterable = o.getDasChildren(null).filter(BasicMajorObject.class).filter((Condition)getScriptableMajorObjects.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"o.getDasChildren(null)\n \u2026icTable || !it.isSystem})");
        return (Iterable)jBIterable;
    }

    @NotNull
    protected Iterable<BasicSchemaObject> getScriptableChildren(@NotNull BasicSchemaObject o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        JBIterable jBIterable = o.getDasChildren(null).filter(BasicSchemaObject.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"o.getDasChildren(null).f\u2026SchemaObject::class.java)");
        return (Iterable)jBIterable;
    }

    protected final void sortAndGenerate(@NotNull ScriptingTask task, @NotNull Iterable<? extends BasicScriptable> unsortedObjects) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(unsortedObjects, (String)"unsortedObjects");
        Collection<BasicElement> preliminarySortedObjects = this.sortPreliminary(unsortedObjects);
        Collection<BasicElement> topoSortedObjects = this.sortTopologically(preliminarySortedObjects);
        AbstractCodeGenerator generator = this.createGenerator(task);
        generator.setElementsToGenerate((Iterable<? extends BasicElement>)topoSortedObjects);
        generator.generate();
    }

    @NotNull
    protected AbstractCodeGenerator createGenerator(@NotNull ScriptingTask task) {
        AbstractCodeGenerator abstractCodeGenerator;
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        switch (AbstractScriptingService$WhenMappings.$EnumSwitchMapping$0[task.ordinal()]) {
            case 1: 
            case 2: {
                abstractCodeGenerator = this.createCreatingGenerator(task);
                break;
            }
            case 3: {
                abstractCodeGenerator = this.createDropGenerator(task);
                break;
            }
            case 4: 
            case 5: {
                abstractCodeGenerator = this.createEnableDisableGenerator(task);
                break;
            }
            case 6: {
                abstractCodeGenerator = this.createRefreshingGenerator(task);
                break;
            }
            case 7: {
                abstractCodeGenerator = this.createExecuteGenerator(task);
                break;
            }
            default: {
                abstractCodeGenerator = new StupidGenerator(this.context, task);
            }
        }
        return abstractCodeGenerator;
    }

    @NotNull
    protected AbstractCodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new BaseCreatingGenerator(this.context, task);
    }

    @NotNull
    protected AbstractCodeGenerator createEnableDisableGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new BaseEnableDisableGenerator(this.context, task);
    }

    @NotNull
    protected AbstractCodeGenerator createRefreshingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new BaseRefreshMatViewGenerator(this.context, task);
    }

    @NotNull
    protected AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new StupidGenerator(this.context, task);
    }

    @NotNull
    protected AbstractCodeGenerator createDropGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new BaseDropGenerator(this.context, task);
    }

    @NotNull
    protected final Collection<BasicElement> sortPreliminary(@NotNull Iterable<? extends BasicElement> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        TreeMap<String, BasicElement> sortingTree = new TreeMap<String, BasicElement>();
        for (BasicElement basicElement : objects) {
            String order = this.getPreliminaryOrder(basicElement);
            sortingTree.put(order, basicElement);
        }
        Collection<BasicElement> collection = sortingTree.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"sortingTree.values");
        return collection;
    }

    @NotNull
    public String getPreliminaryOrder(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        StringBuilder b = new StringBuilder(60);
        for (BasicElement e = element; e != null; e = e.getParent()) {
            CharSequence charSequence = b;
            if (charSequence.length() > 0) {
                b.insert(0, '.');
            }
            b.insert(0, this.getPreliminaryOrderPart(e));
            if (e instanceof BasicMajorObject) break;
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    @NotNull
    public String getPreliminaryOrderPart(@NotNull BasicElement element) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String kindOrder = ScriptingUtilsKt.orderString(element.getKind());
        BasicElement basicElement = element;
        if (basicElement instanceof BasicArrangedElement) {
            string = "#" + ScriptingUtilsKt.toFixedOrderString(((BasicArrangedElement)element).getPosition());
        } else if (basicElement instanceof BasicIdentifiedElement) {
            string = ScriptingUtilsKt.toOrderString(((BasicIdentifiedElement)element).getObjectId()) + "_" + ((BasicIdentifiedElement)element).getRealName();
        } else if (basicElement instanceof BasicNamedElement) {
            StringBuilder stringBuilder = new StringBuilder().append("?_");
            String string2 = ((BasicNamedElement)element).getRealName();
            if (string2 == null) {
                string2 = "???";
            }
            string = stringBuilder.append((Object)string2).toString();
        } else {
            string = "?????";
        }
        String elementOrder = string;
        return kindOrder + "_" + elementOrder;
    }

    private final Collection<BasicElement> sortTopologically(Collection<? extends BasicElement> objects) {
        return objects;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String[] getScriptStatements() {
        void var2_2;
        int size$iv = this.getScript().size();
        String[] result$iv = new String[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            void i2;
            String string;
            void i$iv;
            void var5_5 = i$iv;
            void var9_7 = i$iv++;
            String[] stringArray = result$iv;
            stringArray[var9_7] = string = ((Object)this.getScript().get((int)i2).getText()).toString();
        }
        return var2_2;
    }

    @Override
    @NotNull
    public String getScriptText() {
        return ((Object)this.getScript().getText()).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeText getScript() {
        void $receiver$iv;
        int initial$iv;
        Iterable iterable = this.getScript();
        int accumulator$iv = initial$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void t;
            CompositeText compositeText = (CompositeText)element$iv;
            int x = accumulator$iv;
            accumulator$iv = x + t.getText().length();
        }
        int capacity = accumulator$iv + 8 * this.getScript().size();
        CodeTextBuilder b = new CodeTextBuilder(capacity);
        for (CompositeText stmt : this.getScript()) {
            for (CompositeText.Fragment f : stmt.getFragments()) {
                b.append(f);
            }
            boolean hasDelimiter = b.endsWithIgnoreSpace(this.getStatementDelimiterStr());
            if (!hasDelimiter) {
                if (this.getStatementDelimiterOwnsLine()) {
                    b.ensureEoln(CompositeText.Kind.SQL_DELIMITER);
                }
                CodeTextBuilder.append$default(b, this.getStatementDelimiterStr(), CompositeText.Kind.SQL_DELIMITER, false, 4, null);
            }
            b.ensureBlankLine(CompositeText.Kind.SQL_DELIMITER);
        }
        return b;
    }

    private final String getStatementDelimiter(CompositeText stmt) {
        CompositeText.Fragment fragment = (CompositeText.Fragment)CollectionsKt.lastOrNull(stmt.getFragments());
        return Intrinsics.areEqual((Object)((Object)(fragment != null ? fragment.getKind() : null)), (Object)((Object)CompositeText.Kind.SQL_DELIMITER)) ^ true ? "" + this.getStatementDelimiterStr() + "\n\n" : "\n\n";
    }

    @Override
    public final void clearScript() {
        this.getScript().clear();
    }

    @NotNull
    public String getStatementDelimiterStr() {
        return ";";
    }

    public boolean getStatementDelimiterOwnsLine() {
        return false;
    }

    @NotNull
    public String toString() {
        return this.getScript().isEmpty() ? "ScriptingService for " + this.model.getRdbms() + ". Empty." : "ScriptingService for " + this.model.getRdbms() + "\nGenerated " + this.getScript().size() + " statements:\n" + this.getScriptText();
    }

    @Override
    public void makeRefactoringScript(@NotNull Iterable<? extends Pair<? extends BasicElement, ? extends BasicElement>> task, @Nullable BasicSchema schema) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        RefactoringGenerator generator = this.createRefactoringGenerator(MapsKt.toMap(task));
        Collection<BasicElement> preliminarySortedObjects = this.sortPreliminary((Iterable<BasicElement>)generator.getMigrated().keySet());
        Collection<BasicElement> topoSortedObjects = this.sortTopologically(preliminarySortedObjects);
        generator.setElementsToGenerate((Iterable<? extends BasicElement>)topoSortedObjects);
        generator.generate();
    }

    @NotNull
    protected RefactoringGenerator createRefactoringGenerator(@NotNull Map<BasicElement, ? extends BasicElement> migrated) {
        Intrinsics.checkParameterIsNotNull(migrated, (String)"migrated");
        return new RefactoringGenerator(this.context, migrated);
    }

    protected AbstractScriptingService(@NotNull M model, @NotNull D database) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        this.model = model;
        this.context = new ScriptingContext((BasicModel)model);
        this.context.setCurrentDatabase((BasicDatabase)database);
        this.context.setCurrentSchema(ModelFun.getCurrentSchema(database));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$StupidGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "database-scripting"})
    protected final class StupidGenerator
    extends AbstractCodeGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
                final /* synthetic */ StupidGenerator this$0;
                final /* synthetic */ BasicElement $element;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- " + this.$element.getKind().code() + ' ' + this.$element.getName(), null, false, 6, null);
                }
                {
                    this.this$0 = stupidGenerator;
                    this.$element = basicElement;
                    super(0);
                }
            }, 3, null);
        }

        public StupidGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(context, task);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(){

                public final void invoke() {
                    CodeTextBuilder.append$default(this.getBuilder(), "-- We don't know how to generate " + this.getTask().name() + " :(", null, false, 6, null);
                }
            }, 3, null);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0014R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$RefactoringGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "migrated", "", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Ljava/util/Map;)V", "getMigrated", "()Ljava/util/Map;", "generateElement", "", "element", "database-scripting"})
    protected class RefactoringGenerator
    extends AbstractCodeGenerator {
        @NotNull
        private final Map<BasicElement, BasicElement> migrated;

        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
                final /* synthetic */ RefactoringGenerator this$0;
                final /* synthetic */ BasicElement $element;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- unable to refactor " + this.$element.getKind().code() + ' ' + this.$element.getName(), null, false, 6, null);
                }
                {
                    this.this$0 = refactoringGenerator;
                    this.$element = basicElement;
                    super(0);
                }
            }, 3, null);
        }

        @NotNull
        public final Map<BasicElement, BasicElement> getMigrated() {
            return this.migrated;
        }

        public RefactoringGenerator(@NotNull ScriptingContext context, Map<BasicElement, ? extends BasicElement> migrated) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(migrated, (String)"migrated");
            super(context, ScriptingTask.CREATE_DEFINITION);
            this.migrated = migrated;
        }
    }
}

