/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateConstraint", "", "constraint", "Lcom/intellij/database/model/basic/BasicConstraint;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateTable", "table", "Lcom/intellij/database/model/basic/BasicTable;", "generateTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateUnspecifiedMajorObject", "Lcom/intellij/database/model/basic/BasicMajorObject;", "unknownHowToDrop", "database-scripting"})
public class BaseDropGenerator
extends AbstractCodeGenerator {
    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof BasicTable) {
            this.generateTable((BasicTable)element);
        } else if (basicElement instanceof BasicConstraint) {
            this.generateConstraint((BasicConstraint)element);
        } else if (basicElement instanceof BasicTrigger) {
            this.generateTrigger((BasicTrigger)element);
        } else if (basicElement instanceof BasicMajorObject) {
            this.generateUnspecifiedMajorObject((BasicMajorObject)element);
        } else {
            this.unknownHowToDrop(element);
        }
    }

    protected void generateTable(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        this.generateUnspecifiedMajorObject(table);
    }

    /*
     * WARNING - void declaration
     */
    protected void generateConstraint(@NotNull BasicConstraint constraint) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        BasicLikeTable basicLikeTable = constraint.getLikeTable();
        if (basicLikeTable == null) {
            return;
        }
        BasicLikeTable table = basicLikeTable;
        String tableName = this.currentScopeName(table);
        String string = constraint.getName();
        BaseDropGenerator this_$iv = this;
        String constraintName = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tableName, constraintName){
            final /* synthetic */ BaseDropGenerator this$0;
            final /* synthetic */ String $tableName;
            final /* synthetic */ String $constraintName;

            public final void invoke() {
                this.this$0.getBuilder().phrase("alter table", this.$tableName, "drop constraint", this.$constraintName);
            }
            {
                this.this$0 = baseDropGenerator;
                this.$tableName = string;
                this.$constraintName = string2;
                super(0);
            }
        }, 3, null);
    }

    protected void generateTrigger(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger){
            final /* synthetic */ BaseDropGenerator this$0;
            final /* synthetic */ BasicTrigger $trigger;

            public final void invoke() {
                this.this$0.getBuilder().phrase("drop trigger", this.this$0.currentScopeName(this.$trigger));
            }
            {
                this.this$0 = baseDropGenerator;
                this.$trigger = basicTrigger;
                super(0);
            }
        }, 3, null);
    }

    protected void generateUnspecifiedMajorObject(@NotNull BasicMajorObject element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String kindName = element.getKind().name();
        String objectName = this.currentScopeName(element);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, kindName, objectName){
            final /* synthetic */ BaseDropGenerator this$0;
            final /* synthetic */ String $kindName;
            final /* synthetic */ String $objectName;

            public final void invoke() {
                this.this$0.getBuilder().phrase("drop", this.$kindName, this.$objectName);
            }
            {
                this.this$0 = baseDropGenerator;
                this.$kindName = string;
                this.$objectName = string2;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void unknownHowToDrop(BasicElement element) {
        void $receiver$iv;
        String kindName = element.getKind().name();
        String string = element.getName();
        BaseDropGenerator this_$iv = this;
        String elementName = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, kindName, elementName){
            final /* synthetic */ BaseDropGenerator this$0;
            final /* synthetic */ String $kindName;
            final /* synthetic */ String $elementName;

            public final void invoke() {
                this.this$0.getBuilder().phrase("-- unknown how to drop " + this.$kindName + ' ' + this.$elementName + " :(");
            }
            {
                this.this$0 = baseDropGenerator;
                this.$kindName = string;
                this.$elementName = string2;
                super(0);
            }
        }, 3, null);
    }

    public BaseDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        super(context, task);
    }
}

