/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicMatView;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.oracle.OraArgument;
import com.intellij.database.model.oracle.OraBody;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraClusterColumn;
import com.intellij.database.model.oracle.OraClusterIndex;
import com.intellij.database.model.oracle.OraCollectionType;
import com.intellij.database.model.oracle.OraMatLog;
import com.intellij.database.model.oracle.OraMatView;
import com.intellij.database.model.oracle.OraModel;
import com.intellij.database.model.oracle.OraModule;
import com.intellij.database.model.oracle.OraPackage;
import com.intellij.database.model.oracle.OraPackageRoutine;
import com.intellij.database.model.oracle.OraRoot;
import com.intellij.database.model.oracle.OraRoutine;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraSequence;
import com.intellij.database.model.oracle.OraSingleRoutine;
import com.intellij.database.model.oracle.OraSourceAware;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.oracle.OraTableColumn;
import com.intellij.database.model.oracle.OraTrigger;
import com.intellij.database.model.oracle.OraView;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.BaseExecuteGenerator;
import com.intellij.database.scripting.BaseRefreshMatViewGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.OraScriptingService;
import com.intellij.database.scripting.OraScriptingService$OraCreatingGenerator$WhenMappings;
import com.intellij.database.scripting.OraScriptingService$OraExecuteGenerator$WhenMappings;
import com.intellij.database.scripting.OraScriptingService$OraRefreshMatViewGenerator$WhenMappings;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0004\u0015\u0016\u0017\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/scripting/OraScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/oracle/OraModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "model", "(Lcom/intellij/database/model/oracle/OraModel;)V", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "statementDelimiterStr", "", "getStatementDelimiterStr", "()Ljava/lang/String;", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "createExecuteGenerator", "createRefreshingGenerator", "OraCreatingGenerator", "OraExecuteGenerator", "OraRefreshMatViewGenerator", "VERSION", "database-scripting"})
public final class OraScriptingService
extends AbstractScriptingService<OraModel, OraRoot, OraSchema> {
    @NotNull
    private final String statementDelimiterStr = "/";
    private final boolean statementDelimiterOwnsLine = true;

    @Override
    @NotNull
    public String getStatementDelimiterStr() {
        return this.statementDelimiterStr;
    }

    @Override
    public boolean getStatementDelimiterOwnsLine() {
        return this.statementDelimiterOwnsLine;
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new OraCreatingGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createRefreshingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new OraRefreshMatViewGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new OraExecuteGenerator(this.getContext(), task);
    }

    public OraScriptingService(@NotNull OraModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        BasicModel basicModel = model;
        OraRoot oraRoot = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)oraRoot, (String)"model.root");
        super(basicModel, (BasicDatabase)oraRoot);
        this.statementDelimiterStr = "/";
        this.statementDelimiterOwnsLine = true;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0014J\u0010\u00103\u001a\u00020\b2\u0006\u0010'\u001a\u000204H\u0014J\u0010\u00105\u001a\u00020\b2\u0006\u00106\u001a\u000207H\u0014J\u000e\u00108\u001a\u00020\b2\u0006\u0010!\u001a\u000209J\u0012\u0010:\u001a\u0004\u0018\u00010\r2\u0006\u0010;\u001a\u00020<H\u0014J\u0010\u0010=\u001a\u00020>2\u0006\u0010'\u001a\u000204H\u0014\u00a8\u0006?"}, d2={"Lcom/intellij/database/scripting/OraScriptingService$OraCreatingGenerator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/OraScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "gatherSequenceIdentityParameters", "", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "parameters", "", "", "generateBody", "body", "Lcom/intellij/database/model/oracle/OraBody;", "generateCluster", "cluster", "Lcom/intellij/database/model/oracle/OraCluster;", "generateClusterIndex", "index", "Lcom/intellij/database/model/oracle/OraClusterIndex;", "generateCollectionType", "col", "Lcom/intellij/database/model/oracle/OraCollectionType;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateMatLog", "ml", "Lcom/intellij/database/model/oracle/OraMatLog;", "generateMatView", "view", "Lcom/intellij/database/model/oracle/OraMatView;", "generateModule", "module", "Lcom/intellij/database/model/oracle/OraModule;", "generateObjectTable", "table", "Lcom/intellij/database/model/oracle/OraTable;", "generatePublicSynonym", "synonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "generateSimpleSourceAwareObject", "obj", "Lcom/intellij/database/model/oracle/OraSourceAware;", "generateSingleRoutine", "routine", "Lcom/intellij/database/model/oracle/OraSingleRoutine;", "generateSynonym", "generateTable", "Lcom/intellij/database/model/basic/BasicTable;", "generateTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateView", "Lcom/intellij/database/model/oracle/OraView;", "makeColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "database-scripting"})
    private final class OraCreatingGenerator
    extends BaseCreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof OraCluster) {
                this.generateCluster((OraCluster)element);
            } else if (basicElement instanceof OraClusterIndex) {
                this.generateClusterIndex((OraClusterIndex)element);
            } else if (basicElement instanceof OraCollectionType) {
                this.generateCollectionType((OraCollectionType)element);
            } else if (basicElement instanceof OraModule) {
                this.generateModule((OraModule)element);
            } else if (basicElement instanceof OraBody) {
                this.generateBody((OraBody)element);
            } else if (basicElement instanceof OraSingleRoutine) {
                this.generateSingleRoutine((OraSingleRoutine)element);
            } else if (basicElement instanceof OraMatLog) {
                this.generateMatLog((OraMatLog)element);
            } else if (basicElement instanceof OraMatView) {
                this.generateMatView((OraMatView)element);
            } else if (basicElement instanceof OraView) {
                this.generateView((OraView)element);
            } else {
                super.generateElement(element);
            }
        }

        @Override
        protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            super.gatherSequenceIdentityParameters(sequence, parameters);
            if (sequence instanceof OraSequence) {
                if (((OraSequence)sequence).isOrdered()) {
                    parameters.add("order");
                }
                if (((OraSequence)sequence).isCycled()) {
                    parameters.add("cycle");
                }
                if (((OraSequence)sequence).getCacheSize() > 0) {
                    parameters.add("cache " + ((OraSequence)sequence).getCacheSize());
                }
                if (((OraSequence)sequence).getCacheSize() < 0) {
                    parameters.add("nocache");
                }
            }
        }

        @Override
        protected void generateTable(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            if (table instanceof OraTable && ((OraTable)table).getRowTypeObjectName() != null) {
                this.generateObjectTable((OraTable)table);
            } else {
                super.generateTable(table);
            }
        }

        private final void generateObjectTable(OraTable table) {
            String string;
            String $receiver$iv;
            OraCreatingGenerator this_$iv;
            String objectSchemaName = table.getRowTypeSchemaName();
            if (Intrinsics.areEqual((Object)objectSchemaName, (Object)table.getSchemaName())) {
                objectSchemaName = null;
            }
            String string2 = table.getRowTypeObjectName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String objectName = string2;
            if (objectSchemaName == null) {
                String string3 = objectName;
                this_$iv = this;
                string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            } else {
                $receiver$iv = objectSchemaName;
                this_$iv = this;
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                $receiver$iv = objectName;
                this_$iv = this;
                stringBuilder = stringBuilder.append(string4).append('.');
                string4 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                string = stringBuilder.append(string4).toString();
            }
            String n = string;
            String[] stringArray = new String[5];
            stringArray[0] = "create table";
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"TABLE");
            stringArray[1] = this.ifNotExists(objectKind);
            stringArray[2] = this.currentScopeName(table);
            stringArray[3] = "of";
            stringArray[4] = n;
            String s = ScriptingUtilsKt.phrase(stringArray);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s, null, false, 6, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$s = string;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        @Nullable
        protected String makeColumnSpecification(@NotNull BasicLikeColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String s = super.makeColumnSpecification(column);
            if (column instanceof OraTableColumn && ((OraTableColumn)column).isAutoInc()) {
                Collection collection;
                String x = ((OraTableColumn)column).isDefaultOnNull() ? " generated by default on null as identity" : " generated as identity";
                ArrayList parameters = new ArrayList();
                SequenceIdentity sequenceIdentity = ((OraTableColumn)column).getSequenceIdentity();
                if (sequenceIdentity != null) {
                    this.gatherSequenceIdentityParameters(sequenceIdentity, (List<String>)parameters);
                }
                if (!(collection = (Collection)parameters).isEmpty()) {
                    x = x + " (" + CollectionsKt.joinToString$default((Iterable)parameters, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ')';
                }
                s = Intrinsics.stringPlus((String)s, (Object)x);
            }
            return s;
        }

        private final void generateCluster(OraCluster cluster) {
            String name = this.currentScopeName(cluster);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, cluster){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ OraCluster $cluster;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create cluster " + this.$name, null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, 6, null);
                    AbstractCodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateCluster.1 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            for (OraClusterColumn oraClusterColumn : this.this$0.$cluster.getColumns()) {
                                void $receiver$iv;
                                String string = oraClusterColumn.getName();
                                OraCreatingGenerator this_$iv = this.this$0.this$0;
                                String name1 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
                                String type1 = oraClusterColumn.getDataType().getSpecification();
                                String suffix = oraClusterColumn.isSorted() ? " sort" : "";
                                CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), "" + name1 + ' ' + type1 + "" + suffix + ',', null, false, 6, null);
                            }
                            if (this.this$0.$cluster.getColumns().isEmpty()) {
                                CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), "-- looks like columns were not retrieved because the user had no SELECT_CATALOG_ROLE :(", null, false, 6, null);
                            }
                            this.this$0.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 1, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (this.$cluster.getBlockSize() > 0) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "size " + this.$cluster.getBlockSize(), null, false, 6, null);
                        }
                        String singleTableClause = this.$cluster.isSingleTable() ? "single table" : null;
                        String cardinalityClause = this.$cluster.getHashCardinality() != 0 ? "hashkeys " + this.$cluster.getHashCardinality() : null;
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), ScriptingUtilsKt.concatWithSpace(singleTableClause, cardinalityClause), null, false, 6, null);
                        if (this.$cluster.getHashExpression() != null) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "hash is " + this.$cluster.getHashExpression(), null, false, 6, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$name = string;
                    this.$cluster = oraCluster;
                    super(0);
                }
            }, 3, null);
            OraClusterIndex index = cluster.getIndices().get();
            if (index != null) {
                this.generateClusterIndex(index);
            }
        }

        private final void generateClusterIndex(OraClusterIndex index) {
            OraCluster oraCluster = index.getCluster();
            if (oraCluster == null) {
                return;
            }
            OraCluster cluster = oraCluster;
            String clusterName = this.currentScopeName(cluster);
            String indexName = this.currentScopeName(index);
            ClusterType clusterType = cluster.getClusterType();
            if (clusterType != null) {
                switch (OraScriptingService$OraCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[clusterType.ordinal()]) {
                    case 1: {
                        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, indexName, clusterName){
                            final /* synthetic */ OraCreatingGenerator this$0;
                            final /* synthetic */ String $indexName;
                            final /* synthetic */ String $clusterName;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void invoke() {
                                CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                                CharSequence[] charSequenceArray = new CharSequence[3];
                                charSequenceArray[0] = "create index";
                                ObjectKind objectKind = ObjectKind.INDEX;
                                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"INDEX");
                                charSequenceArray[1] = this.this$0.ifNotExists(objectKind);
                                charSequenceArray[2] = this.$indexName;
                                codeTextBuilder.phrase(charSequenceArray);
                                CodeTextBuilder this_$iv = this.this$0.getBuilder();
                                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                                try {
                                    this.this$0.getBuilder().phrase("on cluster", this.$clusterName);
                                }
                                finally {
                                    this_$iv.unindent();
                                }
                            }
                            {
                                this.this$0 = oraCreatingGenerator;
                                this.$indexName = string;
                                this.$clusterName = string2;
                                super(0);
                            }
                        }, 3, null);
                    }
                }
            }
            OraScriptingService.this.getGenerated().add(index);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            OraTable tab = (OraTable)table;
            String name = this.currentScopeName(table);
            String[] stringArray = new String[3];
            stringArray[0] = "create table";
            ObjectKind objectKind = ((OraTable)table).getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"table.kind");
            stringArray[1] = this.ifNotExists(objectKind);
            stringArray[2] = name;
            String string = ScriptingUtilsKt.phrase(stringArray);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String h = string;
            String f = null;
            if (tab.getClusterName() != null) {
                void $receiver$iv;
                void $receiver$iv2;
                String string2 = tab.getClusterName();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = string2;
                OraCreatingGenerator this_$iv = this;
                String cn = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv2);
                Iterable $i$f$getScr = ((OraTable)table).getClusterColNames();
                OraCreatingGenerator this_$iv2 = this;
                String cols = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>((AbstractCodeGenerator)this_$iv2){
                    final /* synthetic */ AbstractCodeGenerator this$0;

                    @NotNull
                    public final String invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        String $receiver$iv = it;
                        AbstractCodeGenerator this_$iv = this.this$0;
                        return AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                    }
                    {
                        this.this$0 = abstractCodeGenerator;
                        super(1);
                    }
                }), (int)31, null);
                f = "\tcluster " + cn + " (" + cols + ')';
            } else if (Intrinsics.areEqual((Object)((Object)tab.getOrganization()), (Object)((Object)TableOrganization.INDEX))) {
                f = "\torganization index";
            } else if (tab.isTemporary()) {
                String string4;
                String[] stringArray2 = new String[3];
                stringArray2[0] = "create global temporary table";
                ObjectKind objectKind2 = ((OraTable)table).getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"table.kind");
                stringArray2[1] = this.ifNotExists(objectKind2);
                stringArray2[2] = name;
                String string5 = ScriptingUtilsKt.phrase(stringArray2);
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                h = string5;
                boolean bl = tab.isTemporaryPreserve();
                if (!bl) {
                    string4 = "\ton commit delete rows";
                } else if (bl) {
                    string4 = "\ton commit preserve rows";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                f = string4;
            }
            return new HeaderFooter(h, f);
        }

        public final void generateCollectionType(@NotNull OraCollectionType col) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
            String name = this.currentScopeName(col);
            int n = col.getUpperBound();
            DataType dataType = col.getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"col.elementType");
            String d = this.script(dataType);
            if (col.isArray() && n > 0) {
                String[] stringArray = new String[4];
                ObjectKind objectKind = col.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"col.kind");
                stringArray[0] = this.createOrReplace(objectKind);
                stringArray[1] = "type";
                stringArray[2] = name;
                stringArray[3] = "is varray(" + n + ") of " + d;
                string = ScriptingUtilsKt.phrase(stringArray);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                String[] stringArray = new String[5];
                ObjectKind objectKind = col.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"col.kind");
                stringArray[0] = this.createOrReplace(objectKind);
                stringArray[1] = "type";
                stringArray[2] = name;
                stringArray[3] = "as table of";
                stringArray[4] = d;
                string = ScriptingUtilsKt.phrase(stringArray);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            }
            String s1 = string;
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s1){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $s1;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s1, null, false, 6, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$s1 = string;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateTrigger(@NotNull BasicTrigger trigger) {
            OraTable table;
            Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
            OraTrigger cfr_ignored_0 = (OraTrigger)trigger;
            String triggerName = this.currentScopeName(trigger);
            CharSequence charSequence = ((OraTrigger)trigger).getOriginalSourceText();
            if (charSequence == null) {
                return;
            }
            CharSequence text2 = charSequence;
            DasTable dasTable = ((OraTrigger)trigger).getTable();
            if (!(dasTable instanceof OraTable)) {
                dasTable = null;
            }
            if ((table = (OraTable)dasTable) == null) {
                AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName){
                    final /* synthetic */ OraCreatingGenerator this$0;
                    final /* synthetic */ String $triggerName;

                    public final void invoke() {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- Cannot generate trigger " + this.$triggerName + ": the table is unknown", null, false, 6, null);
                    }
                    {
                        this.this$0 = oraCreatingGenerator;
                        this.$triggerName = string;
                        super(0);
                    }
                }, 3, null);
                return;
            }
            String tableName = this.currentScopeName(table);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, trigger, tableName, text2){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $triggerName;
                final /* synthetic */ BasicTrigger $trigger;
                final /* synthetic */ String $tableName;
                final /* synthetic */ CharSequence $text;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    CharSequence[] charSequenceArray = new CharSequence[3];
                    ObjectKind objectKind = ObjectKind.TRIGGER;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"TRIGGER");
                    charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                    charSequenceArray[1] = "trigger";
                    charSequenceArray[2] = this.$triggerName;
                    codeTextBuilder.phrase(charSequenceArray);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        String ev = ScriptingUtilsKt.makeTriggerEventString(this.$trigger);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), ev, null, false, 6, null);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "on " + this.$tableName, null, false, 6, null);
                        TrigTurn turn = ((OraTrigger)this.$trigger).getTurn();
                        if (Intrinsics.areEqual((Object)turn, (Object)TrigTurn.BEFORE_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.AFTER_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.INSTEAD_OF)) {
                            String c;
                            String string;
                            CharSequence charSequence;
                            String s = "for each row";
                            String string2 = ((OraTrigger)this.$trigger).getCondition();
                            if (string2 != null) {
                                charSequence = string2;
                                String string3 = charSequence;
                                if (string3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                            } else {
                                string = c = null;
                            }
                            if (c != null && (charSequence = (CharSequence)c).length() > 0) {
                                s = s + " when (" + s + ')';
                            }
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), s, null, false, 6, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$text, CompositeText.Kind.ORIGINAL_TEXT, false, 4, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$triggerName = string;
                    this.$trigger = basicTrigger;
                    this.$tableName = string2;
                    this.$text = charSequence;
                    super(0);
                }
            }, 3, null);
        }

        public final void generateMatLog(@NotNull OraMatLog ml) {
            OraTable logTable;
            Intrinsics.checkParameterIsNotNull((Object)ml, (String)"ml");
            OraTable oraTable = ml.getTable();
            if (oraTable == null) {
                return;
            }
            OraTable masterTable = oraTable;
            String string = masterTable.getRealName();
            if (string == null) {
                return;
            }
            String masterName = string;
            String withOptions = ml.withOptions();
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, masterName, withOptions, ml){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $masterName;
                final /* synthetic */ String $withOptions;
                final /* synthetic */ OraMatLog $ml;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    this.this$0.getBuilder().phrase("create materialized view log on " + this.$masterName);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$withOptions, null, false, 6, null);
                        if (this.$ml.isWithNewValues()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "including new values", null, false, 6, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$masterName = string;
                    this.$withOptions = string2;
                    this.$ml = oraMatLog;
                    super(0);
                }
            }, 3, null);
            OraSchema schema = masterTable.getSchema();
            BasicNode basicNode = schema;
            OraTable oraTable2 = basicNode != null && (basicNode = basicNode.getTables()) != null ? (OraTable)basicNode.get(ml.getName()) : (logTable = null);
            if (logTable != null) {
                OraScriptingService.this.getGenerated().add(logTable);
            }
        }

        public final void generateMatView(@NotNull OraMatView view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            String name = this.currentScopeName(view);
            Object object = view.getSourceText();
            if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
                return;
            }
            Object sourceText = object;
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view, name, (CompositeText.Fragment)sourceText){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ OraMatView $view;
                final /* synthetic */ String $name;
                final /* synthetic */ CompositeText.Fragment $sourceText;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    CharSequence[] charSequenceArray = new CharSequence[3];
                    ObjectKind objectKind = this.$view.getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"view.kind");
                    charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                    charSequenceArray[1] = "materialized view";
                    charSequenceArray[2] = this.$name;
                    codeTextBuilder.phrase(charSequenceArray);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (this.$view.isPrebuilt()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "on prebuilt table", null, false, 6, null);
                        }
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$view.getRefreshSpecification(), null, false, 6, null);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "as", null, false, 6, null);
                    this.this$0.getBuilder().append(this.$sourceText);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$view = oraMatView;
                    this.$name = string;
                    this.$sourceText = fragment;
                    super(0);
                }
            }, 3, null);
        }

        public final void generateView(@NotNull OraView view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            String name = this.currentScopeName(view);
            Object object = view.getSourceText();
            if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
                return;
            }
            Object sourceText = object;
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view, name, (CompositeText.Fragment)sourceText){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ OraView $view;
                final /* synthetic */ String $name;
                final /* synthetic */ CompositeText.Fragment $sourceText;

                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    CharSequence[] charSequenceArray = new CharSequence[4];
                    ObjectKind objectKind = this.$view.getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"view.kind");
                    charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                    charSequenceArray[1] = "view";
                    charSequenceArray[2] = this.$name;
                    charSequenceArray[3] = "as";
                    codeTextBuilder.phrase(charSequenceArray);
                    this.this$0.getBuilder().append(this.$sourceText);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$view = oraView;
                    this.$name = string;
                    this.$sourceText = fragment;
                    super(0);
                }
            }, 3, null);
        }

        public final void generateModule(@NotNull OraModule module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            this.generateSimpleSourceAwareObject(module);
            OraBody body = module.getBodies().get();
            if (body != null) {
                this.process(body);
            }
        }

        public final void generateBody(@NotNull OraBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            this.generateSimpleSourceAwareObject(body);
        }

        public final void generateSingleRoutine(@NotNull OraSingleRoutine routine) {
            Intrinsics.checkParameterIsNotNull((Object)routine, (String)"routine");
            this.generateSimpleSourceAwareObject(routine);
        }

        private final void generateSimpleSourceAwareObject(OraSourceAware obj) {
            Object object = obj.getSourceText();
            if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
                return;
            }
            Object sourceText = object;
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, obj, (CompositeText.Fragment)sourceText){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ OraSourceAware $obj;
                final /* synthetic */ CompositeText.Fragment $sourceText;

                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    StringBuilder stringBuilder = new StringBuilder();
                    ObjectKind objectKind = this.$obj.getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"obj.kind");
                    CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(this.this$0.createOrReplace(objectKind)).append(" ").toString(), null, false, 2, null);
                    this.this$0.getBuilder().append(this.$sourceText);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$obj = oraSourceAware;
                    this.$sourceText = fragment;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateSynonym(@NotNull BasicSynonym synonym) {
            Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
            if (Intrinsics.areEqual((Object)synonym.getSchemaName(), (Object)"PUBLIC")) {
                this.generatePublicSynonym(synonym);
            } else {
                super.generateSynonym(synonym);
            }
        }

        private final void generatePublicSynonym(BasicSynonym synonym) {
            String text2;
            String targetSpec = this.makeSynonymTargetSpec(synonym);
            String name = this.currentScopeName(synonym);
            if (targetSpec != null) {
                String[] stringArray = new String[5];
                ObjectKind objectKind = ObjectKind.SYNONYM;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"SYNONYM");
                stringArray[0] = this.createOrReplace(objectKind);
                stringArray[1] = "public synonym";
                stringArray[2] = name;
                stringArray[3] = "for";
                stringArray[4] = targetSpec;
                text2 = ScriptingUtilsKt.phrase(stringArray);
            } else {
                text2 = "-- unknown what the public synonym " + name + " references on :(";
            }
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, text2){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $text;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$text, null, false, 6, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$text = string;
                    super(0);
                }
            }, 3, null);
        }

        public OraCreatingGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(context, task);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/database/scripting/OraScriptingService$OraRefreshMatViewGenerator;", "Lcom/intellij/database/scripting/BaseRefreshMatViewGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/OraScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateHeading", "", "generateRefreshMatView", "view", "Lcom/intellij/database/model/basic/BasicMatView;", "generateRefreshMatViewsUsingSystemProcedure", "database-scripting"})
    private final class OraRefreshMatViewGenerator
    extends BaseRefreshMatViewGenerator {
        @Override
        protected void generateHeading() {
            super.generateHeading();
            if (OraScriptingService.this.getOptions().get(ScriptingOptionStatic.USE_SYSTEM_PROCEDURES).booleanValue()) {
                this.generateRefreshMatViewsUsingSystemProcedure();
            }
        }

        private final void generateRefreshMatViewsUsingSystemProcedure() {
            List mvs = CollectionsKt.filterIsInstance((Iterable)this.getDeck(), OraMatView.class);
            if (mvs.isEmpty()) {
                return;
            }
            String mvsString2 = CollectionsKt.joinToString$default((Iterable)mvs, null, null, null, (int)0, null, (Function1)((Function1)new Function1<OraMatView, String>(this){
                final /* synthetic */ OraRefreshMatViewGenerator this$0;

                @NotNull
                public final String invoke(@NotNull OraMatView it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.this$0.currentScopeName(it);
                }
                {
                    this.this$0 = oraRefreshMatViewGenerator;
                    super(1);
                }
            }), (int)31, null);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, mvsString2){
                final /* synthetic */ OraRefreshMatViewGenerator this$0;
                final /* synthetic */ String $mvsString;

                public final void invoke() {
                    this.this$0.getBuilder().phrase("begin");
                    this.this$0.coding(ScriptLocus.IN_CODE_BLOCK, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateRefreshMatViewsUsingSystemProcedure.1 this$0;

                        public final void invoke() {
                            String cmd = "dbms_mview.refresh('" + this.this$0.$mvsString + "');";
                            CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), cmd, null, false, 6, null);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                    this.this$0.getBuilder().phrase("end;");
                }
                {
                    this.this$0 = oraRefreshMatViewGenerator;
                    this.$mvsString = string;
                    super(0);
                }
            }, 3, null);
            this.getDeck().removeAll(mvs);
            OraScriptingService.this.getGenerated().addAll(mvs);
        }

        @Override
        protected void generateRefreshMatView(@NotNull BasicMatView view) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            OraMatView cfr_ignored_0 = (OraMatView)view;
            switch (OraScriptingService$OraRefreshMatViewGenerator$WhenMappings.$EnumSwitchMapping$0[((OraMatView)view).getRefreshMethod().ordinal()]) {
                case 1: 
                case 2: {
                    string = "force";
                    break;
                }
                default: {
                    string = "complete";
                }
            }
            String methodString = string;
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view, methodString){
                final /* synthetic */ OraRefreshMatViewGenerator this$0;
                final /* synthetic */ BasicMatView $view;
                final /* synthetic */ String $methodString;

                public final void invoke() {
                    this.this$0.getBuilder().phrase("alter materialized view", this.this$0.currentScopeName(this.$view), "refresh", this.$methodString);
                }
                {
                    this.this$0 = oraRefreshMatViewGenerator;
                    this.$view = basicMatView;
                    this.$methodString = string;
                    super(0);
                }
            }, 3, null);
        }

        public OraRefreshMatViewGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(context, task);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/OraScriptingService$OraExecuteGenerator;", "Lcom/intellij/database/scripting/BaseExecuteGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/OraScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generatePackage", "pack", "Lcom/intellij/database/model/oracle/OraPackage;", "generateRoutine", "routine", "Lcom/intellij/database/model/oracle/OraRoutine;", "guessDefaultValue", "", "dt", "Lcom/intellij/database/model/DataType;", "database-scripting"})
    private final class OraExecuteGenerator
    extends BaseExecuteGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof OraPackage) {
                this.generatePackage((OraPackage)element);
            } else if (basicElement instanceof OraRoutine) {
                this.generateRoutine((OraRoutine)element);
            }
        }

        private final void generatePackage(OraPackage pack) {
            Iterator iterator = pack.getRoutines().iterator();
            while (iterator.hasNext()) {
                OraPackageRoutine routine;
                OraPackageRoutine oraPackageRoutine = routine = (OraPackageRoutine)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)oraPackageRoutine, (String)"routine");
                this.process(oraPackageRoutine);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void generateRoutine(OraRoutine routine) {
            void ret;
            void hasOut;
            Ref.BooleanRef $receiver$iv;
            String string;
            OraRoutine oraRoutine = routine;
            if (oraRoutine instanceof OraSingleRoutine) {
                string = this.currentScopeName(routine);
            } else if (oraRoutine instanceof OraPackageRoutine) {
                void this_$iv;
                StringBuilder stringBuilder = new StringBuilder();
                OraPackage oraPackage = ((OraPackageRoutine)routine).getPackage();
                if (oraPackage == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = ((OraPackageRoutine)routine).getName();
                OraExecuteGenerator oraExecuteGenerator = this;
                StringBuilder stringBuilder2 = stringBuilder.append(this.currentScopeName(oraPackage)).append('.');
                String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                string = stringBuilder2.append(string3).toString();
            } else {
                return;
            }
            String callName = string;
            List arguments = CollectionsKt.toList((Iterable)routine.getArguments());
            int n = arguments.size();
            $receiver$iv = new Ref.BooleanRef();
            $receiver$iv.element = false;
            Ref.ObjectRef $i$f$getScr = new Ref.ObjectRef();
            $i$f$getScr.element = null;
            for (OraArgument argument : arguments) {
                DasArgument.Direction d = argument.getArgumentDirection();
                switch (OraScriptingService$OraExecuteGenerator$WhenMappings.$EnumSwitchMapping$0[d.ordinal()]) {
                    case 1: {
                        hasOut.element = true;
                        break;
                    }
                    case 2: {
                        hasOut.element = true;
                        break;
                    }
                    case 3: {
                        ret.element = argument;
                    }
                }
            }
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, (Ref.BooleanRef)hasOut, (Ref.ObjectRef)ret, arguments, n, callName){
                final /* synthetic */ OraExecuteGenerator this$0;
                final /* synthetic */ Ref.BooleanRef $hasOut;
                final /* synthetic */ Ref.ObjectRef $ret;
                final /* synthetic */ List $arguments;
                final /* synthetic */ int $n;
                final /* synthetic */ String $callName;

                public final void invoke() {
                    if (this.$hasOut.element || (OraArgument)this.$ret.element != null) {
                        this.this$0.getBuilder().phrase("declare");
                        this.this$0.coding(ScriptLocus.IN_STATEMENT, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                            final /* synthetic */ generateRoutine.1 this$0;

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                for (OraArgument a : this.this$0.$arguments) {
                                    String string;
                                    String this_$iv;
                                    CodeTextBuilder codeTextBuilder;
                                    StringBuilder stringBuilder;
                                    Object defaultValue;
                                    DasArgument.Direction dir = a.getArgumentDirection();
                                    DataType dt = a.getDataType();
                                    OraExecuteGenerator oraExecuteGenerator = this.this$0.this$0;
                                    DataType dataType = dt;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"dt");
                                    String specification = oraExecuteGenerator.script(dataType);
                                    if (Intrinsics.areEqual((Object)dir, (Object)DasArgument.Direction.INOUT)) {
                                        void $receiver$iv;
                                        defaultValue = OraExecuteGenerator.access$guessDefaultValue(this.this$0.this$0, dt);
                                        String string2 = a.getName();
                                        OraExecuteGenerator oraExecuteGenerator2 = this.this$0.this$0;
                                        stringBuilder = new StringBuilder().append("");
                                        codeTextBuilder = this.this$0.this$0.getBuilder();
                                        string = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)((Object)this_$iv)).nameToScript((String)$receiver$iv);
                                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(' ').append(specification).append(" := ").append((String)defaultValue).append(';').toString(), null, false, 6, null);
                                    }
                                    if (Intrinsics.areEqual((Object)dir, (Object)DasArgument.Direction.OUT)) {
                                        void $receiver$iv;
                                        void this_$iv2;
                                        this_$iv = a.getName();
                                        defaultValue = this.this$0.this$0;
                                        stringBuilder = new StringBuilder().append("");
                                        codeTextBuilder = this.this$0.this$0.getBuilder();
                                        string = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv2).nameToScript((String)$receiver$iv);
                                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(' ').append(specification).append(';').toString(), null, false, 6, null);
                                    }
                                    if (!Intrinsics.areEqual((Object)dir, (Object)DasArgument.Direction.RETURN)) continue;
                                    CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), "Result " + specification + ';', null, false, 6, null);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }));
                    }
                    this.this$0.getBuilder().phrase("begin");
                    this.this$0.coding(ScriptLocus.IN_STATEMENT, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateRoutine.1 this$0;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            String string;
                            Object this_$iv;
                            ArrayList<String> passing = new ArrayList<String>(this.this$0.$n);
                            for (OraArgument a : this.this$0.$arguments) {
                                switch (OraScriptingService$OraExecuteGenerator$WhenMappings.$EnumSwitchMapping$1[a.getArgumentDirection().ordinal()]) {
                                    case 1: {
                                        String $receiver$iv;
                                        String string2 = a.getName();
                                        OraExecuteGenerator oraExecuteGenerator = this.this$0.this$0;
                                        StringBuilder stringBuilder = new StringBuilder().append("");
                                        ArrayList<String> arrayList = passing;
                                        string = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript($receiver$iv);
                                        StringBuilder stringBuilder2 = stringBuilder.append(string).append(" => ");
                                        OraExecuteGenerator oraExecuteGenerator2 = this.this$0.this$0;
                                        DataType dataType = a.getDataType();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"a.dataType");
                                        arrayList.add(stringBuilder2.append(OraExecuteGenerator.access$guessDefaultValue(oraExecuteGenerator2, dataType)).toString());
                                        break;
                                    }
                                    case 2: 
                                    case 3: {
                                        String $receiver$iv = a.getName();
                                        this_$iv = this.this$0.this$0;
                                        StringBuilder stringBuilder = new StringBuilder().append("");
                                        ArrayList<String> arrayList = passing;
                                        string = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript($receiver$iv);
                                        $receiver$iv = a.getName();
                                        this_$iv = this.this$0.this$0;
                                        stringBuilder = stringBuilder.append(string).append(" => ");
                                        string = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript($receiver$iv);
                                        arrayList.add(stringBuilder.append(string).toString());
                                    }
                                }
                            }
                            String retClause = (OraArgument)this.this$0.$ret.element != null ? "result :=" : null;
                            Iterable $receiver$iv = passing;
                            int sum$iv = 0;
                            for (T element$iv : $receiver$iv) {
                                void it;
                                String string3 = (String)element$iv;
                                int n = sum$iv;
                                int n2 = it.length();
                                sum$iv = n + n2;
                            }
                            int x = sum$iv;
                            if (x == 0) {
                                this.this$0.this$0.getBuilder().phrase(retClause, this.this$0.$callName + ';');
                            } else if (x <= 60) {
                                String passingText = CollectionsKt.joinToString$default((Iterable)passing, null, null, null, (int)0, null, null, (int)63, null);
                                this.this$0.this$0.getBuilder().phrase(retClause, "" + this.this$0.$callName + '(' + passingText + ");");
                            } else {
                                this.this$0.this$0.getBuilder().phrase(retClause, this.this$0.$callName + '(');
                                this_$iv = this.this$0.this$0.getBuilder();
                                CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
                                try {
                                    for (Object $i$f$getScr : CollectionsKt.withIndex((Iterable)passing)) {
                                        int i2 = $i$f$getScr.component1();
                                        String p = (String)$i$f$getScr.component2();
                                        CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), i2 + 1 < passing.size() ? p + ',' : p, null, false, 6, null);
                                    }
                                }
                                finally {
                                    ((CodeTextBuilder)this_$iv).unindent();
                                }
                                CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), ");", null, false, 6, null);
                            }
                            for (OraArgument a : this.this$0.$arguments) {
                                void $receiver$iv2;
                                void this_$iv2;
                                Object $i$f$getScr;
                                if (!a.getArgumentDirection().isOut()) continue;
                                String i2 = a.getName();
                                $i$f$getScr = this.this$0.this$0;
                                StringBuilder stringBuilder = new StringBuilder().append("dbms_output.put_line('").append(a.getName()).append(" = '||");
                                CodeTextBuilder codeTextBuilder = this.this$0.this$0.getBuilder();
                                string = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv2).nameToScript((String)$receiver$iv2);
                                CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(");").toString(), null, false, 6, null);
                            }
                            if ((OraArgument)this.this$0.$ret.element != null) {
                                CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), "dbms_output.put_line('Result = '||Result);", null, false, 6, null);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                    this.this$0.getBuilder().phrase("end;");
                }
                {
                    this.this$0 = oraExecuteGenerator;
                    this.$hasOut = booleanRef;
                    this.$ret = objectRef;
                    this.$arguments = list;
                    this.$n = n;
                    this.$callName = string;
                    super(0);
                }
            }, 3, null);
        }

        private final String guessDefaultValue(DataType dt) {
            String typeName = dt.typeName;
            return StringsKt.startsWith((String)typeName, (String)"binary_integer", (boolean)true) ? "0" : (StringsKt.startsWith((String)typeName, (String)"number", (boolean)true) ? (dt.scale > 0 ? "0.0" : "0") : (StringsKt.startsWith((String)typeName, (String)"float", (boolean)true) ? "0.0" : (StringsKt.startsWith((String)typeName, (String)"char", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"varchar", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"nchar", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"nvarchar", (boolean)true) ? "''" : (StringsKt.startsWith((String)typeName, (String)"date", (boolean)true) ? "sysdate" : "null")))))));
        }

        public OraExecuteGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(context, task);
        }

        @NotNull
        public static final /* synthetic */ String access$guessDefaultValue(OraExecuteGenerator $this, @NotNull DataType dt) {
            return $this.guessDefaultValue(dt);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/scripting/OraScriptingService$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-scripting"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
        }

        static {
            VERSION vERSION;
            INSTANCE = vERSION = new VERSION();
        }
    }
}

