/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.PostgresHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.Case;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcInjectable;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectHashingStrategy;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.rmi.ConnectException;
import java.rmi.UnmarshalException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DbImplUtil {
    private static final int UNLIMITED_PAGE_SIZE = -1;
    public static final Condition<DbElement> CAN_CONNECT_TO = DbImplUtil::canConnectTo;
    private static final char ESCAPE_CHAR = '#';
    public static final ThrowableConvertor<ResultSet, List<String>, SQLException> RS_AS_STRING_LIST = rs -> {
        ArrayList res = ContainerUtil.newArrayList();
        while (rs.next()) {
            res.add(rs.getString(1));
        }
        return res;
    };
    private static final String ROW_ID = "ROW_ID";
    private static final VfsDependentEnum<String> myDialectAndDataSourcesEnumerator = new VfsDependentEnum("sql_dialects_and_data_sources", (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 1);

    private DbImplUtil() {
    }

    public static boolean valuesEqual(Object v1, Object v2) {
        ThreeState result2;
        if (v1 == ReservedCellValue.NULL) {
            v1 = null;
        }
        if (v2 == ReservedCellValue.NULL) {
            v2 = null;
        }
        if ((result2 = DbImplUtil.simpleEquals(v1, v2)) == ThreeState.UNSURE) {
            result2 = DbImplUtil.numberEquals(v1, v2);
        }
        if (result2 == ThreeState.UNSURE) {
            result2 = DbImplUtil.arrayEquals(v1, v2);
        }
        if (result2 == ThreeState.UNSURE) {
            result2 = DbImplUtil.clobEquals(v1, v2);
        }
        if (result2 == ThreeState.UNSURE) {
            result2 = ThreeState.NO;
        }
        return result2.toBoolean();
    }

    public static int valueHashCode(Object v) {
        if (v == ReservedCellValue.NULL) {
            v = null;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return Long.valueOf(n.longValue()).hashCode() * 31 + Double.valueOf(n.doubleValue()).hashCode();
        }
        if (v instanceof byte[]) {
            return Arrays.hashCode((byte[])v);
        }
        if (v instanceof char[]) {
            return Arrays.hashCode((char[])v);
        }
        if (v instanceof LobInfo.ClobInfo) {
            return Comparing.hashcode((Object)((LobInfo.ClobInfo)v).data);
        }
        return Comparing.hashcode((Object)v);
    }

    private static ThreeState simpleEquals(Object v1, Object v2) {
        return Comparing.equal((Object)v1, (Object)v2) ? ThreeState.YES : ThreeState.UNSURE;
    }

    private static ThreeState numberEquals(Object v1, Object v2) {
        Number n1 = (Number)ObjectUtils.tryCast((Object)v1, Number.class);
        Number n2 = (Number)ObjectUtils.tryCast((Object)v2, Number.class);
        if (n1 != null && n2 != null) {
            long l1 = n1.longValue();
            long l2 = n2.longValue();
            double d1 = n1.doubleValue();
            double d2 = n2.doubleValue();
            return ThreeState.fromBoolean((l1 == l2 && (d1 == d2 || Double.isNaN(d1) && Double.isNaN(d2)) ? 1 : 0) != 0);
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState arrayEquals(Object v1, Object v2) {
        if (v1 != null && v2 != null && v1.getClass() == v2.getClass() && v1.getClass().isArray()) {
            if (v1 instanceof byte[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((byte[])v1, (byte[])v2));
            }
            if (v1 instanceof char[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((char[])v1, (char[])v2));
            }
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState clobEquals(Object v1, Object v2) {
        LobInfo.ClobInfo info1 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v1, LobInfo.ClobInfo.class);
        LobInfo.ClobInfo info2 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v2, LobInfo.ClobInfo.class);
        if (info1 != null && info2 != null) {
            return ThreeState.fromBoolean((!info2.isTruncated() && DbImplUtil.clobStringEquals(info1, info2.data) ? 1 : 0) != 0);
        }
        if (info1 != null && v2 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtil.clobStringEquals(info1, (String)v2));
        }
        if (info2 != null && v1 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtil.clobStringEquals(info2, (String)v1));
        }
        return ThreeState.UNSURE;
    }

    private static boolean clobStringEquals(@NotNull LobInfo.ClobInfo lob, @Nullable String s) {
        if (lob == null) {
            DbImplUtil.$$$reportNull$$$0(0);
        }
        return !lob.isTruncated() && Comparing.equal((String)lob.data, (String)s);
    }

    @Nullable
    public static DbElement findElement(@Nullable DbDataSource dataSource, @Nullable DasObject object) {
        if (dataSource == null || object == null) {
            return null;
        }
        return ((DbDataSourceImpl)dataSource).findElement(object);
    }

    public static DdlBuilder createBuilderForExec(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(1);
        }
        return new DdlBuilder().withDialect(dialect).qualifyReferences(true).quoteIdentifiers(true);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull DatabaseDialectEx dialect, @Nullable DasObject object) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(2);
        }
        DdlBuilder builder = DbImplUtil.createBuilderForExec(dialect).quoteIdentifiers(false);
        DbElement element = DbImplUtil.getDbElement(object);
        return element != null ? builder.withCasingFor(element) : builder;
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system) {
        if (databaseTable == null) {
            DbImplUtil.$$$reportNull$$$0(3);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(4);
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dialect, system, false, -1);
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, int rows) {
        if (databaseTable == null) {
            DbImplUtil.$$$reportNull$$$0(5);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(6);
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dialect, system, false, rows);
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, boolean appendRowId, int rows) {
        if (databaseTable == null) {
            DbImplUtil.$$$reportNull$$$0(7);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(8);
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dialect, system, appendRowId, rows, Collections.emptyList(), Collections.emptyList());
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, int rows, @NotNull Iterable<String> columnNames, @NotNull Iterable<?> values) {
        if (databaseTable == null) {
            DbImplUtil.$$$reportNull$$$0(9);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(10);
        }
        if (columnNames == null) {
            DbImplUtil.$$$reportNull$$$0(11);
        }
        if (values == null) {
            DbImplUtil.$$$reportNull$$$0(12);
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dialect, system, false, rows, columnNames, values);
    }

    private static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, boolean appendRowId, int rows, @NotNull Iterable<String> columnNames, @NotNull Iterable<?> values) {
        if (databaseTable == null) {
            DbImplUtil.$$$reportNull$$$0(13);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(14);
        }
        if (columnNames == null) {
            DbImplUtil.$$$reportNull$$$0(15);
        }
        if (values == null) {
            DbImplUtil.$$$reportNull$$$0(16);
        }
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, (DasObject)databaseTable);
        BiConsumer<String, DdlBuilder> appendWhereClause = Iterables.isEmpty(columnNames) ? null : (tableNameAlias, ddlBuilder) -> {
            if (columnNames == null) {
                DbImplUtil.$$$reportNull$$$0(158);
            }
            if (values == null) {
                DbImplUtil.$$$reportNull$$$0(159);
            }
            if (dialect == null) {
                DbImplUtil.$$$reportNull$$$0(160);
            }
            ddlBuilder.space().keyword("WHERE").space();
            DbImplUtil.composeWhereCondition(ddlBuilder, columnNames, values, tableNameAlias, dialect);
        };
        return DbImplUtil.createSelectAllQuery(builder, databaseTable, dialect, system, appendWhereClause, appendRowId, rows);
    }

    @Nullable
    private static DbElement getDbElement(@Nullable DasObject object) {
        return (DbElement)DasUtil.getParentOfClass((DasObject)object, DbDataSource.class, (boolean)false);
    }

    @NotNull
    public static List<ColumnQueryData> createSelectAllQueryWithParameters(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, @NotNull List<ColumnQueryData> datas, int rows) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(17);
        }
        if (table == null) {
            DbImplUtil.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(19);
        }
        if (datas == null) {
            DbImplUtil.$$$reportNull$$$0(20);
        }
        if (datas.isEmpty()) {
            DbImplUtil.createSelectAllQuery(table, dialect, system, rows);
            ImmutableList immutableList = ContainerUtil.immutableList((Object[])new ColumnQueryData[0]);
            if (immutableList == null) {
                DbImplUtil.$$$reportNull$$$0(21);
            }
            return immutableList;
        }
        ArrayList newData = ContainerUtil.newArrayList();
        BiConsumer<String, DdlBuilder> appendWhereClauseFunction = (tableNameAlias, ddlBuilder) -> {
            if (datas == null) {
                DbImplUtil.$$$reportNull$$$0(156);
            }
            if (dialect == null) {
                DbImplUtil.$$$reportNull$$$0(157);
            }
            ddlBuilder.space().keyword("WHERE").space();
            newData.addAll(DbImplUtil.composeWhereConditionWithParameters(ddlBuilder, datas, tableNameAlias, dialect));
        };
        DbImplUtil.createSelectAllQuery(builder, table, dialect, system, appendWhereClauseFunction, false, rows);
        ArrayList arrayList = newData;
        if (arrayList == null) {
            DbImplUtil.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    private static DdlBuilder createSelectAllQuery(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, @Nullable BiConsumer<String, DdlBuilder> appendWhereClause, boolean appendRowId, int rows) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(23);
        }
        if (dasTable == null) {
            DbImplUtil.$$$reportNull$$$0(24);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(25);
        }
        DdlBuilder ddlBuilder = dialect.sqlSelectAll(builder, dasTable, system, appendWhereClause, null, appendRowId, rows);
        if (ddlBuilder == null) {
            DbImplUtil.$$$reportNull$$$0(26);
        }
        return ddlBuilder;
    }

    @NotNull
    public static String findFreeAlias(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull String query, @NotNull String alias) {
        SqlResultSetExpression expression;
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(27);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(28);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(29);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(30);
        }
        if ((expression = DbSqlUtil.parseQuery(project, DbSqlUtil.getSqlDialect(dialect), query, null)) == null) {
            String string = alias;
            if (string == null) {
                DbImplUtil.$$$reportNull$$$0(31);
            }
            return string;
        }
        Set names = SyntaxTraverser.psiTraverser((PsiElement)expression).filter(SqlIdentifier.class).transform(SqlNameElement::getName).toSet();
        String result2 = alias;
        int index = 1;
        while (names.contains(result2)) {
            result2 = alias + index++;
        }
        String string = result2;
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Nullable
    public static String createSelectCountQuery(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @Nullable String queryText, @Nullable DbDataSource dataSource) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(33);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(34);
        }
        return DbImplUtil.createSelectCountQuery(project, dialect, queryText, dataSource, "t");
    }

    @Nullable
    public static String createSelectCountQuery(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @Nullable String queryText, @Nullable DbDataSource dataSource, @NotNull String alias) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(35);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(36);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(37);
        }
        queryText = queryText != null ? StringUtil.trimEnd((String)queryText, (String)";") : "";
        SqlResultSetExpression e = DbSqlUtil.parseQuery(project, DbSqlUtil.getSqlDialect(dialect), queryText, null);
        if (e == null) {
            return null;
        }
        SqlQueryExpression query = e instanceof SqlWithQueryExpression ? (SqlQueryExpression)ObjectUtils.tryCast((Object)((SqlWithQueryExpression)e).getExpression(), SqlQueryExpression.class) : (e instanceof SqlQueryExpression ? (SqlQueryExpression)e : null);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, (DasObject)dataSource);
        if (query == null || !DbImplUtil.buildOptimizedCountQuery(builder, query, queryText)) {
            DbImplUtil.appendWrappedQueryTail(DbImplUtil.countQueryHead(builder).symbol("("), e, queryText, alias);
        }
        return builder.getStatement();
    }

    @Nullable
    public static DdlBuilder wrapSelectQuery(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull String query, @NotNull String alias) {
        SqlResultSetExpression expression;
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(38);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(39);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(40);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(41);
        }
        if ((expression = DbSqlUtil.parseQuery(project, DbSqlUtil.getSqlDialect(dialect), query, null)) == null) {
            return null;
        }
        DdlBuilder builder = DbImplUtil.createBuilderForExec(dialect);
        builder.keyword("SELECT").space().symbol("*").space().keyword("FROM").space().symbol("(");
        return DbImplUtil.appendWrappedQueryTail(builder, expression, query, alias);
    }

    @NotNull
    private static DdlBuilder appendWrappedQueryTail(@NotNull DdlBuilder head, @NotNull SqlResultSetExpression e, @NotNull String query, @NotNull String alias) {
        if (head == null) {
            DbImplUtil.$$$reportNull$$$0(42);
        }
        if (e == null) {
            DbImplUtil.$$$reportNull$$$0(43);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(44);
        }
        if (alias == null) {
            DbImplUtil.$$$reportNull$$$0(45);
        }
        boolean subqueryIsBuilt = false;
        boolean needSelectTargetAliases = head.getDialect().getFamilyId().isMicrosoft();
        if (needSelectTargetAliases) {
            TIntArrayList endOffsets = new TIntArrayList();
            for (SqlSelectClause selectClause : SyntaxTraverser.psiTraverser((PsiElement)e).filter(SqlSelectClause.class)) {
                for (SqlExpression expression : selectClause.getExpressions()) {
                    if (expression instanceof SqlAsExpression || expression instanceof SqlReferenceExpression) continue;
                    endOffsets.add(expression.getTextRange().getEndOffset());
                }
            }
            endOffsets.sort();
            int prevIdx = 0;
            int count2 = 0;
            int len = endOffsets.size();
            for (int i2 = 0; i2 < len; ++i2) {
                int offset = endOffsets.get(i2);
                head.plain(query.substring(prevIdx, offset));
                head.space().columnRef("_" + ++count2);
                prevIdx = offset;
            }
            head.plain(e.getText().substring(prevIdx));
            subqueryIsBuilt = true;
        }
        if (!subqueryIsBuilt) {
            head.plain(query);
        }
        DdlBuilder ddlBuilder = head.symbol(")").space().alias(alias);
        if (ddlBuilder == null) {
            DbImplUtil.$$$reportNull$$$0(46);
        }
        return ddlBuilder;
    }

    @NotNull
    private static DdlBuilder countQueryHead(@NotNull DdlBuilder builder) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(47);
        }
        DdlBuilder ddlBuilder = builder.keyword("SELECT").space().keyword("COUNT").symbol("(").symbol("*").symbol(")").space().keyword("FROM").space();
        if (ddlBuilder == null) {
            DbImplUtil.$$$reportNull$$$0(48);
        }
        return ddlBuilder;
    }

    private static boolean buildOptimizedCountQuery(@NotNull DdlBuilder builder, @NotNull SqlQueryExpression query, @NotNull String queryText) {
        SqlSelectClause selectClause;
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(49);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(50);
        }
        if (queryText == null) {
            DbImplUtil.$$$reportNull$$$0(51);
        }
        if ((selectClause = query.getSelectClause()) == null) {
            return false;
        }
        for (SqlSelectOption option : selectClause.getOptions()) {
            if (!option.getOptionName().startsWith("DISTINCT") && option.getClause() == null) continue;
            return false;
        }
        SqlTableExpression tableExp = query.getTableExpression();
        if (tableExp == null || tableExp.getHavingClause() != null || tableExp.getGroupByClause() != null) {
            return false;
        }
        List expressions = selectClause.getExpressions();
        for (SqlExpression e : expressions) {
            if (((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)e)).preOrderDfsTraversal().filter(SqlFunctionCallExpression.class).isEmpty()) continue;
            return false;
        }
        SqlExpression firstExpression = (SqlExpression)ContainerUtil.getFirstItem((List)expressions);
        SqlExpression lastExpression = (SqlExpression)ContainerUtil.getLastItem((List)expressions);
        if (firstExpression == null || lastExpression == null) {
            return false;
        }
        int expressionsStartOffset = firstExpression.getTextRange().getStartOffset();
        int expressionsEndOffset = lastExpression.getTextRange().getEndOffset();
        builder.clear().plain(queryText.substring(0, expressionsStartOffset)).keyword("COUNT").symbol("(").symbol("*").symbol(")").plain(queryText.substring(expressionsEndOffset));
        return true;
    }

    @NotNull
    public static String resultSetToString(ResultSet rs, DatabaseDialectEx dialect, DataExtractor extractor) throws Exception {
        String string = DbImplUtil.resultSetToString("", rs, Integer.MAX_VALUE, dialect, extractor, CharOut.Util.newSink()).toString();
        if (string == null) {
            DbImplUtil.$$$reportNull$$$0(52);
        }
        return string;
    }

    public static CharOut resultSetToString(String title, ResultSet rs, int size, DatabaseDialectEx dialect, DataExtractor extractor, CharOut out) throws Exception {
        DataConsumer.Column[] columns2 = JdbcEngine.getColumnDescriptors(rs, dialect);
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)rs, RemoteResultSet.class);
        int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
        RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(DbImplUtil.getRdbms(dialect), Calendar.getInstance(), size, maxLobLength, false);
        List objects = remoteResultSet.getObjects(options);
        List data = (List)RemoteUtil.handleRemoteResult((Object)objects, List.class, (Object)extractor);
        ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(data.size());
        if (data.isEmpty()) {
            return out;
        }
        for (int i2 = 0; i2 < data.size(); ++i2) {
            rows.add(DataConsumer.Row.create(i2 + 1, (Object[])data.get(i2)));
        }
        out.append(String.format(title, data.size()));
        ExtractorsUtil.extract(out, dialect, false, Arrays.asList(columns2), extractor, rows, new int[0]);
        return out;
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull DatabaseSystem database) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(53);
        }
        if (database == null) {
            DbImplUtil.$$$reportNull$$$0(54);
        }
        return database instanceof DbDataSource ? (DbDataSource)database : DbPsiFacade.getInstance((Project)project).findDataSource(database.getUniqueId());
    }

    public static boolean isConnected(@NotNull DbElement element) {
        if (element == null) {
            DbImplUtil.$$$reportNull$$$0(55);
        }
        Object delegate = element.getDelegate();
        Project project = element.getProject();
        return delegate instanceof LocalDataSource && DbImplUtil.isConnected(project, (LocalDataSource)delegate);
    }

    public static boolean isConnected(@NotNull Project project, @NotNull LocalDataSource delegate) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(56);
        }
        if (delegate == null) {
            DbImplUtil.$$$reportNull$$$0(57);
        }
        return !JdbcDriverManager.getDriverManager(project).getActiveConfigurations(delegate).isEmpty();
    }

    public static boolean canConnectTo(@Nullable DbElement element) {
        DatabaseSystem ds = element == null ? null : element.getDataSource().getDelegate();
        return ds instanceof LocalDataSource && DbImplUtil.canConnectTo((LocalDataSource)ds);
    }

    public static boolean isInLocalDataSource(@Nullable DbElement element) {
        DatabaseSystem ds = element == null ? null : element.getDataSource().getDelegate();
        return ds instanceof LocalDataSource;
    }

    public static boolean hasDriverFiles(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(58);
        }
        return !dataSource.getClasspathElements().isEmpty();
    }

    public static boolean canConnectTo(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(59);
        }
        if (StringUtil.isEmptyOrSpaces((String)dataSource.getUrl())) {
            return false;
        }
        if (!DbImplUtil.hasDriverFiles(dataSource)) {
            return false;
        }
        String driverClass = dataSource.getDriverClass();
        return !StringUtil.isEmptyOrSpaces((String)driverClass);
    }

    public static boolean canConnectToAndModify(@Nullable DbElement element) {
        return element != null && element.isWritable() && DbImplUtil.canConnectTo(element) && !DataImporter.isBusy(element);
    }

    @Deprecated
    @Nullable
    public static Connection getConnection(@NotNull DbElement element) throws Exception {
        GuardedRef<DatabaseConnection> connection;
        if (element == null) {
            DbImplUtil.$$$reportNull$$$0(60);
        }
        return (connection = DbImplUtil.getDatabaseConnection(element)) == null ? null : connection.get().getJdbcConnection();
    }

    @Deprecated
    @Nullable
    public static GuardedRef<DatabaseConnection> getDatabaseConnection(@NotNull DbElement element) throws Exception {
        DatabaseSystem ds;
        if (element == null) {
            DbImplUtil.$$$reportNull$$$0(61);
        }
        if (!((ds = element.getDataSource().getDelegate()) instanceof LocalDataSource)) {
            return null;
        }
        GuardedRef<DatabaseConnection> connection = DatabaseConnectionManager.getInstance().build(element.getProject(), (LocalDataSource)ds).setDestination(ObjectPath.of((DasObject)element)).create();
        if (connection != null) {
            JdbcUtil.setCatalogSafe((Connection)connection.get().getJdbcConnection(), (String)DasUtil.getCatalog((DasObject)element));
        }
        return connection;
    }

    public static boolean isRemoteProcessDown(@NotNull Throwable e) {
        if (e == null) {
            DbImplUtil.$$$reportNull$$$0(62);
        }
        if (ExceptionUtil.findCause((Throwable)e, ConnectException.class) != null) {
            return true;
        }
        UnmarshalException unmarshal = (UnmarshalException)ExceptionUtil.findCause((Throwable)e, UnmarshalException.class);
        return unmarshal != null && unmarshal.getCause() instanceof EOFException;
    }

    public static void setStatementParameter(@NotNull PreparedStatement statement, @NotNull ColumnDescriptor column, @Nullable Object value, @NotNull DatabaseDialect dialect, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            DbImplUtil.$$$reportNull$$$0(63);
        }
        if (column == null) {
            DbImplUtil.$$$reportNull$$$0(64);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(65);
        }
        RemotePreparedStatement remoteStatement = (RemotePreparedStatement)RemoteUtil.castToRemoteNotNull((Object)statement, RemotePreparedStatement.class);
        ColumnInfo info = new ColumnInfo(column.getJavaClassName(), column.getTypeName(), column.getType(), idx);
        remoteStatement.setObject(DbImplUtil.prepareValue(dialect.getFamilyId(), value), DbImplUtil.getRdbms(dialect), info, needsEscaping, idx);
    }

    @NotNull
    public static Rdbms getRdbms(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(66);
        }
        Rdbms rdbms = DbImplUtil.getRdbms(dialect.getFamilyId());
        if (rdbms == null) {
            DbImplUtil.$$$reportNull$$$0(67);
        }
        return rdbms;
    }

    @NotNull
    public static Rdbms getRdbms(@NotNull DatabaseFamilyId id) {
        Rdbms rdbms;
        if (id == null) {
            DbImplUtil.$$$reportNull$$$0(68);
        }
        Rdbms rdbms2 = (rdbms = DataSourceUiUtil.getRdbmsForIntrospection(id)) == null ? UnknownDatabase.RDBMS : rdbms;
        if (rdbms2 == null) {
            DbImplUtil.$$$reportNull$$$0(69);
        }
        return rdbms2;
    }

    @NotNull
    public static DatabaseFamilyId getFamily(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            DbImplUtil.$$$reportNull$$$0(70);
        }
        DatabaseFamilyId familyId = GenericIntrospectorLegacyModelUtils.findFamily(rdbms);
        DatabaseFamilyId databaseFamilyId = (DatabaseFamilyId)ObjectUtils.chooseNotNull((Object)familyId, (Object)DatabaseFamilyId.UNKNOWN);
        if (databaseFamilyId == null) {
            DbImplUtil.$$$reportNull$$$0(71);
        }
        return databaseFamilyId;
    }

    @Nullable
    public static Object prepareValue(@NotNull DatabaseFamilyId family, @Nullable Object value) {
        if (family == null) {
            DbImplUtil.$$$reportNull$$$0(72);
        }
        return value == null || value == ReservedCellValue.NULL ? null : (value instanceof JdbcInjectable ? ((JdbcInjectable)value).injection(family) : (value instanceof ObjectFormatter.ImageInfo ? (JdbcInjection)((ObjectFormatter.ImageInfo)value).bytes : (value instanceof ObjectFormatter.TextInfo ? (JdbcInjection)((ObjectFormatter.TextInfo)value).bytes : (value instanceof BitString ? (JdbcInjection)((BitString)value).getBytes() : (value instanceof Date ? DbImplUtil.prepareDate((Date)value) : value)))));
    }

    @NotNull
    private static Object prepareDate(@NotNull Date value) {
        if (value == null) {
            DbImplUtil.$$$reportNull$$$0(73);
        }
        Date date = value instanceof Timestamp ? value : (value instanceof Time ? value : new JdbcInjection.DateInjection(Calendar.getInstance(), JdbcNativeUtil.createSqlDate((Date)value)));
        if (date == null) {
            DbImplUtil.$$$reportNull$$$0(74);
        }
        return date;
    }

    public static boolean canInsertBlob(@NotNull DataConsumer.Column column) {
        int type;
        if (column == null) {
            DbImplUtil.$$$reportNull$$$0(75);
        }
        return (type = ExtractorsUtil.guessJdbcType(column)) == -2 || type == 2004 || type == -4 || type == -3;
    }

    public static boolean canInsertClob(@NotNull DataConsumer.Column column) {
        int type;
        if (column == null) {
            DbImplUtil.$$$reportNull$$$0(76);
        }
        return (type = ExtractorsUtil.guessJdbcType(column)) == 2005 || type == 2011 || type == -1 || type == -16 || type == -15 || type == 1 || type == 12 || type == -9 || type == 2009;
    }

    @Nullable
    public static LobInfo.FileClobInfo clobFromFile(@NotNull VirtualFile virtualFile) {
        Charset encoding;
        if (virtualFile == null) {
            DbImplUtil.$$$reportNull$$$0(77);
        }
        String charset = (encoding = EncodingManager.getInstance().getEncoding(virtualFile, true)) != null ? encoding.name() : null;
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        return new LobInfo.FileClobInfo(file, charset);
    }

    @NotNull
    public static LobInfo.FileBlobInfo blobFromFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DbImplUtil.$$$reportNull$$$0(78);
        }
        LobInfo.FileBlobInfo fileBlobInfo = new LobInfo.FileBlobInfo(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
        if (fileBlobInfo == null) {
            DbImplUtil.$$$reportNull$$$0(79);
        }
        return fileBlobInfo;
    }

    public static void tryLoadFirstNRows(DatabaseConnection connection, String query, StringBuilder sb, int rows) {
        try {
            DbImplUtil.tryLoadFirstNRows("", connection, query, CharOut.Util.newSink(sb), rows);
        }
        catch (Exception e) {
            DbImplUtil.exceptionToHtml(e, "Unable to load table data", sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadFirstNRows(String title, DatabaseConnection connection, String query, CharOut sb, int rows) throws Exception {
        if (connection == null) {
            return;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query);
            ObjectFormatter converter = new ObjectFormatter(){

                @Override
                @Nullable
                public String objectToString(@Nullable Object o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                    Object o1 = 1.objectToObject(o, column);
                    if (o1 instanceof ObjectFormatter.ImageInfo) {
                        ObjectFormatter.ImageInfo info = (ObjectFormatter.ImageInfo)o1;
                        o1 = new ObjectFormatter.ImageInfo(info.format, info.width, info.height, info.size, null);
                    }
                    return super.objectToString(o1, column, dialect, forDisplay);
                }
            };
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(DocumentationComponent.COLOR_KEY.getDefaultColor(), converter){

                @Override
                protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect, boolean forDisplay) {
                    String unescaped;
                    if (row == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (column == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (dialect == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return this.escapeChars((unescaped = super.getValueAsString(2.getOriginalRow(row, column), 2.getOriginalColumn(row, column), dialect, forDisplay, false)) != null && unescaped.length() > 50 ? unescaped.substring(0, 50) + "..." : unescaped);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "row";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "column";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dialect";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/util/DbImplUtil$2";
                    objectArray[2] = "getValueAsString";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            DbImplUtil.resultSetToString(title, resultSet, rows, GenericDialect.INSTANCE, extractor, sb);
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    public static StringBuilder exceptionToHtml(Exception e, String str, StringBuilder sb) {
        sb.append(str).append(":<br>");
        sb.append("<code>").append(e).append("</code><br>");
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadViewDefinition(ConnectionProvider provider, @NotNull DbTable element, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect;
        if (element == null) {
            DbImplUtil.$$$reportNull$$$0(80);
        }
        if (!(dialect = DbImplUtil.getDatabaseDialect((DbElement)element)).supportsViewDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            DatabaseFamilyId familyId = dialect.getFamilyId();
            Pair<String, ConcatenationProps> query = dialect.sqlViewDefinition((DasObject)element);
            int initialLength = sb.length();
            DbImplUtil.concatStringResults(provider.getConnection(), dialect, 0, (String)query.first, sb, (ConcatenationProps)query.second);
            if (sb.length() > initialLength) {
                if (familyId.isMysql() || familyId.isPostgres() || familyId.isOracle()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
                    String fullDefinition = dialect.sqlCreateView(builder, (DasTable)element, sb.substring(initialLength), "").getStatement();
                    sb.setLength(initialLength);
                    sb.append(fullDefinition);
                } else if (familyId.isDerby()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, (DasTable)element, true).getStatement() + ";\n");
                } else if (familyId.isMicrosoft()) {
                    DbImplUtil.replaceTokenInDefinition((DbElement)element, sb, dialect, SqlCreateViewStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
                } else if (familyId.isSybase()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, (DasTable)element, true).newLine().keyword("GO").getStatement() + "\n");
                } else if (familyId.isH2()) {
                    sb.insert(initialLength + "CREATE ".length(), "OR REPLACE ");
                }
            }
        }
        finally {
            provider.release();
        }
    }

    @Nullable
    public static DasNamespace getSearchPathObjectForSwitch(@NotNull DatabaseDialectEx dialect, @Nullable DasObject dasObject) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(81);
        }
        if (dasObject == null) {
            return null;
        }
        DasNamespace object = DbImplUtil.getSearchPathObject(dialect, dasObject);
        if (!dialect.getFamilyId().isPostgres()) {
            return object;
        }
        if (dasObject.getKind() == ObjectKind.DATABASE) {
            return (DasNamespace)ObjectUtils.tryCast((Object)dasObject, DasNamespace.class);
        }
        if (object == null || object.getKind() != ObjectKind.SCHEMA) {
            return object;
        }
        return (DasNamespace)ObjectUtils.tryCast((Object)object.getDasParent(), DasNamespace.class);
    }

    @Nullable
    public static DasNamespace getSearchPathObjectForSwitch(@Nullable DbElement element) {
        return element == null ? null : DbImplUtil.getSearchPathObjectForSwitch(DbImplUtil.getDatabaseDialect(element), (DasObject)element);
    }

    @Nullable
    public static DasNamespace getSearchPathObject(@NotNull DatabaseDialectEx dialect, @Nullable DasObject dasObject) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(82);
        }
        if (dialect.getFamilyId().isSqlite()) {
            return (DasNamespace)ObjectUtils.tryCast((Object)DasUtil.getSchemaObject((DasObject)dasObject), DasNamespace.class);
        }
        ObjectKind kind = dialect.getSearchPathObjectKind();
        return kind == null ? null : (DasNamespace)DasUtil.dasParents((DasObject)dasObject).filter(DasNamespace.class).find(DasUtil.byKind((ObjectKind)kind));
    }

    @Nullable
    public static DasNamespace getSearchPathObject(@Nullable DbElement element) {
        return element == null ? null : DbImplUtil.getSearchPathObject(DbImplUtil.getDatabaseDialect(element), (DasObject)element);
    }

    public static DdlBuilder endStatement(@NotNull DdlBuilder builder) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(83);
        }
        if (builder.getDialect().getFamilyId().isTransactSql()) {
            builder.newLine().keyword("go").newStatement();
        } else {
            builder.newStatement();
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void tryLoadProcedureDefinition(@NotNull ConnectionProvider provider, @NotNull DbRoutine element, @NotNull StringBuilder sb) throws Exception {
        if (provider == null) {
            DbImplUtil.$$$reportNull$$$0(84);
        }
        if (element == null) {
            DbImplUtil.$$$reportNull$$$0(85);
        }
        if (sb == null) {
            DbImplUtil.$$$reportNull$$$0(86);
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!provider.acquire()) {
            provider.release();
            return;
        }
        String fromDialect = dialect.tryToLoadProcedureDefinition((DasRoutine)element, provider.getConnection());
        if (StringUtil.isNotEmpty((String)fromDialect)) {
            sb.append(fromDialect);
            provider.release();
            return;
        }
        if (!dialect.supportsProcedureDefinition()) {
            return;
        }
        DatabaseFamilyId familyId = dialect.getFamilyId();
        Pair<String, ConcatenationProps> query = dialect.sqlProcedureDefinition((DasRoutine)element);
        StringBuilder definition = DbImplUtil.concatStringResults(provider.getConnection(), dialect, (String)query.first, 0, new StringBuilder(), (ConcatenationProps)query.second);
        if (StringUtil.isEmptyOrSpaces((String)definition.toString())) return;
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
        if (familyId.isOracle()) {
            definition.insert(0, builder.keywords("create", "or", "replace").space().getStatement());
        } else if (familyId.isDb2()) {
            definition.insert(0, dialect.sqlDropProcedure(builder, (DasRoutine)element).getStatement() + ";\n");
        } else if (familyId.isMicrosoft()) {
            DbImplUtil.replaceTokenInDefinition((DbElement)element, definition, dialect, SqlCreateStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
        } else if (familyId.isSybase()) {
            builder.keyword("drop").space().keyword(StringUtil.startsWithIgnoreCase((String)definition.toString().trim(), (String)"create function") ? "function" : "procedure").space();
            dialect.qualifiedIdentifier(builder, element.getName(), (DasObject)element, (DasObject)element);
            builder.newLine();
            builder.keyword("go").newLine();
            definition.insert(0, builder.getStatement());
        }
        String trim = definition.toString().trim();
        sb.append(trim);
        if (familyId.isTransactSql()) {
            sb.append(DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false).clear().newLine().keyword("go").getStatement());
            return;
        }
        if (trim.endsWith(";")) return;
        sb.append(";");
        return;
    }

    private static void replaceTokenInDefinition(@NotNull DbElement element, @NotNull StringBuilder sb, @NotNull DatabaseDialectEx dialect, @NotNull Class<? extends SqlDefinition> defClazz, @NotNull SqlTokenType fromToken, @NotNull SqlTokenType toToken) {
        SqlFile psi;
        SyntaxTraverser st;
        PsiElement keyword;
        if (element == null) {
            DbImplUtil.$$$reportNull$$$0(87);
        }
        if (sb == null) {
            DbImplUtil.$$$reportNull$$$0(88);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(89);
        }
        if (defClazz == null) {
            DbImplUtil.$$$reportNull$$$0(90);
        }
        if (fromToken == null) {
            DbImplUtil.$$$reportNull$$$0(91);
        }
        if (toToken == null) {
            DbImplUtil.$$$reportNull$$$0(92);
        }
        if ((keyword = (PsiElement)(st = SyntaxTraverser.psiTraverser((PsiElement)(psi = SqlPsiFacade.getInstance((Project)element.getProject()).createSqlReader().getReadOnlyPsi(DbSqlUtil.getSqlDialect(dialect), (CharSequence)sb)))).traverse().skipWhile(Conditions.notInstanceOf(defClazz)).filter(Conditions.compose((Function)st.api.TO_TYPE, (Condition)Conditions.equalTo((Object)fromToken))).first()) != null) {
            TextRange r = st.api.rangeOf((Object)keyword);
            int i0 = r.getStartOffset();
            int i1 = r.getEndOffset();
            String replacement = ((Case)ObjectUtils.notNull((Object)Case.forString((String)sb.substring(i0, i1)), (Object)Case.EXACT)).apply(toToken.toString());
            sb.replace(i0, i1, replacement);
        }
    }

    public static boolean isDataTable(@Nullable DasTable info) {
        if (info == null) {
            return false;
        }
        return DbImplUtil.isDataTable(info.getKind());
    }

    public static boolean isDataTable(@Nullable ObjectKind kind) {
        return ArrayUtil.contains((Object)kind, (Object[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.FOREIGN_TABLE, ObjectKind.VIRTUAL_TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW});
    }

    public static boolean isEditableTable(@Nullable ObjectKind kind) {
        return kind == ObjectKind.TABLE || kind == ObjectKind.VIRTUAL_TABLE || kind == ObjectKind.FOREIGN_TABLE;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull DbElement element) {
        DbDataSource dataSource;
        if (element == null) {
            DbImplUtil.$$$reportNull$$$0(93);
        }
        DatabaseDialectEx databaseDialectEx = (dataSource = element.getDataSource()) instanceof DbDataSourceImpl ? ((DbDataSourceImpl)dataSource).getDatabaseDialect() : GenericDialect.INSTANCE;
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(94);
        }
        return databaseDialectEx;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull JdbcConsole console) {
        if (console == null) {
            DbImplUtil.$$$reportNull$$$0(95);
        }
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(console.getDataSource());
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(96);
        }
        return databaseDialectEx;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull RawConnectionConfig connectionInfo) {
        if (connectionInfo == null) {
            DbImplUtil.$$$reportNull$$$0(97);
        }
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(connectionInfo), (Object)GenericDialect.INSTANCE);
        if (databaseDialectEx == null) {
            DbImplUtil.$$$reportNull$$$0(98);
        }
        return databaseDialectEx;
    }

    @Nullable
    public static DatabaseDialectEx guessDatabaseDialect(@Nullable RawConnectionConfig connectionInfo) {
        DatabaseFamilyId familyId = connectionInfo instanceof DatabaseSystem ? DatabaseFamilyId.forDataSource((DatabaseSystem)((DatabaseSystem)connectionInfo)) : DatabaseFamilyId.forConnection((RawConnectionConfig)connectionInfo);
        return DbImplUtil.guessDatabaseDialect(familyId);
    }

    @Nullable
    public static DatabaseDialectEx guessDatabaseDialect(@NotNull DatabaseFamilyId familyId) {
        if (familyId == null) {
            DbImplUtil.$$$reportNull$$$0(99);
        }
        if (familyId == DatabaseFamilyId.UNKNOWN) {
            return null;
        }
        if (familyId.isMysql()) {
            familyId = DatabaseFamilyId.MYSQL;
        }
        for (DatabaseDialectEx dialect : DatabaseDialects.getSupportedDialects()) {
            if (dialect.getFamilyId() != familyId) continue;
            return dialect;
        }
        return null;
    }

    @Nullable
    public static DatabaseDialect guessDatabaseDialect(@Nullable DasObject object) {
        Language language;
        BasicModel model;
        DasObject o;
        Object object2 = o = object instanceof DbElement ? ((DbElement)object).getDelegate() : object;
        Object dialect = o instanceof BasicElement ? ((model = ((BasicElement)o).getModel()) == null ? null : DbImplUtil.guessDatabaseDialect(DbImplUtil.getFamily(model.getRdbms()))) : (o instanceof SqlElement ? ((language = ((SqlElement)o).getContainingFile().getLanguage()) instanceof SqlLanguageDialect ? ((SqlLanguageDialect)language).getDatabaseDialect() : null) : null);
        return dialect;
    }

    public static boolean supportsDynamicSchemaSwitching(@NotNull LocalDataSource dataSource) {
        DatabaseDialectEx dialect;
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(100);
        }
        return (dialect = DbImplUtil.guessDatabaseDialect(dataSource)) == null || !dialect.getFamilyId().isMysql() || !dataSource.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadPackageDefinition(ConnectionProvider provider, @NotNull DbPackage element, boolean spec, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect;
        if (element == null) {
            DbImplUtil.$$$reportNull$$$0(101);
        }
        if (!(dialect = DbImplUtil.getDatabaseDialect((DbElement)element)).supportsPackageDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            Pair<String, ConcatenationProps> query = spec ? dialect.sqlPackageDefinition((DasObject)element) : dialect.sqlPackageBodyDefinition((DasObject)element);
            StringBuilder def = DbImplUtil.concatStringResults(provider.getConnection(), dialect, (String)query.first, 0, new StringBuilder(), (ConcatenationProps)query.second);
            Case caseMode = (Case)ObjectUtils.notNull((Object)Case.forString((String)def.substring(0, Math.min(sb.length(), 7))), (Object)Case.EXACT);
            if (StringUtil.startsWith((CharSequence)def, (CharSequence)"package") || StringUtil.startsWith((CharSequence)def, (CharSequence)"PACKAGE")) {
                def.insert(0, caseMode.apply("CREATE OR REPLACE "));
            }
            sb.append((CharSequence)def);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSequenceDefinition(ConnectionProvider provider, DbTable element, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsSequenceDefinition()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        String drop = dialect.sqlDropSequence(DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false), (DasObject)element, false).getStatement() + ";\n";
        builder.append(drop);
        try {
            if (!provider.acquire()) {
                return;
            }
            Pair<String, ConcatenationProps> query = dialect.sqlSequenceDefinition((DasObject)element);
            DbImplUtil.concatStringResults(provider.getConnection(), dialect, (String)query.first, 0, builder, (ConcatenationProps)query.second);
            sb.append((CharSequence)builder);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadTableDefinition(ConnectionProvider provider, DbTable element, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = dialect.tryToLoadTableDefinition((DasTable)element, provider.getConnection());
            if (!StringUtil.isEmptyOrSpaces((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> tryLoadTableInfo(ConnectionProvider provider, DbTable element) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsTableInfo()) {
            return Collections.emptyMap();
        }
        try {
            if (!provider.acquire()) {
                Map<String, Object> map2 = Collections.emptyMap();
                return map2;
            }
            Map<String, Object> map3 = dialect.tryToLoadTableInfo(element, provider.getConnection());
            return map3;
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSynonymDefinition(ConnectionProvider provider, DbTable element, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = dialect.tryToLoadSynonymDefinition((DasTable)element, provider.getConnection());
            if (!StringUtil.isEmpty((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    @Nullable
    public static String getCustomTypeShortDescription(@Nullable Object delegate) {
        JBIterable names;
        if (delegate instanceof DasTypedObject) {
            DataType type = ((DasTypedObject)delegate).getDataType();
            if (type != DataType.UNKNOWN) {
                return DbPresentation.arrow() + " " + type.toString();
            }
        } else if (delegate instanceof DasTable && !(names = DasUtil.getColumns((DasObject)((DasTable)delegate)).transform(DasUtil.TO_NAME)).isEmpty()) {
            return "(" + StringUtil.join((Iterable)names, (String)", ") + ')';
        }
        return null;
    }

    public static boolean isDatabaseVirtualFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return DbSrcUtils.isDbSrcFile(file) || file instanceof DatabaseElementVirtualFileImpl;
    }

    @Nullable
    public static DbDataSource findDataSource(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(102);
        }
        if (DbSrcUtils.isDbSrcFile(file)) {
            return DbPsiFacade.getInstance((Project)project).findDataSource(DbSrcUtils.getDataSource(file));
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)file;
            return dbFile.findDataSource();
        }
        return null;
    }

    @Nullable
    public static DbElement findElement(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtil.$$$reportNull$$$0(103);
        }
        if (DbSrcUtils.isDbSrcFile(file)) {
            return DbSrcUtils.findDbElement(project, file.getPath(), DbElement.class, true);
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).findElement();
        }
        return null;
    }

    @Nullable
    public static ObjectKind getKind(@NotNull VirtualFile file) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(104);
        }
        if (DbSrcUtils.isDbSrcFile(file)) {
            return (ObjectKind)ObjectKind.ourKinds.get(DbSrcUtils.getKind(file.getPath()));
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).getObjectKind();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findSourceVirtualFile(@NotNull DbElement o, boolean refresh) {
        if (o == null) {
            DbImplUtil.$$$reportNull$$$0(105);
        }
        ObjectKind kind = o.getKind();
        VirtualFile file = DbImplUtil.findVirtualFileInSourceStorage(o, false, refresh);
        if (file != null) {
            return file;
        }
        if (kind == ObjectKind.NONE || kind == ObjectKind.DATABASE || kind == ObjectKind.SCHEMA) {
            return null;
        }
        if (DbImplUtil.isDataTable(kind)) {
            return DatabaseElementVirtualFileImpl.findFile(o, true);
        }
        return o.getVirtualFile();
    }

    @Nullable
    public static VirtualFile findVirtualFileInSourceStorage(@Nullable DbElement o, boolean original, boolean refresh) {
        Object delegate;
        Object object = delegate = o != null ? o.getDelegate() : null;
        if (delegate instanceof BasicSourceAware) {
            DbSrcPath srcPath = DbSrcPath.of((DasObject)o);
            VirtualFile vf = DbSrcUtils.findDbSrcFile(o.getDataSource(), srcPath, refresh);
            if (vf != null) {
                return original ? DbSrcFileSystem.getInstance().getBaseFile(vf, false) : vf;
            }
        }
        return null;
    }

    @Nullable
    public static String loadDefinitionFromStorage(@Nullable DbElement o) {
        VirtualFile file = DbImplUtil.findVirtualFileInSourceStorage(o, true, false);
        if (file == null) {
            return null;
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public static String getSearchPath(@NotNull SearchPath to, @NotNull LocalDataSource dataSource, @NotNull DatabaseDialectEx dialect) {
        if (to == null) {
            DbImplUtil.$$$reportNull$$$0(106);
        }
        if (dataSource == null) {
            DbImplUtil.$$$reportNull$$$0(107);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(108);
        }
        String setSchemaSql = dialect.sqlSetSearchPath(to);
        ObjectPath current = to.getCurrent();
        if (setSchemaSql == null && current.path.size() > 1 && current.kind == ObjectKind.SCHEMA) {
            return dialect.sqlSetSearchPath(SearchPath.of((ObjectPath)new ObjectPath(ObjectKind.DATABASE, current.path.subList(0, current.path.size() - 1))));
        }
        return setSchemaSql;
    }

    @NotNull
    public static <T extends ColumnDescriptor> List<T> getWhereClauseColumns(@Nullable DasTable table, @NotNull List<T> descriptors, @NotNull DatabaseDialect dialect) {
        if (descriptors == null) {
            DbImplUtil.$$$reportNull$$$0(109);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(110);
        }
        DasTableKey primaryKey = table == null ? null : DasUtil.getPrimaryKey((DasTable)table);
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)descriptors.size());
        if (primaryKey != null) {
            THashSet set = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            ContainerUtil.addAll((Collection)set, (Iterable)primaryKey.getColumnsRef().names());
            result2.addAll(ContainerUtil.filter(descriptors, arg_0 -> DbImplUtil.lambda$getWhereClauseColumns$3((Set)set, arg_0)));
        }
        if (!result2.isEmpty()) {
            ArrayList arrayList = result2;
            if (arrayList == null) {
                DbImplUtil.$$$reportNull$$$0(111);
            }
            return arrayList;
        }
        result2.addAll(ContainerUtil.filter(descriptors, descriptor -> {
            if (dialect == null) {
                DbImplUtil.$$$reportNull$$$0(155);
            }
            return DbImplUtil.isSuitable(descriptor, dialect);
        }));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DbImplUtil.$$$reportNull$$$0(112);
        }
        return arrayList;
    }

    public static boolean supportsDomainAuth(@Nullable DatabaseDriver driver) {
        return SystemInfo.isWindows && driver != null && ("sqlserver.ms".equals(driver.getId()) || "sqlserver.jtds".equals(driver.getId()) || "com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driver.getDriverClass()) || "net.sourceforge.jtds.jdbc.Driver".equals(driver.getDriverClass()));
    }

    public static String concatStringResults(DatabaseConnection connection, DatabaseDialectEx dialect, String query, int forcedColumn, ConcatenationProps props) throws SQLException {
        return DbImplUtil.concatStringResults(connection, dialect, query, forcedColumn, new StringBuilder(), props).toString().trim();
    }

    public static StringBuilder concatStringResults(DatabaseConnection connection, DatabaseDialectEx dialect, int forcedColumn, String query, StringBuilder sb, ConcatenationProps props) throws SQLException {
        return DbImplUtil.concatStringResults(connection, dialect, query, forcedColumn, sb, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder concatStringResults(DatabaseConnection connection, DatabaseDialectEx dialect, String query, int forcedColumn, StringBuilder sb, ConcatenationProps props) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            int updateCount;
            ResultSet rs = statement.executeQuery(query);
            boolean resultSetHere = rs != null;
            int n = updateCount = resultSetHere ? -1 : JdbcEngine.getUpdateCountSafe(statement);
            while (resultSetHere || updateCount != -1) {
                if (resultSetHere && rs == null) {
                    rs = statement.getResultSet();
                }
                if (rs != null) {
                    try {
                        DbImplUtil.concatStringResults(rs, (DatabaseDialect)dialect, forcedColumn, sb, props);
                    }
                    finally {
                        JdbcUtil.closeResultSetSafe((ResultSet)rs);
                    }
                }
                rs = null;
                resultSetHere = statement.getMoreResults();
                updateCount = JdbcEngine.getUpdateCountSafe(statement);
            }
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
        return sb;
    }

    protected static void concatStringResults(ResultSet rs, DatabaseDialect dialect, int forcedColumn, StringBuilder sb, ConcatenationProps props) throws SQLException {
        int trimmedLen;
        DataConsumer.Column[] columns2 = JdbcEngine.getColumnDescriptors(rs, dialect);
        int columnCount = columns2.length;
        int start = sb.length();
        while (rs.next()) {
            if (start != sb.length()) {
                sb.append(props.rowSep);
            }
            int rowStart = sb.length();
            for (int i2 = forcedColumn > 0 ? forcedColumn : 1; i2 <= (forcedColumn > 0 ? forcedColumn : columnCount); ++i2) {
                CharSequence s = DbImplUtil.extractString(rs.getObject(i2));
                if (s == null) continue;
                if (props.lTrim) {
                    s = StringUtil.trimLeading((CharSequence)s);
                }
                if (props.rTrim) {
                    s = StringUtil.trimTrailing((CharSequence)s);
                }
                if (rowStart != sb.length()) {
                    sb.append(props.colSep);
                }
                sb.append(s);
            }
        }
        for (trimmedLen = sb.length(); trimmedLen != 0 && sb.charAt(trimmedLen - 1) == ' '; --trimmedLen) {
        }
        sb.setLength(trimmedLen);
    }

    @Nullable
    private static CharSequence extractString(@Nullable Object object) throws SQLException {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            return clob.getSubString(1L, (int)clob.length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeAndGetResult(DatabaseConnection connection, String query, ThrowableConvertor<ResultSet, T, SQLException> result2) throws SQLException {
        Object object;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            rs = statement.executeQuery(query);
            object = result2.convert((Object)rs);
        }
        catch (Throwable throwable) {
            JdbcUtil.closeResultSetSafe(rs);
            JdbcUtil.closeStatementSafe((Statement)statement);
            throw throwable;
        }
        JdbcUtil.closeResultSetSafe((ResultSet)rs);
        JdbcUtil.closeStatementSafe((Statement)statement);
        return (T)object;
    }

    public static int getCount(@NotNull DatabaseConnection connection, @NotNull String query) throws SQLException {
        if (connection == null) {
            DbImplUtil.$$$reportNull$$$0(113);
        }
        if (query == null) {
            DbImplUtil.$$$reportNull$$$0(114);
        }
        return (Integer)DbImplUtil.executeAndGetResult(connection, query, resultSet -> {
            if (!resultSet.next()) {
                throw new AssertionError((Object)"Incorrect count query!");
            }
            return resultSet.getInt(1);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(@NotNull DatabaseConnection connection, @NotNull String sql) throws SQLException {
        if (connection == null) {
            DbImplUtil.$$$reportNull$$$0(115);
        }
        if (sql == null) {
            DbImplUtil.$$$reportNull$$$0(116);
        }
        Statement statement = connection.createStatement();
        try {
            int n = statement.executeUpdate(sql);
            return n;
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> resultRowAsMap(DatabaseConnection connection, String query, String ... columnSelection) throws SQLException {
        ResultSet rs;
        Statement statement;
        Map result2;
        block5: {
            result2 = Collections.emptyMap();
            statement = null;
            rs = null;
            try {
                statement = connection.createStatement();
                rs = statement.executeQuery(query);
                if (!rs.next()) break block5;
                result2 = JdbcUtil.resultSetRowToMapSafe((ResultSet)rs);
                if (columnSelection.length > 0 && !result2.isEmpty()) {
                    assert (columnSelection.length % 2 == 0);
                    LinkedHashMap map2 = ContainerUtil.newLinkedHashMap();
                    for (int i2 = 0; i2 < columnSelection.length; i2 += 2) {
                        Object o = result2.get(columnSelection[i2]);
                        if (o == null) continue;
                        map2.put(columnSelection[i2 + 1], o);
                    }
                    result2 = map2;
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.closeResultSetSafe(rs);
                JdbcUtil.closeStatementSafe((Statement)statement);
                throw throwable;
            }
        }
        JdbcUtil.closeResultSetSafe((ResultSet)rs);
        JdbcUtil.closeStatementSafe((Statement)statement);
        return result2;
    }

    @Nullable
    public static DbDataSource getForcedDataSource(@Nullable PsiFile psiFile) {
        DbDataSource element;
        VirtualFileSystem fileSystem;
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = virtualFile = psiFile == null ? null : psiFile.getViewProvider().getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = PsiUtilCore.getVirtualFile((PsiElement)InjectedLanguageUtil.getTopLevelFile((PsiElement)psiFile));
        }
        VirtualFileSystem virtualFileSystem = fileSystem = virtualFile == null ? null : virtualFile.getFileSystem();
        if (virtualFile == null) {
            element = null;
        } else if (virtualFile instanceof DatabaseElementVirtualFileImpl) {
            element = ((DatabaseElementVirtualFileImpl)virtualFile).findDataSource();
        } else if (DbConsoleRootType.isConsoleFile(virtualFile)) {
            element = DbConsoleRootType.getDataSource(psiFile.getProject(), virtualFile);
        } else if (fileSystem instanceof DbSrcFileSystem) {
            String dataSourceId = DbSrcUtils.getDataSource(virtualFile);
            element = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)psiFile.getProject()).findDataSource(dataSourceId);
        } else {
            JdbcConsole console = JdbcConsoleProvider.getAttachedConsole(psiFile.getProject(), virtualFile);
            DbDataSource dbDataSource = element = console == null ? (DbDataSource)DatabaseDataKeys.DATA_SOURCE_KEY.get((UserDataHolder)psiFile) : DbImplUtil.getDbDataSource(console.getProject(), console.getDataSource());
            if (element == null && ApplicationManager.getApplication().isUnitTestMode()) {
                return (DbDataSource)DatabaseDataKeys.DATA_SOURCE_KEY.get((UserDataHolder)virtualFile);
            }
        }
        return element != null && element.isValid() ? element : null;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForExec(@NotNull PsiFile file, boolean ignoreForced, boolean matchingOnly) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(117);
        }
        DbDataSource forced = ignoreForced ? null : DbImplUtil.getForcedDataSource(file);
        JBIterable<DbDataSource> result2 = forced != null ? JBIterable.of((Object)forced) : DbSqlUtil.getAppropriateDataSources(file, false, matchingOnly);
        JBIterable jBIterable = result2.filter(CAN_CONNECT_TO);
        if (jBIterable == null) {
            DbImplUtil.$$$reportNull$$$0(118);
        }
        return jBIterable;
    }

    public static DdlBuilder composeWhereCondition(@NotNull DdlBuilder builder, @NotNull List<DataConsumer.Column> columns2, @NotNull List<Object> values, @NotNull DatabaseDialect dialect, @Nullable String tableAlias) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(119);
        }
        if (columns2 == null) {
            DbImplUtil.$$$reportNull$$$0(120);
        }
        if (values == null) {
            DbImplUtil.$$$reportNull$$$0(121);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(122);
        }
        for (int i2 = 0; i2 < columns2.size(); ++i2) {
            if (i2 > 0) {
                builder.space().keyword("AND").space();
            }
            DataConsumer.Column column = columns2.get(i2);
            boolean useLike = "java.lang.String".equals(column.clazz);
            DbImplUtil.composeWhereItem(builder, column.name, values.get(i2), useLike, tableAlias, dialect);
        }
        return builder;
    }

    public static DdlBuilder composeWhereCondition(DdlBuilder builder, Iterable<String> names, Iterable<?> values, String alias, DatabaseDialect dialect) {
        boolean first = true;
        Iterator<String> it1 = names.iterator();
        Iterator<?> it2 = values.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (first) {
                first = false;
            } else {
                builder.space().keyword("AND").space();
            }
            DbImplUtil.composeWhereItem(builder, it1.next(), it2.next(), true, alias, dialect);
        }
        return builder;
    }

    public static DdlBuilder composeWhereItem(@NotNull DdlBuilder builder, String columnName, Object value, boolean useLike, String alias, @NotNull DatabaseDialect dialect) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(123);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(124);
        }
        if (alias != null) {
            builder.alias(alias).symbol(".");
        }
        builder.identifier(columnName).space();
        if (value == null) {
            builder.keywords("IS", "NULL");
        } else {
            boolean isString = value instanceof String;
            boolean bl = useLike = useLike && isString && DbImplUtil.supportsLike(dialect);
            if (useLike) {
                builder.keyword("LIKE");
            } else {
                builder.symbol("=");
            }
            String literal = isString ? DbImplUtil.escapeSql((String)value, useLike, dialect) : value.toString();
            builder.space().literal(isString ? "'" + literal.replace("'", "''") + "'" : literal);
            if (useLike && literal.indexOf(35) > -1) {
                builder.space().keyword("ESCAPE").space().plain("'#'");
            }
        }
        return builder;
    }

    private static boolean supportsLike(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(125);
        }
        return JdbcNativeUtil.supportsLike((Rdbms)DbImplUtil.getRdbms(dialect));
    }

    @NotNull
    public static List<ColumnQueryData> composeWhereConditionWithParameters(@NotNull DdlBuilder builder, @NotNull Iterable<ColumnQueryData> datas, @Nullable String alias, @NotNull DatabaseDialect dialect) {
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(126);
        }
        if (datas == null) {
            DbImplUtil.$$$reportNull$$$0(127);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(128);
        }
        ArrayList parameters = ContainerUtil.newArrayList();
        boolean first = true;
        for (ColumnQueryData data : datas) {
            if (first) {
                first = false;
            } else {
                builder.space().keyword("AND").space();
            }
            ThreeState nullability = data.getObject() == null ? ThreeState.YES : ThreeState.NO;
            int placeholdersAdded = DbImplUtil.composeWhereItemWithParameters(builder, data.getColumn(), nullability, alias, dialect);
            parameters.addAll(Collections.nCopies(placeholdersAdded, data));
        }
        ArrayList arrayList = parameters;
        if (arrayList == null) {
            DbImplUtil.$$$reportNull$$$0(129);
        }
        return arrayList;
    }

    public static int composeWhereItemWithParameters(@NotNull DdlBuilder builder, @NotNull DataConsumer.Column column, @NotNull ThreeState nullability, @Nullable String alias, @NotNull DatabaseDialect dialect) {
        boolean useLike;
        if (builder == null) {
            DbImplUtil.$$$reportNull$$$0(130);
        }
        if (column == null) {
            DbImplUtil.$$$reportNull$$$0(131);
        }
        if (nullability == null) {
            DbImplUtil.$$$reportNull$$$0(132);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(133);
        }
        if (nullability == ThreeState.UNSURE) {
            builder.symbol("(");
        }
        if (DbImplUtil.isRowId(column)) {
            builder.plain(column.name);
        } else {
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column.name);
        }
        builder.space();
        if (nullability == ThreeState.YES) {
            builder.keywords("IS", "NULL");
            return 0;
        }
        boolean bl = useLike = DbImplUtil.supportsLike(dialect) && "java.lang.String".equals(column.clazz);
        if (useLike) {
            builder.keyword("LIKE");
        } else {
            builder.symbol("=");
        }
        builder.space().symbol("?");
        if (useLike) {
            builder.space().keyword("ESCAPE").space().plain("'#'");
        }
        if (nullability == ThreeState.UNSURE) {
            builder.space().keyword("OR").space().symbol("(");
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column.name).space().keywords("IS", "NULL", "AND").space().symbol("?").space().keywords("IS", "NULL");
            builder.symbol(")");
            builder.symbol(")");
            return 2;
        }
        return 1;
    }

    public static String escapeStr(String value) {
        return StringUtil.notNullize((String)value).replace("'", "''");
    }

    public static <T> T escapeSql(T value, boolean needsEscaping, @NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(134);
        }
        if (!needsEscaping) {
            return value;
        }
        DatabaseFamilyId familyId = dialect.getFamilyId();
        if (familyId.isSqlite()) {
            return value;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String s = (String)value;
        List<String> unescapedChars = familyId.isMysql() ? Arrays.asList("%", "_", "\\", String.valueOf('#')) : Arrays.asList("%", "_", String.valueOf('#'));
        List escapedChars = ContainerUtil.map2List(unescapedChars, s1 -> '#' + s1);
        return (T)StringUtil.replace((String)s, unescapedChars, (List)escapedChars);
    }

    public static boolean isRowId(DataConsumer.Column column) {
        return ROW_ID == column.table;
    }

    public static DataConsumer.Column makeRowId(DataConsumer.Column column) {
        return new DataConsumer.Column(column.columnNum, column.name, column.type, column.typeName, column.clazz, -1, -1, ROW_ID, ROW_ID, ROW_ID);
    }

    public static boolean isSqlFileType(FileType fileType) {
        return fileType instanceof LanguageFileType && "sql".equals(fileType.getDefaultExtension());
    }

    public static boolean isPageSizeUnlimited(int pageSize) {
        return pageSize < 1;
    }

    public static boolean writeVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute, @Nullable String value) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(135);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(136);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return false;
        }
        try {
            return DbImplUtil.writeVFSAttribute(file, attribute, value);
        }
        catch (IOException ex) {
            DataSourceUiUtil.LOG.warn((Throwable)ex);
            return false;
        }
    }

    @Nullable
    public static String readVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute) {
        if (file == null) {
            DbImplUtil.$$$reportNull$$$0(137);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(138);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        try {
            return DbImplUtil.readVFSAttribute(file, attribute);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean writeVFSAttribute(@NotNull VirtualFile fileOrDir, @NotNull FileAttribute attribute, @Nullable String value) throws IOException {
        String oldValue;
        if (fileOrDir == null) {
            DbImplUtil.$$$reportNull$$$0(139);
        }
        if (attribute == null) {
            DbImplUtil.$$$reportNull$$$0(140);
        }
        if (Comparing.equal((String)(oldValue = DbImplUtil.readVFSAttribute(fileOrDir, attribute)), (String)value)) {
            return false;
        }
        DataOutputStream oStream = attribute.writeAttribute(fileOrDir);
        DataInputOutputUtil.writeINT((DataOutput)oStream, (int)myDialectAndDataSourcesEnumerator.getId((Object)StringUtil.notNullize((String)value)));
        oStream.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readVFSAttribute(VirtualFile fileOrDir, FileAttribute attribute) throws IOException {
        DataInputStream iStream = attribute.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                String string = StringUtil.nullize((String)((String)myDialectAndDataSourcesEnumerator.getById(DataInputOutputUtil.readINT((DataInput)iStream))));
                return string;
            }
            finally {
                iStream.close();
            }
        }
        return null;
    }

    public static boolean isAuthRequired(@NotNull LocalDataSource info) {
        if (info == null) {
            DbImplUtil.$$$reportNull$$$0(141);
        }
        return info.isAuthRequired();
    }

    public static void initLanguageComboBox(JComboBox comboBox, boolean allowNull) {
        ArrayList<SqlLanguageDialect> langs = new ArrayList<SqlLanguageDialect>();
        if (allowNull) {
            langs.add(null);
        }
        langs.addAll(DbSqlUtil.getTopLevelSqlDialects());
        comboBox.setModel(new CollectionComboBoxModel(langs));
        comboBox.setEditable(false);
        comboBox.setRenderer(new ListCellRendererWrapper<Language>(){

            public void customize(JList list, Language language, int index, boolean selected, boolean hasFocus) {
                if (language == null) {
                    this.setText("<default>");
                    this.setIcon(null);
                } else {
                    if (language instanceof SqlLanguageDialect) {
                        this.setIcon(((SqlLanguageDialect)language).getDatabaseDialect().getIcon());
                    } else {
                        LanguageFileType fileType = language.getAssociatedFileType();
                        this.setIcon(fileType == null ? null : fileType.getIcon());
                    }
                    this.setText(language.getDisplayName());
                }
            }
        });
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull RawConnectionConfig info) {
        if (info == null) {
            DbImplUtil.$$$reportNull$$$0(142);
        }
        Collection<? extends DatabaseDriver> allDrivers = DatabaseDriverManager.getInstance().getDrivers();
        List matchedDrivers = ContainerUtil.newSmartList();
        if (info.getDriverClass() == null) {
            matchedDrivers.addAll(allDrivers);
        } else {
            for (DatabaseDriver databaseDriver : allDrivers) {
                if (!Comparing.equal((String)info.getDriverClass(), (String)databaseDriver.getDriverClass())) continue;
                matchedDrivers.add(databaseDriver);
            }
        }
        if (matchedDrivers.isEmpty()) {
            return null;
        }
        if (matchedDrivers.size() == 1) {
            return (DatabaseDriver)matchedDrivers.get(0);
        }
        String url = StringUtil.notNullize((String)info.getUrl());
        ArrayList arrayList = ContainerUtil.newArrayListWithCapacity((int)matchedDrivers.size());
        for (DatabaseDriver driver : matchedDrivers) {
            if (!driver.matchesUrl(url)) continue;
            arrayList.add(driver);
        }
        if (arrayList.isEmpty()) {
            return (DatabaseDriver)matchedDrivers.get(0);
        }
        if (arrayList.size() == 1) {
            return (DatabaseDriver)arrayList.get(0);
        }
        return DbImplUtil.disambiguate(url, (JBIterable<DatabaseDriver>)JBIterable.from((Iterable)arrayList));
    }

    @Nullable
    public static DatabaseDriver disambiguate(@NotNull String url, @NotNull JBIterable<DatabaseDriver> drivers) {
        if (url == null) {
            DbImplUtil.$$$reportNull$$$0(143);
        }
        if (drivers == null) {
            DbImplUtil.$$$reportNull$$$0(144);
        }
        if (StringUtil.containsIgnoreCase((String)url, (String)"database.windows.net")) {
            return (DatabaseDriver)drivers.filter(d -> DbImplUtil.likelyAzureDriver(d)).append(drivers).first();
        }
        if (StringUtil.containsIgnoreCase((String)url, (String)"redshift.amazonaws.com")) {
            return (DatabaseDriver)drivers.filter(d -> DbImplUtil.likelyRedshiftDriver(d)).append(drivers).first();
        }
        return (DatabaseDriver)drivers.filter(d -> !DbImplUtil.likelyAzureDriver(d) && !DbImplUtil.likelyRedshiftDriver(d)).append(drivers).first();
    }

    private static boolean likelyRedshiftDriver(DatabaseDriver driver) {
        return StringUtil.containsIgnoreCase((String)driver.getId(), (String)"redshift") || StringUtil.containsIgnoreCase((String)driver.getName(), (String)"redshift");
    }

    private static boolean likelyAzureDriver(DatabaseDriver driver) {
        return StringUtil.containsIgnoreCase((String)driver.getId(), (String)"azure") || StringUtil.containsIgnoreCase((String)driver.getName(), (String)"azure");
    }

    @Nullable
    public static BasicElement getMaybeBasicElement(@Nullable DasObject o) {
        Object delegate = DbImplUtil.unwrap(o);
        return delegate instanceof BasicElement ? (BasicElement)delegate : null;
    }

    @Nullable
    public static LocalDataSource getMaybeLocalDataSource(@Nullable DatabaseSystem info) {
        DatabaseSystem dataSource = DbImplUtil.unwrapDS(info);
        return dataSource instanceof LocalDataSource ? (LocalDataSource)dataSource : null;
    }

    @NotNull
    public static LocalDataSource getLocalDataSource(@Nullable DatabaseSystem info) {
        DatabaseSystem dataSource = DbImplUtil.unwrapDS(info);
        if (dataSource instanceof LocalDataSource) {
            LocalDataSource localDataSource = (LocalDataSource)dataSource;
            if (localDataSource == null) {
                DbImplUtil.$$$reportNull$$$0(145);
            }
            return localDataSource;
        }
        throw new AssertionError(info);
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done, @Nullable String reason) {
        if (callback == null) {
            return;
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            if (done) {
                callback.setResult(null);
            } else {
                callback.setError(StringUtil.isEmptyOrSpaces((String)reason) ? "not done" : reason);
            }
        });
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done) {
        DbImplUtil.setActionCallbackDone(callback, done, null);
    }

    @NotNull
    public static EnumSet<ReservedCellValue> getSpecialValues(@Nullable DasColumn databaseColumn) {
        if (databaseColumn == null) {
            EnumSet<ReservedCellValue> enumSet = EnumSet.of(ReservedCellValue.NULL);
            if (enumSet == null) {
                DbImplUtil.$$$reportNull$$$0(146);
            }
            return enumSet;
        }
        EnumSet<ReservedCellValue> result2 = EnumSet.noneOf(ReservedCellValue.class);
        if (DasUtil.isAutoGenerated((DasColumn)databaseColumn)) {
            result2.add(ReservedCellValue.GENERATED);
        }
        if (DasUtil.isComputed((DasColumn)databaseColumn)) {
            result2.add(ReservedCellValue.COMPUTED);
        }
        if (!databaseColumn.isNotNull()) {
            result2.add(ReservedCellValue.NULL);
        }
        if (databaseColumn.getDefault() != null) {
            result2.add(ReservedCellValue.DEFAULT);
        }
        EnumSet<ReservedCellValue> enumSet = result2;
        if (enumSet == null) {
            DbImplUtil.$$$reportNull$$$0(147);
        }
        return enumSet;
    }

    public static boolean isZonedTimestampColumn(@NotNull ColumnDescriptor column, @NotNull DatabaseDialect dialect) {
        if (column == null) {
            DbImplUtil.$$$reportNull$$$0(148);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(149);
        }
        return JdbcNativeUtil.isZonedTimestampColumn((String)column.getTypeName(), (Rdbms)DbImplUtil.getRdbms(dialect));
    }

    public static boolean isZonedTimeColumn(@NotNull ColumnDescriptor column, @NotNull DatabaseDialect dialect) {
        if (column == null) {
            DbImplUtil.$$$reportNull$$$0(150);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(151);
        }
        return JdbcNativeUtil.isZonedTimeColumn((String)column.getTypeName(), (Rdbms)DbImplUtil.getRdbms(dialect));
    }

    @Nullable
    public static DatabaseSystem unwrapDS(@Nullable DatabaseSystem database) {
        DatabaseSystem o;
        DatabaseSystem databaseSystem = o = database instanceof DbDataSource ? ((DbDataSource)database).getDelegate() : database;
        if (o == null || o instanceof LocalDataSource || o instanceof SqlDataSource) {
            return o;
        }
        throw new AssertionError(database);
    }

    @Contract(value="null -> null")
    public static Object unwrap(@Nullable DasObject object) {
        Object tmp = object;
        while (tmp != null) {
            if (!(tmp instanceof DbElement)) {
                return tmp;
            }
            tmp = ((DbElement)tmp).getDelegate();
        }
        return object;
    }

    public static boolean autoSwitchSchema(@Nullable DatabaseDialect dialect) {
        return dialect == null || !dialect.getFamilyId().isPostgres();
    }

    @Nullable
    public static SearchPath getAutoSwitchPath(@Nullable DatabaseDialect dialect, @Nullable SearchPath path) {
        if (DbImplUtil.autoSwitchSchema(dialect)) {
            return path;
        }
        if (path == null || !dialect.getFamilyId().isPostgres()) {
            return null;
        }
        ObjectPath current = path.getCurrent();
        if (current.kind == ObjectKind.DATABASE) {
            return path;
        }
        int sz = current.path.size();
        if (current.kind == ObjectKind.SCHEMA && sz > 1) {
            return SearchPath.of((ObjectPath)new ObjectPath(ObjectKind.DATABASE, current.path.subList(0, sz - 1)));
        }
        return null;
    }

    public static void performSrcOperation(@Nullable DasModel model, @Nullable TransactionId transactionId, boolean asyncRefresh, @NotNull Runnable runnable) {
        BasicModModel basicModel;
        DbSrcModelStorage storage;
        if (runnable == null) {
            DbImplUtil.$$$reportNull$$$0(152);
        }
        DbSrcModelStorage dbSrcModelStorage = storage = (basicModel = (BasicModModel)ObjectUtils.tryCast((Object)model, BasicModModel.class)) == null ? null : (DbSrcModelStorage)ObjectUtils.tryCast((Object)basicModel.getTextStorage(), DbSrcModelStorage.class);
        if (storage == null) {
            runnable.run();
        } else {
            try (GuardedRef ignored = storage.startWriteSession(basicModel, transactionId, asyncRefresh);){
                runnable.run();
            }
        }
    }

    private static boolean isSuitable(@NotNull ColumnDescriptor descriptor, @NotNull DatabaseDialect dialect) {
        if (descriptor == null) {
            DbImplUtil.$$$reportNull$$$0(153);
        }
        if (dialect == null) {
            DbImplUtil.$$$reportNull$$$0(154);
        }
        int type = descriptor.getType();
        DatabaseFamilyId family = dialect.getFamilyId();
        String typeName = descriptor.getTypeName();
        return type != 2004 && type != 2005 && type != 2011 && (!StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"xml") || !family.isMicrosoft()) && (type != 2009 || !family.isPostgres() && !family.isOracle()) && !PostgresHelper.isPgJson((Rdbms)DbImplUtil.getRdbms(family), (String)typeName);
    }

    public static boolean isTypeKind(@Nullable ObjectKind kind) {
        return kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.COLLECTION_TYPE || kind == ObjectKind.ALIAS_TYPE || kind == ObjectKind.TABLE_TYPE;
    }

    private static /* synthetic */ boolean lambda$getWhereClauseColumns$3(Set set, ColumnDescriptor descriptor) {
        return set.contains(descriptor.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 46: 
            case 48: 
            case 52: 
            case 67: 
            case 69: 
            case 71: 
            case 74: 
            case 79: 
            case 94: 
            case 96: 
            case 98: 
            case 111: 
            case 112: 
            case 118: 
            case 129: 
            case 145: 
            case 146: 
            case 147: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 46: 
            case 48: 
            case 52: 
            case 67: 
            case 69: 
            case 71: 
            case 74: 
            case 79: 
            case 94: 
            case 96: 
            case 98: 
            case 111: 
            case 112: 
            case 118: 
            case 129: 
            case 145: 
            case 146: 
            case 147: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lob";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 19: 
            case 25: 
            case 28: 
            case 34: 
            case 36: 
            case 39: 
            case 65: 
            case 66: 
            case 81: 
            case 82: 
            case 89: 
            case 108: 
            case 110: 
            case 122: 
            case 124: 
            case 125: 
            case 128: 
            case 133: 
            case 134: 
            case 149: 
            case 151: 
            case 154: 
            case 155: 
            case 157: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseTable";
                break;
            }
            case 11: 
            case 15: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 12: 
            case 16: 
            case 121: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 17: 
            case 23: 
            case 47: 
            case 49: 
            case 83: 
            case 119: 
            case 123: 
            case 126: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 20: 
            case 127: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datas";
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 46: 
            case 48: 
            case 52: 
            case 67: 
            case 69: 
            case 71: 
            case 74: 
            case 79: 
            case 94: 
            case 96: 
            case 98: 
            case 111: 
            case 112: 
            case 118: 
            case 129: 
            case 145: 
            case 146: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasTable";
                break;
            }
            case 27: 
            case 33: 
            case 35: 
            case 38: 
            case 53: 
            case 56: 
            case 102: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 29: 
            case 40: 
            case 44: 
            case 50: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 30: 
            case 37: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 43: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 55: 
            case 60: 
            case 61: 
            case 80: 
            case 85: 
            case 87: 
            case 93: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 58: 
            case 59: 
            case 100: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 64: 
            case 75: 
            case 76: 
            case 131: 
            case 148: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdbms";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defClazz";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromToken";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toToken";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionInfo";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
            case 104: 
            case 117: 
            case 135: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 136: 
            case 138: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 141: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drivers";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbImplUtil";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectAllQueryWithParameters";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectAllQuery";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findFreeAlias";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "appendWrappedQueryTail";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "countQueryHead";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "resultSetToString";
                break;
            }
            case 67: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getRdbms";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamily";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDate";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "blobFromFile";
                break;
            }
            case 94: 
            case 96: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhereClauseColumns";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourcesForExec";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "composeWhereConditionWithParameters";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalDataSource";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "clobStringEquals";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForExec";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForUIExec";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createSelectAllQuery";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createSelectAllQueryWithParameters";
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 46: 
            case 48: 
            case 52: 
            case 67: 
            case 69: 
            case 71: 
            case 74: 
            case 79: 
            case 94: 
            case 96: 
            case 98: 
            case 111: 
            case 112: 
            case 118: 
            case 129: 
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findFreeAlias";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createSelectCountQuery";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "wrapSelectQuery";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "appendWrappedQueryTail";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "countQueryHead";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "buildOptimizedCountQuery";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getDbDataSource";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isConnected";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "hasDriverFiles";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "canConnectTo";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getConnection";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseConnection";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteProcessDown";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 66: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getRdbms";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getFamily";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "prepareValue";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "prepareDate";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "canInsertBlob";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "canInsertClob";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "clobFromFile";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "blobFromFile";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadViewDefinition";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathObjectForSwitch";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathObject";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "endStatement";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadProcedureDefinition";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "replaceTokenInDefinition";
                break;
            }
            case 93: 
            case 95: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "guessDatabaseDialect";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "supportsDynamicSchemaSwitching";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadPackageDefinition";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "findSourceVirtualFile";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPath";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getWhereClauseColumns";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getCount";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdate";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesForExec";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereCondition";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereItem";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "supportsLike";
                break;
            }
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereConditionWithParameters";
                break;
            }
            case 130: 
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "composeWhereItemWithParameters";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "escapeSql";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "writeVFSAttributeSafe";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "readVFSAttributeSafe";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "writeVFSAttribute";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "isAuthRequired";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "guessDatabaseDriver";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "disambiguate";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimestampColumn";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimeColumn";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "performSrcOperation";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getWhereClauseColumns$4";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSelectAllQueryWithParameters$2";
                break;
            }
            case 158: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSelectAllQuery$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 46: 
            case 48: 
            case 52: 
            case 67: 
            case 69: 
            case 71: 
            case 74: 
            case 79: 
            case 94: 
            case 96: 
            case 98: 
            case 111: 
            case 112: 
            case 118: 
            case 129: 
            case 145: 
            case 146: 
            case 147: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConcatenationProps {
        public String rowSep;
        public String colSep;
        public boolean lTrim;
        public boolean rTrim;
        public static final ConcatenationProps LINES = new ConcatenationProps("\n", " ", false, false);
        public static final ConcatenationProps TIGHT = new ConcatenationProps("", "", false, false);
        public static final ConcatenationProps NO_CONCAT = LINES;

        public ConcatenationProps(String rowSep, String colSep, boolean lTrim, boolean rTrim) {
            this.rowSep = rowSep;
            this.colSep = colSep;
            this.lTrim = lTrim;
            this.rTrim = rTrim;
        }

        public String toString() {
            return "ConcatenationProps{rowSep='" + this.rowSep + '\'' + ", colSep='" + this.colSep + '\'' + ", lTrim=" + this.lTrim + ", rTrim=" + this.rTrim + '}';
        }
    }
}

