/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlPrefixedElement;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.fragments.SqlCodeFragment;
import com.intellij.sql.psi.impl.SqlCompletionUtil;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompletionContributor
extends CompletionContributor {
    public static final int ALIAS_PRIORITY = 100;
    public static final int FK_TABLE_PRIORITY = 90;
    public static final int FK_CONDITION_PRIORITY = 91;
    public static final int FUN_PRIORITY = 0;
    public static final int AS_ALIAS_PRIORITY = 10;
    public static final int KW_PRIORITY = 5;
    public static final int SIMILARITY_FACTOR = 10;
    private static final TokenSet FOR_FUNCTION_COMPLETION = TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE, SqlCompositeElementTypes.SQL_PROCEDURE_REFERENCE, SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE, SqlCompositeElementTypes.SQL_ARGUMENT_REFERENCE, SqlCompositeElementTypes.SQL_VARIABLE_REFERENCE, SqlCompositeElementTypes.SQL_REFERENCE});

    public SqlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiFile file;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
                    return;
                }
                PsiElement position = parameters.getPosition();
                if (position instanceof SqlStringTokenElement || position instanceof PsiComment) {
                    return;
                }
                PsiElement prevSibling = position.getParent().getPrevSibling();
                if (prevSibling instanceof ASTNode && ((ASTNode)prevSibling).getElementType() == SqlTokens.SQL_PERIOD) {
                    return;
                }
                SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
                SqlCompletionContributor.suggestTableColumnListAtOnce(position, dialect, result2);
                SqlAsExpression aliasDefinition = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlAsExpression.class);
                if (aliasDefinition != null && PsiTreeUtil.isContextAncestor((PsiElement)aliasDefinition.getNameElement(), (PsiElement)position, (boolean)false)) {
                    for (String name : SqlCompletionContributor.suggestAliasName(aliasDefinition.getExpression())) {
                        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(name, false, true, SqlCompletionUtil.TEMPLATE_SAFE_INSERT_HANDLER, new String[0]), (double)10.0));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet _result) {
                SqlType qualType;
                IElementType fragmentType;
                SqlReferenceImpl ref;
                PsiFile file;
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (_result == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
                    return;
                }
                PsiElement position = parameters.getPosition();
                SqlExpression expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{SqlReferenceExpression.class, SqlStringLiteralExpression.class});
                SqlReferenceImpl sqlReferenceImpl = ref = expression == null ? null : (SqlReferenceImpl)ObjectUtils.tryCast((Object)expression.getReference(), SqlReferenceImpl.class);
                if (ref == null) {
                    return;
                }
                IElementType iElementType = fragmentType = file instanceof SqlCodeFragment ? ((SqlCodeFragment)file).getElementType() : null;
                if (fragmentType == SqlCompositeElementTypes.SQL_TABLE_REFERENCE || fragmentType == SqlCompositeElementTypes.SQL_TYPE_ELEMENT) {
                    return;
                }
                SqlExpression qualifier = ref.getQualifier();
                SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
                if (qualifier != null && !dialect.getFamilyId().isPostgres()) {
                    return;
                }
                SqlType sqlType = qualType = qualifier == null ? null : qualifier.getSqlType();
                if (qualType == SqlType.UNKNOWN) {
                    return;
                }
                CompletionResultSet result2 = _result.caseInsensitive();
                SqlReferenceElementType type = ref.getReferenceElementType();
                if (FOR_FUNCTION_COMPLETION.contains((IElementType)type) && !SqlCompletionUtil.isDropTarget(position) && !ref.resolveStrict()) {
                    boolean isTableFunction = SqlCompletionContributor.isTableFunctionCallRef((PsiElement)expression);
                    for (String s : dialect.getSupportedFunctions().keySet()) {
                        SqlFunctionDefinition def;
                        if (!result2.getPrefixMatcher().prefixMatches(s) || (def = dialect.getSupportedFunctions().get(s)).isTableQueryOnly() && !isTableFunction) continue;
                        for (SqlFunctionDefinition.Prototype prototype : def.getPrototypes()) {
                            if (qualifier != null && !this.isApplicable(prototype, qualifier, qualType)) continue;
                            result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(prototype, dialect), (double)0.0));
                        }
                    }
                }
            }

            private boolean isApplicable(SqlFunctionDefinition.Prototype prototype, SqlExpression qual, SqlType type) {
                SqlFunctionDefinition.Parameter[] params2 = prototype.getParams();
                if (params2.length != 1) {
                    return false;
                }
                return SqlFunctionsUtil.isAssignable(params2[0], qual, type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "_result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                SqlCompletionContributor.suggestJoinStuff(parameters, result2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
                SqlLanguageDialectEx dialect;
                String separator;
                if (parameters == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((separator = this.getSeparator(dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)parameters.getOriginalFile()))) == null) {
                    return;
                }
                PsiElement position = parameters.getPosition();
                int offset = position.getTextRange().getStartOffset();
                SqlExpressionList params2 = (SqlExpressionList)PsiTreeUtil.getParentOfType((PsiElement)position, SqlExpressionList.class);
                SqlFunctionCallExpressionImpl foo = (SqlFunctionCallExpressionImpl)((Object)ObjectUtils.tryCast((Object)(params2 == null ? null : params2.getParent()), SqlFunctionCallExpressionImpl.class));
                if (foo == null) {
                    return;
                }
                SqlExpression slot = (SqlExpression)((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)params2).expand(e -> e == params2)).filter(SqlExpression.class).filter(e -> e.getTextRange().contains(offset)).first();
                if (slot == null || slot instanceof SqlNamedParameterValueExpression) {
                    return;
                }
                PsiElement nonEmpty = (PsiElement)JBIterable.generate((Object)position, PsiTreeUtil::prevVisibleLeaf).skip(1).skipWhile(e -> e instanceof PsiComment || e instanceof PsiWhiteSpace).first();
                if (nonEmpty != null && slot.getTextRange().contains(nonEmpty.getTextRange().getStartOffset())) {
                    return;
                }
                LinkedHashSet names = ContainerUtil.newLinkedHashSet();
                SqlFunctionCallExpressionImpl.processParameters(foo.getNameElement(), (Processor<PsiElement>)((Processor)p -> {
                    if (p instanceof DasObject) {
                        names.add(((DasObject)p).getName());
                    }
                    return true;
                }), position);
                for (String name : names) {
                    result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)name).appendTailText(" " + separator, true).withIcon(DbPresentation.getIcon(ObjectKind.ARGUMENT)).withInsertHandler((ctx, item) -> {
                        SqlCompletionUtil.QUOT_INSERT_HANDLER.handleInsert(ctx, item);
                        String suffix = " " + separator + " ";
                        ctx.getDocument().insertString(ctx.getTailOffset(), (CharSequence)suffix);
                        ctx.getEditor().getCaretModel().moveCaretRelatively(suffix.length(), 0, false, false, false);
                    }), (double)(parameters.getInvocationCount() <= 1 ? 0.0 : 100.0)));
                }
            }

            @Nullable
            private String getSeparator(SqlLanguageDialectEx dialect) {
                if (dialect.getFamilyId().isTransactSql()) {
                    return "=";
                }
                if (dialect.getFamilyId().isPostgres()) {
                    return ":=";
                }
                if (dialect.getFamilyId().isOracle()) {
                    return "=>";
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlCompletionContributor$4";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
                SqlReferenceExpression topReference;
                if (parameters == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (SqlCompletionContributor.suggestJoinStuff(parameters, result2) || SqlCompletionUtil.isJoinUsingColumn(parameters.getPosition())) {
                    return;
                }
                PsiElement position = parameters.getPosition();
                PsiFile file = parameters.getOriginalFile();
                SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
                SqlReferenceExpression reference = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlReferenceExpression.class);
                SqlReferenceExpression sqlReferenceExpression = topReference = reference == null ? null : (SqlReferenceExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)position, SqlReferenceExpression.class);
                if (topReference == null || topReference.getQualifierExpression() != null || !(topReference.getParent() instanceof SqlBinaryExpression)) {
                    return;
                }
                SqlBinaryExpression binary = (SqlBinaryExpression)topReference.getParent();
                IElementType sign = binary.getOpSign();
                if (sign == SqlCommonKeywords.SQL_OR || sign == SqlCommonKeywords.SQL_AND) {
                    return;
                }
                Object leftOperand = binary.getLOperand() == topReference ? binary.getROperand() : (binary.getROperand() == topReference ? binary.getLOperand() : null);
                if (leftOperand == null) {
                    return;
                }
                boolean isEq = sign == SqlTokens.SQL_OP_EQ || sign == SqlTokens.SQL_OP_EQEQ;
                SqlExpression qualifier = reference.getQualifierExpression();
                SqlType expectedType = leftOperand.getSqlType();
                SqlType.Category expectedCategory = expectedType.getCategory();
                PsiElement leftResolved = leftOperand instanceof SqlReferenceExpression ? ((SqlReferenceExpression)leftOperand).resolve() : null;
                DasColumn leftColumn = leftResolved instanceof DasColumn ? (DasColumn)leftResolved : null;
                ArrayList asExpressions = ContainerUtil.newArrayList();
                SqlCompletionUtil.addReferenceCompletionVariants((SqlReferenceImpl)reference.getReference(), result2.getPrefixMatcher(), (Consumer<LookupElement>)((Consumer)lookupElement -> {
                    PsiElement object;
                    if (parameters == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    if (result2 == null) {
                        5.$$$reportNull$$$0(3);
                    }
                    if ((object = CompletionUtil.getTargetElement((LookupElement)lookupElement)) instanceof SqlAsExpression) {
                        asExpressions.add((SqlAsExpression)object);
                        return;
                    }
                    if (!(object instanceof DasColumn)) {
                        return;
                    }
                    DasColumn columnInfo = (DasColumn)object;
                    DataType dataType = columnInfo.getDataType();
                    SqlType byJdbc = SqlTypeFactory.findByJdbcType(dataType.jdbcType, dialect);
                    SqlType byName = SqlTypeFactory.of(dataType, dialect);
                    if (!(expectedCategory.is(byJdbc) || byJdbc != byName && expectedCategory.is(byName))) {
                        return;
                    }
                    DasTable table = columnInfo.getTable();
                    if (table == null) {
                        return;
                    }
                    if (parameters.getInvocationCount() <= 1 && isEq && (leftColumn == null || !SqlCompletionContributor.areColumnsConnected(leftColumn, columnInfo))) {
                        return;
                    }
                    LookupElement element = qualifier == null ? SqlCompletionContributor.prefix(lookupElement, SqlCompletionContributor.calcQualifier(table, asExpressions, dialect) + ".") : lookupElement;
                    result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)element, (double)90.0));
                }));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameters";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/completion/SqlCompletionContributor$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addCompletions";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$addCompletions$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement parent;
                SqlQueryExpression query;
                PsiReference ref;
                if (parameters == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    6.$$$reportNull$$$0(1);
                }
                PsiElement position = parameters.getPosition();
                SqlExpression expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{SqlReferenceExpression.class, SqlStringLiteralExpression.class});
                PsiReference psiReference = ref = expression == null ? null : expression.getReference();
                if (!(ref instanceof SqlReferenceImpl) || SqlCompletionUtil.isJoinUsingColumn(position)) {
                    return;
                }
                SqlReferenceElementType refType = ((SqlReferenceImpl)ref).getReferenceElementType();
                DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)expression).getDatabaseDialect();
                THashSet columnsNamesFromSelect = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
                Ref fromType = Ref.create();
                if (refType == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
                    SqlTableExpression tableExpression;
                    SqlSelectClause selectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlSelectClause.class);
                    query = (SqlQueryExpression)ObjectUtils.tryCast((Object)(selectClause == null ? null : selectClause.getParent()), SqlQueryExpression.class);
                    SqlTableExpression sqlTableExpression = tableExpression = query == null ? null : query.getTableExpression();
                    if (tableExpression != null) {
                        fromType.set((Object)tableExpression.getSqlType());
                    }
                }
                if (refType == SqlCompositeElementTypes.SQL_TABLE_REFERENCE && ((parent = expression.getParent()) instanceof SqlFromClause || parent instanceof SqlJoinExpression)) {
                    SqlSelectClause select;
                    query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlQueryExpression.class);
                    SqlSelectClause sqlSelectClause = select = query != null ? query.getSelectClause() : null;
                    if (select != null) {
                        select.accept(new SqlVisitor((Set)columnsNamesFromSelect, dialect){
                            final /* synthetic */ Set val$columnsNamesFromSelect;
                            final /* synthetic */ DatabaseDialectEx val$dialect;
                            {
                                this.val$columnsNamesFromSelect = set;
                                this.val$dialect = databaseDialectEx;
                            }

                            public void visitSqlReferenceExpression(SqlReferenceExpression e) {
                                if (e.getQualifierExpression() == null && e.getReferenceElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
                                    this.val$columnsNamesFromSelect.add(this.val$dialect.quoteIdentifier(e.getName(), true, false));
                                }
                            }

                            public void visitSqlElement(SqlElement e) {
                                for (PsiElement element = e.getFirstChild(); element != null; element = element.getNextSibling()) {
                                    if (!(element instanceof SqlElement)) continue;
                                    ((SqlElement)element).accept((SqlVisitor)this);
                                }
                            }
                        });
                    }
                }
                PsiElement originalPosition = parameters.getOriginalPosition();
                CompletionResultSet resultSet = result2.caseInsensitive();
                SqlCompletionUtil.addReferenceCompletionVariants((SqlReferenceImpl)ref, resultSet.getPrefixMatcher(), (Consumer<LookupElement>)((Consumer)arg_0 -> 6.lambda$addCompletions$0(refType, originalPosition, fromType, (Set)columnsNamesFromSelect, dialect, resultSet, arg_0)));
            }

            private static /* synthetic */ void lambda$addCompletions$0(SqlReferenceElementType refType, PsiElement originalPosition, Ref fromType, Set columnsNamesFromSelect, DatabaseDialectEx dialect, CompletionResultSet resultSet, LookupElement element) {
                SqlNameElement ne;
                ObjectKind kind;
                PsiElement tgt = CompletionUtil.getTargetElement((LookupElement)element);
                if (tgt instanceof DasObject && !refType.isQualified() && (kind = refType.getTargetKind()) != SqlDbElementType.ANY && ((DasObject)tgt).getKind() != kind) {
                    return;
                }
                if (originalPosition != null && tgt instanceof SqlDefinition && (ne = ((SqlDefinition)tgt).getNameElement()) != null && PsiTreeUtil.isContextAncestor((PsiElement)ne, (PsiElement)originalPosition, (boolean)false)) {
                    return;
                }
                int similarity = 0;
                if (fromType.get() != null) {
                    int i2;
                    if (tgt instanceof DasColumn) {
                        for (i2 = 0; i2 < ((SqlTableType)fromType.get()).getColumnCount(); ++i2) {
                            if (!((SqlTableType)fromType.get()).getColumnElement(i2).equals(tgt)) continue;
                            similarity += 2;
                            break;
                        }
                    } else if (tgt instanceof DasTable) {
                        for (i2 = 0; i2 < ((SqlTableType)fromType.get()).getColumnCount(); ++i2) {
                            if (!Comparing.equal((Object)((SqlTableType)fromType.get()).getColumnQualifier(i2), (Object)tgt)) continue;
                            ++similarity;
                            break;
                        }
                    }
                }
                if (!columnsNamesFromSelect.isEmpty() && tgt instanceof DasTable) {
                    for (DasColumn c : DasUtil.getColumns((DasObject)((DasTable)tgt))) {
                        if (!columnsNamesFromSelect.contains(dialect.quoteIdentifier(c.getName(), true, false))) continue;
                        ++similarity;
                    }
                }
                resultSet.addElement(similarity > 0 ? PrioritizedLookupElement.withPriority((LookupElement)element, (double)(similarity * 10)) : element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlCompletionContributor$6";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean suggestJoinStuff(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiFile file;
        if (parameters == null) {
            SqlCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
            return true;
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent.getNextSibling() != null) {
            return true;
        }
        PsiElement grandPa = parent.getParent();
        if (grandPa instanceof SqlReferenceExpression && ((SqlReferenceExpression)grandPa).getQualifierExpression() != null) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        LinkedHashSet tables = ContainerUtil.newLinkedHashSet(SqlCompletionContributor.collectTablesForJoin(parent, dialect));
        for (TableInfo table : tables) {
            SqlCompletionUtil.addLookupElement(dialect, table.table, (Consumer<LookupElement>)result2, false, 90.0);
        }
        SqlCompletionContributor.suggestJoinConditions(parent, dialect, tables, result2);
        SqlCompletionContributor.suggestJoinUsing(parent, dialect, result2);
        return false;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        String prevElementText;
        if (context == null) {
            SqlCompletionContributor.$$$reportNull$$$0(2);
        }
        if (context.getCompletionType() == CompletionType.SMART) {
            return;
        }
        PsiFile file = context.getFile();
        if (!(file instanceof SqlFile)) {
            return;
        }
        int offset = context.getStartOffset();
        PsiElement element = file.findElementAt(offset);
        DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file).getDatabaseDialect();
        PsiElement prevElement = offset > 0 ? file.findElementAt(offset - 1) : null;
        IElementType prevLeafType = prevElement instanceof LeafPsiElement ? ((LeafPsiElement)prevElement).getElementType() : null;
        PsiElement psiElement = prevElement = prevElement instanceof PsiWhiteSpace || prevLeafType == SqlTokens.SQL_IDENT ? PsiTreeUtil.prevLeaf((PsiElement)prevElement) : prevElement;
        if (prevLeafType == SqlTokens.SQL_UNCLOSED_TOKEN || prevElement != null && (prevElementText = prevElement.getText()) != null && String.valueOf(dialect.openQuote()).equals(prevElementText)) {
            char currentQuote = prevElement.getText().charAt(0);
            char closingQuote = currentQuote == dialect.openQuote() ? dialect.closeQuote() : currentQuote;
            context.setDummyIdentifier(String.valueOf(closingQuote));
        } else if (element != null) {
            ASTNode node = element.getNode();
            IElementType type = node != null ? node.getElementType() : null;
            boolean doNotPatch = type instanceof SqlKeywordTokenType && ((SqlFile)file).getSqlLanguage().isReservedKeyword(type);
            doNotPatch = doNotPatch || (element.getTextRange().getStartOffset() != offset || element.getParent() instanceof SqlIdentifier) && file.findReferenceAt(offset) != null;
            SqlPrefixedElement prefixed = (SqlPrefixedElement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlPrefixedElement.class, (boolean)false);
            if (doNotPatch || prefixed != null && prefixed.getNamePrefix() != null) {
                context.setDummyIdentifier("");
            }
            SqlCompletionContributor.tuneReplacementOffset(context, element);
        }
    }

    private static void tuneReplacementOffset(@NotNull CompletionInitializationContext context, @NotNull PsiElement element) {
        if (context == null) {
            SqlCompletionContributor.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SqlCompletionContributor.$$$reportNull$$$0(4);
        }
        ASTNode node = element.getNode();
        int offset = context.getStartOffset();
        IElementType type = node != null ? node.getElementType() : null;
        TextRange elementRange = element.getTextRange();
        if (type == SqlTokens.SQL_IDENT_DELIMITED && offset == elementRange.getStartOffset()) {
            context.setReplacementOffset(elementRange.getEndOffset());
        }
        if (type == SqlTokens.SQL_IDENT_DELIMITED && offset != elementRange.getStartOffset()) {
            context.getOffsetMap().addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, elementRange.getEndOffset() - 1);
            context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, elementRange.getEndOffset() - 1);
        }
    }

    private static LookupElementDecorator<LookupElement> prefix(LookupElement lookupElement, final String prefix) {
        return LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, (InsertHandler)new InsertHandler<LookupElementDecorator<LookupElement>>(){

            public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
                context.getDocument().insertString(context.getStartOffset(), (CharSequence)prefix);
            }
        });
    }

    @NotNull
    private static String calcQualifier(@NotNull DasTable table, @NotNull List<SqlAsExpression> asExpressions, @NotNull SqlLanguageDialect dialect) {
        if (table == null) {
            SqlCompletionContributor.$$$reportNull$$$0(5);
        }
        if (asExpressions == null) {
            SqlCompletionContributor.$$$reportNull$$$0(6);
        }
        if (dialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(7);
        }
        for (SqlAsExpression asExpression : asExpressions) {
            SqlExpression expression = asExpression.getExpression();
            DasTable element = SqlCompletionContributor.retrieveTable((PsiElement)expression);
            if (element == null || !SqlCompletionContributor.areTablesEqual(table, element)) continue;
            String name = asExpression.getName();
            if (name == null) break;
            String string = name;
            if (string == null) {
                SqlCompletionContributor.$$$reportNull$$$0(8);
            }
            return string;
        }
        DatabaseDialect databaseDialect = dialect.getDatabaseDialect();
        String string = databaseDialect.quoteIdentifier(table.getName(), false, !DbSqlUtil.isQuoted((DasObject)table));
        if (string == null) {
            SqlCompletionContributor.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static boolean areTablesEqual(@NotNull DasTable t1, @NotNull DasTable t2) {
        if (t1 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(10);
        }
        if (t2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(11);
        }
        return Comparing.equal((String)t1.getName(), (String)t2.getName(), (boolean)false) && Comparing.equal((String)DasUtil.getSchema((DasObject)t1), (String)DasUtil.getSchema((DasObject)t2), (boolean)false) && Comparing.equal((String)DasUtil.getCatalog((DasObject)t1), (String)DasUtil.getCatalog((DasObject)t2), (boolean)false);
    }

    public static boolean areColumnsConnected(@NotNull DasColumn c1, @NotNull DasColumn c2) {
        String n2;
        String n1;
        DasTable t2;
        DasTable t1;
        if (c1 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(12);
        }
        if (c2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(13);
        }
        return SqlCompletionContributor.isInFk(t1 = c1.getTable(), t2 = c2.getTable(), n1 = c1.getName(), n2 = c2.getName()) || SqlCompletionContributor.isInFk(t2, t1, n2, n1);
    }

    private static boolean isInFk(@Nullable DasTable t1, @Nullable DasTable t2, @Nullable String n1, @Nullable String n2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        for (DasForeignKey fk : DasUtil.getForeignKeys((DasTable)t1)) {
            if (!Comparing.equal((String)fk.getRefTableName(), (String)t2.getName(), (boolean)false)) continue;
            Iterator it1 = fk.getColumnsRef().names().iterator();
            Iterator it2 = fk.getRefColumns().names().iterator();
            while (it1.hasNext() && it2.hasNext()) {
                if (!Comparing.equal((String)n2, (String)((String)it2.next()), (boolean)false) || !Comparing.equal((String)n1, (String)((String)it1.next()), (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Collection<String> suggestAliasName(@NotNull SqlExpression expression) {
        if (expression == null) {
            SqlCompletionContributor.$$$reportNull$$$0(14);
        }
        Collection<String> collection = SqlCompletionContributor.suggestAliasName((PsiElement)expression, SqlCompletionContributor.collectExistingNames((PsiElement)expression), SqlCompletionContributor.getWords(expression));
        if (collection == null) {
            SqlCompletionContributor.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> suggestAliasName(@NotNull PsiElement element, @NotNull Collection<String> existingNames, @NotNull String words) {
        if (element == null) {
            SqlCompletionContributor.$$$reportNull$$$0(16);
        }
        if (existingNames == null) {
            SqlCompletionContributor.$$$reportNull$$$0(17);
        }
        if (words == null) {
            SqlCompletionContributor.$$$reportNull$$$0(18);
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element);
        Project project = element.getProject();
        THashSet result2 = new THashSet();
        NamesGenerator generator = new NamesGenerator(existingNames, dialect.getKeywords());
        SqlCompletionContributor.appendSuggestions((Set<String>)result2, words, generator);
        Case idCase = SqlCompletionContributor.getDefaultCase(SqlCompletionUtil.getAliasCase(project));
        Case qidCase = SqlCompletionContributor.getDefaultCase(SqlCompletionUtil.getQuotedIdentifierCase(project));
        SqlCodeStyleSettings settings = SqlCompletionUtil.settings(project);
        boolean force = settings != null && settings.QUOTE_IDENTIFIER == 0;
        boolean suppress = true;
        List list = ContainerUtil.map((Collection)result2, s -> SqlCompletionContributor.quoteIdentifierIfNeeded(s, dialect.getDatabaseDialect(), idCase, qidCase, force, true));
        if (list == null) {
            SqlCompletionContributor.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private static String getWords(@NotNull SqlExpression expression) {
        if (expression == null) {
            SqlCompletionContributor.$$$reportNull$$$0(20);
        }
        LinkedList<Object> stack = new LinkedList<Object>();
        StringBuilder sb = new StringBuilder();
        stack.push(expression);
        while (!stack.isEmpty()) {
            SqlExpression fromExpression;
            SqlFromClause fromClause;
            SqlExpression expr = (SqlExpression)stack.pop();
            if (expr instanceof SqlReferenceExpression) {
                String text2;
                SqlIdentifier identifier = ((SqlReferenceExpression)expr).getIdentifier();
                String string = text2 = identifier != null ? identifier.getName() : expr.getText();
                if (!"*".equals(text2)) {
                    if (sb.length() > 0) {
                        sb.append("_");
                    }
                    sb.append(text2);
                }
            }
            if (expr instanceof SqlAsExpression) {
                if (sb.length() > 0) {
                    sb.append("_");
                }
                sb.append(expr.getName());
                continue;
            }
            if (expr instanceof SqlParenthesizedExpression) {
                SqlExpression item = (SqlExpression)ContainerUtil.getFirstItem((List)((SqlParenthesizedExpression)expr).getExpressionList());
                if (item == null) continue;
                stack.push(item);
                continue;
            }
            if (expr instanceof SqlBinaryExpression) {
                SqlExpression l = ((SqlBinaryExpression)expr).getLOperand();
                SqlExpression r = ((SqlBinaryExpression)expr).getROperand();
                if (r != null) {
                    stack.push(r);
                }
                stack.push(l);
                continue;
            }
            if (!(expr instanceof SqlQueryExpression)) continue;
            SqlQueryExpression query = (SqlQueryExpression)expr;
            SqlSelectClause selectClause = query.getSelectClause();
            SqlTableExpression tableExpression = query.getTableExpression();
            SqlFromClause sqlFromClause = fromClause = tableExpression == null ? null : tableExpression.getFromClause();
            if (selectClause != null) {
                List expressions = selectClause.getExpressions();
                ListIterator it = expressions.listIterator(expressions.size());
                while (it.hasPrevious()) {
                    stack.push(it.previous());
                }
            }
            if ((fromExpression = fromClause != null ? fromClause.getFromExpression() : null) == null) continue;
            stack.push(fromExpression);
        }
        String string = sb.toString();
        if (string == null) {
            SqlCompletionContributor.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static Case getDefaultCase(@NotNull Case c) {
        if (c == null) {
            SqlCompletionContributor.$$$reportNull$$$0(22);
        }
        Case case_ = c == Case.EXACT ? Case.LOWER : c;
        if (case_ == null) {
            SqlCompletionContributor.$$$reportNull$$$0(23);
        }
        return case_;
    }

    @NotNull
    private static String quoteIdentifierIfNeeded(@NotNull String id, @NotNull DatabaseDialect dialect, @NotNull Case idCase, @NotNull Case qidCase, boolean force, boolean suppress) {
        if (id == null) {
            SqlCompletionContributor.$$$reportNull$$$0(24);
        }
        if (dialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(25);
        }
        if (idCase == null) {
            SqlCompletionContributor.$$$reportNull$$$0(26);
        }
        if (qidCase == null) {
            SqlCompletionContributor.$$$reportNull$$$0(27);
        }
        if (!dialect.isQuotedIdentifier(id)) {
            id = dialect.quoteIdentifier(id, force, suppress);
        }
        Case curCase = dialect.isQuotedIdentifier(id) ? qidCase : idCase;
        String string = curCase.apply(id);
        if (string == null) {
            SqlCompletionContributor.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static Collection<String> collectExistingNames(@Nullable PsiElement expression) {
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)expression, SqlStatement.class);
        final THashSet strings = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        if (statement == null) {
            THashSet tHashSet = strings;
            if (tHashSet == null) {
                SqlCompletionContributor.$$$reportNull$$$0(29);
            }
            return tHashSet;
        }
        statement.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiNamedElement) {
                    ContainerUtil.addIfNotNull((Collection)strings, (Object)((PsiNamedElement)element).getName());
                    super.visitElement(element);
                } else if (element instanceof SqlNameElement) {
                    ContainerUtil.addIfNotNull((Collection)strings, (Object)((SqlNameElement)element).getName());
                } else {
                    super.visitElement(element);
                }
            }
        });
        THashSet tHashSet = strings;
        if (tHashSet == null) {
            SqlCompletionContributor.$$$reportNull$$$0(30);
        }
        return tHashSet;
    }

    private static void appendSuggestions(Set<String> result2, String text2, NamesGenerator generator) {
        String[] words = NameUtil.splitNameIntoWords((String)text2);
        if (words.length > 0) {
            result2.add(generator.generate(words[0].substring(0, 1)));
            if (words.length > 1) {
                String abbreviation = "";
                String lastWord = null;
                for (String word : words) {
                    int i2;
                    for (i2 = 1; i2 < word.length() && !Character.isLetter(word.charAt(i2 - 1)) && word.charAt(i2 - 1) != '.'; ++i2) {
                    }
                    abbreviation = abbreviation + word.substring(0, i2);
                    if (!Character.isLetter(word.charAt(0))) continue;
                    lastWord = word;
                }
                result2.add(generator.generate(abbreviation));
                if (lastWord != null && lastWord != words[0]) {
                    result2.add(generator.generate(lastWord.substring(0, 1)));
                    result2.add(generator.generate((String)ObjectUtils.chooseNotNull((Object)StringUtil.unpluralize((String)lastWord), (Object)lastWord)));
                }
            }
        }
    }

    private static void suggestTableColumnListAtOnce(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx dialect, @NotNull CompletionResultSet result2) {
        SqlTableColumnsList columnsList;
        if (position == null) {
            SqlCompletionContributor.$$$reportNull$$$0(31);
        }
        if (dialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(32);
        }
        if (result2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(33);
        }
        if ((columnsList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)position, SqlTableColumnsList.class)) == null) {
            return;
        }
        SqlReferenceExpression tableReference = columnsList.getTableReference();
        DasTable resolve = SqlCompletionContributor.retrieveTable((PsiElement)tableReference);
        if (resolve == null) {
            return;
        }
        List<SqlReferenceExpression> colRefs = SqlImplUtil.getReferenceList(columnsList);
        if (colRefs.size() > 1) {
            return;
        }
        Condition notAuto = info -> !DasUtil.isAuto((DasColumn)info);
        Condition notComputed = info -> !DasUtil.isComputed((DasColumn)info);
        Condition noDefault = info -> StringUtil.isEmpty((String)info.getDefault());
        JBIterable columns2 = DasUtil.getColumns((DasObject)resolve);
        if (dialect.getFamilyId().isMysql()) {
            SqlCompletionContributor.processMultiColumnVariants(dialect.getDatabaseDialect(), result2, columns2.filter(notComputed).toList(), columns2.filter(notAuto).toList(), columns2.filter(notAuto).filter(noDefault).toList());
        } else {
            SqlCompletionContributor.processMultiColumnVariants(dialect.getDatabaseDialect(), result2, columns2.filter(notAuto).toList(), columns2.filter(notAuto).filter(noDefault).toList());
        }
    }

    private static void processMultiColumnVariants(@NotNull DatabaseDialectEx dialect, @NotNull CompletionResultSet result2, List<? extends DasColumn> ... multiColumns) {
        if (dialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(34);
        }
        if (result2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(35);
        }
        LinkedHashSet sorted = ContainerUtil.newLinkedHashSet((Object[])multiColumns);
        sorted.forEach(c -> {
            if (dialect == null) {
                SqlCompletionContributor.$$$reportNull$$$0(84);
            }
            if (result2 == null) {
                SqlCompletionContributor.$$$reportNull$$$0(85);
            }
            SqlCompletionContributor.processColumns(dialect, c, result2);
        });
    }

    private static void processColumns(@NotNull DatabaseDialectEx dialect, @NotNull Iterable<? extends DasColumn> columns2, @NotNull CompletionResultSet result2) {
        if (dialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(36);
        }
        if (columns2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(37);
        }
        if (result2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(38);
        }
        if (Iterables.size(columns2) <= 1) {
            return;
        }
        LookupElement all = SqlCompletionContributor.createAllColumnsLookupElement(columns2, dialect);
        if (all != null) {
            result2.addElement(all);
        }
    }

    @Nullable
    private static LookupElement createAllColumnsLookupElement(@NotNull Iterable<? extends DasColumn> columns2, @NotNull DatabaseDialectEx dialect) {
        if (columns2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(39);
        }
        if (dialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(40);
        }
        DdlBuilder classic = new DdlBuilder().withDialect(dialect);
        boolean first = true;
        for (DasColumn dasColumn : columns2) {
            if (first) {
                first = false;
            } else {
                classic.symbol(",").space();
            }
            classic.suppressQuoteIdentifiers(!DbSqlUtil.isQuoted((DasObject)dasColumn));
            classic.columnRef(dasColumn.getName());
        }
        String statement = classic.getStatement();
        if (statement.isEmpty()) {
            return null;
        }
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)statement).withIcon(DatabaseIcons.Col).withInsertHandler((InsertHandler)new BasicInsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                if (context.getCompletionChar() != ')') {
                    Editor editor = context.getEditor();
                    Document document = editor.getDocument();
                    context.commitDocument();
                    int offset = context.getTailOffset();
                    PsiElement at = context.getFile().findElementAt(offset > 1 ? offset - 1 : offset);
                    SqlTableColumnsList tcl = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)at, SqlTableColumnsList.class);
                    SqlValuesExpression values = (SqlValuesExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)tcl, SqlValuesExpression.class);
                    if (values != null) {
                        return;
                    }
                    SqlReferenceList list = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)at, SqlReferenceList.class);
                    if (list != null) {
                        ASTNode right = list.getNode().findChildByType((IElementType)SqlTokens.SQL_RIGHT_PAREN);
                        String what = right == null ? ") " : " ";
                        int where = right == null ? offset : right.getStartOffset() + 1;
                        document.insertString(where, (CharSequence)what);
                        editor.getCaretModel().moveToOffset(where + what.length());
                        AutoPopupController.getInstance((Project)at.getProject()).autoPopupMemberLookup(editor, null);
                    }
                }
            }
        }), (double)100.0);
    }

    @NotNull
    private static Collection<TableInfo> collectTablesForJoin(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx dialect) {
        SqlJoinExpression join;
        if (position == null) {
            SqlCompletionContributor.$$$reportNull$$$0(41);
        }
        if (dialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(42);
        }
        if ((join = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlJoinExpression.class)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlCompletionContributor.$$$reportNull$$$0(43);
            }
            return list;
        }
        PsiElement parent = position.getParent();
        if (parent == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlCompletionContributor.$$$reportNull$$$0(44);
            }
            return list;
        }
        ASTNode joinNode = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)parent.getNode());
        if (joinNode == null || joinNode.getElementType() != SqlCommonKeywords.SQL_JOIN && joinNode.getElementType() != SqlTokens.SQL_COMMA) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlCompletionContributor.$$$reportNull$$$0(45);
            }
            return list;
        }
        if (!(parent instanceof SqlReferenceExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlCompletionContributor.$$$reportNull$$$0(46);
            }
            return list;
        }
        PsiReference reference = parent.getReference();
        if (!(reference instanceof SqlReferenceImpl)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlCompletionContributor.$$$reportNull$$$0(47);
            }
            return list;
        }
        final HashSet fromLeft = ContainerUtil.newHashSet();
        SqlJoinExpression topmost = (SqlJoinExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)join, SqlJoinExpression.class);
        final SqlJoinExpression mainJoin = topmost == null ? join : topmost;
        mainJoin.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                ContainerUtil.addAllNotNull((Collection)fromLeft, (Object[])new DasTable[]{SqlCompletionContributor.retrieveTable(element)});
                super.visitElement(element);
            }
        });
        final HashSet fks = ContainerUtil.newHashSet();
        for (DasTable table : fromLeft) {
            Iterables.addAll((Collection)fks, (Iterable)DasUtil.getForeignKeys((DasTable)table));
        }
        final ArrayList result2 = ContainerUtil.newArrayList();
        ((SqlReferenceImpl)reference).processResolveVariants(new SqlScopeProcessor(null, dialect, SqlImplUtil.getDataSources(parent), parent){

            @Override
            public boolean isResultEmpty() {
                return false;
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (element == null) {
                    11.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    11.$$$reportNull$$$0(1);
                }
                if (element instanceof DasTable) {
                    this.addLookupElement((DasTable)element);
                }
                return true;
            }

            private void addLookupElement(@NotNull DasTable table) {
                if (table == null) {
                    11.$$$reportNull$$$0(2);
                }
                for (DasForeignKey fk : fks) {
                    if (!SqlCompletionContributor.cheapEquals(table, fk) || !table.equals(fk.getRefTable())) continue;
                    result2.add(new TableInfo(table, ObjectName.plain((String)this.suggestAlias(table, (PsiElement)mainJoin)), null));
                    return;
                }
                for (DasForeignKey fk : DasUtil.getForeignKeys((DasTable)table)) {
                    DasTable info = (DasTable)ContainerUtil.find((Iterable)fromLeft, info1 -> SqlCompletionContributor.cheapEquals(info1, fk));
                    if (info == null || !fromLeft.contains(fk.getRefTable())) continue;
                    result2.add(new TableInfo(table, ObjectName.plain((String)this.suggestAlias(table, (PsiElement)mainJoin)), null));
                    return;
                }
            }

            @Nullable
            private String suggestAlias(@NotNull DasTable table, @NotNull PsiElement element) {
                if (table == null) {
                    11.$$$reportNull$$$0(3);
                }
                if (element == null) {
                    11.$$$reportNull$$$0(4);
                }
                String tableName = table.getName();
                Collection existingNames = SqlCompletionContributor.collectExistingNames(element);
                existingNames.add(tableName);
                return (String)ContainerUtil.getFirstItem(SqlCompletionContributor.suggestAliasName(element, existingNames, tableName));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/completion/SqlCompletionContributor$11";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "executeTarget";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addLookupElement";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "suggestAlias";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SqlCompletionContributor.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    public static boolean cheapEquals(@NotNull DasTable table, @NotNull DasForeignKey fk) {
        if (table == null) {
            SqlCompletionContributor.$$$reportNull$$$0(49);
        }
        if (fk == null) {
            SqlCompletionContributor.$$$reportNull$$$0(50);
        }
        return !(!Comparing.strEqual((String)table.getName(), (String)fk.getRefTableName(), (boolean)false) || !StringUtil.isEmpty((String)DasUtil.getSchema((DasObject)table)) && !StringUtil.isEmpty((String)fk.getRefTableSchema()) && !Comparing.strEqual((String)DasUtil.getSchema((DasObject)table), (String)fk.getRefTableSchema(), (boolean)false) || !StringUtil.isEmpty((String)DasUtil.getCatalog((DasObject)table)) && !StringUtil.isEmpty((String)fk.getRefTableCatalog()) && !Comparing.strEqual((String)DasUtil.getCatalog((DasObject)table), (String)fk.getRefTableCatalog(), (boolean)false));
    }

    private static void suggestJoinConditions(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull Collection<TableInfo> right, @NotNull CompletionResultSet result2) {
        boolean appendTable;
        PsiElement parent;
        if (position == null) {
            SqlCompletionContributor.$$$reportNull$$$0(51);
        }
        if (sqlDialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(52);
        }
        if (right == null) {
            SqlCompletionContributor.$$$reportNull$$$0(53);
        }
        if (result2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(54);
        }
        if ((parent = position.getParent()) == null) {
            return;
        }
        ASTNode sibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)parent.getNode());
        IElementType type = sibling == null ? null : sibling.getElementType();
        boolean appendCondition = type == SqlCommonKeywords.SQL_ON;
        boolean bl = appendTable = type == SqlCommonKeywords.SQL_JOIN;
        if (!appendCondition && !appendTable) {
            return;
        }
        SqlJoinExpression join = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlJoinExpression.class);
        if (join == null) {
            return;
        }
        LinkedHashSet left = ContainerUtil.newLinkedHashSet();
        SqlCompletionContributor.collectTables(join.getLOperand(), left);
        if (!appendTable) {
            SqlCompletionContributor.collectTables(join.getROperand(), right);
        }
        Project project = position.getProject();
        SqlCompletionContributor.processTables(project, left, right, sqlDialect, result2, join.getLOperand());
    }

    private static void suggestJoinUsing(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull CompletionResultSet result2) {
        String name;
        int i2;
        SqlUsingClause using;
        SqlJoinExpression join;
        if (position == null) {
            SqlCompletionContributor.$$$reportNull$$$0(55);
        }
        if (sqlDialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(56);
        }
        if (result2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(57);
        }
        SqlJoinExpression sqlJoinExpression = join = (using = (SqlUsingClause)PsiTreeUtil.getParentOfType((PsiElement)position, SqlUsingClause.class)) == null ? null : (SqlJoinExpression)ObjectUtils.tryCast((Object)using.getParent(), SqlJoinExpression.class);
        if (join == null) {
            return;
        }
        SqlReferenceList refs = using.getReferenceList();
        if (refs == null || !PsiTreeUtil.isContextAncestor((PsiElement)refs, (PsiElement)position, (boolean)false)) {
            return;
        }
        SqlExpression right = join.getROperand();
        SqlTableType ltype = (SqlTableType)ObjectUtils.tryCast((Object)join.getLOperand().getSqlType(), SqlTableType.class);
        SqlTableType rtype = (SqlTableType)ObjectUtils.tryCast((Object)(right == null ? null : right.getSqlType()), SqlTableType.class);
        if (ltype == null || rtype == null) {
            return;
        }
        Set lnames = DasUtil.newCaseAwareSet((boolean)false);
        Set rnames = DasUtil.newCaseAwareSet((boolean)false);
        HashSet exluded = ContainerUtil.newHashSet();
        HashMap toColumn = ContainerUtil.newHashMap();
        for (i2 = 0; i2 < ltype.getColumnCount(); ++i2) {
            name = ltype.getColumnName(i2);
            toColumn.put(name, ltype.getColumnElement(i2));
            if (lnames.add(name)) continue;
            exluded.add(name);
        }
        for (i2 = 0; i2 < rtype.getColumnCount(); ++i2) {
            name = rtype.getColumnName(i2);
            if (rnames.add(name)) continue;
            exluded.add(name);
        }
        ArrayList usingCandidates = ContainerUtil.newArrayList();
        for (int i3 = 0; i3 < ltype.getColumnCount(); ++i3) {
            String name2 = ltype.getColumnName(i3);
            if (!rnames.contains(name2) || exluded.contains(name2)) continue;
            usingCandidates.add(name2);
        }
        if (usingCandidates.size() >= 2 || refs.getReferenceList().size() > 1) {
            DdlBuilder builder = new DdlBuilder().withDialect(sqlDialect.getDatabaseDialect()).applyCodeStyle(position.getProject());
            for (String candidate : usingCandidates) {
                if (!builder.isEmpty()) {
                    builder.symbol(", ");
                }
                builder.columnRef(candidate);
            }
            result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)builder.getStatement()).withIcon(DatabaseIcons.ColBlueKey), (double)90.0));
        }
        for (String candidate : usingCandidates) {
            SqlCompletionUtil.addLookupElement(sqlDialect, toColumn.get(candidate), null, (Consumer<LookupElement>)result2, false, 90.0, PsiTreeUtil.getParentOfType((PsiElement)position, SqlReferenceExpression.class));
        }
    }

    private static void collectTables(@Nullable SqlExpression e, @NotNull Collection<TableInfo> tables) {
        if (tables == null) {
            SqlCompletionContributor.$$$reportNull$$$0(58);
        }
        if (e instanceof SqlJoinExpression) {
            SqlCompletionContributor.collectTables(((SqlJoinExpression)e).getLOperand(), tables);
            SqlCompletionContributor.collectTables(((SqlJoinExpression)e).getROperand(), tables);
            return;
        }
        ContainerUtil.addAllNotNull(tables, (Object[])new TableInfo[]{SqlCompletionContributor.retrieveTable(e)});
    }

    private static TableInfo retrieveTable(@Nullable SqlExpression o) {
        SqlAsExpression asExpr = (SqlAsExpression)ObjectUtils.tryCast((Object)o, SqlAsExpression.class);
        return asExpr != null ? SqlCompletionContributor.retrieveTable(asExpr.getExpression(), DbSqlUtil.getName((DasObject)asExpr)) : SqlCompletionContributor.retrieveTable(o, null);
    }

    @Nullable
    private static TableInfo retrieveTable(@Nullable SqlExpression place, @Nullable ObjectName alias) {
        DasTable table = SqlCompletionContributor.retrieveTable((PsiElement)place);
        return table == null ? null : new TableInfo(table, alias, place);
    }

    @Nullable
    private static DasTable retrieveTable(@Nullable PsiElement e) {
        ObjectKind kind;
        if (e instanceof SqlReferenceExpression && (kind = ((SqlReferenceExpression)e).getReferenceElementType().getTargetKind()) == ObjectKind.TABLE) {
            for (ResolveResult result2 : ((SqlReferenceExpression)e).multiResolve(true)) {
                if (!result2.isValidResult() || !(result2.getElement() instanceof DasTable)) continue;
                return (DasTable)result2.getElement();
            }
        }
        return null;
    }

    private static void processTables(@NotNull Project project, @NotNull Collection<TableInfo> left, @NotNull Collection<TableInfo> right, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull CompletionResultSet result2, @Nullable SqlExpression lOperand) {
        if (project == null) {
            SqlCompletionContributor.$$$reportNull$$$0(59);
        }
        if (left == null) {
            SqlCompletionContributor.$$$reportNull$$$0(60);
        }
        if (right == null) {
            SqlCompletionContributor.$$$reportNull$$$0(61);
        }
        if (sqlDialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(62);
        }
        if (result2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(63);
        }
        for (TableInfo r : right) {
            for (TableInfo l : left) {
                SqlCompletionContributor.processForeignKeys(project, sqlDialect, r, l, result2, lOperand);
                SqlCompletionContributor.processForeignKeys(project, sqlDialect, l, r, result2, lOperand);
            }
        }
    }

    private static void processForeignKeys(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull TableInfo first, @NotNull TableInfo second, @NotNull CompletionResultSet result2, @Nullable SqlExpression lOperand) {
        if (project == null) {
            SqlCompletionContributor.$$$reportNull$$$0(64);
        }
        if (sqlDialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(65);
        }
        if (first == null) {
            SqlCompletionContributor.$$$reportNull$$$0(66);
        }
        if (second == null) {
            SqlCompletionContributor.$$$reportNull$$$0(67);
        }
        if (result2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(68);
        }
        for (String s : SqlCompletionContributor.foreignKeyStatements(project, sqlDialect, first, second, lOperand)) {
            result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)s).withIcon(DatabaseIcons.ColBlueKey), (double)91.0));
        }
    }

    private static Iterable<String> foreignKeyStatements(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull TableInfo firstTable, @NotNull TableInfo secondTable, @Nullable SqlExpression lOperand) {
        if (project == null) {
            SqlCompletionContributor.$$$reportNull$$$0(69);
        }
        if (sqlDialect == null) {
            SqlCompletionContributor.$$$reportNull$$$0(70);
        }
        if (firstTable == null) {
            SqlCompletionContributor.$$$reportNull$$$0(71);
        }
        if (secondTable == null) {
            SqlCompletionContributor.$$$reportNull$$$0(72);
        }
        DatabaseDialectEx dialect = sqlDialect.getDatabaseDialect();
        boolean ancestor = secondTable.place != null && PsiTreeUtil.isContextAncestor((PsiElement)lOperand, (PsiElement)secondTable.place, (boolean)false);
        ArrayList result2 = ContainerUtil.newArrayList();
        for (DasForeignKey key2 : DasUtil.getForeignKeys((DasTable)secondTable.table)) {
            if (!firstTable.table.equals(key2.getRefTable())) continue;
            MultiRef cols = key2.getColumnsRef();
            MultiRef refCols = key2.getRefColumns();
            if (cols.size() != refCols.size()) continue;
            DdlBuilder builder = new DdlBuilder().withDialect(dialect).applyCodeStyle(project);
            if (firstTable.place == null) {
                SqlCompletionContributor.appendTableReference(builder, firstTable);
            } else if (secondTable.place == null) {
                SqlCompletionContributor.appendTableReference(builder, secondTable);
            }
            boolean first = true;
            Iterator<ObjectName> refIt = SqlCompletionContributor.iterateNames((MultiRef<? extends DasObject>)refCols);
            for (ObjectName name : JBIterable.once(SqlCompletionContributor.iterateNames((MultiRef<? extends DasObject>)cols))) {
                if (first) {
                    first = false;
                } else {
                    builder.space().keyword("and").space();
                }
                ObjectName refName = refIt.next();
                Runnable leftPart = () -> {
                    if (secondTable == null) {
                        SqlCompletionContributor.$$$reportNull$$$0(83);
                    }
                    SqlCompletionContributor.appendJoinPart(name, secondTable, key2.getTable(), builder);
                };
                Runnable rightPart = () -> {
                    if (firstTable == null) {
                        SqlCompletionContributor.$$$reportNull$$$0(82);
                    }
                    SqlCompletionContributor.appendJoinPart(refName, firstTable, key2.getRefTable(), builder);
                };
                (ancestor ? leftPart : rightPart).run();
                builder.space().symbol("=").space();
                (ancestor ? rightPart : leftPart).run();
            }
            result2.add(builder.getStatement());
        }
        return result2;
    }

    private static Iterator<ObjectName> iterateNames(MultiRef<? extends DasObject> ref) {
        final MultiRef.It it = ref.iterate();
        return new JBIterator<ObjectName>(){

            protected ObjectName nextImpl() {
                if (!it.hasNext()) {
                    return (ObjectName)this.stop();
                }
                String name = (String)it.next();
                DasObject obj = (DasObject)it.resolve();
                return obj == null ? ObjectName.plain((String)name) : DbSqlUtil.getName(obj);
            }
        };
    }

    private static void appendTableReference(@NotNull DdlBuilder builder, @NotNull TableInfo info) {
        if (builder == null) {
            SqlCompletionContributor.$$$reportNull$$$0(73);
        }
        if (info == null) {
            SqlCompletionContributor.$$$reportNull$$$0(74);
        }
        builder.identifier((DasObject)info.table).space();
        if (info.alias != null) {
            builder.identifier(info.alias, ObjectKind.TABLE).space();
        }
        builder.keyword("on").space();
    }

    private static void appendJoinPart(@NotNull ObjectName columnName, @NotNull TableInfo info, @NotNull DasTable relatedTable, @NotNull DdlBuilder builder) {
        if (columnName == null) {
            SqlCompletionContributor.$$$reportNull$$$0(75);
        }
        if (info == null) {
            SqlCompletionContributor.$$$reportNull$$$0(76);
        }
        if (relatedTable == null) {
            SqlCompletionContributor.$$$reportNull$$$0(77);
        }
        if (builder == null) {
            SqlCompletionContributor.$$$reportNull$$$0(78);
        }
        (info.alias == null ? builder.identifier((DasObject)relatedTable) : builder.identifier(info.alias, ObjectKind.TABLE)).symbol(".").identifier(columnName, ObjectKind.COLUMN);
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        DatabaseDialectEx dialect;
        char quote;
        if (parameters == null) {
            SqlCompletionContributor.$$$reportNull$$$0(79);
        }
        if (result2 == null) {
            SqlCompletionContributor.$$$reportNull$$$0(80);
        }
        if (SqlCompletionUtil.isNumericLiteral(parameters)) {
            return;
        }
        SqlPrefixedElement prefixed = (SqlPrefixedElement)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), SqlPrefixedElement.class, (boolean)false);
        String prefix = StringUtil.notNullize((String)(prefixed == null ? null : prefixed.getNamePrefix()));
        String searchPrefix = result2.getPrefixMatcher().getPrefix();
        if (searchPrefix.length() > prefix.length() && ((quote = searchPrefix.charAt(prefix.length())) == (dialect = SqlImplUtil.getSqlDialectSafe(parameters.getPosition()).getDatabaseDialect()).openQuote() || quote == '\"')) {
            result2 = result2.withPrefixMatcher(prefix + result2.getPrefixMatcher().getPrefix().substring(prefix.length() + 1));
        }
        super.fillCompletionVariants(parameters, result2);
    }

    public static boolean isTableFunctionCallRef(@NotNull PsiElement expr) {
        PsiElement parent;
        if (expr == null) {
            SqlCompletionContributor.$$$reportNull$$$0(81);
        }
        return (parent = expr.getParent()) instanceof SqlFunctionCallExpression && parent.getParent() instanceof SqlFunctionCallTableExpressionImpl || parent instanceof SqlQueryExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 33: 
            case 35: 
            case 38: 
            case 54: 
            case 57: 
            case 63: 
            case 68: 
            case 80: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asExpressions";
                break;
            }
            case 7: 
            case 25: 
            case 32: 
            case 34: 
            case 36: 
            case 40: 
            case 42: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/SqlCompletionContributor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idCase";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qidCase";
                break;
            }
            case 31: 
            case 41: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fk";
                break;
            }
            case 52: 
            case 56: 
            case 62: 
            case 65: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlDialect";
                break;
            }
            case 53: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 59: 
            case 64: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 71: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstTable";
                break;
            }
            case 72: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondTable";
                break;
            }
            case 73: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedTable";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/SqlCompletionContributor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcQualifier";
                break;
            }
            case 15: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestAliasName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getWords";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCase";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteIdentifierIfNeeded";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExistingNames";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTablesForJoin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinStuff";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tuneReplacementOffset";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcQualifier";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "areTablesEqual";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "areColumnsConnected";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "suggestAliasName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getWords";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCase";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifierIfNeeded";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "suggestTableColumnListAtOnce";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processMultiColumnVariants";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processColumns";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createAllColumnsLookupElement";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "collectTablesForJoin";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "cheapEquals";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinConditions";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "suggestJoinUsing";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "collectTables";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processTables";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "processForeignKeys";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "foreignKeyStatements";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "appendTableReference";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "appendJoinPart";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isTableFunctionCallRef";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "lambda$foreignKeyStatements$6";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "lambda$foreignKeyStatements$5";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMultiColumnVariants$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NamesGenerator {
        private final Collection<String> myExistingNames;
        private final Set<String> myKeywords;

        NamesGenerator(@NotNull Collection<String> existingNames, @NotNull Set<String> keywords) {
            if (existingNames == null) {
                NamesGenerator.$$$reportNull$$$0(0);
            }
            if (keywords == null) {
                NamesGenerator.$$$reportNull$$$0(1);
            }
            this.myExistingNames = existingNames;
            this.myKeywords = keywords;
        }

        String generate(@NotNull String name) {
            if (name == null) {
                NamesGenerator.$$$reportNull$$$0(2);
            }
            String generated = UniqueNameGenerator.generateUniqueName((String)name, s -> !this.myExistingNames.contains(s) && !this.myKeywords.contains(s));
            ContainerUtil.addAllNotNull(this.myExistingNames, (Object[])new String[]{generated});
            return generated;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keywords";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/completion/SqlCompletionContributor$NamesGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TableInfo {
        final DasTable table;
        final ObjectName alias;
        final SqlExpression place;

        TableInfo(@NotNull DasTable table, @Nullable ObjectName alias, @Nullable SqlExpression place) {
            if (table == null) {
                TableInfo.$$$reportNull$$$0(0);
            }
            this.table = table;
            this.alias = alias;
            this.place = place;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/sql/completion/SqlCompletionContributor$TableInfo", "<init>"));
        }
    }
}

