/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImportState {
    public final SqlImportState prevState;
    public final Shared shared;
    public final PsiElement element;
    public final TreePattern state;
    private static final TreePatternNode FAKE_NODE = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(new ObjectName("FAKEFAKEFAKEFAKEFAKEFAKE", true)), TreePatternNode.NO_GROUPS);

    public SqlImportState(@Nullable PsiElement element, @NotNull Shared shared, @NotNull TreePattern state, @Nullable SqlImportState prevState) {
        if (shared == null) {
            SqlImportState.$$$reportNull$$$0(0);
        }
        if (state == null) {
            SqlImportState.$$$reportNull$$$0(1);
        }
        this.element = element;
        this.shared = shared;
        this.state = state;
        this.prevState = prevState;
    }

    public boolean isImported(@Nullable DbDataSource dataSource, @Nullable SqlDialectImplUtil.ObjectTracer<?> tracer) {
        List kinds = ContainerUtil.newSmartList();
        List names = ContainerUtil.newSmartList();
        SqlImportState.getPartialTrace(tracer, kinds, names);
        kinds.add(SqlImportUtil.DATA_SOURCE);
        names.add(dataSource == null ? null : SqlImportUtil.getDataSourceName((DatabaseSystem)dataSource));
        DasModel casingProvider = dataSource != null ? dataSource.getModel() : this.shared.file;
        return this.shared.overlay != null && SqlImportState.isImported(this.shared.overlay, kinds, names, (CasingProvider)casingProvider) || SqlImportState.isImported(this.state, kinds, names, (CasingProvider)casingProvider);
    }

    private static boolean isImported(@NotNull TreePattern state, @NotNull List<ObjectKind> kinds, @NotNull List<ObjectName> names, @NotNull CasingProvider casingProvider) {
        if (state == null) {
            SqlImportState.$$$reportNull$$$0(2);
        }
        if (kinds == null) {
            SqlImportState.$$$reportNull$$$0(3);
        }
        if (names == null) {
            SqlImportState.$$$reportNull$$$0(4);
        }
        if (casingProvider == null) {
            SqlImportState.$$$reportNull$$$0(5);
        }
        TIntArrayList depth = new TIntArrayList();
        ArrayList nodes2 = ContainerUtil.newArrayList();
        nodes2.add(state.root);
        depth.add(kinds.size() - 1);
        while (!nodes2.isEmpty()) {
            TreePatternNode node = (TreePatternNode)nodes2.remove(nodes2.size() - 1);
            int d = depth.remove(depth.size() - 1);
            ObjectName name = names.get(d);
            ObjectKind kind = kinds.get(d);
            boolean found = node.matchedChildren(name == null || name.name.length() == 0 ? null : name, casingProvider.getCasing(kind, null), kind, nodes2);
            if (name != null && name.name.length() == 0 || name == null && kind == SqlImportUtil.DATA_SOURCE) {
                found = true;
                nodes2.add(FAKE_NODE);
            }
            if (d == 0) {
                nodes2.subList(depth.size(), nodes2.size()).clear();
                if (!found) continue;
                return true;
            }
            while (depth.size() < nodes2.size()) {
                depth.add(d - 1);
            }
        }
        return false;
    }

    public static void getPartialTrace(@Nullable SqlDialectImplUtil.ObjectTracer<?> tracer, @NotNull List<ObjectKind> kinds, @NotNull List names) {
        if (kinds == null) {
            SqlImportState.$$$reportNull$$$0(6);
        }
        if (names == null) {
            SqlImportState.$$$reportNull$$$0(7);
        }
        if (tracer != null) {
            SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<?> it = tracer.trace();
            while (it.hasNext()) {
                it.next();
                kinds.add(it.getKind());
                names.add(new ObjectName(it.getName(), it.isQuoted()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/SqlImportState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isImported";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getPartialTrace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Shared {
        public final SqlFile file;
        public final TreePattern overlay;

        public Shared(@NotNull SqlFile file, @Nullable TreePattern overlay) {
            if (file == null) {
                Shared.$$$reportNull$$$0(0);
            }
            this.file = file;
            this.overlay = overlay;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/dialects/SqlImportState$Shared", "<init>"));
        }
    }
}

