/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.model.constant;

import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.web.Filter;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.dom.struts.StrutsRoot;
import com.intellij.struts2.dom.struts.constant.Constant;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.model.constant.StrutsConstant;
import com.intellij.struts2.model.constant.StrutsConstantKey;
import com.intellij.struts2.model.constant.StrutsConstantManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.impl.ConvertContextFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsConstantManagerImpl
extends StrutsConstantManager {
    @NonNls
    private static final String STRUTS_DEFAULT_PROPERTIES = "/org/apache/struts2/default.properties";
    @NonNls
    private static final String STRUTS_PROPERTIES_FILENAME = "struts.properties";
    private static final Condition<Filter> WEB_XML_STRUTS_FILTER_CONDITION = filter -> {
        PsiClass filterClass = (PsiClass)filter.getFilterClass().getValue();
        return InheritanceUtil.isInheritor((PsiClass)filterClass, (String)"org.apache.struts2.dispatcher.FilterDispatcher") || InheritanceUtil.isInheritor((PsiClass)filterClass, (String)"org.apache.struts2.dispatcher.ng.filter.StrutsPrepareAndExecuteFilter");
    };

    @Override
    @NotNull
    public List<StrutsConstant> getConstants(@NotNull Module module) {
        if (module == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.concat((Object[])Extensions.getExtensions((ExtensionPointName)EP_NAME), contributor -> {
            if (module == null) {
                StrutsConstantManagerImpl.$$$reportNull$$$0(15);
            }
            if (!contributor.isAvailable(module)) {
                return Collections.emptyList();
            }
            return contributor.getStrutsConstantDefinitions(module);
        });
        if (list == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public <T> Converter<T> findConverter(@NotNull PsiElement context, @NotNull StrutsConstantKey<T> strutsConstantKey) {
        Module module;
        if (context == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(2);
        }
        if (strutsConstantKey == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) == null) {
            return null;
        }
        StrutsConstant strutsConstant = (StrutsConstant)ContainerUtil.find(this.getConstants(module), strutsConstant1 -> {
            if (strutsConstantKey == null) {
                StrutsConstantManagerImpl.$$$reportNull$$$0(14);
            }
            return Comparing.equal((String)strutsConstant1.getName(), (String)strutsConstantKey.getKey());
        });
        return strutsConstant != null ? strutsConstant.getConverter() : null;
    }

    @Override
    @Nullable
    public <T> T getConvertedValue(@NotNull PsiElement context, @NotNull StrutsConstantKey<T> strutsConstantKey) {
        PsiFile containingFile;
        StrutsModel strutsModel;
        if (context == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(4);
        }
        if (strutsConstantKey == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(5);
        }
        if ((strutsModel = StrutsConstantManagerImpl.getStrutsModel(containingFile = context.getContainingFile())) == null) {
            return null;
        }
        String stringValue = StrutsConstantManagerImpl.getStringValue(containingFile, strutsModel, strutsConstantKey.getKey());
        if (stringValue == null) {
            return null;
        }
        Converter<T> converter = this.findConverter(context, strutsConstantKey);
        if (converter == null) {
            return (T)stringValue;
        }
        DomFileElement first = (DomFileElement)strutsModel.getRoots().iterator().next();
        ConvertContext convertContext = ConvertContextFactory.createConvertContext((DomElement)first);
        return (T)converter.fromString(stringValue, convertContext);
    }

    @Nullable
    private static String getStringValue(@NotNull PsiFile context, @NotNull StrutsModel strutsModel, @NotNull @NonNls String name) {
        ParamValue initParam;
        WebFacet webFacet;
        if (context == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(6);
        }
        if (strutsModel == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(7);
        }
        if (name == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(8);
        }
        Project project = context.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        assert (module != null) : context;
        List properties = PropertiesImplUtil.findPropertiesByKey((Project)project, (String)name);
        String value = null;
        IProperty strutsDefaultProperty = (IProperty)ContainerUtil.find((Iterable)properties, property -> {
            VirtualFile virtualFile = property.getPropertiesFile().getVirtualFile();
            return virtualFile != null && virtualFile.getFileSystem() instanceof JarFileSystem && StringUtil.endsWith((CharSequence)virtualFile.getPath(), (CharSequence)STRUTS_DEFAULT_PROPERTIES) && ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)virtualFile, (boolean)true);
        });
        if (strutsDefaultProperty != null) {
            value = strutsDefaultProperty.getValue();
        }
        Condition constantNameCondition = constant -> {
            if (name == null) {
                StrutsConstantManagerImpl.$$$reportNull$$$0(13);
            }
            return Comparing.equal((String)constant.getName().getStringValue(), (String)name);
        };
        ArrayList<DomFileElement<StrutsRoot>> domFileElements = new ArrayList<DomFileElement<StrutsRoot>>();
        StrutsConstantManagerImpl.collectStrutsXmls(domFileElements, strutsModel, "struts-default.xml", true);
        StrutsConstantManagerImpl.collectStrutsXmls(domFileElements, strutsModel, "struts-plugin.xml", true);
        StrutsConstantManagerImpl.collectStrutsXmls(domFileElements, strutsModel, "struts.xml", false);
        for (DomFileElement domFileElement : domFileElements) {
            Constant constant2 = (Constant)ContainerUtil.find((Iterable)((StrutsRoot)domFileElement.getRootElement()).getConstants(), (Condition)constantNameCondition);
            String strutsXmlValue = constant2 != null ? constant2.getValue().getStringValue() : null;
            if (strutsXmlValue == null) continue;
            value = strutsXmlValue;
        }
        IProperty strutsProperty = (IProperty)ContainerUtil.find((Iterable)properties, property -> {
            VirtualFile virtualFile = property.getPropertiesFile().getVirtualFile();
            return virtualFile != null && Comparing.equal((String)virtualFile.getName(), (String)STRUTS_PROPERTIES_FILENAME) && ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)virtualFile, (boolean)false);
        });
        if (strutsProperty != null) {
            value = strutsProperty.getValue();
        }
        if ((webFacet = WebUtil.getWebFacet((PsiElement)context)) == null) {
            return value;
        }
        WebApp webApp = webFacet.getRoot();
        if (webApp == null) {
            return value;
        }
        Filter filter = (Filter)ContainerUtil.find((Iterable)webApp.getFilters(), WEB_XML_STRUTS_FILTER_CONDITION);
        if (filter != null && (initParam = (ParamValue)ContainerUtil.find((Iterable)filter.getInitParams(), paramValue -> {
            if (name == null) {
                StrutsConstantManagerImpl.$$$reportNull$$$0(12);
            }
            return Comparing.equal((String)paramValue.getParamName().getStringValue(), (String)name);
        })) != null) {
            value = initParam.getParamValue().getStringValue();
        }
        return value;
    }

    @Nullable
    private static StrutsModel getStrutsModel(PsiFile psiFile) {
        StrutsManager strutsManager = StrutsManager.getInstance(psiFile.getProject());
        StrutsModel model = psiFile instanceof XmlFile && strutsManager.isStruts2ConfigFile((XmlFile)psiFile) ? strutsManager.getModelByFile((XmlFile)psiFile) : strutsManager.getCombinedModel((PsiElement)psiFile);
        return model;
    }

    private static void collectStrutsXmls(@NotNull List<DomFileElement<StrutsRoot>> domFileElements, @NotNull StrutsModel model, @NotNull @NonNls String strutsXmlName, boolean onlyInJARs) {
        if (domFileElements == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(9);
        }
        if (model == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(10);
        }
        if (strutsXmlName == null) {
            StrutsConstantManagerImpl.$$$reportNull$$$0(11);
        }
        ContainerUtil.process((List)model.getRoots(), (Processor)new FilteringProcessor(StrutsConstantManagerImpl.getStrutsXmlCondition(strutsXmlName, onlyInJARs), (Processor)new CommonProcessors.CollectProcessor(domFileElements)));
    }

    private static Condition<DomFileElement<StrutsRoot>> getStrutsXmlCondition(String strutsXmlName, boolean onlyInJARs) {
        return strutsRootDomFileElement -> {
            XmlFile xmlFile = strutsRootDomFileElement.getFile();
            boolean nameMatch = Comparing.equal((String)xmlFile.getName(), (String)strutsXmlName);
            if (!onlyInJARs) {
                return nameMatch;
            }
            VirtualFile virtualFile = xmlFile.getVirtualFile();
            return nameMatch && virtualFile != null && virtualFile.getFileSystem() instanceof JarFileSystem;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/struts2/model/constant/StrutsConstantManagerImpl";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strutsConstantKey";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strutsModel";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strutsXmlName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/struts2/model/constant/StrutsConstantManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConstants";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findConverter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConvertedValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectStrutsXmls";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getStringValue$6";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getStringValue$4";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findConverter$2";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConstants$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

