/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class InterceptionAnnotationWithoutRuntimeRetentionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("interception.annotation.without.runtime.retention.problem.descriptor", new Object[0]);
        if (string == null) {
            InterceptionAnnotationWithoutRuntimeRetentionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/InterceptionAnnotationWithoutRuntimeRetentionInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"annotatedWith".equals(name)) {
                return;
            }
            PsiExpression[] args = expression.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            if (!(args[0] instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!"com.google.inject.matcher.Matchers".equals(containingClass.getQualifiedName())) {
                return;
            }
            PsiClassObjectAccessExpression arg = (PsiClassObjectAccessExpression)args[0];
            PsiTypeElement operandType = arg.getOperand();
            PsiClassType operandAnnotationType = (PsiClassType)operandType.getType();
            PsiClass operantAnnotation = operandAnnotationType.resolve();
            PsiAnnotation retentionAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)operantAnnotation, Collections.singleton("java.lang.annotation.Retention"));
            if (retentionAnnotation == null || !retentionAnnotation.getText().contains("RUNTIME")) {
                this.registerError((PsiElement)operandType, new Object[0]);
            }
        }
    }
}

