/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.utils;

import com.intellij.guice.utils.BoolUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;

public class MutationUtils {
    private MutationUtils() {
    }

    public static void negateExpression(PsiExpression exp) throws IncorrectOperationException {
        String expString;
        PsiJavaParserFacade facade = JavaPsiFacade.getInstance((Project)exp.getProject()).getParserFacade();
        PsiExpression expressionToReplace = exp;
        String newExpressionText = exp.getText();
        if ("true".equals(newExpressionText)) {
            expressionToReplace = exp;
            expString = "false";
        } else if ("false".equals(newExpressionText)) {
            expressionToReplace = exp;
            expString = "true";
        } else if (BoolUtils.isNegated(exp)) {
            expressionToReplace = BoolUtils.findNegation(exp);
            expString = newExpressionText;
        } else if (BoolUtils.isNegation(exp)) {
            expressionToReplace = exp;
            expString = BoolUtils.getNegated(exp).getText();
        } else if (ComparisonUtils.isComparison((PsiExpression)exp)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)exp;
            String negatedComparison = ComparisonUtils.getNegatedComparison((IElementType)binaryExpression.getOperationTokenType());
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            assert (rhs != null);
            expString = lhs.getText() + negatedComparison + rhs.getText();
        } else {
            expString = ParenthesesUtils.getPrecedence((PsiExpression)exp) > 3 ? "!(" + newExpressionText + ')' : '!' + newExpressionText;
        }
        PsiExpression newCall = facade.createExpressionFromText(expString, null);
        PsiElement insertedElement = expressionToReplace.replace((PsiElement)newCall);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)exp.getProject());
        codeStyleManager.reformat(insertedElement);
    }

    public static PsiExpression replaceExpression(String newExpression, PsiExpression exp) throws IncorrectOperationException {
        Project project = exp.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiExpression newCall = factory.createExpressionFromText(newExpression, null);
        PsiElement insertedElement = exp.replace((PsiElement)newCall);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(insertedElement);
        return (PsiExpression)codeStyleManager.reformat(shortenedElement);
    }

    public static void addAnnotation(PsiModifierListOwner owner, String annotation) throws IncorrectOperationException {
        PsiModifierList modifiers = owner.getModifierList();
        Project project = owner.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiAnnotation newAnnotation = elementFactory.createAnnotationFromText(annotation, (PsiElement)owner);
        assert (modifiers != null);
        PsiElement replacedAnnotation = modifiers.add((PsiElement)newAnnotation);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        codeStyleManager.shortenClassReferences(replacedAnnotation);
    }

    public static void replaceAnnotation(PsiAnnotation originalAnnotation, String replacementString) throws IncorrectOperationException {
        Project project = originalAnnotation.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiAnnotation newAnnotation = elementFactory.createAnnotationFromText(replacementString, (PsiElement)originalAnnotation);
        PsiElement replacedAnnotation = originalAnnotation.replace((PsiElement)newAnnotation);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replacedAnnotation);
    }
}

