/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.operations;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ApplyProgress {
    public static final ApplyProgress EMPTY = new ApplyProgress(){

        @Override
        public void setText(String text) {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public void setFraction(double fraction) {
        }
    };

    public void setText(String var1);

    public boolean isCancelled();

    public void setFraction(double var1);

    public static class RollbackProgressWrapper
    implements ApplyProgress {
        @NotNull
        private final RollbackProgressListener myListener;

        public RollbackProgressWrapper(@NotNull RollbackProgressListener listener) {
            if (listener == null) {
                RollbackProgressWrapper.$$$reportNull$$$0(0);
            }
            this.myListener = listener;
        }

        @Override
        public void setText(String text) {
            this.myListener.accept(new File(text));
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public void setFraction(double fraction) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/tfsIntegration/core/tfs/operations/ApplyProgress$RollbackProgressWrapper", "<init>"));
        }
    }

    public static class ProgressIndicatorWrapper
    implements ApplyProgress {
        @Nullable
        private final ProgressIndicator myProgressIndicator;

        public ProgressIndicatorWrapper(@Nullable ProgressIndicator progressIndicator) {
            this.myProgressIndicator = progressIndicator;
        }

        @Override
        public void setText(String text) {
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setText(text);
            }
        }

        @Override
        public boolean isCancelled() {
            return this.myProgressIndicator != null && this.myProgressIndicator.isCanceled();
        }

        @Override
        public void setFraction(double fraction) {
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setFraction(fraction);
            }
        }
    }
}

