/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.workitems;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WorkItemState {
    private static final Map<String, WorkItemState> ourAllStates = ContainerUtil.newHashMap();
    public static final WorkItemState ACTIVE = WorkItemState.register("Active");
    public static final WorkItemState RESOLVED = WorkItemState.register("Resolved");
    public static final WorkItemState CLOSED = WorkItemState.register("Closed");
    @NonNls
    @NotNull
    private final String myName;

    private WorkItemState(@NonNls @NotNull String name) {
        if (name == null) {
            WorkItemState.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            WorkItemState.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static WorkItemState from(@NotNull String stateName) {
        if (stateName == null) {
            WorkItemState.$$$reportNull$$$0(2);
        }
        WorkItemState workItemState = WorkItemState.register(stateName);
        if (workItemState == null) {
            WorkItemState.$$$reportNull$$$0(3);
        }
        return workItemState;
    }

    @NotNull
    private static synchronized WorkItemState register(@NotNull String stateName) {
        WorkItemState result;
        if (stateName == null) {
            WorkItemState.$$$reportNull$$$0(4);
        }
        if ((result = ourAllStates.get(stateName)) == null) {
            result = new WorkItemState(stateName);
            ourAllStates.put(stateName, result);
        }
        WorkItemState workItemState = result;
        if (workItemState == null) {
            WorkItemState.$$$reportNull$$$0(5);
        }
        return workItemState;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkItemState)) {
            return false;
        }
        WorkItemState state = (WorkItemState)o;
        return this.myName.equals(state.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemState";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/workitems/WorkItemState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "register";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

