/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemSpec;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.labels.LabelItemSpecWithItems;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.AddItemForm;
import org.jetbrains.tfsIntegration.ui.servertree.TfsTreeForm;

public class AddItemDialog
extends DialogWrapper {
    private final Project myProject;
    private final WorkspaceInfo myWorkspace;
    private final AddItemForm myForm;
    private LabelItemSpecWithItems myLabelSpec;

    public AddItemDialog(Project project, WorkspaceInfo workspace, String sourcePath) {
        super(project, true);
        this.myForm = new AddItemForm(project, workspace, sourcePath);
        this.myProject = project;
        this.myWorkspace = workspace;
        this.setTitle("Add Item");
        this.init();
        this.myForm.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AddItemDialog.this.updateButtons();
            }
        });
        this.updateButtons();
    }

    private void updateButtons() {
        this.setOKActionEnabled(this.myForm.getServerItem() != null && this.myForm.getVersion() != null);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myForm.getContentPane();
    }

    @Nullable
    public LabelItemSpecWithItems getLabelSpec() {
        return this.myLabelSpec;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    protected void doOKAction() {
        try {
            TfsTreeForm.SelectedItem serverItem = this.myForm.getServerItem();
            ItemSpec itemSpec = VersionControlServer.createItemSpec(serverItem.path, (RecursionType)(serverItem.isDirectory ? RecursionType.Full : null));
            List<Item> items = this.myWorkspace.getServer().getVCS().queryItems(itemSpec, this.myForm.getVersion(), this.getContentPane(), TFSBundle.message("loading.item", new Object[0]));
            if (items.isEmpty()) {
                String message = MessageFormat.format("Item ''{0}'' was not found in source control at version ''{1}''.", serverItem.path, this.myForm.getVersion().getPresentableString());
                Messages.showErrorDialog((Project)this.myProject, (String)message, (String)"Apply label");
                return;
            }
            this.myLabelSpec = LabelItemSpecWithItems.createForAdd(itemSpec, this.myForm.getVersion(), items);
        }
        catch (TfsException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)"Apply label");
            return;
        }
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "TFS.AddItem";
    }
}

