/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.checkoutwizard;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcsUtil.VcsUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardModel;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseLocalAndServerPathsStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseServerPathStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.SummaryForm;

public class SummaryStep
extends CheckoutWizardStep {
    public static final Object ID = new Object();
    private final SummaryForm mySummaryForm = new SummaryForm();

    public SummaryStep(CheckoutWizardModel model) {
        super("Summary", model);
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            SummaryStep.$$$reportNull$$$0(0);
        }
        return object;
    }

    @Nullable
    public Object getNextStepId() {
        return null;
    }

    @Nullable
    public Object getPreviousStepId() {
        if (this.myModel.getMode() == CheckoutWizardModel.Mode.Manual) {
            return ChooseServerPathStep.ID;
        }
        return ChooseLocalAndServerPathsStep.ID;
    }

    public boolean isComplete() {
        return true;
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
    }

    public JComponent getComponent() {
        return this.mySummaryForm.getContentPanel();
    }

    public void _init() {
        this.mySummaryForm.setServer(this.myModel.getServer());
        this.mySummaryForm.setServerPath(this.myModel.getServerPath());
        if (this.myModel.getMode() == CheckoutWizardModel.Mode.Auto) {
            this.mySummaryForm.setNewWorkspaceName(this.myModel.getNewWorkspaceName());
            this.mySummaryForm.setLocalPath(VcsUtil.getFilePath((String)this.myModel.getDestinationFolder()).getPresentableUrl());
        } else {
            this.mySummaryForm.setWorkspace(this.myModel.getWorkspace());
            try {
                FilePath localPath = this.myModel.getWorkspace().findLocalPathByServerPath(this.myModel.getServerPath(), true, null);
                this.mySummaryForm.setLocalPath(localPath.getPresentableUrl());
            }
            catch (TfsException e) {
                TFSVcs.error(e.getMessage());
            }
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public String getHelpId() {
        return "reference.checkoutTFS.summary";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/checkoutwizard/SummaryStep", "getStepId"));
    }
}

