/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.bnd.run.BndLaunchUtil;
import org.jetbrains.osgi.bnd.run.BndRunConfigurationBase;
import org.jetbrains.osgi.bnd.run.BndRunConfigurationType;

public abstract class BndRunConfigurationProducer
extends RunConfigurationProducer<BndRunConfigurationBase> {
    protected BndRunConfigurationProducer(@NotNull ConfigurationFactory factory) {
        if (factory == null) {
            BndRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        super(factory);
    }

    protected boolean setupConfigurationFromContext(BndRunConfigurationBase configuration, ConfigurationContext context, Ref<PsiElement> source) {
        Boolean hasTestCases;
        String extension;
        VirtualFile file;
        Location location = context.getLocation();
        if (location != null && (file = location.getVirtualFile()) != null && !file.isDirectory() && ("bndrun".equals(extension = file.getExtension()) || "bnd".equals(extension)) && ((hasTestCases = BndLaunchUtil.hasTestCases(file.getPath())) == Boolean.FALSE && configuration instanceof BndRunConfigurationBase.Launch || hasTestCases == Boolean.TRUE && configuration instanceof BndRunConfigurationBase.Test)) {
            configuration.setName(context.getModule().getName());
            configuration.bndRunFile = file.getPath();
            return true;
        }
        return false;
    }

    public boolean isConfigurationFromContext(BndRunConfigurationBase configuration, ConfigurationContext context) {
        Location location;
        if (this.getConfigurationFactory() == configuration.getFactory() && (location = context.getLocation()) != null) {
            VirtualFile file = location.getVirtualFile();
            return file != null && !file.isDirectory() && FileUtil.pathsEqual((String)file.getPath(), (String)configuration.bndRunFile);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/osgi/bnd/run/BndRunConfigurationProducer", "<init>"));
    }

    public static class Test
    extends BndRunConfigurationProducer {
        public Test() {
            super(BndRunConfigurationType.getInstance().getConfigurationFactories()[1]);
        }
    }

    public static class Launch
    extends BndRunConfigurationProducer {
        public Launch() {
            super(BndRunConfigurationType.getInstance().getConfigurationFactories()[0]);
        }
    }
}

