/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.concierge;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;
import org.osmorc.frameworkintegration.impl.AbstractFrameworkRunner;
import org.osmorc.frameworkintegration.impl.GenericRunProperties;
import org.osmorc.run.ui.SelectedBundle;

public class ConciergeRunner
extends AbstractFrameworkRunner {
    static final String MAIN_CLASS = "ch.ethz.iks.concierge.framework.Framework";

    @Override
    protected void setupParameters(@NotNull JavaParameters parameters) {
        if (parameters == null) {
            ConciergeRunner.$$$reportNull$$$0(0);
        }
        ParametersList vmParameters = parameters.getVMParametersList();
        MultiMap startBundles = new MultiMap();
        List installBundles = ContainerUtil.newSmartList();
        for (SelectedBundle bundle : this.myBundles) {
            String bundlePath = bundle.getBundlePath();
            if (bundlePath == null) continue;
            boolean isFragment = CachingBundleInfoProvider.isFragmentBundle((String)bundlePath);
            String bundleUrl = this.toFileUri(bundlePath);
            if (bundle.isStartAfterInstallation() && !isFragment) {
                int startLevel = this.getBundleStartLevel(bundle);
                startBundles.putValue((Object)startLevel, (Object)bundleUrl);
                continue;
            }
            installBundles.add(bundleUrl);
        }
        for (Integer startLevel : startBundles.keySet()) {
            vmParameters.addProperty("osgi.auto.start." + startLevel, StringUtil.join((Collection)startBundles.get((Object)startLevel), (String)" "));
        }
        if (!installBundles.isEmpty()) {
            vmParameters.addProperty("osgi.auto.install", StringUtil.join((Collection)installBundles, (String)" "));
        }
        int startLevel = this.getFrameworkStartLevel();
        vmParameters.addProperty("osgi.startlevel.framework", String.valueOf(startLevel));
        int defaultStartLevel = this.myRunConfiguration.getDefaultStartLevel();
        vmParameters.addProperty("osgi.startlevel.bundle", String.valueOf(defaultStartLevel));
        vmParameters.addProperty("osgi.init", "true");
        if (GenericRunProperties.isDebugMode(this.myAdditionalProperties)) {
            vmParameters.addProperty("ch.ethz.iks.concierge.debug", "true");
        }
        parameters.setMainClass(MAIN_CLASS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/osmorc/frameworkintegration/impl/concierge/ConciergeRunner", "setupParameters"));
    }
}

