/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.header;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.jetbrains.lang.manifest.psi.ManifestToken;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;
import org.osmorc.manifest.lang.header.BasePackageParser;
import org.osmorc.manifest.lang.psi.Attribute;
import org.osmorc.manifest.lang.psi.Clause;
import org.osmorc.manifest.lang.psi.Directive;
import org.osmorc.util.OsgiPsiUtil;

public class ExportPackageParser
extends BasePackageParser {
    public static final HeaderParser INSTANCE = new ExportPackageParser();
    private static final TokenSet TOKEN_FILTER = TokenSet.create((IElementType[])new IElementType[]{ManifestTokenType.HEADER_VALUE_PART});

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull HeaderValuePart headerValuePart) {
        Attribute attribute;
        PsiElement parent;
        if (headerValuePart == null) {
            ExportPackageParser.$$$reportNull$$$0(0);
        }
        if ((parent = headerValuePart.getParent()) instanceof Clause) {
            PsiElement element = headerValuePart.getOriginalElement().getPrevSibling();
            if (!(element instanceof ManifestToken) || ((ManifestToken)element).getTokenType() != ManifestTokenType.SEMICOLON) {
                PsiReference[] psiReferenceArray = ExportPackageParser.getPackageReferences((PsiElement)headerValuePart);
                if (psiReferenceArray == null) {
                    ExportPackageParser.$$$reportNull$$$0(1);
                }
                return psiReferenceArray;
            }
        } else if (parent instanceof Attribute && "uses".equals((attribute = (Attribute)parent).getName())) {
            List references = ContainerUtil.newSmartList();
            for (ASTNode astNode : headerValuePart.getNode().getChildren(TOKEN_FILTER)) {
                if (!(astNode instanceof ManifestToken)) continue;
                ManifestToken manifestToken = (ManifestToken)astNode;
                ContainerUtil.addAll((Collection)references, (Object[])ExportPackageParser.getPackageReferences((PsiElement)manifestToken));
            }
            PsiReference[] psiReferenceArray = (PsiReference[])ContainerUtilRt.toArray((List)references, (Object[])new PsiReference[references.size()]);
            if (psiReferenceArray == null) {
                ExportPackageParser.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            ExportPackageParser.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        if (header == null) {
            ExportPackageParser.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            ExportPackageParser.$$$reportNull$$$0(5);
        }
        if (super.annotate(header, holder)) {
            return true;
        }
        boolean annotated = false;
        for (HeaderValue value : header.getHeaderValues()) {
            HeaderValuePart valuePart;
            Directive uses;
            if (!(value instanceof Clause) || (uses = ((Clause)value).getDirective("uses")) == null || (valuePart = uses.getValueElement()) == null) continue;
            String text = StringUtil.trimTrailing((String)valuePart.getText());
            int start = StringUtil.startsWithChar((CharSequence)text, (char)'\"') ? 1 : 0;
            int length = StringUtil.endsWithChar((CharSequence)text, (char)'\"') ? text.length() - 1 : text.length();
            int offset = valuePart.getTextOffset();
            while (start < length) {
                int end = text.indexOf(44, start);
                if (end < 0) {
                    end = length;
                }
                TextRange range = new TextRange(start, end);
                start = end + 1;
                String packageName = range.substring(text).replaceAll("\\s", "");
                if (StringUtil.isEmptyOrSpaces((String)packageName)) {
                    TextRange highlight = range.shiftRight(offset);
                    holder.createErrorAnnotation(highlight, ManifestBundle.message((String)"header.reference.invalid", (Object[])new Object[0]));
                    annotated = true;
                    continue;
                }
                PsiDirectory[] directories = OsgiPsiUtil.resolvePackage((PsiElement)header, packageName);
                if (directories.length != 0) continue;
                TextRange highlight = ExportPackageParser.adjust(range, text).shiftRight(offset);
                holder.createErrorAnnotation(highlight, JavaErrorMessages.message((String)"cannot.resolve.package", (Object[])new Object[]{packageName}));
                annotated = true;
            }
        }
        return annotated;
    }

    private static TextRange adjust(TextRange range, String text) {
        int end;
        int start = range.getStartOffset();
        for (end = range.getEndOffset(); end > start && Character.isWhitespace(text.charAt(end - 1)); --end) {
        }
        while (start < end && Character.isWhitespace(text.charAt(start))) {
            ++start;
        }
        return new TextRange(start, end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerValuePart";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/manifest/lang/header/ExportPackageParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/manifest/lang/header/ExportPackageParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

