/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectPath {
    public final ObjectKind kind;
    public final List<String> path;

    public ObjectPath(@NotNull ObjectKind kind, @NotNull List<String> path) {
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(0);
        }
        if (path == null) {
            ObjectPath.$$$reportNull$$$0(1);
        }
        this.kind = kind;
        this.path = ContainerUtil.immutableList((Object[])ArrayUtil.toStringArray(path));
    }

    @NotNull
    public String getDisplayName() {
        String string = StringUtil.join((Iterable)JBIterable.from(this.path).filter(StringUtil::isNotEmpty), (String)".");
        if (string == null) {
            ObjectPath.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.path.isEmpty() ? "" : this.path.get(this.path.size() - 1);
        if (string == null) {
            ObjectPath.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Contract(value="!null->!null")
    public static ObjectPath of(@Nullable DasObject o) {
        if (o == null) {
            return null;
        }
        List parents = ContainerUtil.reverse((List)DasUtil.dasParents(o).filter(x -> x.getKind() != ObjectKind.ROOT).toList());
        return new ObjectPath(o.getKind(), JBIterable.from((Iterable)parents).transform(DasUtil.TO_NAME).toList());
    }

    public String toString() {
        return this.kind + ":" + this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectPath path1 = (ObjectPath)o;
        if (!this.kind.equals(path1.kind)) {
            return false;
        }
        return this.path.equals(path1.path);
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/ObjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/ObjectPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

