/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.xml.util.PsiElementPointer;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BeanNamesMapper {
    private final Map<String, SpringBeanPointer> myBeansMap;
    private final Map<String, Pair<String, PsiElementPointer>> myAliasesMap = new THashMap();
    private final MultiMap<String, String> myAllBeanNames;
    private final MultiMap<String, PsiElementPointer> myDuplicatedNames = MultiMap.createSmart();

    BeanNamesMapper(LocalXmlModel model) {
        java.util.HashSet ownBeans = new java.util.HashSet(model.getLocalBeans());
        this.myBeansMap = new THashMap(ownBeans.size());
        this.myAllBeanNames = MultiMap.createSet();
        for (SpringBeanPointer bean : ownBeans) {
            String beanName = bean.getName();
            if (!StringUtil.isNotEmpty((String)beanName)) continue;
            SpringBeanPointer duplication = this.myBeansMap.put(beanName, bean);
            if (duplication != null) {
                this.myDuplicatedNames.putValue((Object)beanName, (Object)duplication);
                this.myDuplicatedNames.putValue((Object)beanName, (Object)bean);
            }
            this.myAllBeanNames.putValue((Object)beanName, (Object)beanName);
            for (String alias : bean.getAliases()) {
                this.registerAlias(beanName, alias, bean, null);
            }
        }
        PlaceholderUtils placeholderUtils = PlaceholderUtils.getInstance();
        List<Alias> aliases = BeanNamesMapper.getAliases((DomFileElement<Beans>)model.getRoot());
        for (Alias anAlias : aliases) {
            String aliasedBean = anAlias.getAliasedBean().getRawText();
            String alias = anAlias.getAlias().getRawText();
            if (placeholderUtils.isDefaultPlaceholder(aliasedBean) || placeholderUtils.isDefaultPlaceholder(alias)) continue;
            this.registerAlias(aliasedBean, alias, null, anAlias);
        }
    }

    @Nullable
    SpringBeanPointer getBean(@NotNull String beanName) {
        if (beanName == null) {
            BeanNamesMapper.$$$reportNull$$$0(0);
        }
        String curName = beanName;
        Set visited = null;
        SpringBeanPointer bean;
        while ((bean = this.myBeansMap.get(curName)) == null) {
            Pair<String, PsiElementPointer> newName = this.myAliasesMap.get(curName);
            if (newName == null || visited != null && visited.contains(curName)) {
                return null;
            }
            if (visited == null) {
                visited = new THashSet();
            }
            visited.add(curName);
            curName = (String)newName.getFirst();
        }
        return bean.derive(beanName);
    }

    Set<String> getAllBeanNames(String beanName) {
        return (Set)this.myAllBeanNames.get((Object)beanName);
    }

    Collection<PsiElementPointer> getDuplicatedNames(@NotNull String name) {
        if (name == null) {
            BeanNamesMapper.$$$reportNull$$$0(1);
        }
        return this.myDuplicatedNames.get((Object)name);
    }

    private void registerAlias(String beanName, String alias, @Nullable SpringBeanPointer bean, @Nullable Alias anAlias) {
        SpringBeanPointer beanPointer;
        if (!StringUtil.isNotEmpty((String)alias) || !StringUtil.isNotEmpty((String)beanName) || Comparing.equal((String)beanName, (String)alias)) {
            return;
        }
        Object elementPointer = bean == null ? DomService.getInstance().createAnchor((DomElement)anAlias) : bean;
        Pair<String, PsiElementPointer> duplication = this.myAliasesMap.put(alias, (Pair<String, PsiElementPointer>)Pair.create((Object)beanName, (Object)elementPointer));
        if (duplication != null) {
            this.myDuplicatedNames.putValue((Object)alias, elementPointer);
            this.myDuplicatedNames.putValue((Object)alias, duplication.getSecond());
        }
        if ((beanPointer = this.myBeansMap.get(alias)) != null) {
            this.myDuplicatedNames.putValue((Object)alias, elementPointer);
            this.myDuplicatedNames.putValue((Object)alias, (Object)beanPointer);
        }
        HashSet aliases = new HashSet();
        aliases.add((Object)alias);
        while (!this.myBeansMap.containsKey(beanName)) {
            Pair<String, PsiElementPointer> pair = this.myAliasesMap.get(beanName);
            if (pair == null) {
                return;
            }
            beanName = (String)pair.getFirst();
            aliases.add((Object)beanName);
        }
        this.myAllBeanNames.putValues((Object)beanName, (Collection)aliases);
    }

    private static List<Alias> getAliases(@Nullable DomFileElement<Beans> fileElement) {
        if (fileElement == null) {
            return Collections.emptyList();
        }
        List list = ((Beans)fileElement.getRootElement()).getAliases();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return new SmartList((Collection)list);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/contexts/model/BeanNamesMapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDuplicatedNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

