/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.highlighting.SpringCacheableBaseInspection;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCacheAnnotationsOnInterfaceInspection
extends SpringCacheableBaseInspection {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiClass containingClass;
        if (method == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(1);
        }
        if (SpringCacheAnnotationsOnInterfaceInspection.isPlainJavaFileInSpringModule((PsiElement)method) && (containingClass = method.getContainingClass()) != null && containingClass.isInterface()) {
            ProblemsHolder holder = new ProblemsHolder(manager, method.getContainingFile(), isOnTheFly);
            for (SpringJamCacheableElement cacheableElement : SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)method)) {
                SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, cacheableElement.getAnnotation());
            }
            SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.springframework.cache.annotation.Caching"}));
            return holder.getResultsArray();
        }
        return null;
    }

    private static void registerProblemIfAnnotationExists(@NotNull ProblemsHolder holder, @Nullable PsiAnnotation annotation) {
        if (holder == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(2);
        }
        if (annotation != null) {
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("cacheable.should.be.defined.on.concrete.method", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(4);
        }
        if (SpringCacheAnnotationsOnInterfaceInspection.isPlainJavaFileInSpringModule((PsiElement)aClass) && aClass.isInterface() && !aClass.isAnnotationType()) {
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            for (SpringJamCacheableElement cacheableElement : SemService.getSemService((Project)aClass.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)aClass)) {
                SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, cacheableElement.getAnnotation());
            }
            SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{"org.springframework.cache.annotation.Caching"}));
            return holder.getResultsArray();
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringCacheAnnotationsOnInterfaceInspection" == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(5);
        }
        return "SpringCacheAnnotationsOnInterfaceInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/cacheable/highlighting/SpringCacheAnnotationsOnInterfaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/cacheable/highlighting/SpringCacheAnnotationsOnInterfaceInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerProblemIfAnnotationExists";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

