/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.metrics.StatementCountVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyOverlyLongMethodInspectionBase
extends GroovyMethodMetricInspection {
    public GroovyOverlyLongMethodInspectionBase() {
        super(30);
    }

    @NotNull
    public String getDisplayName() {
        if ("Overly long method" == null) {
            GroovyOverlyLongMethodInspectionBase.$$$reportNull$$$0(0);
        }
        return "Overly long method";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' is too long ( statement count =" + args[0] + '>' + args[1] + ')';
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyOverlyLongMethodInspectionBase.$$$reportNull$$$0(1);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyLongMethodInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod method) {
            if (method == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            int limit = GroovyOverlyLongMethodInspectionBase.this.getLimit();
            StatementCountVisitor visitor2 = new StatementCountVisitor();
            GrOpenBlock block = method.getBlock();
            if (block == null) {
                return;
            }
            block.accept(visitor2);
            int statementCount = visitor2.getStatementCount();
            if (statementCount <= limit) {
                return;
            }
            this.registerMethodError(method, statementCount, limit);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyLongMethodInspectionBase$Visitor", "visitMethod"));
        }
    }
}

