/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypeVisitorEx;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.LazyFqnClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrImmediateClosureSignatureImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypeConstants;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class TypesUtil
implements TypeConstants {
    public static final PsiPrimitiveType[] PRIMITIVES = new PsiPrimitiveType[]{PsiType.BYTE, PsiType.CHAR, PsiType.DOUBLE, PsiType.FLOAT, PsiType.INT, PsiType.SHORT, PsiType.LONG, PsiType.BOOLEAN, PsiType.VOID};
    private static final Map<IElementType, String> ourPrimitiveTypesToClassNames = new HashMap();
    private static final String NULL = "null";
    private static final Map<IElementType, String> ourOperationsToOperatorNames;
    private static final Map<IElementType, String> ourUnaryOperationsToOperatorNames;
    static final TObjectIntHashMap<String> TYPE_TO_RANK;
    static final TIntObjectHashMap<String> RANK_TO_TYPE;
    private static final List<PsiType> LUB_NUMERIC_TYPES;

    private TypesUtil() {
    }

    @NotNull
    public static GroovyResolveResult[] getOverloadedOperatorCandidates(@NotNull PsiType thisType, IElementType tokenType, @NotNull GroovyPsiElement place, PsiType[] argumentTypes) {
        if (thisType == null) {
            TypesUtil.$$$reportNull$$$0(0);
        }
        if (place == null) {
            TypesUtil.$$$reportNull$$$0(1);
        }
        GroovyResolveResult[] groovyResolveResultArray = TypesUtil.getOverloadedOperatorCandidates(thisType, tokenType, place, argumentTypes, false);
        if (groovyResolveResultArray == null) {
            TypesUtil.$$$reportNull$$$0(2);
        }
        return groovyResolveResultArray;
    }

    @NotNull
    public static GroovyResolveResult[] getOverloadedOperatorCandidates(@NotNull PsiType thisType, IElementType tokenType, @NotNull GroovyPsiElement place, PsiType[] argumentTypes, boolean incompleteCode) {
        if (thisType == null) {
            TypesUtil.$$$reportNull$$$0(3);
        }
        if (place == null) {
            TypesUtil.$$$reportNull$$$0(4);
        }
        GroovyResolveResult[] groovyResolveResultArray = ResolveUtil.getMethodCandidates(thisType, ourOperationsToOperatorNames.get(tokenType), (PsiElement)place, true, incompleteCode, argumentTypes);
        if (groovyResolveResultArray == null) {
            TypesUtil.$$$reportNull$$$0(5);
        }
        return groovyResolveResultArray;
    }

    public static GroovyResolveResult[] getOverloadedUnaryOperatorCandidates(@NotNull PsiType thisType, IElementType tokenType, @NotNull GroovyPsiElement place, PsiType[] argumentTypes) {
        if (thisType == null) {
            TypesUtil.$$$reportNull$$$0(6);
        }
        if (place == null) {
            TypesUtil.$$$reportNull$$$0(7);
        }
        return ResolveUtil.getMethodCandidates(thisType, ourUnaryOperationsToOperatorNames.get(tokenType), (PsiElement)place, argumentTypes);
    }

    @Deprecated
    public static boolean isAssignable(@Nullable PsiType lType, @Nullable PsiType rType, @NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(8);
        }
        if (lType == null || rType == null) {
            return false;
        }
        return TypesUtil.canAssign(lType, rType, context, GrTypeConverter.ApplicableTo.ASSIGNMENT) == ConversionResult.OK;
    }

    @NotNull
    public static ConversionResult canAssign(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull PsiElement context, @NotNull GrTypeConverter.ApplicableTo position) {
        GlobalSearchScope scope;
        if (targetType == null) {
            TypesUtil.$$$reportNull$$$0(9);
        }
        if (actualType == null) {
            TypesUtil.$$$reportNull$$$0(10);
        }
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(11);
        }
        if (position == null) {
            TypesUtil.$$$reportNull$$$0(12);
        }
        if (actualType instanceof PsiIntersectionType) {
            ConversionResult min = ConversionResult.ERROR;
            for (PsiType child : ((PsiIntersectionType)actualType).getConjuncts()) {
                ConversionResult result = TypesUtil.canAssign(targetType, child, context, position);
                if (result.ordinal() < min.ordinal()) {
                    min = result;
                }
                if (min != ConversionResult.OK) continue;
                ConversionResult conversionResult = ConversionResult.OK;
                if (conversionResult == null) {
                    TypesUtil.$$$reportNull$$$0(13);
                }
                return conversionResult;
            }
            ConversionResult conversionResult = min;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(14);
            }
            return conversionResult;
        }
        if (targetType instanceof PsiIntersectionType) {
            ConversionResult max = ConversionResult.OK;
            for (PsiType child : ((PsiIntersectionType)targetType).getConjuncts()) {
                ConversionResult result = TypesUtil.canAssign(child, actualType, context, position);
                if (result.ordinal() > max.ordinal()) {
                    max = result;
                }
                if (max != ConversionResult.ERROR) continue;
                ConversionResult conversionResult = ConversionResult.ERROR;
                if (conversionResult == null) {
                    TypesUtil.$$$reportNull$$$0(15);
                }
                return conversionResult;
            }
            ConversionResult conversionResult = max;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(16);
            }
            return conversionResult;
        }
        ConversionResult result = TypesUtil.areTypesConvertible(targetType, actualType, context, position);
        if (result != null) {
            ConversionResult conversionResult = result;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(17);
            }
            return conversionResult;
        }
        if (TypesUtil.isAssignableWithoutConversions(targetType, actualType, context)) {
            ConversionResult conversionResult = ConversionResult.OK;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(18);
            }
            return conversionResult;
        }
        PsiManager manager = context.getManager();
        if ((targetType = TypesUtil.boxPrimitiveType(targetType, manager, scope = context.getResolveScope())).isAssignableFrom(actualType = TypesUtil.boxPrimitiveType(actualType, manager, scope))) {
            ConversionResult conversionResult = ConversionResult.OK;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(19);
            }
            return conversionResult;
        }
        ConversionResult conversionResult = ConversionResult.ERROR;
        if (conversionResult == null) {
            TypesUtil.$$$reportNull$$$0(20);
        }
        return conversionResult;
    }

    public static boolean isAssignableByMethodCallConversion(@Nullable PsiType targetType, @Nullable PsiType actualType, @NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(21);
        }
        if (targetType == null || actualType == null) {
            return false;
        }
        return TypesUtil.canAssign(targetType, actualType, context, GrTypeConverter.ApplicableTo.METHOD_PARAMETER) == ConversionResult.OK;
    }

    public static boolean isAssignableByParameter(@Nullable PsiType targetType, @Nullable PsiType actualType, @NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(22);
        }
        if (targetType == null || actualType == null) {
            return false;
        }
        return TypesUtil.canAssign(targetType, actualType, context, GrTypeConverter.ApplicableTo.GENERIC_PARAMETER) == ConversionResult.OK;
    }

    @Nullable
    private static ConversionResult areTypesConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull PsiElement context, @NotNull GrTypeConverter.ApplicableTo position) {
        if (targetType == null) {
            TypesUtil.$$$reportNull$$$0(23);
        }
        if (actualType == null) {
            TypesUtil.$$$reportNull$$$0(24);
        }
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(25);
        }
        if (position == null) {
            TypesUtil.$$$reportNull$$$0(26);
        }
        if (!(context instanceof GroovyPsiElement)) {
            return null;
        }
        if (targetType.equals(actualType)) {
            return ConversionResult.OK;
        }
        for (GrTypeConverter converter : (GrTypeConverter[])GrTypeConverter.EP_NAME.getExtensions()) {
            ConversionResult result;
            if (!converter.isApplicableTo(position) || (result = converter.isConvertibleEx(targetType, actualType, (GroovyPsiElement)context, position)) == null) continue;
            return result;
        }
        return null;
    }

    public static boolean isAssignableWithoutConversions(@Nullable PsiType lType, @Nullable PsiType rType, @NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(27);
        }
        if (lType == null || rType == null) {
            return false;
        }
        if (rType == PsiType.NULL) {
            return !(lType instanceof PsiPrimitiveType);
        }
        if (rType instanceof GrTraitType) {
            for (PsiType type : ((GrTraitType)rType).getConjuncts()) {
                if (!TypesUtil.isAssignableWithoutConversions(lType, type, context)) continue;
                return true;
            }
            return false;
        }
        if (TypesUtil.isClassType(rType, "groovy.lang.GString") && lType.equalsToText("java.lang.String")) {
            return true;
        }
        lType = TypesUtil.optionalUnbox(lType);
        rType = TypesUtil.optionalUnbox(rType);
        return TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType);
    }

    @NotNull
    public static ConversionResult canCast(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull PsiElement context) {
        ConversionResult result;
        if (targetType == null) {
            TypesUtil.$$$reportNull$$$0(28);
        }
        if (actualType == null) {
            TypesUtil.$$$reportNull$$$0(29);
        }
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(30);
        }
        if ((result = TypesUtil.areTypesConvertible(targetType, actualType, context, GrTypeConverter.ApplicableTo.EXPLICIT_CAST)) != null) {
            ConversionResult conversionResult = result;
            if (conversionResult == null) {
                TypesUtil.$$$reportNull$$$0(31);
            }
            return conversionResult;
        }
        ConversionResult conversionResult = TypeConversionUtil.areTypesConvertible((PsiType)actualType, (PsiType)targetType) ? ConversionResult.OK : ConversionResult.ERROR;
        if (conversionResult == null) {
            TypesUtil.$$$reportNull$$$0(32);
        }
        return conversionResult;
    }

    @NotNull
    public static ConversionResult canAssignWithinMultipleAssignment(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull PsiElement context) {
        if (targetType == null) {
            TypesUtil.$$$reportNull$$$0(33);
        }
        if (actualType == null) {
            TypesUtil.$$$reportNull$$$0(34);
        }
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(35);
        }
        ConversionResult conversionResult = TypesUtil.isAssignableWithoutConversions(targetType, actualType, context) ? ConversionResult.OK : ConversionResult.ERROR;
        if (conversionResult == null) {
            TypesUtil.$$$reportNull$$$0(36);
        }
        return conversionResult;
    }

    public static boolean isNumericType(@Nullable PsiType type) {
        if (type instanceof PsiClassType) {
            return TYPE_TO_RANK.contains((Object)TypesUtil.getQualifiedName(type));
        }
        return type instanceof PsiPrimitiveType && TypeConversionUtil.isNumericType((PsiType)type);
    }

    public static boolean isIntegralNumberType(@Nullable PsiType type) {
        if (type instanceof PsiClassType) {
            int rank = TYPE_TO_RANK.get((Object)TypesUtil.getQualifiedName(type));
            return rank > 0 && rank <= 6;
        }
        return type instanceof PsiPrimitiveType && TypeConversionUtil.isIntegralNumberType((PsiType)type);
    }

    public static PsiType unboxPrimitiveTypeWrapperAndEraseGenerics(PsiType result) {
        return TypeConversionUtil.erasure((PsiType)TypesUtil.unboxPrimitiveTypeWrapper(result));
    }

    @NotNull
    public static PsiType optionalUnbox(@NotNull PsiType type) {
        PsiType unboxed;
        if (type == null) {
            TypesUtil.$$$reportNull$$$0(37);
        }
        PsiType psiType = (unboxed = TypesUtil.unboxPrimitiveTypeWrapper(type)) == null ? type : unboxed;
        if (psiType == null) {
            TypesUtil.$$$reportNull$$$0(38);
        }
        return psiType;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiType unboxPrimitiveTypeWrapper(@Nullable PsiType type) {
        PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
        return unboxed == null ? type : unboxed;
    }

    public static PsiType boxPrimitiveType(@Nullable PsiType result, @NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope, boolean boxVoid) {
        PsiPrimitiveType primitive;
        String boxedTypeName;
        if (manager == null) {
            TypesUtil.$$$reportNull$$$0(39);
        }
        if (resolveScope == null) {
            TypesUtil.$$$reportNull$$$0(40);
        }
        if (result instanceof PsiPrimitiveType && (boxVoid || !PsiType.VOID.equals((Object)result)) && (boxedTypeName = (primitive = (PsiPrimitiveType)result).getBoxedTypeName()) != null) {
            return GroovyPsiManager.getInstance(manager.getProject()).createTypeByFQClassName(boxedTypeName, resolveScope);
        }
        return result;
    }

    public static PsiType boxPrimitiveType(@Nullable PsiType result, @NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            TypesUtil.$$$reportNull$$$0(41);
        }
        if (resolveScope == null) {
            TypesUtil.$$$reportNull$$$0(42);
        }
        return TypesUtil.boxPrimitiveType(result, manager, resolveScope, false);
    }

    @NotNull
    public static PsiClassType createType(String fqName, @NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(43);
        }
        PsiClassType psiClassType = TypesUtil.createTypeByFQClassName(fqName, context);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(44);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType createType(@NotNull PsiClass clazz) {
        if (clazz == null) {
            TypesUtil.$$$reportNull$$$0(45);
        }
        PsiClassType psiClassType = TypesUtil.createType(clazz, null, new PsiType[0]);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(46);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType createType(@NotNull PsiClass clazz, @Nullable PsiElement context, PsiType ... parameters) {
        if (clazz == null) {
            TypesUtil.$$$reportNull$$$0(47);
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)(context == null ? clazz : context).getProject()).getElementFactory().createType(clazz, parameters);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(48);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiElement context) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(49);
        }
        PsiClassType psiClassType = LazyFqnClassType.getLazyType("java.lang.Object", context);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(50);
        }
        return psiClassType;
    }

    @Nullable
    public static PsiType getLeastUpperBoundNullable(@Nullable PsiType type1, @Nullable PsiType type2, @NotNull PsiManager manager) {
        if (manager == null) {
            TypesUtil.$$$reportNull$$$0(51);
        }
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        return TypesUtil.getLeastUpperBound(type1, type2, manager);
    }

    @Nullable
    public static PsiType getLeastUpperBoundNullable(@NotNull Iterable<PsiType> collection, @NotNull PsiManager manager) {
        Iterator<PsiType> iterator;
        if (collection == null) {
            TypesUtil.$$$reportNull$$$0(52);
        }
        if (manager == null) {
            TypesUtil.$$$reportNull$$$0(53);
        }
        if (!(iterator = collection.iterator()).hasNext()) {
            return null;
        }
        PsiType result = iterator.next();
        while (iterator.hasNext()) {
            result = TypesUtil.getLeastUpperBoundNullable(result, iterator.next(), manager);
        }
        return result;
    }

    @Nullable
    public static PsiType getLeastUpperBound(@NotNull PsiType type1, @NotNull PsiType type2, PsiManager manager) {
        PsiType numericLUB;
        if (type1 == null) {
            TypesUtil.$$$reportNull$$$0(54);
        }
        if (type2 == null) {
            TypesUtil.$$$reportNull$$$0(55);
        }
        if ((numericLUB = TypesUtil.getNumericLUB(type1, type2)) != null) {
            return numericLUB;
        }
        if (type1 instanceof GrTupleType && type2 instanceof GrTupleType) {
            GrTupleType tuple1 = (GrTupleType)type1;
            GrTupleType tuple2 = (GrTupleType)type2;
            PsiType[] components1 = tuple1.getComponentTypes();
            PsiType[] components2 = tuple2.getComponentTypes();
            if (components1.length == 0) {
                return TypesUtil.genNewListBy(type2, manager);
            }
            if (components2.length == 0) {
                return TypesUtil.genNewListBy(type1, manager);
            }
            PsiType[] components3 = PsiType.createArray((int)Math.min(components1.length, components2.length));
            for (int i = 0; i < components3.length; ++i) {
                PsiType c1 = components1[i];
                PsiType c2 = components2[i];
                components3[i] = c1 == null || c2 == null ? null : TypesUtil.getLeastUpperBound(c1, c2, manager);
            }
            return new GrImmediateTupleType(components3, JavaPsiFacade.getInstance((Project)manager.getProject()), tuple1.getScope().intersectWith(tuple2.getResolveScope()));
        }
        if (TypesUtil.checkEmptyListAndList(type1, type2)) {
            return TypesUtil.genNewListBy(type2, manager);
        }
        if (TypesUtil.checkEmptyListAndList(type2, type1)) {
            return TypesUtil.genNewListBy(type1, manager);
        }
        if (type1 instanceof GrMapType && type2 instanceof GrMapType) {
            return GrMapType.merge((GrMapType)type1, (GrMapType)type2);
        }
        if (TypesUtil.checkEmptyMapAndMap(type1, type2)) {
            return TypesUtil.genNewMapBy(type2, manager);
        }
        if (TypesUtil.checkEmptyMapAndMap(type2, type1)) {
            return TypesUtil.genNewMapBy(type1, manager);
        }
        if (type1 instanceof GrClosureType && type2 instanceof GrClosureType) {
            GrClosureSignature signature;
            GrClosureType clType1 = (GrClosureType)type1;
            GrClosureType clType2 = (GrClosureType)type2;
            GrSignature signature1 = clType1.getSignature();
            GrSignature signature2 = clType2.getSignature();
            if (signature1 instanceof GrClosureSignature && signature2 instanceof GrClosureSignature && ((GrClosureSignature)signature1).getParameterCount() == ((GrClosureSignature)signature2).getParameterCount() && (signature = GrImmediateClosureSignatureImpl.getLeastUpperBound((GrClosureSignature)signature1, (GrClosureSignature)signature2, manager)) != null) {
                GlobalSearchScope scope = clType1.getResolveScope().intersectWith(clType2.getResolveScope());
                LanguageLevel languageLevel = (LanguageLevel)ComparatorUtil.max((Comparable)clType1.getLanguageLevel(), (Comparable)clType2.getLanguageLevel());
                return GrClosureType.create(signature, scope, JavaPsiFacade.getInstance((Project)manager.getProject()), languageLevel, true);
            }
        } else {
            if ("groovy.lang.GString".equals(TypesUtil.getQualifiedName(type1)) && "java.lang.String".equals(TypesUtil.getQualifiedName(type2))) {
                return type2;
            }
            if ("groovy.lang.GString".equals(TypesUtil.getQualifiedName(type2)) && "java.lang.String".equals(TypesUtil.getQualifiedName(type1))) {
                return type1;
            }
        }
        return GenericsUtil.getLeastUpperBound((PsiType)type1, (PsiType)type2, (PsiManager)manager);
    }

    @Nullable
    private static PsiType getNumericLUB(@Nullable PsiType type1, @Nullable PsiType type2) {
        PsiPrimitiveType unboxedType1 = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)type1);
        PsiPrimitiveType unboxedType2 = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)type2);
        if (unboxedType1 != null && unboxedType2 != null) {
            int i1 = LUB_NUMERIC_TYPES.indexOf(unboxedType1);
            int i2 = LUB_NUMERIC_TYPES.indexOf(unboxedType2);
            if (i1 >= 0 && i2 >= 0) {
                if (i1 > i2) {
                    return type1;
                }
                if (i2 >= i1) {
                    return type2;
                }
            }
        }
        return null;
    }

    private static boolean checkEmptyListAndList(PsiType type1, PsiType type2) {
        PsiType[] types;
        return type1 instanceof GrTupleType && (types = ((GrTupleType)type1).getComponentTypes()).length == 0 && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.List");
    }

    private static PsiType genNewListBy(PsiType genericOwner, PsiManager manager) {
        PsiClass list = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.List", genericOwner.getResolveScope());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (list == null) {
            return factory.createTypeFromText("java.util.List", null);
        }
        return factory.createType(list, PsiUtil.extractIterableTypeParameter((PsiType)genericOwner, (boolean)false));
    }

    private static boolean checkEmptyMapAndMap(PsiType type1, PsiType type2) {
        return type1 instanceof GrMapType && ((GrMapType)type1).isEmpty() && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map");
    }

    private static PsiType genNewMapBy(PsiType genericOwner, PsiManager manager) {
        PsiClass map2 = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.Map", genericOwner.getResolveScope());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (map2 == null) {
            return factory.createTypeFromText("java.util.Map", null);
        }
        PsiType key = PsiUtil.substituteTypeParameter((PsiType)genericOwner, (String)"java.util.Map", (int)0, (boolean)false);
        PsiType value = PsiUtil.substituteTypeParameter((PsiType)genericOwner, (String)"java.util.Map", (int)1, (boolean)false);
        return factory.createType(map2, new PsiType[]{key, value});
    }

    @Nullable
    public static PsiType getPsiType(PsiElement context, IElementType elemType) {
        if (elemType == GroovyTokenTypes.kNULL) {
            return PsiType.NULL;
        }
        String typeName = TypesUtil.getBoxedTypeName(elemType);
        if (typeName != null) {
            return TypesUtil.createTypeByFQClassName(typeName, context);
        }
        return null;
    }

    @Nullable
    public static String getBoxedTypeName(IElementType elemType) {
        return ourPrimitiveTypesToClassNames.get(elemType);
    }

    @NotNull
    public static PsiType getLeastUpperBound(PsiType[] classes, PsiManager manager) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (classes.length == 0) {
            PsiClassType psiClassType = factory.createTypeByFQClassName("java.lang.Object");
            if (psiClassType == null) {
                TypesUtil.$$$reportNull$$$0(56);
            }
            return psiClassType;
        }
        PsiType type = classes[0];
        for (int i = 1; i < classes.length; ++i) {
            PsiType t = TypesUtil.getLeastUpperBound(type, classes[i], manager);
            if (t == null) continue;
            type = t;
        }
        PsiType psiType = type;
        if (psiType == null) {
            TypesUtil.$$$reportNull$$$0(57);
        }
        return psiType;
    }

    @Contract(value="null, _ -> false")
    public static boolean isClassType(@Nullable PsiType type, @NotNull String qName) {
        if (qName == null) {
            TypesUtil.$$$reportNull$$$0(58);
        }
        return qName.equals(TypesUtil.getQualifiedName(type));
    }

    public static PsiSubstitutor composeSubstitutors(PsiSubstitutor s1, PsiSubstitutor s2) {
        Map map2 = s1.getSubstitutionMap();
        THashMap result = new THashMap(map2.size());
        for (PsiTypeParameter parameter : map2.keySet()) {
            result.put(parameter, s2.substitute((PsiType)map2.get(parameter)));
        }
        Map map22 = s2.getSubstitutionMap();
        for (PsiTypeParameter parameter : map22.keySet()) {
            if (result.containsKey(parameter)) continue;
            result.put(parameter, map22.get(parameter));
        }
        return PsiSubstitutorImpl.createSubstitutor((Map)result);
    }

    @NotNull
    public static PsiClassType createTypeByFQClassName(@NotNull String fqName, @NotNull PsiElement context) {
        if (fqName == null) {
            TypesUtil.$$$reportNull$$$0(59);
        }
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(60);
        }
        PsiClassType psiClassType = GroovyPsiManager.getInstance(context.getProject()).createTypeByFQClassName(fqName, context.getResolveScope());
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(61);
        }
        return psiClassType;
    }

    @Nullable
    public static PsiType createJavaLangClassType(@Nullable PsiType type, Project project, GlobalSearchScope resolveScope) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClassType result = null;
        PsiClass javaLangClass = facade.findClass("java.lang.Class", resolveScope);
        if (javaLangClass != null) {
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], type);
            }
            result = facade.getElementFactory().createType(javaLangClass, substitutor);
        }
        return result;
    }

    @NotNull
    public static PsiPrimitiveType getPrimitiveTypeByText(String typeText) {
        for (PsiPrimitiveType primitive : PRIMITIVES) {
            if (PsiType.VOID.equals((Object)primitive)) {
                PsiPrimitiveType psiPrimitiveType = primitive;
                if (psiPrimitiveType == null) {
                    TypesUtil.$$$reportNull$$$0(62);
                }
                return psiPrimitiveType;
            }
            if (!primitive.getCanonicalText().equals(typeText)) continue;
            PsiPrimitiveType psiPrimitiveType = primitive;
            if (psiPrimitiveType == null) {
                TypesUtil.$$$reportNull$$$0(63);
            }
            return psiPrimitiveType;
        }
        assert (false) : "Unknown primitive type";
        if (null == null) {
            TypesUtil.$$$reportNull$$$0(64);
        }
        return null;
    }

    @NotNull
    public static PsiClassType createGenericType(@NotNull String fqn, @NotNull PsiElement context, @Nullable PsiType type) {
        GlobalSearchScope resolveScope;
        JavaPsiFacade facade;
        PsiClass clazz;
        if (fqn == null) {
            TypesUtil.$$$reportNull$$$0(65);
        }
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(66);
        }
        if ((clazz = (facade = JavaPsiFacade.getInstance((Project)context.getProject())).findClass(fqn, resolveScope = context.getResolveScope())) == null || clazz.getTypeParameters().length != 1) {
            PsiClassType psiClassType = facade.getElementFactory().createTypeByFQClassName(fqn, resolveScope);
            if (psiClassType == null) {
                TypesUtil.$$$reportNull$$$0(67);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = type == null ? facade.getElementFactory().createType(clazz) : facade.getElementFactory().createType(clazz, type);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(68);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType createIterableType(@NotNull PsiElement context, @Nullable PsiType type) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(69);
        }
        PsiClassType psiClassType = TypesUtil.createGenericType("java.lang.Iterable", context, type);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(70);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType createListType(@NotNull PsiElement context, @Nullable PsiType type) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(71);
        }
        PsiType boxedType = TypesUtil.boxPrimitiveType(type, context.getManager(), context.getResolveScope());
        PsiClassType psiClassType = TypesUtil.createGenericType("java.util.List", context, boxedType);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(72);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType createListType(@NotNull PsiClass elements) {
        if (elements == null) {
            TypesUtil.$$$reportNull$$$0(73);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)elements.getProject());
        PsiClassType psiClassType = TypesUtil.createGenericType("java.util.List", (PsiElement)elements, (PsiType)facade.getElementFactory().createType(elements));
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(74);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiType createSetType(@NotNull PsiElement context, @NotNull PsiType type) {
        if (context == null) {
            TypesUtil.$$$reportNull$$$0(75);
        }
        if (type == null) {
            TypesUtil.$$$reportNull$$$0(76);
        }
        PsiClassType psiClassType = TypesUtil.createGenericType("java.util.Set", context, type);
        if (psiClassType == null) {
            TypesUtil.$$$reportNull$$$0(77);
        }
        return psiClassType;
    }

    public static boolean isAnnotatedCheckHierarchyWithCache(@NotNull PsiClass aClass, @NotNull String annotationFQN) {
        if (aClass == null) {
            TypesUtil.$$$reportNull$$$0(78);
        }
        if (annotationFQN == null) {
            TypesUtil.$$$reportNull$$$0(79);
        }
        Map<String, PsiClass> classMap = ClassUtil.getSuperClassesWithCache(aClass);
        for (PsiClass psiClass : classMap.values()) {
            PsiModifierList modifierList = psiClass.getModifierList();
            if (modifierList == null || modifierList.findAnnotation(annotationFQN) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiType substituteAndNormalizeType(@Nullable PsiType type, @NotNull PsiSubstitutor substitutor, @Nullable SpreadState state, @NotNull GrExpression expression) {
        if (substitutor == null) {
            TypesUtil.$$$reportNull$$$0(80);
        }
        if (expression == null) {
            TypesUtil.$$$reportNull$$$0(81);
        }
        if (type == null) {
            return null;
        }
        if ((type = substitutor.substitute(type)) == null) {
            return null;
        }
        type = PsiImplUtil.normalizeWildcardTypeByPosition(type, expression);
        type = SpreadState.apply(type, state, expression.getProject());
        return type;
    }

    @Nullable
    public static PsiType getItemType(@Nullable PsiType containerType) {
        if (containerType == null) {
            return null;
        }
        if (containerType instanceof PsiArrayType) {
            return ((PsiArrayType)containerType).getComponentType();
        }
        return PsiUtil.extractIterableTypeParameter((PsiType)containerType, (boolean)false);
    }

    @Nullable
    public static PsiType inferAnnotationMemberValueType(GrAnnotationMemberValue value) {
        if (value instanceof GrExpression) {
            return ((GrExpression)value).getType();
        }
        if (value instanceof GrAnnotation) {
            PsiElement resolved = ((GrAnnotation)value).getClassReference().resolve();
            if (resolved instanceof PsiClass) {
                return JavaPsiFacade.getElementFactory((Project)value.getProject()).createType((PsiClass)resolved, PsiSubstitutor.EMPTY);
            }
            return null;
        }
        if (value instanceof GrAnnotationArrayInitializer) {
            return TypesUtil.getTupleByAnnotationArrayInitializer((GrAnnotationArrayInitializer)value);
        }
        return null;
    }

    public static PsiType getTupleByAnnotationArrayInitializer(final GrAnnotationArrayInitializer value) {
        return new GrTupleType(value.getResolveScope(), JavaPsiFacade.getInstance((Project)value.getProject())){

            @Override
            @NotNull
            protected PsiType[] inferComponents() {
                Object[] initializers = value.getInitializers();
                PsiType[] psiTypeArray = (PsiType[])ContainerUtil.map((Object[])initializers, value1 -> TypesUtil.inferAnnotationMemberValueType(value1), (Object[])PsiType.createArray((int)initializers.length));
                if (psiTypeArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiTypeArray;
            }

            public boolean isValid() {
                return value.isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil$1", "inferComponents"));
            }
        };
    }

    public static boolean resolvesTo(PsiType type, String fqn) {
        if (type instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type).resolve();
            return resolved != null && fqn.equals(resolved.getQualifiedName());
        }
        return false;
    }

    @Nullable
    public static PsiType rawSecondGeneric(PsiType type, Project project) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult result = ((PsiClassType)type).resolveGenerics();
        PsiClass element = result.getElement();
        if (element == null) {
            return null;
        }
        PsiType[] parameters = ((PsiClassType)type).getParameters();
        boolean changed = false;
        for (int i = 0; i < parameters.length; ++i) {
            PsiType parameter = parameters[i];
            if (parameter == null) continue;
            final Ref newParam = new Ref();
            parameter.accept((PsiTypeVisitor)new PsiTypeVisitorEx<Object>(){

                @Nullable
                public Object visitClassType(PsiClassType classType) {
                    newParam.set((Object)classType.rawType());
                    return null;
                }

                @Nullable
                public Object visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                    newParam.set((Object)capturedWildcardType.getWildcard().getBound());
                    return null;
                }

                @Nullable
                public Object visitWildcardType(PsiWildcardType wildcardType) {
                    newParam.set((Object)wildcardType.getBound());
                    return null;
                }
            });
            if (newParam.isNull()) continue;
            changed = true;
            parameters[i] = (PsiType)newParam.get();
        }
        if (!changed) {
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)project).createType(element, parameters);
    }

    public static boolean isPsiClassTypeToClosure(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null) {
            return false;
        }
        return "groovy.lang.Closure".equals(psiClass.getQualifiedName());
    }

    @Nullable
    public static String getQualifiedName(@Nullable PsiType type) {
        if (type instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type).resolve();
            if (resolved instanceof PsiAnonymousClass) {
                return "anonymous " + TypesUtil.getQualifiedName((PsiType)((PsiAnonymousClass)resolved).getBaseClassType());
            }
            if (resolved != null) {
                return resolved.getQualifiedName();
            }
            return PsiNameHelper.getQualifiedClassName((String)type.getCanonicalText(), (boolean)true);
        }
        return null;
    }

    public static boolean isEnum(PsiType type) {
        if (type instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type).resolve();
            return resolved != null && resolved.isEnum();
        }
        return false;
    }

    static {
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mSTRING_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mGSTRING_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mREGEX_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_INT, "java.lang.Integer");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_LONG, "java.lang.Long");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_FLOAT, "java.lang.Float");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_DOUBLE, "java.lang.Double");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_BIG_INT, "java.math.BigInteger");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_BIG_DECIMAL, "java.math.BigDecimal");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kFALSE, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kTRUE, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kNULL, NULL);
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kINT, "java.lang.Integer");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kLONG, "java.lang.Long");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kFLOAT, "java.lang.Float");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kDOUBLE, "java.lang.Double");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kBOOLEAN, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kCHAR, "java.lang.Character");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kBYTE, "java.lang.Byte");
        ourOperationsToOperatorNames = new HashMap();
        ourUnaryOperationsToOperatorNames = new HashMap();
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mPLUS, "plus");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mMINUS, "minus");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mBAND, "and");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mBOR, "or");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mBXOR, "xor");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mDIV, "div");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mMOD, "mod");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mSTAR, "multiply");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.kAS, "asType");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mCOMPARE_TO, "compareTo");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mGT, "compareTo");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mGE, "compareTo");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mLT, "compareTo");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mLE, "compareTo");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mSTAR_STAR, "power");
        ourOperationsToOperatorNames.put(GroovyElementTypes.COMPOSITE_LSHIFT_SIGN, "leftShift");
        ourOperationsToOperatorNames.put(GroovyElementTypes.COMPOSITE_RSHIFT_SIGN, "rightShift");
        ourOperationsToOperatorNames.put(GroovyElementTypes.COMPOSITE_TRIPLE_SHIFT_SIGN, "rightShiftUnsigned");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mEQUAL, "equals");
        ourOperationsToOperatorNames.put(GroovyTokenTypes.mNOT_EQUAL, "equals");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mLNOT, "asBoolean");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mPLUS, "positive");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mMINUS, "negative");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mDEC, "previous");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mINC, "next");
        ourUnaryOperationsToOperatorNames.put(GroovyTokenTypes.mBNOT, "bitwiseNegate");
        TYPE_TO_RANK = new TObjectIntHashMap();
        TYPE_TO_RANK.put((Object)"java.lang.Byte", 1);
        TYPE_TO_RANK.put((Object)"java.lang.Character", 2);
        TYPE_TO_RANK.put((Object)"java.lang.Short", 3);
        TYPE_TO_RANK.put((Object)"java.lang.Integer", 4);
        TYPE_TO_RANK.put((Object)"java.lang.Long", 5);
        TYPE_TO_RANK.put((Object)"java.math.BigInteger", 6);
        TYPE_TO_RANK.put((Object)"java.math.BigDecimal", 7);
        TYPE_TO_RANK.put((Object)"java.lang.Float", 8);
        TYPE_TO_RANK.put((Object)"java.lang.Double", 9);
        TYPE_TO_RANK.put((Object)"java.lang.Number", 10);
        RANK_TO_TYPE = new TIntObjectHashMap();
        TYPE_TO_RANK.forEachEntry((fqn, rank) -> {
            RANK_TO_TYPE.put(rank, fqn);
            return true;
        });
        LUB_NUMERIC_TYPES = ContainerUtil.newArrayList((Object[])new PsiType[]{PsiType.BYTE, PsiType.SHORT, PsiType.INT, PsiType.LONG, PsiType.FLOAT, PsiType.DOUBLE});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 77: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 77: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil";
                break;
            }
            case 8: 
            case 11: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 30: 
            case 35: 
            case 43: 
            case 49: 
            case 60: 
            case 66: 
            case 69: 
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 23: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 10: 
            case 24: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 37: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 39: 
            case 41: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/TypesUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloadedOperatorCandidates";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "canAssign";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "canCast";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "canAssignWithinMultipleAssignment";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "optionalUnbox";
                break;
            }
            case 44: 
            case 46: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaLangObject";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeastUpperBound";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeByFQClassName";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveTypeByText";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenericType";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterableType";
                break;
            }
            case 72: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "createListType";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadedOperatorCandidates";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 77: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadedUnaryOperatorCandidates";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canAssign";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableByMethodCallConversion";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableByParameter";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "areTypesConvertible";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableWithoutConversions";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "canCast";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "canAssignWithinMultipleAssignment";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "optionalUnbox";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "boxPrimitiveType";
                break;
            }
            case 43: 
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangObject";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getLeastUpperBoundNullable";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getLeastUpperBound";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isClassType";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByFQClassName";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createGenericType";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createIterableType";
                break;
            }
            case 71: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "createListType";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createSetType";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedCheckHierarchyWithCache";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "substituteAndNormalizeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 31: 
            case 32: 
            case 36: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 77: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

