/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.ChangeCreator;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.LastSuccessfulUpdateTracker;
import org.jetbrains.idea.perforce.application.LocalPathsSet;
import org.jetbrains.idea.perforce.application.OpenedResultProcessor;
import org.jetbrains.idea.perforce.application.PerforceChangeListCalculator;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.application.PerforceReadOnlyFileStateManager;
import org.jetbrains.idea.perforce.application.PerforceShelf;
import org.jetbrains.idea.perforce.application.PerforceUnversionedTracker;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.ResolvedFilesWrapper;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.PerforceChangeCache;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;

public class PerforceChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceChangeProvider");
    private final Project myProject;
    private final PerforceRunner myRunner;
    private final LastSuccessfulUpdateTracker myLastSuccessfulUpdateTracker;
    private final PerforceNumberNameSynchronizer mySynchronizer;
    private final PerforceReadOnlyFileStateManager myPerforceReadOnlyFileStateManager;
    private final Map<VirtualFile, Boolean> myAlwaysWritable = new ConcurrentHashMap<VirtualFile, Boolean>();
    private PerforceShelf myShelf;

    public PerforceChangeProvider(PerforceVcs vcs) {
        this.myProject = vcs.getProject();
        this.myRunner = PerforceRunner.getInstance(this.myProject);
        this.myLastSuccessfulUpdateTracker = LastSuccessfulUpdateTracker.getInstance(this.myProject);
        this.mySynchronizer = PerforceNumberNameSynchronizer.getInstance(this.myProject);
        this.myPerforceReadOnlyFileStateManager = new PerforceReadOnlyFileStateManager(this.myProject);
        this.myShelf = PerforceManager.getInstance(this.myProject).getShelf();
    }

    public void activate() {
        this.myPerforceReadOnlyFileStateManager.activate();
    }

    public void deactivate() {
        this.myPerforceReadOnlyFileStateManager.deactivate();
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        if (dirtyScope == null) {
            PerforceChangeProvider.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            PerforceChangeProvider.$$$reportNull$$$0(1);
        }
        if (progress == null) {
            PerforceChangeProvider.$$$reportNull$$$0(2);
        }
        if (addGate == null) {
            PerforceChangeProvider.$$$reportNull$$$0(3);
        }
        PerforceChangeProvider.logDebug("getting changes for scope " + dirtyScope);
        this.myLastSuccessfulUpdateTracker.updateStarted();
        this.myShelf.clearShelf();
        PerforceManager.getInstance(this.myProject).clearInfoClientCache();
        PerforceChangeCache changeCache = new PerforceChangeCache(this.myProject);
        MultiMap<ConnectionKey, PerforceChangeList> allLists = this.calcChangeListMap(changeCache);
        this.refreshSynchronizer(addGate, allLists);
        ChangeCreator creator = new ChangeCreator(this.myProject);
        Map<ConnectionKey, P4Connection> key2connection = PerforceSettings.getSettings(this.myProject).getConnectionsByKeys();
        MultiMap<ConnectionKey, VirtualFile> roots = this.getAffectedRoots(dirtyScope);
        for (ConnectionKey key : roots.keySet()) {
            P4Connection connection = key2connection.get(key);
            if (connection == null) continue;
            this.processConnection(connection, builder, roots.get((Object)key), progress, addGate, allLists.get((Object)key), dirtyScope, changeCache, creator);
        }
        this.myPerforceReadOnlyFileStateManager.getChanges(dirtyScope, builder, progress, addGate);
        Set<VirtualFile> writableFiles = PerforceChangeProvider.collectWritableFiles(dirtyScope);
        for (VirtualFile file : PerforceVcs.getInstance(this.myProject).getAsyncEditedFiles()) {
            if (!writableFiles.contains(file)) continue;
            this.processAsyncEdit(file, builder, creator);
            writableFiles.remove(file);
        }
        this.reportModifiedWithoutCheckout(builder, creator, writableFiles);
        this.myLastSuccessfulUpdateTracker.updateSuccessful();
    }

    private void reportModifiedWithoutCheckout(ChangelistBuilder builder, ChangeCreator creator, Set<VirtualFile> writableFiles) throws VcsException {
        ArrayList unknown = ContainerUtil.newArrayList();
        for (VirtualFile file : writableFiles) {
            PerforceUnversionedTracker tracker = this.myPerforceReadOnlyFileStateManager.getUnversionedTracker();
            if (creator.reportedChanges.contains(file) || tracker.isUnversioned(file) || tracker.isIgnored(file) || PerforceChangeProvider.isBrokenSymlink(file)) continue;
            Boolean alwaysWritable = this.myAlwaysWritable.get(file);
            if (alwaysWritable == Boolean.FALSE) {
                PerforceChangeProvider.logDebug("reportModifiedWithoutCheckout, hijacked file = " + file);
                builder.processModifiedWithoutCheckout(file);
                continue;
            }
            if (alwaysWritable != null) continue;
            PerforceChangeProvider.logDebug("reportModifiedWithoutCheckout, unknown file = " + file);
            unknown.add(file);
        }
        if (!unknown.isEmpty() && SystemProperties.getBooleanProperty((String)"perforce.always.writable.check.enabled", (boolean)true)) {
            MultiMap<P4Connection, VirtualFile> map = FileGrouper.distributeFilesByConnection(unknown, this.myProject);
            for (P4Connection connection : map.keySet()) {
                for (VirtualFile file : this.getHijackedFiles(map, connection)) {
                    builder.processModifiedWithoutCheckout(file);
                }
            }
        }
    }

    static boolean isBrokenSymlink(VirtualFile file) {
        return file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null;
    }

    private List<VirtualFile> getHijackedFiles(MultiMap<P4Connection, VirtualFile> map, P4Connection connection) throws VcsException {
        if (PerforceChangeProvider.isAllWriteWorkspace(connection, this.myProject)) {
            return Collections.emptyList();
        }
        ArrayList files = ContainerUtil.newArrayList((Iterable)map.get((Object)connection));
        List paths = ContainerUtil.map((Collection)files, file -> P4File.escapeWildcards(file.getPath()));
        List<String> output = this.myRunner.files(paths, connection);
        ArrayList hijacked = ContainerUtil.newArrayList();
        int fileIndex = 0;
        for (String line : output) {
            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
            if (fileIndex >= files.size()) break;
            int lParen = line.lastIndexOf(40);
            if (lParen < 0) continue;
            VirtualFile file2 = (VirtualFile)files.get(fileIndex);
            PerforceChangeProvider.logDebug("getHijackedFiles, checking file = " + file2 + "; line = " + line);
            boolean expectedWritable = line.substring(lParen).contains("+w");
            this.myAlwaysWritable.put(file2, expectedWritable);
            if (!expectedWritable) {
                hijacked.add(file2);
            }
            ++fileIndex;
        }
        return hijacked;
    }

    public static boolean isAllWriteWorkspace(@NotNull P4Connection connection, @NotNull Project project) {
        List<String> options;
        if (connection == null) {
            PerforceChangeProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PerforceChangeProvider.$$$reportNull$$$0(5);
        }
        return (options = PerforceManager.getInstance(project).getClient(connection).getCachedOptions()) != null && options.contains("allwrite");
    }

    private static void logDebug(String message) {
        LOG.debug(message);
    }

    private MultiMap<ConnectionKey, VirtualFile> getAffectedRoots(VcsDirtyScope dirtyScope) throws VcsException {
        PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance(this.myProject);
        MultiMap roots = new MultiMap();
        for (VirtualFile root : dirtyScope.getAffectedContentRoots()) {
            P4Connection connection = connectionManager.getConnectionForFile(root);
            if (connection == null) continue;
            PerforceManager.ensureValidClient(this.myProject, connection);
            ConnectionKey key = connection.getConnectionKey();
            roots.putValue((Object)key, (Object)root);
        }
        return roots;
    }

    private boolean shouldShowChangeList(PerforceChangeList pcl, Collection<VirtualFile> allRoots, P4Connection connection) {
        if (pcl.getChanges().isEmpty()) {
            return !this.mySynchronizer.isHidden(pcl.getNumber());
        }
        if (this.myShelf.hasLocalChanges(connection.getConnectionKey(), pcl.getNumber())) {
            return true;
        }
        return ContainerUtil.or(allRoots, root -> !pcl.getChangesUnder((VirtualFile)root).isEmpty());
    }

    private MultiMap<ConnectionKey, PerforceChangeList> calcChangeListMap(PerforceChangeCache changeCache) throws VcsException {
        MultiMap allLists = MultiMap.create();
        for (Pair<P4Connection, Collection<VirtualFile>> pair : PerforceVcs.getInstance(this.myProject).getRootsByConnections()) {
            P4Connection connection = (P4Connection)pair.first;
            PerforceManager.ensureValidClient(this.myProject, connection);
            allLists.putValues((Object)connection.getConnectionKey(), this.getPendingChangeListsUnderRoots(changeCache, connection, (Collection)pair.second));
        }
        return allLists;
    }

    private List<PerforceChangeList> getPendingChangeListsUnderRoots(PerforceChangeCache changeCache, P4Connection connection, Collection<VirtualFile> allRoots) throws VcsException {
        List<PerforceChangeList> perforceLists = this.myRunner.getPendingChangeLists(connection, changeCache);
        if (perforceLists.isEmpty()) {
            return perforceLists;
        }
        this.myRunner.fillChangeCache(connection, changeCache, this.myShelf, perforceLists);
        ArrayList filtered = ContainerUtil.newArrayList();
        for (PerforceChangeList pcl : perforceLists) {
            if (!this.shouldShowChangeList(pcl, allRoots, connection)) continue;
            this.mySynchronizer.setHidden(pcl.getNumber(), false);
            filtered.add(pcl);
        }
        return filtered;
    }

    static Set<VirtualFile> collectWritableFiles(VcsDirtyScope dirtyScope) {
        HashSet<VirtualFile> writableFiles = new HashSet<VirtualFile>();
        dirtyScope.iterateExistingInsideScope(vf -> {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (vf.isValid() && !vf.isDirectory() && vf.isWritable() && !ChangeListManager.getInstance((Project)dirtyScope.getProject()).isIgnoredFile(vf)) {
                    writableFiles.add((VirtualFile)vf);
                }
            });
            return true;
        });
        return writableFiles;
    }

    private void processAsyncEdit(VirtualFile file, ChangelistBuilder builder, ChangeCreator changeCreator) throws VcsException {
        long revision = this.myRunner.haveRevision(P4File.create(file));
        if (revision > 0L) {
            FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
            builder.processChange(changeCreator.createEditedFileChange(filePath, revision, false), PerforceVcs.getKey());
        }
    }

    private void refreshSynchronizer(ChangeListManagerGate addGate, MultiMap<ConnectionKey, PerforceChangeList> allLists) {
        for (ConnectionKey key : allLists.keySet()) {
            addGate.setListsToDisappear(this.mySynchronizer.acceptInfo(key, allLists.get((Object)key), addGate));
        }
    }

    private void processConnection(@NotNull P4Connection connection, ChangelistBuilder builder, Collection<VirtualFile> roots, ProgressIndicator progress, ChangeListManagerGate addGate, Collection<PerforceChangeList> allLists, VcsDirtyScope dirtyScope, PerforceChangeCache changeCache, ChangeCreator changeCreator) throws VcsException {
        if (connection == null) {
            PerforceChangeProvider.$$$reportNull$$$0(6);
        }
        progress.checkCanceled();
        LocalPathsSet resolvedWithConflictsMap = this.myRunner.getResolvedWithConflictsMap(connection, roots);
        ResolvedFilesWrapper resolvedFilesWrapper = new ResolvedFilesWrapper(this.myRunner.getResolvedFiles(connection, roots));
        ArrayList<PerforceChange> changes = new ArrayList<PerforceChange>();
        for (VirtualFile root : roots) {
            changes.addAll(this.getChangesUnder(connection, root, dirtyScope, allLists, changeCache));
        }
        PerforceChangeListCalculator changeListCalculator = new PerforceChangeListCalculator(this.myProject, connection, addGate);
        OpenedResultProcessor processor = new OpenedResultProcessor(connection, changeCreator, builder, resolvedWithConflictsMap, resolvedFilesWrapper, changeListCalculator);
        processor.process(changes);
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return false;
    }

    public void doCleanup(List<VirtualFile> files) {
    }

    public void discardCache() {
        this.myPerforceReadOnlyFileStateManager.discardUnversioned();
        this.myAlwaysWritable.clear();
    }

    public void imitateLostFocus() {
        this.myPerforceReadOnlyFileStateManager.processFocusLost();
    }

    private List<PerforceChange> getChangesUnder(P4Connection connection, @NotNull VirtualFile root, VcsDirtyScope dirtyScope, Collection<PerforceChangeList> allLists, PerforceChangeCache changeCache) throws VcsException {
        if (root == null) {
            PerforceChangeProvider.$$$reportNull$$$0(7);
        }
        ArrayList<PerforceChange> perforceChanges = new ArrayList<PerforceChange>();
        List<PerforceChange> defChanges = PerforceChangeProvider.filterByRoot(root, dirtyScope, changeCache.getChanges(connection, -1L, root));
        if (!defChanges.isEmpty()) {
            this.myRunner.setChangeRevisionsFromHave(connection, defChanges);
            perforceChanges.addAll(defChanges);
        }
        for (PerforceChangeList changeList : allLists) {
            perforceChanges.addAll(PerforceChangeProvider.filterByRoot(root, dirtyScope, changeCache.getChanges(connection, changeList.getNumber(), root)));
        }
        return perforceChanges;
    }

    private static List<PerforceChange> filterByRoot(VirtualFile root, VcsDirtyScope dirtyScope, List<PerforceChange> perforceChanges) {
        File ioRoot = new File(root.getPath());
        ArrayList result = ContainerUtil.newArrayList();
        for (PerforceChange perforceChange : perforceChanges) {
            File file = perforceChange.getFile();
            if (file == null || !FileUtil.isAncestor((File)ioRoot, (File)file, (boolean)false) || !dirtyScope.belongsTo(VcsUtil.getFilePath((File)file))) continue;
            result.add(perforceChange);
        }
        return result;
    }

    public void clearUnversionedStatus(@NotNull VirtualFile file) {
        if (file == null) {
            PerforceChangeProvider.$$$reportNull$$$0(8);
        }
        this.myPerforceReadOnlyFileStateManager.getUnversionedTracker().reportRecheck(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addGate";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceChangeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChanges";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllWriteWorkspace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processConnection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getChangesUnder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "clearUnversionedStatus";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

