/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.play.language.PlayLanguage;
import com.intellij.play.utils.PlayUtils;
import com.intellij.psi.LanguageSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayLanguageSubstitutor
extends LanguageSubstitutor {
    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        VirtualFile tagsDir;
        if (file == null) {
            PlayLanguageSubstitutor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PlayLanguageSubstitutor.$$$reportNull$$$0(1);
        }
        if (file instanceof VirtualFileWindow) {
            return null;
        }
        if (file.getFileType() == StdFileTypes.HTML && PlayLanguageSubstitutor.checkViewsParent(file) && PlayUtils.isPlayInstalled(project)) {
            return PlayLanguage.INSTANCE;
        }
        if ("tag".equals(file.getExtension()) && PlayLanguageSubstitutor.checkDirName(tagsDir = file.getParent(), "tags") && PlayLanguageSubstitutor.checkDirName(tagsDir.getParent(), "views") && PlayUtils.isPlayInstalled(project)) {
            return PlayLanguage.INSTANCE;
        }
        return null;
    }

    private static boolean checkDirName(@Nullable VirtualFile tagsDir, @NotNull String dirName) {
        if (dirName == null) {
            PlayLanguageSubstitutor.$$$reportNull$$$0(2);
        }
        return tagsDir != null && dirName.equals(tagsDir.getName());
    }

    private static boolean checkViewsParent(@NotNull VirtualFile file) {
        if (file == null) {
            PlayLanguageSubstitutor.$$$reportNull$$$0(3);
        }
        for (VirtualFile parent = file.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isDirectory() || !"views".equals(parent.getName())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/play/language/PlayLanguageSubstitutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDirName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkViewsParent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

