/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils.routes;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RouterLineDescriptor {
    private static Pattern routePattern = Pattern.compile("^(GET|POST|PUT|DELETE|OPTIONS|HEAD|WS|\\*)[((]?([^)]*)\\)?\\s+(.*/[^\\s]*)\\s+([^\\s(]+)(.+)?(\\s*)$");
    private Pair<String, Integer> myMethod;
    private Pair<String, Integer> myAction;
    private Pair<String, Integer> myPath;
    private String myLine;
    private int myStartOffset;

    public RouterLineDescriptor(@NotNull String line, int startOffset) {
        String action;
        if (line == null) {
            RouterLineDescriptor.$$$reportNull$$$0(0);
        }
        this.myLine = line;
        this.myStartOffset = startOffset;
        Matcher matcher = routePattern.matcher(line);
        if (matcher.matches() && !StringUtil.isEmptyOrSpaces((String)(action = matcher.group(4))) && !action.startsWith("module:")) {
            String path;
            this.myAction = Pair.create((Object)action, (Object)(startOffset + line.indexOf(action)));
            String method = matcher.group(1);
            if (!StringUtil.isEmptyOrSpaces((String)method)) {
                this.myMethod = Pair.create((Object)action, (Object)(startOffset + line.indexOf(method)));
            }
            if (!StringUtil.isEmptyOrSpaces((String)(path = matcher.group(3)))) {
                this.myPath = Pair.create((Object)action, (Object)(startOffset + line.indexOf(path)));
            }
        }
    }

    public String getLine() {
        return this.myLine;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    @Nullable
    public Pair<String, Integer> getMethod() {
        return this.myMethod;
    }

    @Nullable
    public Pair<String, Integer> getAction() {
        return this.myAction;
    }

    @Nullable
    public Pair<String, Integer> getPath() {
        return this.myPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/play/utils/routes/RouterLineDescriptor", "<init>"));
    }
}

