/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.ssh.SSHUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class RSyncUtil {
    private static final Logger LOG = Logger.getInstance(RSyncUtil.class);
    public static final String RSYNC = "rsync";
    public static final String RSYNC_OPTIONS = "-zarv";
    public static final String RSYNC_SSH_PORT_OPTION = "-e";
    public static final String RSYNC_SSH_PORT_OPTION_VALUE = "ssh -p %s";
    public static final int CHECK_CANCELLED_TIMEOUT = 200;
    public static final int DEFAULT_SSH_PORT = 22;

    private static boolean checkRsyncInstalled() {
        return RSyncUtil.checkCommandExists(RSYNC, "--version");
    }

    @NotNull
    public static List<String> externalToolSuggestion() {
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync")) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RSyncUtil.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (!PlatformUtils.isRubyMine()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RSyncUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<String> commandsToInstall = new ArrayList<String>();
        if (!RSyncUtil.checkRsyncInstalled()) {
            commandsToInstall.add(RSYNC);
        }
        ArrayList<String> arrayList = commandsToInstall;
        if (arrayList == null) {
            RSyncUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static boolean canUseRSync() {
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync") || SystemInfo.isWindows && !Registry.is((String)"ide.remote.interpreters.rsync.enabled.on.windows")) {
            return false;
        }
        return RSyncUtil.checkRsyncInstalled();
    }

    private static boolean checkCommandExists(String command, String versionParameter) {
        try {
            File executablePath = PathEnvironmentVariableUtil.findInPath((String)command);
            if (executablePath == null) {
                return false;
            }
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{executablePath.getAbsolutePath(), versionParameter});
            String commandOutput = ScriptRunnerUtil.getProcessOutput((GeneralCommandLine)commandLine);
            String firstLine = commandOutput.split("\n")[0];
            if (firstLine.matches(".*command not found.*")) {
                LOG.info(command + " not found");
                return false;
            }
            LOG.info(command + " version: " + firstLine);
        }
        catch (ExecutionException e) {
            LOG.error("Error during execution of command" + command);
            return false;
        }
        return true;
    }

    public static void uploadWithRSync(String localPath, String remotePath, RemoteSdkCredentials credentials, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        String remoteLastDirectoryName;
        if (progressIndicator == null) {
            RSyncUtil.$$$reportNull$$$0(3);
        }
        if ((remoteLastDirectoryName = PathUtilRt.getFileName((String)remotePath)).equals(PathUtilRt.getFileName((String)localPath))) {
            remotePath = remotePath.substring(0, remotePath.length() - remoteLastDirectoryName.length());
        }
        Pair<String, String[]> commandAndParameters = RSyncUtil.getRSyncCommandAndParameters(localPath, remotePath, credentials, true);
        RSyncUtil.runAndListenBashCommand((String)commandAndParameters.first, (String[])commandAndParameters.second, progressIndicator, credentials);
    }

    public static void downloadWithRSync(String localPath, String remotePath, RemoteSdkCredentials credentials, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        if (progressIndicator == null) {
            RSyncUtil.$$$reportNull$$$0(4);
        }
        if (!remotePath.endsWith(File.separator)) {
            remotePath = remotePath + File.separator;
        }
        FileUtil.createDirectory((File)new File(localPath));
        Pair<String, String[]> commandAndParameters = RSyncUtil.getRSyncCommandAndParameters(localPath, remotePath, credentials, false);
        RSyncUtil.runAndListenBashCommand((String)commandAndParameters.first, (String[])commandAndParameters.second, progressIndicator, credentials);
    }

    private static void runAndListenBashCommand(@NotNull String command, String[] parameters, final @NotNull ProgressIndicator progressIndicator, final @NotNull RemoteSdkCredentials credentials) throws ExecutionException {
        File executablePath;
        if (command == null) {
            RSyncUtil.$$$reportNull$$$0(5);
        }
        if (progressIndicator == null) {
            RSyncUtil.$$$reportNull$$$0(6);
        }
        if (credentials == null) {
            RSyncUtil.$$$reportNull$$$0(7);
        }
        if ((executablePath = PathEnvironmentVariableUtil.findInPath((String)command)) == null) {
            return;
        }
        PtyCommandLine commandLine = new PtyCommandLine();
        commandLine.setConsoleMode(false);
        commandLine.setExePath(executablePath.getPath());
        commandLine.addParameters(parameters);
        final OSProcessHandler osProcessHandler = new OSProcessHandler((GeneralCommandLine)commandLine);
        assert (osProcessHandler.getProcessInput() != null);
        final PrintWriter writer = new PrintWriter(osProcessHandler.getProcessInput());
        osProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                try {
                    progressIndicator.checkCanceled();
                }
                catch (ProcessCanceledException e) {
                    osProcessHandler.destroyProcess();
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    if (event.getText().contains(File.separator)) {
                        progressIndicator.setText(event.getText());
                    }
                } else if (outputType == ProcessOutputTypes.STDERR && !event.getText().contains("No such file or directory")) {
                    LOG.info(event.getText());
                }
                if (SSHUtil.PASSPHRASE_PROMPT.matcher(event.getText()).matches()) {
                    this.sendToTerminal(credentials.getPassphrase());
                } else if (event.getText().trim().toLowerCase(Locale.ENGLISH).endsWith("password:")) {
                    String password = credentials.getPassword() != null ? credentials.getPassword() : credentials.getUserName();
                    this.sendToTerminal(password);
                } else if (event.getText().contains("Are you sure you want to continue connecting")) {
                    this.sendToTerminal("yes");
                }
            }

            private void sendToTerminal(String text) {
                writer.println(text != null ? text : "");
                writer.flush();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/plugins/remotesdk/RSyncUtil$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        osProcessHandler.startNotify();
        while (!osProcessHandler.waitFor(200L)) {
            if (progressIndicator.isCanceled()) {
                osProcessHandler.destroyProcess();
            }
            progressIndicator.checkCanceled();
        }
        osProcessHandler.waitFor();
        if (!progressIndicator.isCanceled() && osProcessHandler.getExitCode() != null && osProcessHandler.getExitCode() != 0) {
            LOG.info("RSync exited with code: " + osProcessHandler.getExitCode());
        }
    }

    private static Pair<String, String[]> getRSyncCommandAndParameters(String localPath, String remotePath, RemoteSdkCredentials credentials, boolean isServerSideModification) {
        String to;
        String from;
        String fullRemotePath = String.format("%s@%s:%s", credentials.getUserName(), credentials.getHost(), remotePath);
        if (isServerSideModification) {
            from = localPath;
            to = fullRemotePath;
        } else {
            from = fullRemotePath;
            to = localPath;
        }
        if (credentials.getPort() != 22) {
            return Pair.create((Object)RSYNC, (Object)new String[]{RSYNC_OPTIONS, RSYNC_SSH_PORT_OPTION, String.format(RSYNC_SSH_PORT_OPTION_VALUE, credentials.getPort()), from, to});
        }
        return Pair.create((Object)RSYNC, (Object)new String[]{RSYNC_OPTIONS, from, to});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/RSyncUtil";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "externalToolSuggestion";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RSyncUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uploadWithRSync";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "downloadWithRSync";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runAndListenBashCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

