/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSRecordType
extends JSType {
    @NotNull
    public List<TypeMember> getTypeMembers();

    public boolean hasProperty(String var1);

    public static boolean areCallSignaturesEqual(@NotNull CallSignature first, @Nullable TypeMember otherRaw, boolean allowResolve) {
        if (first == null) {
            JSRecordType.$$$reportNull$$$0(0);
        }
        if (otherRaw == first) {
            return true;
        }
        if (!(otherRaw instanceof CallSignature)) {
            return false;
        }
        CallSignature other = (CallSignature)otherRaw;
        return other.hasNew() == first.hasNew() && other.getFunctionType().isEquivalentTo(first.getFunctionType(), null, allowResolve);
    }

    @Nullable
    public PropertySignature findPropertySignature(@NotNull String var1);

    public static boolean areIndexSignaturesEqual(@NotNull IndexSignature first, @Nullable TypeMember otherRaw, boolean allowResolve) {
        if (first == null) {
            JSRecordType.$$$reportNull$$$0(1);
        }
        if (otherRaw == first) {
            return true;
        }
        if (!(otherRaw instanceof IndexSignature)) {
            return false;
        }
        IndexSignature other = (IndexSignature)otherRaw;
        return first.getMemberParameterType().isEquivalentTo(other.getMemberParameterType(), null, allowResolve) && first.getMemberType().isEquivalentTo(other.getMemberType(), null, allowResolve);
    }

    public static boolean arePropertySignaturesEqual(@NotNull PropertySignature first, @Nullable TypeMember otherRaw, boolean allowResolve) {
        if (first == null) {
            JSRecordType.$$$reportNull$$$0(2);
        }
        if (otherRaw == first) {
            return true;
        }
        if (!(otherRaw instanceof PropertySignature)) {
            return false;
        }
        PropertySignature other = (PropertySignature)otherRaw;
        return first.getMemberName().equals(other.getMemberName()) && (first.getType() != null ? first.getType().isEquivalentTo(other.getType(), null, allowResolve) : other.getType() == null) && other.isOptional() == other.isOptional();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "first";
        objectArray2[1] = "com/intellij/lang/javascript/psi/JSRecordType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "areCallSignaturesEqual";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "areIndexSignaturesEqual";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "arePropertySignaturesEqual";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface IndexSignature
    extends TypeMember {
        @NotNull
        public IndexSignatureKind getIndexSignatureKind();

        @NotNull
        public JSType getMemberParameterType();

        @NotNull
        public JSType getMemberType();

        @Override
        @NotNull
        public IndexSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);
    }

    public static enum IndexSignatureKind {
        STRING,
        NUMERIC,
        UNKNOWN;

    }

    public static interface CallSignature
    extends TypeMember {
        public boolean hasNew();

        public JSType getFunctionType();

        @Override
        @NotNull
        public CallSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);
    }

    public static interface PropertySignature
    extends TypeMember {
        @NotNull
        public String getMemberName();

        @Override
        @NotNull
        public PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);

        public boolean isOptional();

        @Nullable
        public JSType getType();
    }

    public static interface TypeMember {
        public boolean isEquivalentTo(@Nullable TypeMember var1, boolean var2);

        @NotNull
        public MemberSource getMemberSource();

        @NotNull
        public TypeMember copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, boolean var2);
    }

    public static interface MemberSource {
        public boolean isEmpty();

        @NotNull
        public MemberSourceKind getMemberSourceKind();

        @Nullable
        public PsiElement getSingleElement();

        @NotNull
        public List<PsiElement> getAllSourceElements();

        public MemberSource copyWithKind(MemberSourceKind var1);
    }

    public static enum MemberSourceKind {
        Empty,
        Identity,
        Union,
        Intersection,
        Mapped,
        CompositeSignature;


        public boolean isTypeScriptMergedTypeKind() {
            return this == Union || this == Intersection || this == Mapped;
        }
    }
}

