/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.uml.UmlGraphBuilder;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ReopenInfo {
    private static final Key<ReopenInfo> KEY = Key.create((String)"UmlEditor.ReopenInfo");
    private final String myCurrentVisibility;
    private final DiagramCategory[] myCategories;
    private final Boolean myAllowEdgeCreation;
    private final NamedScope myNamedScope;
    private final Boolean myShowDependencies;

    private ReopenInfo(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            ReopenInfo.$$$reportNull$$$0(0);
        }
        DiagramState presentation = builder.getPresentation();
        this.myCurrentVisibility = presentation.getCurrentVisibility();
        this.myCategories = builder.getPresentationModel().allowChangeVisibleCategories() ? presentation.getEnabledCategories() : null;
        this.myAllowEdgeCreation = builder.getProvider().getEdgeCreationPolicy() == null ? null : Boolean.valueOf(((UmlGraphBuilder)builder).getEditMode().doAllowEdgeCreation());
        DiagramDataModel model = builder.getDataModel();
        if (model == null) {
            this.myNamedScope = null;
            this.myShowDependencies = null;
        } else {
            DiagramScopeManager scopeManager = model.getScopeManager();
            this.myNamedScope = scopeManager == null ? null : scopeManager.getCurrentScope();
            this.myShowDependencies = model.isShowDependencies();
        }
    }

    private void apply(@NotNull DiagramBuilder builder, @Nullable Object element) {
        DiagramDataModel dataModel;
        if (builder == null) {
            ReopenInfo.$$$reportNull$$$0(1);
        }
        builder.getPresentation().setCurrentVisibility(this.myCurrentVisibility);
        if (this.myCategories != null) {
            Arrays.stream(this.myCategories).forEach(category -> {
                if (builder == null) {
                    ReopenInfo.$$$reportNull$$$0(9);
                }
                builder.getPresentation().setCategoryEnabled(category, true);
            });
        }
        if (this.myAllowEdgeCreation != null) {
            builder.setAllowEdgeCreation(this.myAllowEdgeCreation.booleanValue());
        }
        if ((dataModel = builder.getDataModel()) != null && (this.myNamedScope != null || this.myShowDependencies != null)) {
            dataModel.setupScopeManager(element, false);
            DiagramScopeManager scopeManager = dataModel.getScopeManager();
            if (this.myNamedScope != null && scopeManager != null) {
                scopeManager.setCurrentScope(this.myNamedScope);
            }
            if (this.myShowDependencies != null) {
                dataModel.setShowDependencies(this.myShowDependencies.booleanValue());
            }
            dataModel.refreshDataModel();
            dataModel.setModelInitializationFinished();
        }
    }

    public static void apply(@NotNull DiagramBuilder prevBuilder, @NotNull DiagramBuilder newBuilder, @Nullable Object element) {
        if (prevBuilder == null) {
            ReopenInfo.$$$reportNull$$$0(2);
        }
        if (newBuilder == null) {
            ReopenInfo.$$$reportNull$$$0(3);
        }
        new ReopenInfo(prevBuilder).apply(newBuilder, element);
    }

    public static void apply(@NotNull VirtualFile file, @NotNull DiagramBuilder builder, @Nullable Object element) {
        ReopenInfo info;
        if (file == null) {
            ReopenInfo.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            ReopenInfo.$$$reportNull$$$0(5);
        }
        if ((info = (ReopenInfo)KEY.get((UserDataHolder)file)) != null) {
            KEY.set((UserDataHolder)file, null);
            info.apply(builder, element);
        }
    }

    public static boolean isContains(@NotNull VirtualFile file) {
        if (file == null) {
            ReopenInfo.$$$reportNull$$$0(6);
        }
        return KEY.isIn((UserDataHolder)file);
    }

    public static void copyIfNeeded(@NotNull VirtualFile file, @NotNull DiagramBuilder builder) {
        Boolean value;
        if (file == null) {
            ReopenInfo.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            ReopenInfo.$$$reportNull$$$0(8);
        }
        if ((value = (Boolean)file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN)) != null && value.booleanValue()) {
            KEY.set((UserDataHolder)file, (Object)new ReopenInfo(builder));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBuilder";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/ReopenInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isContains";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "copyIfNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$apply$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

