/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.diagram.ChangeTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.PsiChangeTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFilter;
import com.intellij.uml.java.JavaUmlElementManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class JavaChangeTracker
extends ChangeTracker<PsiClass, PsiNamedElement, PsiJavaCodeReferenceElement> {
    private static final PsiFilter<PsiMethod> METHOD_FILTER = new PsiFilter<PsiMethod>(PsiMethod.class){

        public boolean accept(PsiMethod element) {
            return !JavaChangeTracker.isAnonymousClass(element.getContainingClass());
        }
    };
    private static final PsiFilter<PsiField> FIELD_FILTER = new PsiFilter<PsiField>(PsiField.class){

        public boolean accept(PsiField element) {
            return !JavaChangeTracker.isAnonymousClass(element.getContainingClass());
        }
    };
    private static final PsiFilter<PsiClass> CLASS_FILTER = new PsiFilter<PsiClass>(PsiClass.class){

        public boolean accept(PsiClass element) {
            return !JavaChangeTracker.isAnonymousClass(element);
        }
    };
    private static final PsiFilter[] CONTENT_FILTERS = new PsiFilter[]{FIELD_FILTER, METHOD_FILTER};
    private static final PsiFilter<PsiClass>[] NODE_FILTERS = new PsiFilter[]{CLASS_FILTER};
    private static final JavaRefFilter EXTENDS_FILTER = new JavaRefFilter(PsiReferenceList.Role.EXTENDS_LIST);
    private static final JavaRefFilter IMPLEMENTS_FILTER = new JavaRefFilter(PsiReferenceList.Role.IMPLEMENTS_LIST);
    private static final JavaRefFilter[] REL_FILTERS = new JavaRefFilter[]{EXTENDS_FILTER, IMPLEMENTS_FILTER};
    private Map<PsiClass, FileStatus> map = null;

    public JavaChangeTracker(Project project, PsiFile before, PsiFile after) {
        super(project, before, after);
    }

    private static boolean isAnonymousClass(PsiClass psiClass) {
        return psiClass instanceof PsiAnonymousClass;
    }

    public PsiFilter<PsiClass>[] getNodeFilters() {
        return NODE_FILTERS;
    }

    public PsiFilter<PsiNamedElement>[] getNodeContentFilters() {
        return CONTENT_FILTERS;
    }

    public PsiFilter<PsiJavaCodeReferenceElement>[] getRelationshipFilters() {
        return REL_FILTERS;
    }

    public String getPresentableName(PsiNamedElement e) {
        if (e instanceof PsiMethod) {
            return JavaUmlElementManager.getMethodSignature((PsiMethod)e);
        }
        return super.getPresentableName(e);
    }

    public String getQualifiedName(PsiClass psiClass, VirtualFile containingFile) {
        return psiClass.getQualifiedName();
    }

    public String getType(PsiNamedElement member) {
        PsiType type = null;
        if (member instanceof PsiMethod) {
            type = ((PsiMethod)member).getReturnType();
        } else if (member instanceof PsiField) {
            type = ((PsiField)member).getType();
        }
        return type == null ? super.getType(member) : type.getPresentableText();
    }

    public Map<PsiClass, FileStatus> getNodeElements() {
        if (this.map == null) {
            this.map = new HashMap<PsiClass, FileStatus>();
            for (PsiFilter<PsiClass> filter : this.getNodeFilters()) {
                this.map.putAll(PsiChangeTracker.getElementsChanged((PsiElement)this.getAfter(), (PsiElement)this.getBefore(), filter));
            }
        }
        return this.map;
    }

    public ChangeTracker.RelationshipInfo[] getRelationships() {
        final ArrayList<ChangeTracker.RelationshipInfo> result = new ArrayList<ChangeTracker.RelationshipInfo>();
        for (PsiFilter<PsiJavaCodeReferenceElement> filter : this.getRelationshipFilters()) {
            Map map = PsiChangeTracker.getElementsChanged((PsiElement)this.getAfter(), (PsiElement)this.getBefore(), filter);
            ChangeTracker.EdgeType type = filter == EXTENDS_FILTER ? ChangeTracker.EdgeType.EXTENDS : ChangeTracker.EdgeType.IMPLEMENTS;
            for (PsiJavaCodeReferenceElement key : map.keySet()) {
                PsiClass cls = JavaChangeTracker.getContainingClass(key);
                if (cls == null) continue;
                result.add(new ChangeTracker.RelationshipInfo(cls.getQualifiedName(), key.getQualifiedName(), type, (FileStatus)map.get(key)));
            }
        }
        PsiFile after = this.getAfter();
        if (after != null) {
            JavaRecursiveElementVisitor classVisitor = new JavaRecursiveElementVisitor(){

                public void visitClass(PsiClass from) {
                    PsiClass to;
                    super.visitClass(from);
                    if (!(from instanceof PsiAnonymousClass) && (to = from.getContainingClass()) != null && to != from) {
                        result.add(new ChangeTracker.RelationshipInfo(from.getQualifiedName(), to.getQualifiedName(), ChangeTracker.EdgeType.INNER, FileStatus.NOT_CHANGED));
                    }
                }
            };
            after.accept((PsiElementVisitor)classVisitor);
        }
        return result.toArray(new ChangeTracker.RelationshipInfo[result.size()]);
    }

    public PsiNamedElement findElementByFQN(Project project, String fqn) {
        return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
    }

    public boolean isContainerFor(PsiClass aClass, PsiNamedElement element) {
        return aClass.getManager().areElementsEquivalent(element.getParent(), (PsiElement)aClass);
    }

    @Nullable
    private static PsiClass getContainingClass(PsiJavaCodeReferenceElement ref) {
        PsiElement cls;
        PsiElement p = ref.getParent();
        if (p != null && (cls = p.getParent()) instanceof PsiClass) {
            return (PsiClass)cls;
        }
        return null;
    }

    private static class JavaRefFilter
    extends PsiFilter<PsiJavaCodeReferenceElement> {
        private final PsiReferenceList.Role myRole;

        public JavaRefFilter(PsiReferenceList.Role role) {
            super(PsiJavaCodeReferenceElement.class);
            this.myRole = role;
        }

        public boolean accept(PsiJavaCodeReferenceElement element) {
            PsiElement parent = element.getParent();
            return parent instanceof PsiReferenceList && ((PsiReferenceList)parent).getRole() == this.myRole;
        }

        public boolean areEquivalent(PsiJavaCodeReferenceElement e1, PsiJavaCodeReferenceElement e2) {
            try {
                return e1.getQualifiedName().equals(e2.getQualifiedName()) && JavaChangeTracker.getContainingClass(e1).getQualifiedName().equals(JavaChangeTracker.getContainingClass(e2).getQualifiedName());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
    }
}

