/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.dependencies;

import com.intellij.execution.ExecutionException;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.maven.dependencies.bundle.MavenDependenciesBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class MavenManager {
    private static final Logger LOG = Logger.getInstance(MavenManager.class);
    static MavenManager instance = new MavenManager();
    ConcurrentHashMap<String, List<String>> artifactDependentFilesMap = new ConcurrentHashMap();

    private MavenManager() {
    }

    public static MavenManager getInstance() {
        return instance;
    }

    private static boolean checkExistence(List<String> jars) {
        for (String jar : jars) {
            File file = new File(jar);
            if (file.exists() && file.isFile()) continue;
            return false;
        }
        return true;
    }

    public List<String> getOrLoadMavenArtifactJars(@NotNull Project project, @NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean downloadSources, boolean downloadJavaDocs) throws ExecutionException {
        String key;
        List jars;
        if (project == null) {
            MavenManager.$$$reportNull$$$0(0);
        }
        if (groupId == null) {
            MavenManager.$$$reportNull$$$0(1);
        }
        if (artifactId == null) {
            MavenManager.$$$reportNull$$$0(2);
        }
        if (version == null) {
            MavenManager.$$$reportNull$$$0(3);
        }
        if ((jars = this.artifactDependentFilesMap.get(key = groupId + ":" + artifactId + ":" + version)) != null && MavenManager.checkExistence(jars)) {
            return jars;
        }
        Collection roots = JarRepositoryManager.loadDependenciesModal((Project)project, (RepositoryLibraryProperties)new RepositoryLibraryProperties(groupId, artifactId, version), (boolean)downloadSources, (boolean)downloadJavaDocs, null, null);
        if (roots == null || roots.isEmpty()) {
            throw new ExecutionException(MavenDependenciesBundle.message("arquillian.maven.dependencies.load.failed", key));
        }
        jars = JBIterable.from((Iterable)roots).transform(root -> PathUtil.toPresentableUrl((String)root.getFile().getUrl())).toList();
        this.artifactDependentFilesMap.put(key, jars);
        return jars;
    }

    public List<String> getMavenArtifactJars(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            MavenManager.$$$reportNull$$$0(4);
        }
        if (artifactId == null) {
            MavenManager.$$$reportNull$$$0(5);
        }
        if (version == null) {
            MavenManager.$$$reportNull$$$0(6);
        }
        String key = groupId + ":" + artifactId + ":" + version;
        return this.artifactDependentFilesMap.get(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        objectArray2[1] = "com/intellij/maven/dependencies/MavenManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrLoadMavenArtifactJars";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getMavenArtifactJars";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

