/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.lobobrowser.gui.AbstractBrowserWindow;
import org.lobobrowser.gui.DefaultBrowserWindow;
import org.lobobrowser.gui.NavigatorWindowImpl;
import org.lobobrowser.gui.WindowFactory;
import org.lobobrowser.main.ExtensionManager;
import org.lobobrowser.main.PlatformInit;
import org.lobobrowser.request.RequestEngine;
import org.lobobrowser.settings.GeneralSettings;
import org.lobobrowser.ua.NavigatorWindow;
import org.lobobrowser.util.EventDispatch;
import org.lobobrowser.util.ID;
import org.lobobrowser.util.WeakValueHashMap;

public class DefaultWindowFactory
implements WindowFactory {
    private static final Logger logger = Logger.getLogger(DefaultWindowFactory.class.getName());
    private static DefaultWindowFactory instance = new DefaultWindowFactory();
    private static final String DEFAULT_ICON_URL = "res:/images/lobo.png";
    public final EventDispatch evtWindowShown = new EventDispatch();
    private final Map<String, ImageIcon> imageMap = new WeakValueHashMap();
    private final Map<String, DefaultBrowserWindow> framesById = new WeakValueHashMap();
    private final Set<Frame> frames = new HashSet<Frame>();
    private final GeneralSettings generalSettings = GeneralSettings.getInstance();
    private volatile boolean exitWhenAllWindowsClosed = false;

    protected DefaultWindowFactory() {
    }

    public void setExitWhenAllWindowsAreClosed(boolean flag) {
        this.exitWhenAllWindowsClosed = flag;
    }

    public static DefaultWindowFactory getInstance() {
        return instance;
    }

    public ImageIcon getDefaultImageIcon() {
        return this.getImageIcon(DEFAULT_ICON_URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon getImageIcon(String urlOrPath) {
        DefaultWindowFactory defaultWindowFactory = this;
        synchronized (defaultWindowFactory) {
            ImageIcon icon = this.imageMap.get(urlOrPath);
            if (icon == null) {
                try {
                    byte[] imageBytes = RequestEngine.getInstance().loadBytes(urlOrPath);
                    icon = new ImageIcon(imageBytes);
                    this.imageMap.put(urlOrPath, icon);
                }
                catch (Exception err) {
                    logger.log(Level.WARNING, "getImageIcon(): Unable to load image: " + urlOrPath, err);
                }
            }
            return icon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractBrowserWindow getExistingWindow(String windowId) {
        if (windowId == null) {
            return null;
        }
        DefaultWindowFactory defaultWindowFactory = this;
        synchronized (defaultWindowFactory) {
            DefaultBrowserWindow window = this.framesById.get(windowId);
            if (window != null && window.isDisplayable()) {
                return window;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBrowserWindow createBaseWindow(String windowId, NavigatorWindow windowContext, boolean hasMenuBar, boolean hasAddressBar, boolean hasToolBar, boolean hasStatusBar) {
        final NavigatorWindowImpl pwc = (NavigatorWindowImpl)windowContext;
        DefaultWindowFactory defaultWindowFactory = this;
        synchronized (defaultWindowFactory) {
            final DefaultBrowserWindow window = new DefaultBrowserWindow(hasMenuBar, hasAddressBar, hasToolBar, hasStatusBar, pwc);
            if (windowId != null) {
                this.framesById.put(windowId, window);
            }
            window.setDefaultCloseOperation(2);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("createBaseWindow(): Adding window listener: window=" + window + ",windowId=" + windowId);
            }
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    if (!window.isBoundsAssigned()) {
                        if (logger.isLoggable(Level.INFO)) {
                            logger.info("windowClosing(): Saving general settings: bounds=" + window.getBounds());
                        }
                        GeneralSettings settings = DefaultWindowFactory.this.generalSettings;
                        settings.setInitialWindowBounds(window.getBounds());
                        settings.save();
                    }
                    ExtensionManager.getInstance().shutdownExtensionsWindow(pwc);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                    Set frames = DefaultWindowFactory.this.frames;
                    DefaultWindowFactory defaultWindowFactory = DefaultWindowFactory.this;
                    synchronized (defaultWindowFactory) {
                        if (logger.isLoggable(Level.INFO)) {
                            logger.info("windowClosed(): frames.size()=" + frames.size() + ",exitWhenAllWindowsClosed=" + DefaultWindowFactory.this.exitWhenAllWindowsClosed);
                        }
                        frames.remove(window);
                        if (frames.size() == 0 && DefaultWindowFactory.this.exitWhenAllWindowsClosed) {
                            logger.warning("Exiting JVM because all windows are now closed!");
                            PlatformInit.shutdown();
                        }
                    }
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    DefaultWindowFactory.this.evtWindowShown.fireEvent(null);
                }
            });
            this.frames.add(window);
            return window;
        }
    }

    private final boolean isPropertyTrue(Properties properties, String name, boolean defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        String value = properties.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return "1".equals(value) || "yes".equalsIgnoreCase(value);
    }

    @Override
    public AbstractBrowserWindow createWindow(String windowId, Properties properties, NavigatorWindow windowContext) {
        String widthText = properties == null ? null : properties.getProperty("width");
        String heightText = properties == null ? null : properties.getProperty("height");
        boolean defaultValue = widthText == null && heightText == null;
        boolean hasMenuBar = this.isPropertyTrue(properties, "menubar", defaultValue);
        boolean hasToolBar = this.isPropertyTrue(properties, "toolbar", defaultValue);
        boolean hasAddressBar = this.isPropertyTrue(properties, "location", defaultValue);
        boolean hasStatusBar = this.isPropertyTrue(properties, "status", defaultValue);
        boolean isResizable = this.isPropertyTrue(properties, "resizable", defaultValue);
        String iconText = properties == null ? null : properties.getProperty("icon");
        String title = properties == null ? null : properties.getProperty("title");
        int width = -1;
        int height = -1;
        if (widthText != null) {
            try {
                width = Integer.parseInt(widthText);
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "PlatformWindowContextImpl(): Unable to parse window width.", nfe);
            }
        }
        if (heightText != null) {
            try {
                height = Integer.parseInt(heightText);
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "PlatformWindowContextImpl(): Unable to parse window height.", nfe);
            }
        }
        AbstractBrowserWindow window = this.createBaseWindow(windowId, windowContext, hasMenuBar, hasAddressBar, hasToolBar, hasStatusBar);
        window.setTitle(title);
        Rectangle windowBounds = this.generalSettings.getInitialWindowBounds();
        if (width != -1 || height != -1) {
            if (width != -1) {
                windowBounds.width = width;
            }
            if (height != -1) {
                windowBounds.height = height;
            }
            window.setBoundsAssigned(true);
        }
        ImageIcon icon = null;
        if (iconText != null) {
            icon = this.getImageIcon(iconText);
            if (icon == null) {
                icon = this.getDefaultImageIcon();
            }
        } else {
            icon = this.getDefaultImageIcon();
        }
        if (icon != null) {
            window.setIconImage(icon.getImage());
        }
        Dimension windowSize = windowBounds.getSize();
        Rectangle maxBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int maxX = maxBounds.width - windowSize.width;
        int maxY = maxBounds.height - windowSize.height;
        int x = ID.random(0, maxX);
        int y = ID.random(0, maxY);
        window.setBounds(x, y, windowSize.width, windowSize.height);
        window.setResizable(isResizable);
        return window;
    }

    @Override
    public void overrideProperties(AbstractBrowserWindow window, Properties properties) {
        String widthText = properties.getProperty("width");
        String heightText = properties.getProperty("height");
        boolean defaultValue = widthText == null && heightText == null;
        boolean isResizable = this.isPropertyTrue(properties, "resizable", defaultValue);
        properties.getProperty("icon");
        String title = properties.getProperty("title");
        int width = -1;
        int height = -1;
        if (widthText != null) {
            try {
                width = Integer.parseInt(widthText);
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "PlatformWindowContextImpl(): Unable to parse window width.", nfe);
            }
        }
        if (heightText != null) {
            try {
                height = Integer.parseInt(heightText);
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "PlatformWindowContextImpl(): Unable to parse window height.", nfe);
            }
        }
        window.setResizable(isResizable);
        window.setTitle(title);
        window.setSize(width == -1 ? window.getWidth() : width, height == -1 ? window.getHeight() : height);
    }
}

