/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets.html;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.lobobrowser.clientlet.Clientlet;
import org.lobobrowser.clientlet.ClientletContext;
import org.lobobrowser.clientlet.ClientletException;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.dombl.DocumentNotificationListener;
import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.w3c.HTMLElement;
import org.lobobrowser.primary.clientlets.html.HtmlContent;
import org.lobobrowser.primary.clientlets.html.HtmlRendererContextImpl;
import org.lobobrowser.ua.NavigatorFrame;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.io.RecordedInputStream;
import org.w3c.dom.Element;

public class HtmlClientlet
implements Clientlet {
    private static final Logger logger = Logger.getLogger(HtmlClientlet.class.getName());
    private static final Set<String> NON_VISIBLE_ELEMENTS;
    private static final int MAX_IS_BUFFER_SIZE = 102400;

    @Override
    public void process(ClientletContext cc) throws ClientletException {
        this.processImpl(cc, null, null);
    }

    private void processImpl(final ClientletContext cc, Map<String, String> httpEquivData, RecordedInputStream rin) throws ClientletException {
        try {
            ClientletResponse response = cc.getResponse();
            boolean charsetProvided = response.isCharsetProvided();
            String contentLanguage = response.getHeader("Content-Language");
            Set<Locale> locales = contentLanguage == null ? null : this.extractLocales(contentLanguage);
            RefreshInfo refresh = null;
            Iterator hi = response.getHeaderNames();
            while (hi.hasNext()) {
                String headerName = (String)hi.next();
                String[] headerValues = response.getHeaders(headerName);
                if (headerValues == null || headerValues.length <= 0 || !"refresh".equalsIgnoreCase(headerName)) continue;
                refresh = this.extractRefresh(headerValues[headerValues.length - 1]);
            }
            String httpEquivCharset = null;
            if (httpEquivData != null) {
                for (Map.Entry<String, String> entry : httpEquivData.entrySet()) {
                    String httpEquiv = entry.getKey();
                    String content = entry.getValue();
                    if (content == null) continue;
                    if ("content-type".equalsIgnoreCase(httpEquiv)) {
                        httpEquivCharset = this.extractCharset(response.getResponseURL(), content);
                        continue;
                    }
                    if ("refresh".equalsIgnoreCase(httpEquiv)) {
                        refresh = this.extractRefresh(content);
                        continue;
                    }
                    if (!"content-language".equalsIgnoreCase(httpEquiv)) continue;
                    locales = this.extractLocales(content);
                }
            }
            HtmlRendererContextImpl rcontext = HtmlRendererContextImpl.getHtmlRendererContext(cc.getNavigatorFrame());
            DocumentBuilderImpl builder = new DocumentBuilderImpl(rcontext.getUserAgentContext(), rcontext);
            if (rin == null) {
                InputStream in = response.getInputStream();
                rin = in instanceof RecordedInputStream ? (RecordedInputStream)in : new RecordedInputStream(in, 102400);
                rin.mark(Short.MAX_VALUE);
            } else {
                rin.reset();
            }
            URL responseURL = response.getResponseURL();
            String uri = responseURL.toExternalForm();
            String charset = !charsetProvided ? httpEquivCharset : response.getCharset();
            if (charset == null) {
                charset = "ISO-8859-1";
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("process(): charset=" + charset + " for URI=[" + uri + "]");
            }
            InputSourceImpl is = new InputSourceImpl(rin, uri, charset);
            HTMLDocumentImpl document = (HTMLDocumentImpl)builder.createDocument(is);
            document.setLocales(locales);
            String referrer = cc.getRequest().getReferrer();
            document.setReferrer(referrer == null ? "" : referrer);
            HtmlPanel panel = rcontext.getHtmlPanel();
            final HtmlContent content = new HtmlContent(document, panel, rin, charset);
            LocalDocumentNotificationListener listener = new LocalDocumentNotificationListener(document, panel, rcontext, cc, content, httpEquivData == null);
            document.addDocumentNotificationListener(listener);
            long time1 = System.currentTimeMillis();
            try {
                document.load(false);
            }
            catch (HttpEquivRetryException retry) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("processImpl(): Resetting due to META http-equiv: " + uri);
                }
                this.processImpl(cc, retry.getHttpEquivData(), rin);
                return;
            }
            long time2 = System.currentTimeMillis();
            if (logger.isLoggable(Level.INFO)) {
                logger.info("process(): Parse elapsed=" + (time2 - time1) + " ms.");
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("process(): HTML follows:\r\n" + content.getSourceCode());
                }
            }
            listener.ensureSwitchedToRendering();
            String ref = responseURL.getRef();
            if (ref != null && ref.length() != 0) {
                panel.scrollToElement(ref);
            }
            if (refresh != null) {
                String destUri = refresh.destinationUrl;
                URL currentURL = response.getResponseURL();
                URL destURL = destUri == null ? currentURL : Urls.createURL(currentURL, destUri);
                final URL finalURL = destURL;
                ActionListener action = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NavigatorFrame frame = cc.getNavigatorFrame();
                        if (frame.getComponentContent() == content) {
                            frame.navigate(finalURL, RequestType.PROGRAMMATIC);
                        }
                    }
                };
                int waitMillis = refresh.waitSeconds * 1000;
                if (waitMillis <= 0) {
                    waitMillis = 1;
                }
                Timer timer = new Timer(waitMillis, action);
                timer.setRepeats(false);
                timer.start();
            }
        }
        catch (Exception err) {
            throw new ClientletException(err);
        }
    }

    private String extractCharset(URL responseURL, String contentType) {
        StringTokenizer tok = new StringTokenizer(contentType, ";");
        if (tok.hasMoreTokens()) {
            tok.nextToken();
            while (tok.hasMoreTokens()) {
                String varName;
                String assignment = tok.nextToken().trim();
                int eqIdx = assignment.indexOf(61);
                if (eqIdx == -1 || !"charset".equalsIgnoreCase(varName = assignment.substring(0, eqIdx).trim())) continue;
                String varValue = assignment.substring(eqIdx + 1);
                return Strings.unquote(varValue.trim());
            }
        }
        return null;
    }

    private Set<Locale> extractLocales(String contentLanguage) {
        HashSet<Locale> locales = new HashSet<Locale>(3);
        StringTokenizer tok = new StringTokenizer(contentLanguage, ",");
        while (tok.hasMoreTokens()) {
            String lang = tok.nextToken().trim();
            locales.add(new Locale(lang));
        }
        return locales;
    }

    private String getDefaultCharset(URL url) {
        if (Urls.isLocalFile(url)) {
            String charset = System.getProperty("file.encoding");
            return charset == null ? "ISO-8859-1" : charset;
        }
        return "ISO-8859-1";
    }

    private final RefreshInfo extractRefresh(String refresh) {
        int delay;
        String delayText = null;
        String urlText = null;
        StringTokenizer tok = new StringTokenizer(refresh, ";");
        if (tok.hasMoreTokens()) {
            delayText = tok.nextToken().trim();
            while (tok.hasMoreTokens()) {
                String assignment = tok.nextToken().trim();
                int eqIdx = assignment.indexOf(61);
                if (eqIdx != -1) {
                    String varName = assignment.substring(0, eqIdx).trim();
                    if (!"url".equalsIgnoreCase(varName)) continue;
                    String varValue = assignment.substring(eqIdx + 1);
                    urlText = Strings.unquote(varValue.trim());
                    continue;
                }
                urlText = Strings.unquote(assignment);
            }
        }
        try {
            delay = Integer.parseInt(delayText);
        }
        catch (NumberFormatException nfe) {
            logger.warning("extractRefresh(): Bad META refresh delay: " + delayText + ".");
            delay = 0;
        }
        return new RefreshInfo(delay, urlText);
    }

    static {
        Set<String> nve = NON_VISIBLE_ELEMENTS = new HashSet<String>();
        nve.add("html");
        nve.add("body");
        nve.add("head");
        nve.add("title");
        nve.add("meta");
        nve.add("script");
        nve.add("style");
        nve.add("link");
    }

    private static class HttpEquivRetryException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> httpEquivData;

        public HttpEquivRetryException(Map<String, String> httpEquiv) {
            this.httpEquivData = httpEquiv;
        }

        public Map<String, String> getHttpEquivData() {
            return this.httpEquivData;
        }
    }

    private static class RefreshInfo {
        public final int waitSeconds;
        public final String destinationUrl;

        public RefreshInfo(int waitSeconds, String destinationUrl) {
            this.waitSeconds = waitSeconds;
            this.destinationUrl = destinationUrl;
        }
    }

    private static class LocalDocumentNotificationListener
    implements DocumentNotificationListener {
        private static final int MAX_WAIT = 7000;
        private final HTMLDocumentImpl document;
        private final HtmlPanel htmlPanel;
        private final long startTimestamp;
        private final HtmlRendererContext rcontext;
        private final ClientletContext ccontext;
        private final HtmlContent content;
        private final boolean detectHttpEquiv;
        private boolean hasVisibleElements = false;
        private boolean hasSwitchedToRendering = false;
        private Collection<HTMLElement> httpEquivElements;

        public LocalDocumentNotificationListener(HTMLDocumentImpl doc, HtmlPanel panel, HtmlRendererContext rcontext, ClientletContext cc, HtmlContent content, boolean detectHttpEquiv) {
            this.document = doc;
            this.startTimestamp = System.currentTimeMillis();
            this.htmlPanel = panel;
            this.rcontext = rcontext;
            this.ccontext = cc;
            this.content = content;
            this.detectHttpEquiv = detectHttpEquiv;
        }

        @Override
        public void allInvalidated() {
        }

        @Override
        public void externalScriptLoading(DOMNodeImpl node) {
            if (this.hasVisibleElements) {
                this.ensureSwitchedToRendering();
            }
        }

        @Override
        public void invalidated(DOMNodeImpl node) {
        }

        @Override
        public void lookInvalidated(DOMNodeImpl node) {
        }

        private void addHttpEquivElement(HTMLElement element) {
            Collection<HTMLElement> httpEquivElements = this.httpEquivElements;
            if (httpEquivElements == null) {
                this.httpEquivElements = httpEquivElements = new LinkedList<HTMLElement>();
            }
            httpEquivElements.add(element);
        }

        @Override
        public void nodeLoaded(DOMNodeImpl node) {
            if (this.detectHttpEquiv && node instanceof HTMLElement) {
                Object httpEquiv;
                HTMLElement element = (HTMLElement)((Object)node);
                String tagName = element.getTagName();
                if ("meta".equalsIgnoreCase(tagName) && (httpEquiv = element.getAttribute("http-equiv")) != null) {
                    this.addHttpEquivElement(element);
                }
                if (("head".equalsIgnoreCase(tagName) || "script".equalsIgnoreCase(tagName) || "html".equalsIgnoreCase(tagName)) && (httpEquiv = this.getHttpEquivData()) != null && httpEquiv.size() > 0) {
                    throw new HttpEquivRetryException((Map<String, String>)httpEquiv);
                }
            }
            if (!this.hasVisibleElements && this.mayBeVisibleElement(node)) {
                this.hasVisibleElements = true;
            }
            if (this.hasVisibleElements && System.currentTimeMillis() - this.startTimestamp > 7000L) {
                this.ensureSwitchedToRendering();
            }
        }

        @Override
        public void positionInvalidated(DOMNodeImpl node) {
        }

        @Override
        public void sizeInvalidated(DOMNodeImpl node) {
        }

        @Override
        public void structureInvalidated(DOMNodeImpl node) {
        }

        private final boolean mayBeVisibleElement(DOMNodeImpl node) {
            if (node instanceof HTMLElement) {
                boolean visible;
                HTMLElement element = (HTMLElement)((Object)node);
                boolean bl = visible = !NON_VISIBLE_ELEMENTS.contains(element.getTagName().toLowerCase());
                if (visible && logger.isLoggable(Level.INFO)) {
                    logger.info("mayBeVisibleElement(): Found possibly visible element: " + element.getTagName());
                }
                return visible;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ensureSwitchedToRendering() {
            LocalDocumentNotificationListener localDocumentNotificationListener = this;
            synchronized (localDocumentNotificationListener) {
                if (this.hasSwitchedToRendering) {
                    return;
                }
                this.hasSwitchedToRendering = true;
            }
            final HTMLDocumentImpl document = this.document;
            document.removeDocumentNotificationListener(this);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LocalDocumentNotificationListener.this.htmlPanel.setDocument(document, LocalDocumentNotificationListener.this.rcontext);
                    LocalDocumentNotificationListener.this.ccontext.setResultingContent(LocalDocumentNotificationListener.this.content);
                }
            });
        }

        private Map<String, String> getHttpEquivData() {
            Collection<HTMLElement> httpEquivElements = this.httpEquivElements;
            if (httpEquivElements == null) {
                return null;
            }
            HashMap<String, String> httpEquivData = new HashMap<String, String>(0);
            for (Element element : httpEquivElements) {
                String httpEquiv = element.getAttribute("http-equiv");
                if (httpEquiv == null) continue;
                String content = element.getAttribute("content");
                httpEquivData.put(httpEquiv, content);
            }
            return httpEquivData;
        }
    }
}

