/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets.img;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.clientlet.Clientlet;
import org.lobobrowser.clientlet.ClientletContext;
import org.lobobrowser.clientlet.ClientletException;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.primary.clientlets.img.ImageContent;
import org.lobobrowser.util.io.IORoutines;

public class ImageClientlet
implements Clientlet {
    private static final Logger logger = Logger.getLogger(ImageClientlet.class.getName());

    @Override
    public void process(ClientletContext context) throws ClientletException {
        ClientletResponse response = context.getResponse();
        String mimeType = response.getMimeType();
        int contentLength = response.getContentLength();
        URL url = response.getResponseURL();
        Image image = null;
        if (url == null || !url.toString().endsWith(".svg")) {
            byte[] imageBytes;
            try {
                InputStream in = response.getInputStream();
                imageBytes = contentLength == -1 ? IORoutines.load(in) : IORoutines.loadExact(in, contentLength);
            }
            catch (IOException ioe) {
                throw new ClientletException(ioe);
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("process(): Loaded " + imageBytes.length + " bytes.");
            }
            image = Toolkit.getDefaultToolkit().createImage(imageBytes);
        }
        context.setResultingContent(new ImageContent(image, mimeType));
    }
}

