/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;
    private int mark;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
        this.mark = -1;
    }

    @Override
    public final int available() {
        return this.buf.remaining();
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final synchronized void mark(int n) {
        this.mark = this.buf.position();
    }

    @Override
    public final synchronized void reset() throws IOException {
        if (this.mark == -1) {
            throw new IOException();
        }
        this.buf.position(this.mark);
    }

    @Override
    public final long skip(long l) throws IOException {
        if (0L > l) {
            return 0L;
        }
        int n = (int)Math.min((long)this.buf.remaining(), l);
        this.buf.position(this.buf.position() + n);
        return n;
    }

    @Override
    public final int read() {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length || n + n2 > byArray.length || n + n2 < 0) {
            int n3 = byArray.length;
            throw new IndexOutOfBoundsException(new StringBuilder(60).append("offset ").append(n).append(", length ").append(n2).append(", b.length ").append(n3).toString());
        }
        if (0 == n2) {
            return 0;
        }
        int n4 = this.buf.remaining();
        if (0 == n4) {
            return -1;
        }
        int n5 = Math.min(n4, n2);
        if (this.buf.hasArray()) {
            System.arraycopy(this.buf.array(), this.buf.arrayOffset() + this.buf.position(), byArray, n, n5);
            this.buf.position(this.buf.position() + n5);
        } else {
            this.buf.get(byArray, n, n5);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byteBuffer.remaining()) {
            String string = String.valueOf(byteBuffer);
            throw new IndexOutOfBoundsException(new StringBuilder(22 + String.valueOf(string).length()).append("length ").append(n).append(", b ").append(string).toString());
        }
        if (0 == n) {
            return 0;
        }
        int n2 = this.buf.remaining();
        if (0 == n2) {
            return -1;
        }
        int n3 = Math.min(n2, n);
        if (this.buf.hasArray() && byteBuffer.hasArray()) {
            System.arraycopy(this.buf.array(), this.buf.arrayOffset() + this.buf.position(), byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n3);
            this.buf.position(this.buf.position() + n3);
            byteBuffer.position(byteBuffer.position() + n3);
        } else if (n3 == n2) {
            byteBuffer.put(this.buf);
        } else {
            int n4 = this.buf.limit();
            this.buf.limit(n3);
            try {
                byteBuffer.put(this.buf);
            }
            finally {
                this.buf.limit(n4);
            }
        }
        return n3;
    }

    public final ByteBuffer getBuffer() {
        return this.buf;
    }
}

