/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelperBase;
import java.util.Collections;
import java.util.Set;

public class TestModeOptimizingSearchHelper
extends OptimizingSearchHelperBase {
    private final StringBuilder builder = new StringBuilder();
    private String lastString;
    private int lastLength;

    TestModeOptimizingSearchHelper() {
    }

    @Override
    public boolean doOptimizing() {
        return true;
    }

    @Override
    public void clear() {
        this.lastString = this.builder.toString();
        this.builder.setLength(0);
        this.lastLength = 0;
    }

    @Override
    protected void doAddSearchWordInCode(String refname) {
        this.append(refname, "in code:");
    }

    @Override
    protected void doAddSearchWordInText(String refname) {
        this.append(refname, "in text:");
    }

    private void append(String refname, String str) {
        if (this.builder.length() == this.lastLength) {
            this.builder.append("[");
        } else {
            this.builder.append("|");
        }
        this.builder.append(str).append(refname);
    }

    @Override
    protected void doAddSearchWordInComments(String refname) {
        this.append(refname, "in comments:");
    }

    @Override
    protected void doAddSearchWordInLiterals(String refname) {
        this.append(refname, "in literals:");
    }

    @Override
    public void endTransaction() {
        super.endTransaction();
        this.builder.append("]");
        this.lastLength = this.builder.length();
    }

    @Override
    public boolean isScannedSomething() {
        return false;
    }

    @Override
    public Set<PsiFile> getFilesSetToScan() {
        return Collections.emptySet();
    }

    public String getSearchPlan() {
        return this.lastString;
    }
}

