/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.config.webXml;

import com.intellij.javaee.model.xml.Listener;
import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.converters.ContextParamsProvider;
import com.intellij.javaee.model.xml.web.Filter;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.model.converters.SpringBeanResolveConverterForDefiniteClasses;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.PsiClassConverter;
import com.intellij.util.xml.converters.values.ClassArrayConverter;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebContextParamsProvider
extends ContextParamsProvider {
    private static final String CONTEXT_INITIALIZER_CLASSES = "contextInitializerClasses";
    private static final String WEB_APP_ROOT_KEY = "webAppRootKey";
    private static final Set<String> SERVLET_PARAM_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"contextConfigLocation", "contextClass", "contextInitializerClasses", "namespace"});
    private static final Set<String> INIT_PARAM_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"contextConfigLocation", "webAppRootKey"});
    private static final Set<String> INIT_PARAM_NAMES_WITH_CONTEXT_LOADER = ContainerUtil.immutableSet((Object[])new String[]{"contextConfigLocation", "contextInitializerClasses", "webAppRootKey"});
    private static final Converter SPRING_BEAN_FILTER_CONVERTER = new SpringBeanResolveConverterForDefiniteClasses(){

        @Nullable
        protected String[] getClassNames(ConvertContext context) {
            return new String[]{"javax.servlet.Filter"};
        }

        @Nullable
        protected CommonSpringModel getSpringModel(ConvertContext context) {
            Module module = context.getModule();
            return module == null ? null : SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        }
    };

    @NotNull
    public Set<String> getContextParamNames(@NotNull Module module, ConvertContext convertContext) {
        if (module == null) {
            SpringWebContextParamsProvider.$$$reportNull$$$0(0);
        }
        if (!SpringWebContextParamsProvider.isRelevantModule(module)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringWebContextParamsProvider.$$$reportNull$$$0(1);
            }
            return set;
        }
        if (SpringWebContextParamsProvider.isFrameworkServlet(convertContext)) {
            Set<String> set = SERVLET_PARAM_NAMES;
            if (set == null) {
                SpringWebContextParamsProvider.$$$reportNull$$$0(2);
            }
            return set;
        }
        if (SpringWebContextParamsProvider.hasContextLoaderListener(convertContext)) {
            Set<String> set = INIT_PARAM_NAMES_WITH_CONTEXT_LOADER;
            if (set == null) {
                SpringWebContextParamsProvider.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<String> set = INIT_PARAM_NAMES;
        if (set == null) {
            SpringWebContextParamsProvider.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static boolean isRelevantModule(Module module) {
        return (SpringCommonUtils.hasSpringFacet((Module)module) || SpringModelUtils.getInstance().hasAutoConfiguredModels(module)) && !WebFacet.getInstances((Module)module).isEmpty() && SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.context.ContextLoaderListener") != null;
    }

    private static boolean isFrameworkServlet(ConvertContext convertContext) {
        Servlet servlet = (Servlet)convertContext.getInvocationElement().getParentOfType(Servlet.class, true);
        return servlet != null && InheritanceUtil.isInheritor((PsiClass)((PsiClass)servlet.getServletClass().getValue()), (String)"org.springframework.web.servlet.FrameworkServlet");
    }

    private static boolean hasContextLoaderListener(ConvertContext convertContext) {
        WebApp webApp = (WebApp)convertContext.getInvocationElement().getParentOfType(WebApp.class, true);
        if (webApp == null) {
            return false;
        }
        for (Listener listener : webApp.getListeners()) {
            if (!InheritanceUtil.isInheritor((PsiClass)((PsiClass)listener.getListenerClass().getValue()), (String)"org.springframework.web.context.ContextLoader")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Converter getContextParamValueConverter(@Nullable Module module, ParamValue paramValue, String paramName) {
        if ("contextClass".equals(paramName)) {
            return SpringWebContextParamsProvider.createClassConverter("org.springframework.web.context.ConfigurableWebApplicationContext");
        }
        if (CONTEXT_INITIALIZER_CLASSES.equals(paramName)) {
            return ClassArrayConverter.getClassArrayConverter();
        }
        if ("targetBeanName".equals(paramName) && SpringWebContextParamsProvider.isInDelegatingFilterProxy(paramValue)) {
            return SPRING_BEAN_FILTER_CONVERTER;
        }
        return null;
    }

    private static boolean isInDelegatingFilterProxy(ParamValue paramValue) {
        Filter filter = (Filter)paramValue.getParentOfType(Filter.class, true);
        if (filter == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)((PsiClass)filter.getFilterClass().getValue()), (String)"org.springframework.web.filter.DelegatingFilterProxy");
    }

    private static Converter createClassConverter(final String ... extendClasses) {
        return new PsiClassConverter(){

            protected JavaClassReferenceProvider createClassReferenceProvider(GenericDomValue<PsiClass> genericDomValue, ConvertContext context, ExtendClass extendClass) {
                JavaClassReferenceProvider provider = super.createClassReferenceProvider(genericDomValue, context, extendClass);
                provider.setOption(JavaClassReferenceProvider.EXTEND_CLASS_NAMES, (Object)extendClasses);
                provider.setOption(JavaClassReferenceProvider.INSTANTIATABLE, (Object)Boolean.TRUE);
                provider.setOption(JavaClassReferenceProvider.CONCRETE, (Object)Boolean.TRUE);
                return provider;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/config/webXml/SpringWebContextParamsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/config/webXml/SpringWebContextParamsProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextParamNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextParamNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

