/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.pathVariables;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNameValuePairPattern;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReference;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MVCRequestMappingReference
extends PsiReferenceBase<PsiLiteralExpression>
implements EmptyResolveMessageProvider {
    static final PsiJavaElementPattern.Capture<PsiLiteralExpression> PATTERN = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().withAncestor(3, (ElementPattern)((PsiNameValuePairPattern)PsiJavaPatterns.psiNameValuePair().withName(new String[]{"value", "name"})).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiAnnotationParameterList.class).withParent((ElementPattern)PsiJavaPatterns.psiAnnotation().qName("org.springframework.web.bind.annotation.PathVariable"))));

    MVCRequestMappingReference(PsiLiteralExpression psiElement) {
        super((PsiElement)psiElement);
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results;
        CommonProcessors.FindProcessor<MVCPathVariableReference> processor = new CommonProcessors.FindProcessor<MVCPathVariableReference>(){

            protected boolean accept(MVCPathVariableReference reference) {
                return reference.getValue().equals(MVCRequestMappingReference.this.getValue());
            }
        };
        this.processPathVariables((Processor<MVCPathVariableReference>)processor);
        MVCPathVariableReference value = (MVCPathVariableReference)((Object)processor.getFoundValue());
        if (value == null) {
            return null;
        }
        for (ResolveResult result : results = value.multiResolve(false)) {
            PsiElement element = result.getElement();
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processPathVariables((Processor<MVCPathVariableReference>)processor);
        SmartList variants = new SmartList();
        for (MVCPathVariableReference reference : processor.getResults()) {
            variants.add(reference.getValue());
        }
        Object[] objectArray = ArrayUtil.toStringArray((Collection)variants);
        if (objectArray == null) {
            MVCRequestMappingReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("Cannot resolve path variable ''{0}'' in request mapping" == null) {
            MVCRequestMappingReference.$$$reportNull$$$0(1);
        }
        return "Cannot resolve path variable ''{0}'' in request mapping";
    }

    private void processPathVariables(Processor<MVCPathVariableReference> processor) {
        PsiLiteralExpression element = (PsiLiteralExpression)this.getElement();
        PsiModifierListOwner method = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        boolean processed = MVCRequestMappingReference.processModifierListOwner(processor, method, RequestMapping.METHOD_JAM_KEY);
        if (!processed) {
            return;
        }
        PsiModifierListOwner clazz = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class);
        MVCRequestMappingReference.processModifierListOwner(processor, clazz, RequestMapping.CLASS_JAM_KEY);
    }

    private static <T extends PsiMember> boolean processModifierListOwner(Processor<MVCPathVariableReference> processor, @Nullable PsiModifierListOwner modifierListOwner, SemKey<? extends RequestMapping<T>> jamKey) {
        if (modifierListOwner == null) {
            return false;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return false;
        }
        RequestMapping requestMapping = (RequestMapping)JamService.getJamService((Project)modifierList.getProject()).getJamElement(jamKey, (PsiElement)modifierListOwner);
        if (requestMapping == null) {
            return true;
        }
        for (JamStringAttributeElement<String> urlAttribute : requestMapping.getMappingUrls()) {
            PsiAnnotationMemberValue urlPsiElement = urlAttribute.getPsiElement();
            if (urlPsiElement == null) continue;
            for (PsiReference reference : MVCRequestMappingReference.getReferencesForUrlPsiElement(urlPsiElement)) {
                boolean processed;
                if (!(reference instanceof MVCPathVariableReference) || (processed = processor.process((Object)((MVCPathVariableReference)reference)))) continue;
                return false;
            }
        }
        return true;
    }

    private static PsiReference[] getReferencesForUrlPsiElement(PsiAnnotationMemberValue element) {
        PsiReference[] initializer;
        if (element instanceof PsiLiteral) {
            return element.getReferences();
        }
        if (element instanceof PsiReferenceExpression && (initializer = MVCPathVariableReferenceProvider.createMVCPathVariableReferencesForReferenceExpression((PsiReferenceExpression)element)) != null) {
            return initializer;
        }
        return EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/web/mvc/pathVariables/MVCRequestMappingReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

