/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.ws.references.WSReference;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.constants.RSConstants;
import com.intellij.ws.rest.references.RestMimePsiElement;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MimeReference
extends WSReference<PsiLiteralExpression> {
    @NonNls
    static final Pattern MIME_PATTERN = Pattern.compile("[^\\p{Cc}^\\s]+/[^\\p{Cc}^\\s]+");

    public MimeReference(@NotNull PsiLiteralExpression element) {
        if (element == null) {
            MimeReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
    }

    public MimeReference(PsiLiteralExpression element, TextRange range) {
        super((PsiElement)element, range);
    }

    public PsiElement resolve() {
        String value = this.getValue();
        if (!MIME_PATTERN.matcher(value).matches()) {
            return null;
        }
        return new RestMimePsiElement((PsiLiteralExpression)this.getElement());
    }

    @NotNull
    public Object[] getVariants() {
        if (RSConstants.PREDEFINED_MIME_TYPES == null) {
            MimeReference.$$$reportNull$$$0(1);
        }
        return RSConstants.PREDEFINED_MIME_TYPES;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = RSBundle.message("webservices.inspections.rest.annotation.has.wrong.mime.type.problem", new Object[0]);
        if (string == null) {
            MimeReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof RestMimePsiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/references/MimeReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/references/MimeReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

