/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.ioc;

import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.ioc.ServiceBinding;
import com.intellij.tapestry.core.java.IJavaAnnotation;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaMethod;
import com.intellij.tapestry.core.model.ioc.Service;
import java.util.ArrayList;
import java.util.Collection;

public class ModuleBuilder {
    private static final String SCOPE_ANNOTATION = "org.apache.tapestry5.ioc.annotations.Scope";
    private static final String EAGERLOAD_ANNOTATION = "org.apache.tapestry5.ioc.annotations.EagerLoad";
    private final IJavaClassType _moduleBuilderClass;
    private final TapestryProject _project;
    private Collection<Service> _servicesCache;
    private long _servicesCacheTimestamp;

    public ModuleBuilder(IJavaClassType moduleBuilderClass, TapestryProject project) {
        this._moduleBuilderClass = moduleBuilderClass;
        this._project = project;
    }

    public Collection<Service> getServices() {
        if (this._servicesCache != null && !this.hasChanged(this._servicesCacheTimestamp)) {
            return this._servicesCache;
        }
        this._servicesCache = new ArrayList<Service>();
        for (IJavaMethod method : this._moduleBuilderClass.getPublicMethods(true)) {
            if (!(method.getReturnType() instanceof IJavaClassType)) continue;
            if (method.getName().matches("build[\\w\\$]*")) {
                this._servicesCache.add(this.getServiceFromBuildMethod(method));
            }
            if (!method.getName().equals("bind")) continue;
            this._servicesCache.addAll(this.getServicesFromBindMethod(method));
        }
        this._servicesCacheTimestamp = this._moduleBuilderClass.getFile().getFile().lastModified();
        return this._servicesCache;
    }

    private Service getServiceFromBuildMethod(IJavaMethod method) {
        ServiceBinding serviceBinding = new ServiceBinding();
        IJavaAnnotation scopeAnnotation = method.getAnnotation(SCOPE_ANNOTATION);
        if (scopeAnnotation != null) {
            serviceBinding.setScope(scopeAnnotation.getParameters().get("value")[0]);
        }
        if (method.getAnnotation(EAGERLOAD_ANNOTATION) != null) {
            serviceBinding.setEagerLoad(true);
        }
        if (method.getName().equals("build")) {
            serviceBinding.setId(method.getReturnType().getName());
            return new Service(serviceBinding, (IJavaClassType)method.getReturnType());
        }
        serviceBinding.setId(method.getName().substring("build".length()));
        return new Service(serviceBinding, (IJavaClassType)method.getReturnType());
    }

    private Collection<Service> getServicesFromBindMethod(IJavaMethod method) {
        ArrayList<Service> services = new ArrayList<Service>();
        for (ServiceBinding binding : this._project.getJavaTypeFinder().getServiceBindingDiscoverer().getServiceBindings(method)) {
            services.add(new Service(binding, (IJavaClassType)method.getReturnType()));
        }
        return services;
    }

    private boolean hasChanged(long timestamp) {
        return this._moduleBuilderClass.getFile().getFile().lastModified() > timestamp;
    }
}

