/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation;

import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.exceptions.NotTapestryElementException;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.model.Library;
import com.intellij.tapestry.core.model.externalizable.ExternalizableToTemplate;
import com.intellij.tapestry.core.model.externalizable.totemplatechain.ExternalizeToTemplateChain;
import com.intellij.tapestry.core.model.presentation.ParameterReceiverElement;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.core.util.PathUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class Component
extends ParameterReceiverElement
implements ExternalizableToTemplate {
    private IResource[] _templateCache;

    protected Component(@NotNull Library library, @NotNull IJavaClassType componentClass, @NotNull TapestryProject project) throws NotTapestryElementException {
        if (library == null) {
            Component.$$$reportNull$$$0(0);
        }
        if (componentClass == null) {
            Component.$$$reportNull$$$0(1);
        }
        if (project == null) {
            Component.$$$reportNull$$$0(2);
        }
        super(library, componentClass, project);
    }

    protected Component(@NotNull IJavaClassType componentClass, @NotNull TapestryProject project) throws NotTapestryElementException {
        if (componentClass == null) {
            Component.$$$reportNull$$$0(3);
        }
        if (project == null) {
            Component.$$$reportNull$$$0(4);
        }
        super(null, componentClass, project);
    }

    @Override
    public boolean allowsTemplate() {
        return true;
    }

    @Override
    public IResource[] getTemplate() {
        if (this._templateCache != null && Component.checkAllValidResources(this._templateCache)) {
            return this._templateCache;
        }
        String fqn = this.getElementClass().getFullyQualifiedName();
        String packageName = fqn.substring(0, fqn.lastIndexOf(46));
        Collection<IResource> resources = this.getProject().getResourceFinder().findLocalizedClasspathResource(PathUtils.packageIntoPath(packageName, true) + PathUtils.getLastPathElement(this.getName()) + "." + "tml", true);
        if (resources.size() > 0) {
            ArrayList<IResource> templates = new ArrayList<IResource>();
            for (IResource template : resources) {
                templates.add(template);
            }
            this._templateCache = templates.toArray(new IResource[templates.size()]);
        } else {
            this._templateCache = IResource.EMPTY_ARRAY;
        }
        return this._templateCache;
    }

    @Override
    public String getTemplateRepresentation(String namespacePrefix) throws Exception {
        return ExternalizeToTemplateChain.getInstance().externalize(this, namespacePrefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "library";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "componentClass";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/tapestry/core/model/presentation/Component";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

