/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.runConfiguration;

import com.google.common.base.Strings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainersManager;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfiguration;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfigurationCoordinator;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianTestFrameworkRunConfiguration;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianTestNGConfigurationPanel;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationEditor;
import com.theoryinpractice.testng.model.TestData;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArquillianTestNGRunConfiguration
extends TestNGConfiguration
implements ArquillianTestFrameworkRunConfiguration {
    public ArquillianRunConfiguration arquillianRunConfiguration;
    @NotNull
    private final ArquillianRunConfigurationCoordinator arquillianRunConfigurationCoordinator;

    public ArquillianTestNGRunConfiguration(String name, Project project, String containerStateName, ConfigurationFactory configurationFactory) {
        super(name, project, configurationFactory);
        this.setNameChangedByUser(false);
        this.arquillianRunConfiguration = new ArquillianRunConfiguration(containerStateName);
        this.arquillianRunConfigurationCoordinator = new ArquillianRunConfigurationCoordinator(project);
    }

    private ArquillianTestNGRunConfiguration(String name, Project project, TestData data, ConfigurationFactory configurationFactory, ArquillianRunConfiguration arquillianRunConfiguration) {
        super(name, project, data, configurationFactory);
        this.arquillianRunConfiguration = arquillianRunConfiguration;
        this.arquillianRunConfigurationCoordinator = new ArquillianRunConfigurationCoordinator(project);
    }

    @Nullable
    public RemoteConnectionCreator getRemoteConnectionCreator() {
        return this.arquillianRunConfigurationCoordinator.getRemoteConnectionCreator(this.arquillianRunConfiguration);
    }

    public String suggestedName() {
        String containerName = this.arquillianRunConfiguration.getContainerStateName();
        String suggestedName = super.suggestedName();
        return Strings.isNullOrEmpty((String)containerName) ? suggestedName : containerName + ": " + suggestedName;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String containerStateName = this.arquillianRunConfiguration.getContainerStateName();
        if (Strings.isNullOrEmpty((String)containerStateName)) {
            throw new RuntimeConfigurationError(ArquillianBundle.message((String)"arquillian.container.configuration.not.specified", (Object[])new Object[0]));
        }
        if (ArquillianContainersManager.getInstance((Project)this.getProject()).findStateByName(containerStateName) == null) {
            throw new RuntimeConfigurationError(ArquillianBundle.message((String)"arquillian.container.configuration.not.found", (Object[])new Object[]{containerStateName}));
        }
    }

    @Nullable
    public Set<String> calculateGroupNames() {
        Set groupNames = super.calculateGroupNames();
        if (groupNames == null) {
            return null;
        }
        groupNames.add("arquillian");
        return groupNames;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ArquillianBundle.message((String)"arquillian.run.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ArquillianTestNGConfigurationPanel(this.getProject()));
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new TestNGConfigurationEditor(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor("Logs", (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            ArquillianTestNGRunConfiguration.$$$reportNull$$$0(0);
        }
        return settingsEditorGroup;
    }

    public ArquillianRunConfiguration getArquillianRunConfiguration() {
        return this.arquillianRunConfiguration;
    }

    public ArquillianRunConfiguration getRunConfiguration() {
        return this.arquillianRunConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianTestNGRunConfiguration", "getConfigurationEditor"));
    }
}

