/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/KotlinAndroidViewConstructorFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;", "element", "(Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Factory", "idea-android"})
public final class KotlinAndroidViewConstructorFix
extends KotlinQuickFixAction<KtSuperTypeEntry> {
    private static final FqName fqNameAnnotation;
    private static final List<String> requiredConstructorParameterTypes;
    public static final Factory Factory;

    @NotNull
    public String getText() {
        return "Add Android View constructors using '@JvmOverloads'";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (AndroidFacet.getInstance((PsiElement)((PsiElement)file2)) == null) {
            return false;
        }
        return super.isAvailable(project, editor, file2);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        PsiElement psiElement2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtSuperTypeEntry ktSuperTypeEntry = (KtSuperTypeEntry)this.getElement();
        if (ktSuperTypeEntry == null) {
            return;
        }
        KtSuperTypeEntry element3 = ktSuperTypeEntry;
        KtClass ktClass2 = KtPsiUtilKt.containingClass(element3);
        if (ktClass2 == null) {
            return;
        }
        KtClass ktClass3 = ktClass2;
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        KtPrimaryConstructor ktPrimaryConstructor = ((KtClass)CreateByPatternKt.createDeclarationByPattern$default(factory2, "class A constructor(\n $0, $1, $2\n)", new Object[]{factory2.createParameter("context: android.content.Context"), factory2.createParameter("attrs: android.util.AttributeSet? = null"), factory2.createParameter("defStyleAttr: Int = 0")}, false, 4, null)).getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor newPrimaryConstructor = ktPrimaryConstructor;
        PsiElement $receiver$iv = KtClassKt.createPrimaryConstructorIfAbsent(ktClass3);
        PsiElement result$iv = $receiver$iv.replace((PsiElement)newPrimaryConstructor);
        if (result$iv instanceof KtPrimaryConstructor) {
            psiElement2 = result$iv;
        } else {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrimaryConstructor");
            }
            psiElement2 = (KtPrimaryConstructor)ktExpression;
        }
        KtPrimaryConstructor primaryConstructor2 = (KtPrimaryConstructor)psiElement2;
        KtParameterList ktParameterList = primaryConstructor2.getValueParameterList();
        if (ktParameterList != null) {
            KtParameterList ktParameterList2;
            KtParameterList it = ktParameterList2 = ktParameterList;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, it, null, 2, null);
        }
        ModifierListModifactorKt.addAnnotation$default(primaryConstructor2, KotlinAndroidViewConstructorFix.Factory.getFqNameAnnotation(), null, " ", null, 10, null);
        element3.replace((PsiElement)factory2.createSuperTypeCallEntry(element3.getText() + "(context, attrs, defStyleAttr)"));
    }

    public KotlinAndroidViewConstructorFix(@NotNull KtSuperTypeEntry element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    static {
        Factory = new Factory(null);
        fqNameAnnotation = new FqName("kotlin.jvm.JvmOverloads");
        requiredConstructorParameterTypes = CollectionsKt.listOf((Object[])new String[]{"android.content.Context", "android.util.AttributeSet", "kotlin.Int"});
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001c\u0010\u0010\u001a\u0012\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u0018\u00010\b*\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\t*\u00020\u0011H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0011H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/KotlinAndroidViewConstructorFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "fqNameAnnotation", "Lorg/jetbrains/kotlin/name/FqName;", "getFqNameAnnotation", "()Lorg/jetbrains/kotlin/name/FqName;", "requiredConstructorParameterTypes", "", "", "getRequiredConstructorParameterTypes", "()Ljava/util/List;", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "constructorParameters", "Lorg/jetbrains/kotlin/types/KotlinType;", "getFqNameAsString", "isAndroidView", "", "idea-android"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        private final FqName getFqNameAnnotation() {
            return fqNameAnnotation;
        }

        private final List<String> getRequiredConstructorParameterTypes() {
            return requiredConstructorParameterTypes;
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Object type2;
            KtTypeReference ktTypeReference;
            KtTypeReference it;
            KtSuperTypeEntry superTypeEntry;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.SUPERTYPE_NOT_INITIALIZED.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"SUPERTYPE_NOT_INITIALIZED.cast(diagnostic)");
            KtSuperTypeEntry ktSuperTypeEntry = superTypeEntry = (KtSuperTypeEntry)((SimpleDiagnostic)d).getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSuperTypeEntry, (String)"superTypeEntry");
            KtClass ktClass2 = KtPsiUtilKt.containingClass(ktSuperTypeEntry);
            if (ktClass2 == null) {
                return null;
            }
            KtClass ktClass3 = ktClass2;
            if (ktClass3.getPrimaryConstructor() != null) {
                return null;
            }
            BindingContext context = ResolutionUtils.analyze$default(superTypeEntry, null, 1, null);
            Object object = superTypeEntry.getTypeReference();
            if (object == null || (object = (KotlinType)context.get(BindingContext.TYPE, it = (ktTypeReference = object))) == null) {
                return null;
            }
            Object object2 = type2 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"type");
            if (!this.isAndroidView((KotlinType)object2)) {
                boolean bl;
                block10: {
                    Iterable $receiver$iv = TypeUtilsKt.supertypes((KotlinType)type2);
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            KotlinType it2 = (KotlinType)element$iv;
                            if (!Factory.isAndroidView(it2)) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return null;
                }
            }
            List<List<String>> list2 = this.constructorParameters((KotlinType)type2);
            if (list2 == null) {
                return null;
            }
            List<List<String>> names2 = list2;
            if (!names2.contains(this.getRequiredConstructorParameterTypes())) {
                return null;
            }
            return new KotlinAndroidViewConstructorFix(superTypeEntry);
        }

        private final String getFqNameAsString(@NotNull KotlinType $receiver) {
            Object object = $receiver.getConstructor().getDeclarationDescriptor();
            return object != null && (object = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)object)) != null ? ((FqNameUnsafe)object).asString() : null;
        }

        private final boolean isAndroidView(@NotNull KotlinType $receiver) {
            return Intrinsics.areEqual((Object)this.getFqNameAsString($receiver), (Object)"android.view.View");
        }

        /*
         * WARNING - void declaration
         */
        private final List<List<String>> constructorParameters(@NotNull KotlinType $receiver) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            Collection<ClassConstructorDescriptor> collection = classDescriptor2.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"classDescriptor.constructors");
            Iterable iterable = $receiver$iv = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                Iterable $receiver$iv2;
                void it;
                ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                List<ValueParameterDescriptor> list2 = v3.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.valueParameters");
                Iterable iterable2 = $receiver$iv2 = (Iterable)list2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv2 : $receiver$iv$iv2) {
                    void it2;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv2;
                    Collection collection3 = destination$iv$iv2;
                    void v5 = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                    KotlinType kotlinType = v5.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"it.type");
                    String string = Factory.getFqNameAsString(kotlinType);
                    collection3.add(string);
                }
                List list3 = (List)destination$iv$iv2;
                collection2.add(list3);
            }
            return (List)destination$iv$iv;
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

