/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.caches.resolve.lightClasses.LightMemberOriginForCompiledElementKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.ClassFileDecompilerUtilKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.DeserializerForClassfileDecompilerKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.KotlinClassFileDecompilerKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.KotlinClassFileDecompilerKt$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.common.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.idea.decompiler.navigation.ByDescriptorIndexer;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.BuildDecompiledTextKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledTextIndexer;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.ResolverForDecompiler;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"decompilerRendererForClassFiles", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextForClassFile", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/ResolverForDecompiler;", "idea-core"})
public final class KotlinClassFileDecompilerKt {
    private static final DescriptorRenderer decompilerRendererForClassFiles = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)decompilerRendererForClassFiles.1.INSTANCE));

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DecompiledText buildDecompiledTextForClassFile(@NotNull VirtualFile classFile, @NotNull ResolverForDecompiler resolver2) {
        DecompiledText decompiledText2;
        void classHeader;
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        Intrinsics.checkParameterIsNotNull((Object)resolver2, (String)"resolver");
        IDEKotlinBinaryClassCache.KotlinBinaryHeaderData kotlinBinaryHeaderData = IDEKotlinBinaryClassCache.getKotlinBinaryClassHeaderData$default(IDEKotlinBinaryClassCache.INSTANCE, classFile, null, 2, null);
        if (kotlinBinaryHeaderData == null) {
            String string = "Decompiled data factory shouldn't be called on an unsupported file: " + classFile;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        IDEKotlinBinaryClassCache.KotlinBinaryHeaderData kotlinBinaryHeaderData2 = kotlinBinaryHeaderData;
        KotlinClassHeader kotlinClassHeader = kotlinBinaryHeaderData2.component1();
        ClassId classId = kotlinBinaryHeaderData2.component2();
        if (!classHeader.getMetadataVersion().isCompatible()) {
            return IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)JvmMetadataVersion.INSTANCE, (BinaryVersion)classHeader.getMetadataVersion());
        }
        Function1<List<? extends DeclarationDescriptor>, DecompiledText> buildText$ = new Function1<List<? extends DeclarationDescriptor>, DecompiledText>(classId){
            final /* synthetic */ ClassId $classId;

            @NotNull
            public final DecompiledText invoke(@NotNull List<? extends DeclarationDescriptor> declarations2) {
                Intrinsics.checkParameterIsNotNull(declarations2, (String)"declarations");
                FqName fqName2 = this.$classId.getPackageFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
                return BuildDecompiledTextKt.buildDecompiledText(fqName2, declarations2, KotlinClassFileDecompilerKt.access$getDecompilerRendererForClassFiles$p(), CollectionsKt.listOf((Object[])new DecompiledTextIndexer[]{ByDescriptorIndexer.INSTANCE, LightMemberOriginForCompiledElementKt.getBySignatureIndexer()}));
            }
            {
                this.$classId = classId;
                super(1);
            }
        };
        switch (KotlinClassFileDecompilerKt$WhenMappings.$EnumSwitchMapping$0[classHeader.getKind().ordinal()]) {
            case 1: {
                FqName fqName2 = classId.asSingleFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.asSingleFqName()");
                decompiledText2 = buildText$.invoke(resolver2.resolveDeclarationsInFacade(fqName2));
                break;
            }
            case 2: {
                decompiledText2 = buildText$.invoke((List<? extends DeclarationDescriptor>)CollectionsKt.listOfNotNull((Object)resolver2.resolveTopLevelClass(classId)));
                break;
            }
            case 3: {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                List<KotlinJvmBinaryClass> partClasses = ClassFileDecompilerUtilKt.findMultifileClassParts(classFile, classId, (KotlinClassHeader)classHeader);
                Iterable iterable = $receiver$iv = (Iterable)partClasses;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    KotlinJvmBinaryClass partClass = (KotlinJvmBinaryClass)element$iv$iv;
                    FqName fqName3 = partClass.getClassId().asSingleFqName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"partClass.classId.asSingleFqName()");
                    Iterable list$iv$iv = resolver2.resolveDeclarationsInFacade(fqName3);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List partMembers = (List)destination$iv$iv;
                decompiledText2 = buildText$.invoke((List<? extends DeclarationDescriptor>)partMembers);
                break;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException("Unknown header kind: " + classHeader + ", class " + classId);
            }
        }
        return decompiledText2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ DecompiledText buildDecompiledTextForClassFile$default(VirtualFile virtualFile2, ResolverForDecompiler resolverForDecompiler, int n, Object object) {
        if ((n & 2) != 0) {
            resolverForDecompiler = DeserializerForClassfileDecompilerKt.DeserializerForClassfileDecompiler(virtualFile2);
        }
        return KotlinClassFileDecompilerKt.buildDecompiledTextForClassFile(virtualFile2, resolverForDecompiler);
    }

    @NotNull
    public static final /* synthetic */ DescriptorRenderer access$getDecompilerRendererForClassFiles$p() {
        return decompilerRendererForClassFiles;
    }
}

