/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.facet;

import com.intellij.facet.impl.ui.libraries.LibrariesValidatorContext;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.facet.ui.libraries.FrameworkLibraryValidator;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProvider;
import org.jetbrains.kotlin.idea.framework.CommonStandardLibraryDescription;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeLibraryDescription;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/facet/FrameworkLibraryValidatorWithDynamicDescription;", "Lcom/intellij/facet/ui/libraries/FrameworkLibraryValidator;", "context", "Lcom/intellij/facet/impl/ui/libraries/LibrariesValidatorContext;", "validatorsManager", "Lcom/intellij/facet/ui/FacetValidatorsManager;", "libraryCategoryName", "", "getTargetPlatform", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "(Lcom/intellij/facet/impl/ui/libraries/LibrariesValidatorContext;Lcom/intellij/facet/ui/FacetValidatorsManager;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "libraryDescription", "Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "getLibraryDescription", "(Lorg/jetbrains/kotlin/config/TargetPlatformKind;)Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "check", "Lcom/intellij/facet/ui/ValidationResult;", "checkLibraryIsConfigured", "", "targetPlatform", "LibrariesQuickFix", "idea"})
public final class FrameworkLibraryValidatorWithDynamicDescription
extends FrameworkLibraryValidator {
    private final LibrariesValidatorContext context;
    private final FacetValidatorsManager validatorsManager;
    private final String libraryCategoryName;
    private final Function0<TargetPlatformKind<?>> getTargetPlatform;

    private final CustomLibraryDescription getLibraryDescription(@NotNull TargetPlatformKind<?> $receiver) {
        CustomLibraryDescription customLibraryDescription;
        Module module = this.context.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"context.module");
        Project project = module.getProject();
        TargetPlatformKind<?> targetPlatformKind = $receiver;
        if (targetPlatformKind instanceof TargetPlatformKind.Jvm) {
            customLibraryDescription = new JavaRuntimeLibraryDescription(project);
        } else if (targetPlatformKind instanceof TargetPlatformKind.JavaScript) {
            customLibraryDescription = new JSLibraryStdDescription(project);
        } else if (targetPlatformKind instanceof TargetPlatformKind.Common) {
            customLibraryDescription = new CommonStandardLibraryDescription(project);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return customLibraryDescription;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkLibraryIsConfigured(TargetPlatformKind<?> targetPlatform) {
        void found2;
        boolean bl;
        Object element$iv;
        block3: {
            if (Intrinsics.areEqual(targetPlatform, (Object)TargetPlatformKind.Common.INSTANCE)) {
                return true;
            }
            Object[] objectArray = KotlinVersionInfoProvider.Companion.getEP_NAME().getExtensions();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"KotlinVersionInfoProvider.EP_NAME.extensions");
            Object[] $receiver$iv = objectArray;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                element$iv = $receiver$iv[i];
                KotlinVersionInfoProvider it = (KotlinVersionInfoProvider)element$iv;
                Module module = this.context.getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"context.module");
                Collection<String> collection = it.getLibraryVersions(module, targetPlatform, this.context.getRootModel());
                if (!(!collection.isEmpty())) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        CustomLibraryDescription libraryDescription = this.getLibraryDescription(targetPlatform);
        Set libraryKinds = libraryDescription.getSuitableLibraryKinds();
        element$iv = new Ref.BooleanRef();
        ((Ref.BooleanRef)element$iv).element = false;
        LibraryPresentationManager presentationManager = LibraryPresentationManager.getInstance();
        this.context.getRootModel().orderEntries().using((RootModelProvider)this.context.getModulesProvider()).recursively().librariesOnly().forEachLibrary((Processor)new Processor<Library>(this, presentationManager, libraryKinds, (Ref.BooleanRef)found2){
            final /* synthetic */ FrameworkLibraryValidatorWithDynamicDescription this$0;
            final /* synthetic */ LibraryPresentationManager $presentationManager;
            final /* synthetic */ Set $libraryKinds;
            final /* synthetic */ Ref.BooleanRef $found;

            public final boolean process(Library library2) {
                if (this.$presentationManager.isLibraryOfKind(library2, FrameworkLibraryValidatorWithDynamicDescription.access$getContext$p(this.this$0).getLibrariesContainer(), this.$libraryKinds)) {
                    this.$found.element = true;
                }
                return !this.$found.element;
            }
            {
                this.this$0 = frameworkLibraryValidatorWithDynamicDescription;
                this.$presentationManager = libraryPresentationManager;
                this.$libraryKinds = set2;
                this.$found = booleanRef;
            }
        });
        return found2.element;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ValidationResult check() {
        TargetPlatformKind targetPlatform = (TargetPlatformKind)this.getTargetPlatform.invoke();
        if (this.checkLibraryIsConfigured(targetPlatform)) {
            TargetPlatformKind it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)TargetPlatformKind.Companion.getALL_PLATFORMS();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (TargetPlatformKind)element$iv$iv;
                if (!(Intrinsics.areEqual((Object)it, (Object)TargetPlatformKind.Common.INSTANCE) ^ true && Intrinsics.areEqual((Object)it.getName(), (Object)targetPlatform.getName()) ^ true && this.checkLibraryIsConfigured(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List conflictingPlatforms = (List)destination$iv$iv;
            $receiver$iv = conflictingPlatforms;
            if (!$receiver$iv.isEmpty()) {
                void $receiver$iv2;
                $receiver$iv$iv = conflictingPlatforms;
                Collection destination$iv = new LinkedHashSet();
                for (Object item$iv : $receiver$iv2) {
                    it = (TargetPlatformKind)item$iv;
                    Collection collection = destination$iv;
                    String string = it.getName();
                    collection.add(string);
                }
                String platformText = CollectionsKt.joinToString$default((Iterable)destination$iv, null, null, null, (int)0, null, null, (int)63, null);
                return new ValidationResult("Libraries for the following platform are also present in the module dependencies: " + platformText);
            }
            ValidationResult validationResult = ValidationResult.OK;
            Intrinsics.checkExpressionValueIsNotNull((Object)validationResult, (String)"ValidationResult.OK");
            return validationResult;
        }
        return new ValidationResult(IdeBundle.message((String)"label.missed.libraries.text", (Object[])new Object[]{this.libraryCategoryName}), (FacetConfigurationQuickFix)new LibrariesQuickFix(this.getLibraryDescription(targetPlatform)));
    }

    public FrameworkLibraryValidatorWithDynamicDescription(@NotNull LibrariesValidatorContext context, @NotNull FacetValidatorsManager validatorsManager, @NotNull String libraryCategoryName, @NotNull Function0<? extends TargetPlatformKind<?>> getTargetPlatform) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)validatorsManager, (String)"validatorsManager");
        Intrinsics.checkParameterIsNotNull((Object)libraryCategoryName, (String)"libraryCategoryName");
        Intrinsics.checkParameterIsNotNull(getTargetPlatform, (String)"getTargetPlatform");
        this.context = context;
        this.validatorsManager = validatorsManager;
        this.libraryCategoryName = libraryCategoryName;
        this.getTargetPlatform = getTargetPlatform;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/facet/FrameworkLibraryValidatorWithDynamicDescription$LibrariesQuickFix;", "Lcom/intellij/facet/ui/FacetConfigurationQuickFix;", "myDescription", "Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "(Lorg/jetbrains/kotlin/idea/facet/FrameworkLibraryValidatorWithDynamicDescription;Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;)V", "run", "", "place", "Ljavax/swing/JComponent;", "idea"})
    private final class LibrariesQuickFix
    extends FacetConfigurationQuickFix {
        private final CustomLibraryDescription myDescription;

        public void run(@NotNull JComponent place) {
            Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
            AddCustomLibraryDialog dialog2 = AddCustomLibraryDialog.createDialog((CustomLibraryDescription)this.myDescription, (LibrariesContainer)FrameworkLibraryValidatorWithDynamicDescription.this.context.getLibrariesContainer(), (Module)FrameworkLibraryValidatorWithDynamicDescription.this.context.getModule(), (ModifiableRootModel)FrameworkLibraryValidatorWithDynamicDescription.this.context.getModifiableRootModel(), null);
            dialog2.show();
            FrameworkLibraryValidatorWithDynamicDescription.this.validatorsManager.validate();
        }

        public LibrariesQuickFix(CustomLibraryDescription myDescription) {
            Intrinsics.checkParameterIsNotNull((Object)myDescription, (String)"myDescription");
            super(IdeBundle.message((String)"button.fix", (Object[])new Object[0]));
            this.myDescription = myDescription;
        }
    }
}

