/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "libraryJarDescriptors", "", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;)V", "getLibraryJarDescriptors", "()Ljava/util/List;", "getLibraryDescriptor", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "module", "Lcom/intellij/openapi/module/Module;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "MavenExternalLibraryDescriptor", "idea"})
public abstract class AddKotlinLibQuickFix
extends KotlinQuickFixAction<KtElement> {
    @NotNull
    private final List<LibraryJarDescriptor> libraryJarDescriptors;

    @NotNull
    protected abstract MavenExternalLibraryDescriptor getLibraryDescriptor(@NotNull Module var1);

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Module module;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return;
        }
        KtElement element3 = ktElement;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        PsiFile psiFile = element3.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
        Module module2 = projectFileIndex.getModuleForFile(psiFile.getVirtualFile());
        if (module2 == null) {
            return;
        }
        Module module3 = module = module2;
        Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
        KotlinProjectConfigurator configurator = ConfigureKotlinInProjectUtilsKt.findApplicableConfigurator(module3);
        configurator.addLibraryDependency(module, (PsiElement)element3, this.getLibraryDescriptor(module), this.libraryJarDescriptors);
    }

    @NotNull
    public final List<LibraryJarDescriptor> getLibraryJarDescriptors() {
        return this.libraryJarDescriptors;
    }

    public AddKotlinLibQuickFix(@NotNull KtElement element3, @NotNull List<? extends LibraryJarDescriptor> libraryJarDescriptors) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(libraryJarDescriptors, (String)"libraryJarDescriptors");
        super((PsiElement)element3);
        this.libraryJarDescriptors = libraryJarDescriptors;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "groupId", "", "artifactId", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLibraryClassesRoots", "", "idea"})
    public static final class MavenExternalLibraryDescriptor
    extends ExternalLibraryDescriptor {
        @NotNull
        public List<String> getLibraryClassesRoots() {
            return CollectionsKt.emptyList();
        }

        public MavenExternalLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
            Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
            Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            super(groupId, artifactId, version, version);
        }
    }
}

