/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractFunction.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractFunction.ui.ExtractFunctionParameterTablePanel;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableAnalysisUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptorKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptorWithConflicts;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorConfiguration;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorOptions;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractorUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.Parameter;
import org.jetbrains.kotlin.idea.refactoring.introduce.ui.KotlinSignatureComponent;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.types.KotlinType;

public class KotlinExtractFunctionDialog
extends DialogWrapper {
    private JPanel contentPane;
    private TitledSeparator inputParametersPanel;
    private JComboBox visibilityBox;
    private KotlinSignatureComponent signaturePreviewField;
    private JPanel functionNamePanel;
    private NameSuggestionsField functionNameField;
    private JLabel functionNameLabel;
    private JComboBox returnTypeBox;
    private JPanel returnTypePanel;
    private ExtractFunctionParameterTablePanel parameterTablePanel;
    private final Project project;
    private final ExtractableCodeDescriptorWithConflicts originalDescriptor;
    private ExtractableCodeDescriptor currentDescriptor;
    private final Function1<KotlinExtractFunctionDialog, Unit> onAccept;

    public KotlinExtractFunctionDialog(@NotNull Project project, @NotNull ExtractableCodeDescriptorWithConflicts originalDescriptor, @NotNull Function1<KotlinExtractFunctionDialog, Unit> onAccept) {
        if (project == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(0);
        }
        if (originalDescriptor == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(1);
        }
        if (onAccept == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.project = project;
        this.originalDescriptor = originalDescriptor;
        this.$$$setupUI$$$();
        this.currentDescriptor = originalDescriptor.getDescriptor();
        this.onAccept = onAccept;
        this.setModal(true);
        this.setTitle(KotlinRefactoringBundle.message("extract.function", new Object[0]));
        this.init();
        this.update();
    }

    private void createUIComponents() {
        this.signaturePreviewField = new KotlinSignatureComponent("", this.project);
    }

    private boolean isVisibilitySectionAvailable() {
        return ExtractableAnalysisUtilKt.isVisibilityApplicable(this.originalDescriptor.getDescriptor().getExtractionData());
    }

    private String getFunctionName() {
        return UtilsKt.quoteIfNeeded(this.functionNameField.getEnteredName());
    }

    private String getVisibility() {
        if (!this.isVisibilitySectionAvailable()) {
            return "";
        }
        String value2 = (String)this.visibilityBox.getSelectedItem();
        return KtTokens.PUBLIC_KEYWORD.getValue().equals(value2) ? "" : value2;
    }

    private boolean checkNames() {
        if (!KotlinNameSuggester.INSTANCE.isIdentifier(this.getFunctionName())) {
            return false;
        }
        for (ExtractFunctionParameterTablePanel.ParameterInfo parameterInfo : this.parameterTablePanel.getSelectedParameterInfos()) {
            if (KotlinNameSuggester.INSTANCE.isIdentifier(parameterInfo.getName())) continue;
            return false;
        }
        return true;
    }

    private void update() {
        this.currentDescriptor = this.createDescriptor();
        this.setOKActionEnabled(this.checkNames());
        this.signaturePreviewField.setText(ExtractorUtilKt.getSignaturePreview(this.getCurrentConfiguration(), IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES));
    }

    protected void init() {
        super.init();
        ExtractableCodeDescriptor extractableCodeDescriptor = this.originalDescriptor.getDescriptor();
        this.functionNameField = new NameSuggestionsField(ArrayUtil.toStringArray(extractableCodeDescriptor.getSuggestedNames()), this.project, (FileType)KotlinFileType.INSTANCE);
        this.functionNameField.addDataChangedListener(new NameSuggestionsField.DataChanged(){

            public void dataChanged() {
                KotlinExtractFunctionDialog.this.update();
            }
        });
        this.functionNamePanel.add((Component)this.functionNameField, "Center");
        this.functionNameLabel.setLabelFor((Component)this.functionNameField);
        List<KotlinType> possibleReturnTypes = ExtractableCodeDescriptorKt.getPossibleReturnTypes(extractableCodeDescriptor.getControlFlow());
        if (possibleReturnTypes.size() > 1) {
            DefaultComboBoxModel<Object> returnTypeBoxModel = new DefaultComboBoxModel<Object>(possibleReturnTypes.toArray());
            this.returnTypeBox.setModel(returnTypeBoxModel);
            this.returnTypeBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list2, value2, index2, isSelected, cellHasFocus);
                    this.setText(IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType((KotlinType)value2));
                    2 v0 = this;
                    if (v0 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return v0;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog$2", "getListCellRendererComponent"));
                }
            });
            this.returnTypeBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(@NotNull ItemEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    KotlinExtractFunctionDialog.this.update();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog$3", "itemStateChanged"));
                }
            });
        } else {
            this.returnTypePanel.getParent().remove(this.returnTypePanel);
        }
        boolean enableVisibility = this.isVisibilitySectionAvailable();
        this.visibilityBox.setEnabled(enableVisibility);
        if (enableVisibility) {
            String defaultVisibility = extractableCodeDescriptor.getVisibility();
            if (defaultVisibility.isEmpty()) {
                defaultVisibility = KtTokens.PUBLIC_KEYWORD.getValue();
            }
            this.visibilityBox.setSelectedItem(defaultVisibility);
        }
        this.visibilityBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                KotlinExtractFunctionDialog.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog$4", "itemStateChanged"));
            }
        });
        this.parameterTablePanel = new ExtractFunctionParameterTablePanel(){

            @Override
            protected void updateSignature() {
                KotlinExtractFunctionDialog.this.update();
            }

            @Override
            protected void onEnterAction() {
                KotlinExtractFunctionDialog.this.doOKAction();
            }

            @Override
            protected void onCancelAction() {
                KotlinExtractFunctionDialog.this.doCancelAction();
            }
        };
        this.parameterTablePanel.init(extractableCodeDescriptor.getReceiverParameter(), extractableCodeDescriptor.getParameters());
        this.inputParametersPanel.setText("&Parameters");
        this.inputParametersPanel.setLabelFor((Component)this.parameterTablePanel.getTable());
        this.inputParametersPanel.add((Component)this.parameterTablePanel);
    }

    protected void doOKAction() {
        MultiMap<PsiElement, String> conflicts2 = ExtractableAnalysisUtilKt.validate(this.currentDescriptor).getConflicts();
        conflicts2.values().removeAll(this.originalDescriptor.getConflicts().values());
        KotlinRefactoringUtilKt.checkConflictsInteractively(this.project, conflicts2, new Function0<Unit>(){

            public Unit invoke() {
                KotlinExtractFunctionDialog.this.close(0);
                return Unit.INSTANCE;
            }
        }, new Function0<Unit>(){

            public Unit invoke() {
                KotlinExtractFunctionDialog.super.doOKAction();
                return (Unit)KotlinExtractFunctionDialog.this.onAccept.invoke((Object)KotlinExtractFunctionDialog.this);
            }
        });
    }

    public JComponent getPreferredFocusedComponent() {
        return this.functionNameField;
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    @NotNull
    protected JComponent createContentPane() {
        JPanel jPanel = this.contentPane;
        if (jPanel == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    private ExtractableCodeDescriptor createDescriptor() {
        ExtractableCodeDescriptor extractableCodeDescriptor = KotlinExtractFunctionDialog.createNewDescriptor(this.originalDescriptor.getDescriptor(), this.getFunctionName(), this.getVisibility(), this.parameterTablePanel.getSelectedReceiverInfo(), this.parameterTablePanel.getSelectedParameterInfos(), (KotlinType)this.returnTypeBox.getSelectedItem());
        if (extractableCodeDescriptor == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(4);
        }
        return extractableCodeDescriptor;
    }

    @NotNull
    public ExtractionGeneratorConfiguration getCurrentConfiguration() {
        ExtractionGeneratorConfiguration extractionGeneratorConfiguration = new ExtractionGeneratorConfiguration(this.currentDescriptor, ExtractionGeneratorOptions.DEFAULT);
        if (extractionGeneratorConfiguration == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(5);
        }
        return extractionGeneratorConfiguration;
    }

    public static ExtractableCodeDescriptor createNewDescriptor(@NotNull ExtractableCodeDescriptor originalDescriptor, @NotNull String newName2, @NotNull String newVisibility, @Nullable ExtractFunctionParameterTablePanel.ParameterInfo newReceiverInfo, @NotNull List<ExtractFunctionParameterTablePanel.ParameterInfo> newParameterInfos, @Nullable KotlinType returnType2) {
        Parameter newReceiver;
        if (originalDescriptor == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(6);
        }
        if (newName2 == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(7);
        }
        if (newVisibility == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(8);
        }
        if (newParameterInfos == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(9);
        }
        LinkedHashMap oldToNewParameters = ContainerUtil.newLinkedHashMap();
        for (ExtractFunctionParameterTablePanel.ParameterInfo parameterInfo : newParameterInfos) {
            oldToNewParameters.put(parameterInfo.getOriginalParameter(), parameterInfo.toParameter());
        }
        Parameter originalReceiver = originalDescriptor.getReceiverParameter();
        Parameter parameter = newReceiver = newReceiverInfo != null ? newReceiverInfo.toParameter() : null;
        if (originalReceiver != null && newReceiver != null) {
            oldToNewParameters.put(originalReceiver, newReceiver);
        }
        return ExtractableCodeDescriptorKt.copy(originalDescriptor, newName2, newVisibility, oldToNewParameters, newReceiver, returnType2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JComboBox jComboBox2;
        JPanel jPanel2;
        JLabel jLabel;
        TitledSeparator titledSeparator;
        JPanel jPanel3;
        this.createUIComponents();
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        this.inputParametersPanel = titledSeparator = new TitledSeparator();
        titledSeparator.setLayout(new BorderLayout(0, 0));
        titledSeparator.setText("");
        jPanel5.add((Component)titledSeparator, "Center");
        titledSeparator.setBorder(BorderFactory.createTitledBorder(null, "Parameters", 0, 0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(-1, 200), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Signature Preview", 0, 0, null, null));
        KotlinSignatureComponent kotlinSignatureComponent = this.signaturePreviewField;
        kotlinSignatureComponent.setText("");
        jPanel7.add((Component)((Object)kotlinSignatureComponent), new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(500, 100), new Dimension(500, 100), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel8).setEnabled(true);
        ((Component)jPanel8).setVisible(true);
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.functionNameLabel = jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Visibility:");
        jLabel2.setDisplayedMnemonic('V');
        jLabel2.setDisplayedMnemonicIndex(0);
        ((Component)jLabel2).setVisible(true);
        jPanel8.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(114, 16), null));
        this.functionNamePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.visibilityBox = jComboBox2 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("private");
        defaultComboBoxModel.addElement("protected");
        defaultComboBoxModel.addElement("internal");
        defaultComboBoxModel.addElement("public");
        jComboBox2.setModel(defaultComboBoxModel);
        ((Component)jComboBox2).setVisible(true);
        jPanel8.add(jComboBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 2, 0, null, new Dimension(114, 26), null));
        this.returnTypePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Return type:");
        jLabel3.setDisplayedMnemonic('R');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.returnTypeBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 0, 1, 2, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onAccept";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVisibility";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameterInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentPane";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNewDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

