/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.structure.reflect.ReflectClassUtilKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.reflect.ReflectAnnotationSource;
import org.jetbrains.kotlin.load.kotlin.reflect.ReflectKotlinClassKt;
import org.jetbrains.kotlin.load.kotlin.reflect.SignatureSerializer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J$\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001a\u0010\u0018\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/reflect/ReflectClassStructure;", "", "()V", "loadClassAnnotations", "", "klass", "Ljava/lang/Class;", "visitor", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationVisitor;", "loadConstructorAnnotations", "memberVisitor", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$MemberVisitor;", "loadFieldAnnotations", "loadMethodAnnotations", "processAnnotation", "annotation", "", "processAnnotationArgumentValue", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationArgumentVisitor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "value", "processAnnotationArguments", "annotationType", "visitMembers", "core"})
final class ReflectClassStructure {
    public static final ReflectClassStructure INSTANCE;

    public final void loadClassAnnotations(@NotNull Class<?> klass2, @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull(klass2, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)visitor2, (String)"visitor");
        Annotation[] annotationArray = klass2.getDeclaredAnnotations();
        for (int i = 0; i < annotationArray.length; ++i) {
            Annotation annotation2;
            Annotation annotation3 = annotation2 = annotationArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
            this.processAnnotation(visitor2, annotation3);
        }
        visitor2.visitEnd();
    }

    public final void visitMembers(@NotNull Class<?> klass2, @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkParameterIsNotNull(klass2, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)memberVisitor, (String)"memberVisitor");
        this.loadMethodAnnotations(klass2, memberVisitor);
        this.loadConstructorAnnotations(klass2, memberVisitor);
        this.loadFieldAnnotations(klass2, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> klass2, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass2.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Method method;
            Method method2 = method = methodArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
            Name name2 = Name.identifier(method2.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(method.name)");
            if (memberVisitor.visitMethod(name2, SignatureSerializer.INSTANCE.methodDesc(method)) == null) {
                continue;
            }
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation2 = annotationArray[j];
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Annotation annotation3 = annotation2;
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation3);
            }
            Annotation[][] annotationArray2 = method.getParameterAnnotations();
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationArray2, (String)"method.parameterAnnotations");
            for (IndexedValue indexedValue : ArraysKt.withIndex((Object[])((Object[])annotationArray2))) {
                int parameterIndex2 = indexedValue.component1();
                Annotation[] annotations2 = (Annotation[])indexedValue.component2();
                for (int j = 0; j < annotations2.length; ++j) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                    Annotation annotation4 = annotations2[j];
                    Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation4));
                    ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                    Annotation annotation5 = annotation4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)annotation5, (String)"annotation");
                    if (visitor2.visitParameterAnnotation(parameterIndex2, classId, new ReflectAnnotationSource(annotation5)) == null) continue;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
                    INSTANCE.processAnnotationArguments(it, annotation4, annotationType);
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> klass2, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Constructor<?>[] constructorArray = klass2.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Constructor<?> constructor2 = constructorArray[i];
            Name name2 = Name.special("<init>");
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.special(\"<init>\")");
            Constructor<?> constructor3 = constructor2;
            Intrinsics.checkExpressionValueIsNotNull(constructor3, (String)"constructor");
            if (memberVisitor.visitMethod(name2, SignatureSerializer.INSTANCE.constructorDesc(constructor3)) == null) {
                continue;
            }
            IndexedValue indexedValue2 = constructor2.getDeclaredAnnotations();
            for (int j = 0; j < ((Annotation[])indexedValue2).length; ++j) {
                Annotation annotation2 = indexedValue2[j];
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Annotation annotation3 = annotation2;
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation3);
            }
            Annotation[][] parameterAnnotations = constructor2.getParameterAnnotations();
            Intrinsics.checkExpressionValueIsNotNull((Object)parameterAnnotations, (String)"parameterAnnotations");
            Object[] objectArray = (Object[])parameterAnnotations;
            indexedValue2 = objectArray;
            if (!(((Object[])indexedValue2).length == 0)) {
                int shift = ((Object[])constructor2.getParameterTypes()).length - ((Object[])parameterAnnotations).length;
                for (IndexedValue indexedValue2 : ArraysKt.withIndex((Object[])((Object[])parameterAnnotations))) {
                    int parameterIndex2 = indexedValue2.component1();
                    Annotation[] annotations2 = (Annotation[])indexedValue2.component2();
                    for (int j = 0; j < annotations2.length; ++j) {
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                        Annotation annotation4 = annotations2[j];
                        Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation4));
                        ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                        Annotation annotation5 = annotation4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)annotation5, (String)"annotation");
                        if (visitor2.visitParameterAnnotation(parameterIndex2 + shift, classId, new ReflectAnnotationSource(annotation5)) == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
                        INSTANCE.processAnnotationArguments(it, annotation4, annotationType);
                    }
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass2, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass2.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            KotlinJvmBinaryClass.AnnotationVisitor visitor2;
            Field field2;
            Field field3 = field2 = fieldArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"field");
            Name name2 = Name.identifier(field3.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(field.name)");
            if (memberVisitor.visitField(name2, SignatureSerializer.INSTANCE.fieldDesc(field2), null) == null) {
                continue;
            }
            Annotation[] annotationArray = field2.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation2;
                Annotation annotation3 = annotation2 = annotationArray[j];
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
                this.processAnnotation(visitor2, annotation3);
            }
            visitor2.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor2, Annotation annotation2) {
        block0: {
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
            Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation2));
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = visitor2.visitAnnotation(ReflectClassUtilKt.getClassId(annotationType), new ReflectAnnotationSource(annotation2));
            if (annotationArgumentVisitor2 == null) break block0;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor = annotationArgumentVisitor2;
            INSTANCE.processAnnotationArguments(it, annotation2, annotationType);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Annotation annotation2, Class<?> annotationType) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Object object;
            Method method;
            block3: {
                method = methodArray[i];
                try {
                    if (method.invoke((Object)annotation2, new Object[0]) != null) break block3;
                    Intrinsics.throwNpe();
                }
                catch (IllegalAccessException e) {
                    continue;
                }
            }
            Object value2 = object;
            Method method2 = method;
            Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
            Name name2 = Name.identifier(method2.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(method.name)");
            this.processAnnotationArgumentValue(visitor2, name2, value2);
        }
        visitor2.visitEnd();
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Name name2, Object value2) {
        Class<?> clazz = value2.getClass();
        if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            visitor2.visit(name2, value2);
        } else if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            Class<?> clazz2 = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"(if (clazz.isEnum) clazz\u2026lse clazz.enclosingClass)");
            ClassId classId = ReflectClassUtilKt.getClassId(clazz2);
            Object object = value2;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
            }
            Name name3 = Name.identifier(((Enum)object).name());
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier((value as Enum<*>).name)");
            visitor2.visitEnum(name2, classId, name3);
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class annotationClass;
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkExpressionValueIsNotNull(classArray, (String)"clazz.interfaces");
            Class clazz3 = annotationClass = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz3, (String)"annotationClass");
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(name2, ReflectClassUtilKt.getClassId(clazz3));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v = annotationArgumentVisitor;
            Object object = value2;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Annotation");
            }
            this.processAnnotationArguments(v, (Annotation)object, annotationClass);
        } else if (clazz.isArray()) {
            Class<?> componentType;
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = visitor2.visitArray(name2);
            if (annotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v = annotationArrayArgumentVisitor;
            Class<?> clazz4 = componentType = clazz.getComponentType();
            Intrinsics.checkExpressionValueIsNotNull(clazz4, (String)"componentType");
            if (clazz4.isEnum()) {
                ClassId enumClassId = ReflectClassUtilKt.getClassId(componentType);
                Object object = value2;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
                }
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object element3;
                    Object object2 = element3 = objectArray[i];
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
                    }
                    Name name4 = Name.identifier(((Enum)object2).name());
                    Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"Name.identifier((element as Enum<*>).name)");
                    v.visitEnum(enumClassId, name4);
                }
            } else {
                Object object = value2;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
                }
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object element4 = objectArray[i];
                    v.visit(element4);
                }
            }
            v.visitEnd();
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value2);
        }
    }

    private ReflectClassStructure() {
    }

    static {
        ReflectClassStructure reflectClassStructure;
        INSTANCE = reflectClassStructure = new ReflectClassStructure();
    }
}

