/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidLibraryPackagingTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidLibraryPackagingBuilder
extends AndroidTargetBuilder<BuildRootDescriptor, AndroidLibraryPackagingTarget> {
    @NonNls
    private static final String BUILDER_NAME = "Android Library Packaging";

    protected AndroidLibraryPackagingBuilder() {
        super(Collections.singletonList(AndroidLibraryPackagingTarget.MyTargetType.INSTANCE));
    }

    @Override
    protected void buildTarget(@NotNull AndroidLibraryPackagingTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, AndroidLibraryPackagingTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            AndroidLibraryPackagingBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            AndroidLibraryPackagingBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            AndroidLibraryPackagingBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AndroidLibraryPackagingBuilder.$$$reportNull$$$0(3);
        }
        if (!holder.hasDirtyFiles() && !holder.hasRemovedFiles()) {
            return;
        }
        assert (!AndroidJpsUtil.isLightBuild(context));
        if (!AndroidLibraryPackagingBuilder.doBuild(context, target.getModule(), outputConsumer)) {
            throw new StopBuildException();
        }
    }

    private static boolean doBuild(CompileContext context, JpsModule module, BuildOutputConsumer outputConsumer) throws IOException {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        if (extension == null || !extension.isLibrary()) {
            return true;
        }
        File outputDir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(context, module);
        if ((outputDir = AndroidJpsUtil.createDirIfNotExist(outputDir, context, BUILDER_NAME)) == null) {
            return false;
        }
        File classesDir = ProjectPaths.getModuleOutputDir((JpsModule)module, (boolean)false);
        if (classesDir == null || !classesDir.isDirectory()) {
            return true;
        }
        HashSet subdirs = new HashSet();
        AndroidJpsUtil.addSubdirectories(classesDir, (Collection<String>)subdirs);
        if (subdirs.size() > 0) {
            List srcFiles;
            context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.library.packaging", module.getName())));
            File outputJarFile = new File(outputDir, "classes.jar");
            try {
                srcFiles = AndroidCommonUtils.packClassFilesIntoJar((String[])ArrayUtil.EMPTY_STRING_ARRAY, (String[])ArrayUtil.toStringArray((Collection)subdirs), (File)outputJarFile);
            }
            catch (IOException e) {
                AndroidJpsUtil.reportExceptionError(context, null, e, BUILDER_NAME);
                return false;
            }
            AndroidBuildTestingManager testingManager = AndroidBuildTestingManager.getTestingManager();
            if (testingManager != null && outputJarFile.isFile()) {
                testingManager.getCommandExecutor().checkJarContent("library_package_jar", outputJarFile.getPath());
            }
            if (srcFiles.size() > 0) {
                outputConsumer.registerOutputFile(outputJarFile, (Collection)srcFiles);
            }
        }
        return true;
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            AndroidLibraryPackagingBuilder.$$$reportNull$$$0(4);
        }
        return BUILDER_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/AndroidLibraryPackagingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/AndroidLibraryPackagingBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTarget";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

