/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.completion.SassScssCompletionContributor;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclaration;
import org.jetbrains.plugins.scss.psi.stubs.ScssFunctionsIndex;

public class FunctionNamesProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            FunctionNamesProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            FunctionNamesProvider.$$$reportNull$$$0(1);
        }
        PsiElement originalElement = parameters.getOriginalPosition();
        PsiElement position = parameters.getPosition();
        PsiFile originalFile = parameters.getOriginalFile();
        FunctionNamesProvider.addCompletionsFromProjectFiles(position, originalElement, originalFile, result);
        FunctionNamesProvider.addCustomFunctionsFromSassExtensions(position, result);
        FunctionNamesProvider.addFunctionExtensionsFromSassExtensions(parameters.getPosition(), result);
        result.restartCompletionOnPrefixChange(SassScssCompletionContributor.RESTART_IDENTIFIER_COMPLETION_CONDITION);
    }

    private static void addCompletionsFromProjectFiles(@NotNull PsiElement position, PsiElement originalElement, PsiFile originalFile, @NotNull CompletionResultSet result) {
        if (position == null) {
            FunctionNamesProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            FunctionNamesProvider.$$$reportNull$$$0(3);
        }
        Project project = position.getProject();
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)originalFile, (PsiElement)position, (boolean)false);
        GlobalSearchScope scope = SASSSCSSLangUtil.searchScopeWithSassStdlib(position);
        String prefix = result.getPrefixMatcher().getPrefix();
        for (String name : StubIndex.getInstance().getAllKeys(ScssFunctionsIndex.KEY, project)) {
            if (name.isEmpty()) continue;
            ScssFunctionsIndex.process(name, project, scope, (Processor<? super SassScssFunctionDeclaration>)((Processor)declaration -> {
                if (position == null) {
                    FunctionNamesProvider.$$$reportNull$$$0(8);
                }
                if (result == null) {
                    FunctionNamesProvider.$$$reportNull$$$0(9);
                }
                if (declaration != originalElement && SASSSCSSLangUtil.isVisibleDeclaration((PsiElement)declaration, position)) {
                    boolean validResult = importedFiles.contains(declaration.getContainingFile().getVirtualFile());
                    result.addElement(SASSSCSSLangUtil.createFunctionLookupItem(declaration, validResult, prefix));
                }
                return true;
            }));
        }
    }

    private static void addCustomFunctionsFromSassExtensions(@NotNull PsiElement position, @NotNull CompletionResultSet result) {
        Module module;
        if (position == null) {
            FunctionNamesProvider.$$$reportNull$$$0(4);
        }
        if (result == null) {
            FunctionNamesProvider.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)position)) != null) {
            String prefix = result.getPrefixMatcher().getPrefix();
            for (SassExtension sassExtension : SassExtension.getAllExtensions(module)) {
                for (SassExtensionFunctionInfo functionInfo : sassExtension.getCustomFunctions()) {
                    result.addElement(SASSSCSSLangUtil.createCustomFunctionLookupItem(functionInfo, prefix));
                }
            }
        }
    }

    private static void addFunctionExtensionsFromSassExtensions(@NotNull PsiElement position, @NotNull CompletionResultSet result) {
        if (position == null) {
            FunctionNamesProvider.$$$reportNull$$$0(6);
        }
        if (result == null) {
            FunctionNamesProvider.$$$reportNull$$$0(7);
        }
        SassExtension.fillCompletionResultWithExtensionFunctions(position, result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/sass/completion/FunctionNamesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionsFromProjectFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addCustomFunctionsFromSassExtensions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addFunctionExtensionsFromSassExtensions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addCompletionsFromProjectFiles$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

